/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSortedSet;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTreeWriter;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Emoji;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class GenerateDerivedAnnotations {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    static final UnicodeSet SKIP = new UnicodeSet().add("\u2295").add("\u2297").add("\u2296").freeze();
    static Map<String, String> codepointToIsoCurrencyCode;

    public static void main(String[] args) throws IOException {
        MyOptions.parse(args);
        boolean missingOnly = MyOptions.missing.option.doesOccur();
        if (missingOnly) {
            System.out.println("With the 'missing' argument files will not be written, only the missing items will be written to the console");
        }
        Matcher localeMatcher = Pattern.compile(MyOptions.fileFilter.option.getValue()).matcher("");
        Joiner BAR = Joiner.on(" | ");
        Annotations.AnnotationSet enAnnotations = Annotations.getDataSet("en");
        CLDRFile english = CLDR_CONFIG.getEnglish();
        UnicodeSet derivables = new UnicodeSet(Emoji.getAllRgiNoES()).addAll((Iterable<?>)codepointToIsoCurrencyCode.keySet()).removeAll(enAnnotations.keySet()).freeze();
        for (String d : derivables) {
            if (!d.contains("\ud83d\udc8f\ud83c\udffb")) continue;
            System.out.println(d + "\t" + Utility.hex(d));
        }
        LinkedHashMap<String, UnicodeSet> localeToFailures = new LinkedHashMap<String, UnicodeSet>();
        ImmutableSortedSet<String> locales = ImmutableSortedSet.copyOf(Annotations.getAvailable());
        Factory cldrFactory = CLDRConfig.getInstance().getCldrFactory();
        TreeMap<String, Integer> failureMap = new TreeMap<String, Integer>();
        int processCount = 0;
        CLDRTreeWriter treeWriter = new CLDRTreeWriter(CLDRPaths.COMMON_DIRECTORY + "annotationsDerived");
        for (String locale : locales) {
            Annotations.AnnotationSet annotations;
            if ("root".equals(locale) || !localeMatcher.reset(locale).matches()) continue;
            ++processCount;
            UnicodeSet failures = new UnicodeSet(Emoji.getAllRgiNoES());
            localeToFailures.put(locale, failures);
            try {
                annotations = Annotations.getDataSet(locale);
                failures.removeAll(annotations.getExplicitValues());
            }
            catch (Exception e2) {
                System.out.println("Can't create annotations for: " + locale + "\n\t" + e2.getMessage());
                annotations = Annotations.getDataSet(locale);
                continue;
            }
            CLDRFile target = new CLDRFile(new SimpleXMLSource(locale));
            CLDRFile main = null;
            DisplayAndInputProcessor DAIP = new DisplayAndInputProcessor(target);
            Exception[] internalException = new Exception[1];
            target.addComment("//ldml", "Derived short names and annotations, using GenerateDerivedAnnotations.java. See warnings in /annotations/ file.", XPathParts.Comments.CommentType.PREBLOCK);
            for (String derivable : derivables) {
                String currencyCode;
                String shortName = null;
                try {
                    shortName = annotations.getShortName(derivable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (shortName == null && (currencyCode = codepointToIsoCurrencyCode.get(derivable)) != null) {
                    if (main == null) {
                        main = cldrFactory.make(locale, true);
                    }
                    if ((shortName = main.getName(4, currencyCode)).contentEquals(currencyCode)) {
                        shortName = null;
                    }
                }
                if (shortName == null || SKIP.containsSome(shortName)) continue;
                Set<String> keywords = annotations.getKeywordsMinus(derivable);
                String path = "//ldml/annotations/annotation[@cp=\"" + derivable + "\"]";
                if (!keywords.isEmpty()) {
                    HashSet<String> keywordsFixed = new HashSet<String>();
                    for (String keyword : keywords) {
                        if (SKIP.containsSome(keyword)) continue;
                        keywordsFixed.add(keyword);
                    }
                    if (!keywordsFixed.isEmpty()) {
                        String value = BAR.join(keywordsFixed);
                        String newValue = DAIP.processInput(path, value, internalException);
                        target.add(path, newValue);
                    }
                }
                failures.remove(derivable);
                String ttsPath = path + "[@type=\"tts\"]";
                String shortName2 = DAIP.processInput(path, shortName, internalException);
                target.add(ttsPath, shortName2);
            }
            failures.freeze();
            if (!failures.isEmpty()) {
                Level level = StandardCodes.make().getLocaleCoverageLevel(Organization.cldr, locale);
                System.out.println("Failures\t" + locale + "\t" + level + "\t" + english.getName(locale) + "\t" + failures.size() + "\t" + failures.toPattern(false));
                failureMap.put(locale, failures.size());
            }
            if (missingOnly) continue;
            treeWriter.write(target);
        }
        Factory factory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "annotationsDerived", ".*");
        for (String locale : locales) {
            if ("root".equals(locale) || !localeMatcher.reset(locale).matches()) continue;
            CLDRFile cldrFileUnresolved = factory.make(locale, false);
            CLDRFile cldrFileResolved = factory.make(locale, true);
            TreeSet<String> toRemove = new TreeSet<String>();
            boolean gotOne = false;
            for (String xpath : cldrFileUnresolved) {
                String bailey;
                if (xpath.startsWith("//ldml/identity")) continue;
                String value = cldrFileUnresolved.getStringValue(xpath);
                if (value.equals(bailey = cldrFileResolved.getBaileyValue(xpath, null, null))) {
                    toRemove.add(xpath);
                    continue;
                }
                gotOne = true;
            }
            if (!gotOne) {
                if (locale.equals("sr_Cyrl")) {
                    System.err.println("TODO: keep from deleting files with non-empty children");
                    continue;
                }
                System.out.println("Removing empty " + locale);
                treeWriter.delete(locale);
                continue;
            }
            if (toRemove.isEmpty()) continue;
            System.out.println("Removing " + toRemove.size() + " items from " + locale);
            CLDRFile fileToWrite = cldrFileUnresolved.cloneAsThawed();
            fileToWrite.removeAll(toRemove, false);
            treeWriter.write(fileToWrite);
        }
        treeWriter.close();
        System.out.println("Be sure to run CLDRModify passes afterwards, and generate transformed locales (like de-CH).");
        if (!failureMap.isEmpty()) {
            failureMap.entrySet().forEach(e -> System.err.printf("ERROR: %s: %d errors\n", e.getKey(), e.getValue()));
            System.err.printf("ERROR: Errors in %d/%d locales.\n", failureMap.size(), processCount);
            System.exit(1);
        } else if (processCount == 0) {
            System.err.println("ERROR: No locales matched. Check the -f option.\n");
            System.exit(1);
        } else {
            System.out.printf("OK: %d locales processed without error\n", processCount);
            System.exit(0);
        }
    }

    static {
        Splitter tabSplitter = Splitter.on('\t').trimResults();
        TreeMap<String, String> _codepointToIsoCurrencyCode = new TreeMap<String, String>();
        for (String line : FileUtilities.in(CldrUtility.class, "data/codepointToIsoCurrencyCode.tsv")) {
            if (line.startsWith("#")) continue;
            List<String> parts = tabSplitter.splitToList(line);
            _codepointToIsoCurrencyCode.put(parts.get(0), parts.get(1));
        }
        codepointToIsoCurrencyCode = XCldrStub.ImmutableMap.copyOf(_codepointToIsoCurrencyCode);
    }

    private static enum MyOptions {
        fileFilter(new Option.Params().setHelp("filter files by dir/locale, eg: ^main/en$ or .*/en").setMatch(".*").setDefault(".*")),
        missing(new Option.Params().setHelp("only missing").setMatch(""));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

