/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Output;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.LSRSource;
import org.unicode.cldr.tool.LangTagsData;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleScriptInfo;
import org.unicode.cldr.util.LocaleValidator;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;

public class GenerateLikelySubtags {
    private static final Joiner JOIN_TAB;
    private static final CLDRConfig CLDR_CONFIG;
    private static final Map<String, Validity.Status> LANGUAGE_CODE_TO_STATUS;
    private static final Map<String, Validity.Status> SCRIPT_CODE_TO_STATUS;
    private static final String TEMP_UNKNOWN_REGION = "XZ";
    private static final String DEBUG_ADD_KEY = "und_Latn_ZA";
    private static final double MIN_UNOFFICIAL_LANGUAGE_SIZE = 1.0E7;
    private static final double MIN_UNOFFICIAL_LANGUAGE_PROPORTION = 0.2;
    private static final double MIN_UNOFFICIAL_CLDR_LANGUAGE_SIZE = 100000.0;
    private static final double UNOFFICIAL_SCALE_DOWN = 0.2;
    private static final File[] list;
    private static Factory factory;
    private static Factory mainFactory;
    private static SupplementalDataInfo supplementalData;
    private static StandardCodes standardCodes;
    private static CLDRFile english;
    static Relation<String, String> cldrContainerToLanguages;
    private static NumberFormat percent;
    private static NumberFormat integer;
    private static boolean DROP_HARDCODED;
    private static boolean SHOW_ADD;
    private static boolean SHOW_MIN;
    private static boolean SHOW_POP;
    private static boolean SHOW_ORDER;
    private static boolean DEBUG;
    private static Map<String, StandardCodes.LstrType> WATCH_PAIRS;
    private static final boolean SHOW_OVERRIDES = true;
    static final Map<String, LSRSource> silData;
    private static final List<String> KEEP_TARGETS;
    private static final ImmutableSet<String> deprecatedISONotInLST;
    private static final List<String> MAX_ADDITIONS;
    private static final Map<String, String> LANGUAGE_OVERRIDES;
    private static String[][] SpecialScripts;
    private static Map<String, String> localeToScriptCache;
    private static Map<String, String> FALLBACK_SCRIPTS;
    private static int errorCount;
    public static Comparator<String> LOCALE_SOURCE;
    private static OutputStyle OUTPUT_STYLE;
    private static final String TAG_SEPARATOR;
    private static final Joiner JOIN_SPACE;
    private static final Joiner JOIN_UBAR;
    private static final Joiner JOIN_LS;
    static final String SEPARATOR;
    static final Joiner spacing;
    static final String arrow;

    public static void main(String[] args) throws IOException {
        boolean json;
        System.out.println("Use options to track progress, -w to narrow to specific subtags.");
        MyOptions.parse(args);
        SHOW_ADD = MyOptions.add.option.doesOccur();
        SHOW_MIN = MyOptions.minimize.option.doesOccur();
        SHOW_POP = MyOptions.population.option.doesOccur();
        SHOW_ORDER = MyOptions.order.option.doesOccur();
        DEBUG = MyOptions.debug.option.doesOccur();
        String watchValues = MyOptions.watch.option.getValue();
        if (watchValues != null) {
            TreeMap temp = new TreeMap();
            XCldrStub.Splitter.on('|').split(watchValues).forEach(x -> temp.put(x, GenerateLikelySubtags.getTypeFromCasedSubtag(x)));
            WATCH_PAIRS = ImmutableMap.copyOf(temp);
        }
        if (json = MyOptions.json.option.doesOccur()) {
            LangTagsData.Errors jsonErrors = LangTagsData.getProcessErrors();
            jsonErrors.printAll();
        }
        Map<String, String> oldOrigins = supplementalData.getLikelyOrigins();
        System.out.println("origins: " + new TreeSet<String>(oldOrigins.values()));
        Map<String, String> baseMappings = GenerateLikelySubtags.generatePopulationData(new TreeMap<String, String>(LOCALE_SOURCE));
        System.out.println(JOIN_TAB.join("\nBase data:", baseMappings.size(), new Object[0]));
        TreeMap<String, String> itemsRemoved = new TreeMap<String, String>();
        Map<String, String> minimizedMappings = GenerateLikelySubtags.minimize(baseMappings, itemsRemoved);
        System.out.println(JOIN_TAB.join("\nMinimized:", minimizedMappings.size(), new Object[0]));
        LikelySubtags max = new LikelySubtags(baseMappings);
        LikelySubtags min2 = new LikelySubtags(minimizedMappings);
        TreeMap<String, String> minFailures = new TreeMap<String, String>(LOCALE_SOURCE);
        int failures = 0;
        System.out.println("\nVerifying that Minimizing doesn't change function\n" + JOIN_TAB.join("status, source, maxTarg, minTarg".split(", ")));
        for (String source : baseMappings.keySet()) {
            String minTarg;
            String orgTarg = max.maximize(source);
            if (!orgTarg.equals(minTarg = min2.maximize(source))) {
                minFailures.put(source, orgTarg);
                System.out.println(JOIN_TAB.join("Fail", source, orgTarg, minTarg));
                ++failures;
                continue;
            }
            if (!GenerateLikelySubtags.watching(SHOW_MIN, source, orgTarg, minTarg)) continue;
            System.out.println(JOIN_TAB.join("Watch", source, orgTarg, minTarg));
        }
        if (failures != 0) {
            throw new IllegalArgumentException();
        }
        TreeSet newAdditions = new TreeSet();
        TreeSet newMissing = new TreeSet();
        System.out.println("\nReading old supplemental: may have unrelated errors.");
        SupplementalDataInfo oldSupplementalInfo = SupplementalDataInfo.getInstance(CldrUtility.getPath(CLDRPaths.LAST_COMMON_DIRECTORY, "supplemental/"));
        Map<String, String> oldLikelyData = oldSupplementalInfo.getLikelySubtags();
        Map<String, String> oldLikelyOrigins = oldSupplementalInfo.getLikelyOrigins();
        LikelySubtags oldLikely = new LikelySubtags(oldLikelyData);
        TreeSet<String> sorted = new TreeSet<String>(LOCALE_SOURCE);
        sorted.addAll(minimizedMappings.keySet());
        sorted.addAll(oldLikelyData.keySet());
        System.out.println("\nCheck against last version\n" + JOIN_TAB.join("Source", "Name", "oldValue", "Name", "newValue", "Name"));
        for (String source : sorted) {
            String oldValue = oldLikely.maximize(source);
            String oldOrigin = oldLikelyOrigins.get(source);
            if (oldOrigin != null && oldOrigin.contains("sil1")) continue;
            String newValue = min2.maximize(source);
            String removal = (String)itemsRemoved.get(source);
            if (Objects.equal(oldValue, newValue) || oldValue == null || oldValue.equals(removal) || GenerateLikelySubtags.getPart(source, StandardCodes.LstrType.language).equals("und") && oldValue.startsWith("en_Latn")) continue;
            System.out.println(JOIN_TAB.join(source, GenerateLikelySubtags.getNameSafe(source), oldValue, GenerateLikelySubtags.getNameSafe(oldValue), newValue, GenerateLikelySubtags.getNameSafe(newValue)));
        }
        System.out.println("new missing\t" + newMissing);
        GenerateLikelySubtags.printLikelySubtags(minimizedMappings);
    }

    static boolean watching(boolean flag, String ... locales) {
        if (!flag) {
            return false;
        }
        if (WATCH_PAIRS == null) {
            return true;
        }
        for (String locale : locales) {
            for (Map.Entry<String, StandardCodes.LstrType> entry : WATCH_PAIRS.entrySet()) {
                if (!entry.getKey().equals(GenerateLikelySubtags.getPart(locale, entry.getValue()))) continue;
                return true;
            }
        }
        return false;
    }

    public static StandardCodes.LstrType getTypeFromCasedSubtag(String casedSubtag) {
        if (casedSubtag == null) {
            return null;
        }
        char cp0 = casedSubtag.charAt(0);
        char cp1 = casedSubtag.charAt(1);
        return cp0 > 'Z' ? StandardCodes.LstrType.language : (cp1 > 'Z' ? StandardCodes.LstrType.script : StandardCodes.LstrType.region);
    }

    public static String getPart(String locale, StandardCodes.LstrType lstrType) {
        return GenerateLikelySubtags.getPart(CLDRLocale.getInstance(locale), lstrType);
    }

    public static String getPart(CLDRLocale loc, StandardCodes.LstrType type) {
        switch (type) {
            case language: {
                return loc.getLanguage();
            }
            case script: {
                return loc.getScript();
            }
            case region: {
                return loc.getCountry();
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    public static String getNameSafe(String oldValue) {
        try {
            if (oldValue != null) {
                String result = english.getName(oldValue);
                if (result.startsWith("Unknown language ")) {
                    result = result.substring("Unknown language ".length());
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "n/a";
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> generatePopulationData(Map<String, String> toMaximized) {
        void var8_49;
        String script;
        String region;
        MaxData maxData = new MaxData();
        Set<String> cldrLocales = factory.getAvailable();
        TreeSet<String> otherTerritories = new TreeSet<String>(Sets.difference(standardCodes.getGoodAvailableCodes("territory"), Set.of("ZZ")));
        TreeSet<String> noPopulationData = new TreeSet<String>();
        for (String string : supplementalData.getTerritoriesWithPopulationData()) {
            otherTerritories.remove(string);
            SupplementalDataInfo.PopulationData populationData = supplementalData.getPopulationDataForTerritory(string);
            double d = populationData.getLiteratePopulation();
            double d2 = d * 0.2;
            if (d2 < 1.0E7) {
                d2 = 1.0E7;
            }
            for (String writtenLanguage : supplementalData.getLanguagesForTerritoryWithPopulationData(string)) {
                String script3;
                SupplementalDataInfo.PopulationData data = supplementalData.getLanguageAndTerritoryPopulationData(writtenLanguage, string);
                double literatePopulation = GenerateLikelySubtags.getWritingPopulation(data);
                double order = -literatePopulation;
                if (data.getOfficialStatus() == SupplementalDataInfo.OfficialStatus.unknown) {
                    String locale = writtenLanguage + "_" + string;
                    order *= 0.2;
                    if (GenerateLikelySubtags.watching(SHOW_POP, writtenLanguage)) {
                        System.out.println(JOIN_TAB.join("Scaling unofficial: ", writtenLanguage, string, GenerateLikelySubtags.getNameSafe(locale), integer.format(literatePopulation), percent.format(literatePopulation / d), cldrLocales.contains(locale) ? "CLDR Loc" : ""));
                    }
                }
                if ((script3 = localeToScriptCache.get(writtenLanguage)) == null) {
                    script3 = LocaleScriptInfo.getScriptFromLocaleOrSupplemental(writtenLanguage);
                    if (script3 == null) {
                        LSRSource silLSR = silData.get(writtenLanguage);
                        if (silLSR != null) {
                            script3 = silLSR.getScript();
                        } else {
                            noPopulationData.add(writtenLanguage);
                            continue;
                        }
                    }
                    localeToScriptCache.put(writtenLanguage, script3);
                }
                String language2 = writtenLanguage;
                int pos = writtenLanguage.indexOf(95);
                if (pos > 0) {
                    language2 = writtenLanguage.substring(0, pos);
                }
                maxData.add(language2, script3, string, order);
            }
        }
        if (!noPopulationData.isEmpty()) {
            for (String string : noPopulationData) {
                System.out.println(JOIN_TAB.join("No script in pop. data for", string, GenerateLikelySubtags.getNameSafe(string)));
            }
        }
        LanguageTagParser additionLtp = new LanguageTagParser();
        for (String string : MAX_ADDITIONS) {
            additionLtp.set(string);
            String string2 = additionLtp.getLanguage();
            Set<Row.R3<Double, String, String>> set = maxData.languages.get(string2);
            if (set == null) {
                maxData.add(string2, additionLtp.getScript(), additionLtp.getRegion(), 1.0);
                continue;
            }
            boolean bl = false;
        }
        for (String string : otherTerritories) {
            if (!LocaleValidator.ALLOW_IN_LIKELY.isAllowed(StandardCodes.LstrType.region, string, null, null) || string.length() == 3) continue;
            maxData.add("en", "Latn", string, 1.0);
        }
        Map<String, Row.R2<List<String>, String>> map = SupplementalDataInfo.getInstance().getLocaleAliasInfo().get("language");
        for (Map.Entry<String, Row.R2<List<String>, String>> entry : map.entrySet()) {
            String goodLanguage;
            Set<Row.R3<Double, String, String>> goodLanguageData;
            String badLanguage;
            List list;
            String string = (String)entry.getValue().get1();
            if ("overlong".equals(string) || "bibliographic".equals(string) || "macrolanguage".equals(string) || (list = (List)entry.getValue().get0()) == null || (badLanguage = entry.getKey()).contains("_") || deprecatedISONotInLST.contains(badLanguage) || LANGUAGE_CODE_TO_STATUS.get(badLanguage) != Validity.Status.regular && !LocaleValidator.ALLOW_IN_LIKELY.isAllowed(StandardCodes.LstrType.language, badLanguage, null, null) || (goodLanguageData = maxData.languages.getAll(goodLanguage = (String)list.get(0))) == null) continue;
            Row.R3<Double, String, String> value2 = goodLanguageData.iterator().next();
            String script4 = (String)value2.get1();
            String region5 = (String)value2.get2();
            maxData.add(badLanguage, script4, region5, 1.0);
            System.out.println("Adding aliases: " + badLanguage + ", " + script4 + ", " + region5 + ", " + string);
        }
        for (String string : maxData.languages.keySet()) {
            Row.R3<Double, String, String> r3 = maxData.languages.getAll(string).iterator().next();
            String string3 = (String)r3.get1();
            String region2 = (String)r3.get2();
            GenerateLikelySubtags.add(string, string + "_" + string3 + "_" + region2, toMaximized, "L->SR", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.languagesToScripts.keySet()) {
            String string4 = maxData.languagesToScripts.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateLikelySubtags.add(string, string + "_" + string4, toMaximized, "L->S", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.languagesToRegions.keySet()) {
            String string5 = maxData.languagesToRegions.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateLikelySubtags.add(string, string + "_" + string5, toMaximized, "L->R", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.scripts.keySet()) {
            Row.R3<Double, String, String> r3 = maxData.scripts.getAll(string).iterator().next();
            String string6 = (String)r3.get1();
            region = (String)r3.get2();
            GenerateLikelySubtags.add("und_" + string, string6 + "_" + string + "_" + region, toMaximized, "S->LR", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.scriptsToLanguages.keySet()) {
            String string7 = maxData.scriptsToLanguages.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateLikelySubtags.add("und_" + string, string7 + "_" + string, toMaximized, "S->L", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.scriptsToRegions.keySet()) {
            String string8 = maxData.scriptsToRegions.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateLikelySubtags.add("und_" + string, "und_" + string + "_" + string8, toMaximized, "S->R", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.regions.keySet()) {
            Row.R3<Double, String, String> r3 = maxData.regions.getAll(string).iterator().next();
            String string9 = (String)r3.get1();
            script = (String)r3.get2();
            GenerateLikelySubtags.add("und_" + string, string9 + "_" + script + "_" + string, toMaximized, "R->LS", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.regionsToLanguages.keySet()) {
            String string10 = maxData.regionsToLanguages.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateLikelySubtags.add("und_" + string, string10 + "_" + string, toMaximized, "R->L", LocaleOverride.REPLACE_EXISTING);
        }
        for (String string : maxData.regionsToScripts.keySet()) {
            String string11 = maxData.regionsToScripts.get(string).getKeysetSortedByCount(true).iterator().next();
            GenerateLikelySubtags.add("und_" + string, "und_" + string11 + "_" + string, toMaximized, "R->S", LocaleOverride.REPLACE_EXISTING);
        }
        for (Row.R2<String, String> r2 : maxData.languageScripts.keySet()) {
            Row.R2<Double, String> r22 = maxData.languageScripts.getAll(r2).iterator().next();
            String string = (String)r2.get0();
            script = (String)r2.get1();
            String region9 = (String)r22.get1();
            GenerateLikelySubtags.add(string + "_" + script, string + "_" + script + "_" + region9, toMaximized, "LS->R", LocaleOverride.REPLACE_EXISTING);
        }
        for (Row.R2<String, String> r2 : maxData.scriptRegions.keySet()) {
            Row.R2<Double, String> r23 = maxData.scriptRegions.getAll(r2).iterator().next();
            String string = (String)r2.get0();
            region = (String)r2.get1();
            String language9 = (String)r23.get1();
            GenerateLikelySubtags.add("und_" + string + "_" + region, language9 + "_" + string + "_" + region, toMaximized, "SR->L", LocaleOverride.REPLACE_EXISTING);
        }
        for (Row.R2<String, String> r2 : maxData.languageRegions.keySet()) {
            Row.R2<Double, String> r24 = maxData.languageRegions.getAll(r2).iterator().next();
            String string = (String)r2.get0();
            region = (String)r2.get1();
            String script10 = (String)r24.get1();
            GenerateLikelySubtags.add(string + "_" + region, string + "_" + script10 + "_" + region, toMaximized, "LR->S", LocaleOverride.REPLACE_EXISTING);
        }
        TreeSet<String> treeSet = new TreeSet<String>(ScriptMetadata.getScripts());
        block25: for (String string : treeSet) {
            LinkedHashSet<String> errors;
            LanguageTagParser ltp;
            switch (SCRIPT_CODE_TO_STATUS.get(string)) {
                case special: 
                case unknown: {
                    continue block25;
                }
            }
            ScriptMetadata.Info info = ScriptMetadata.getInfo(string);
            String likelyLanguage = info.likelyLanguage;
            String originCountry = info.originCountry;
            if (LANGUAGE_CODE_TO_STATUS.get(likelyLanguage) == Validity.Status.special) {
                likelyLanguage = "und";
            }
            if (!LocaleValidator.isValid(ltp = new LanguageTagParser().setLanguage(likelyLanguage).setScript(string).setRegion(originCountry), LocaleValidator.ALLOW_IN_LIKELY, errors = new LinkedHashSet<String>())) {
                System.out.println(JOIN_LS.join("Failure in ScriptMetaData: " + ltp, errors, new Object[0]));
                continue;
            }
            String result = likelyLanguage + "_" + string + "_" + originCountry;
            GenerateLikelySubtags.add("und_" + string, result, toMaximized, "S->LR\u2022", LocaleOverride.KEEP_EXISTING);
            GenerateLikelySubtags.add(likelyLanguage, result, toMaximized, "L->SR\u2022", LocaleOverride.KEEP_EXISTING);
        }
        for (Map.Entry<String, String> entry : LANGUAGE_OVERRIDES.entrySet()) {
            String string = entry.getKey();
            String target = entry.getValue();
            GenerateLikelySubtags.add(string, target, toMaximized, "OVERRIDE", LocaleOverride.REPLACE_EXISTING);
        }
        boolean bl = false;
        block27: for (Map.Entry<String, String> entry : toMaximized.entrySet()) {
            String source = entry.getKey();
            String target = entry.getValue();
            CLDRLocale cSource = CLDRLocale.getInstance(source);
            String sLang = cSource.getLanguage();
            if (sLang.equals("und")) {
                sLang = "";
            }
            String sScript = cSource.getScript();
            String sRegion = cSource.getRegion();
            int fieldCount = GenerateLikelySubtags.countNonEmpty(sLang, sScript, sRegion);
            switch (fieldCount) {
                case 1: {
                    break;
                }
                case 0: 
                case 2: {
                    continue block27;
                }
                default: {
                    throw new IllegalArgumentException("Bad field count: " + cSource);
                }
            }
            CLDRLocale cTarget = CLDRLocale.getInstance(target);
            String tLang = cTarget.getLanguage();
            String tScript = cTarget.getScript();
            String tRegion = cTarget.getRegion();
            if (!sLang.isBlank()) {
                var8_49 += GenerateLikelySubtags.getErrorCount(toMaximized, source, target, JOIN_UBAR.join(sLang, tScript, new Object[0]));
                var8_49 += GenerateLikelySubtags.getErrorCount(toMaximized, source, target, JOIN_UBAR.join(sLang, tRegion, new Object[0]));
                continue;
            }
            if (!sScript.isBlank()) {
                var8_49 += GenerateLikelySubtags.getErrorCount(toMaximized, source, target, JOIN_UBAR.join(tLang, sScript, new Object[0]));
                var8_49 += GenerateLikelySubtags.getErrorCount(toMaximized, source, target, JOIN_UBAR.join("und", sScript, tRegion));
                continue;
            }
            var8_49 += GenerateLikelySubtags.getErrorCount(toMaximized, source, target, JOIN_UBAR.join(tLang, sRegion, new Object[0]));
            var8_49 += GenerateLikelySubtags.getErrorCount(toMaximized, source, target, JOIN_UBAR.join("und", tScript, sRegion));
        }
        if (var8_49 != false) {
            throw new IllegalArgumentException("Non-additive failure count: " + (int)var8_49);
        }
        HashSet<ImmutableList<String>> hashSet = new HashSet<ImmutableList<String>>();
        block28: while (true) {
            hashSet.clear();
            for (Map.Entry<String, String> entry : toMaximized.entrySet()) {
                String source = entry.getKey();
                String target = entry.getValue();
                if (target.contains("_Zzzz") || target.contains("_ZZ")) continue;
                String idempotentCandidate = LikelySubtags.maximize(target, toMaximized);
                if (idempotentCandidate == null) {
                    System.out.println("Can't maximize " + target);
                    continue;
                }
                if (idempotentCandidate.equals(target)) continue;
                hashSet.add(ImmutableList.of(source, target, idempotentCandidate));
            }
            if (hashSet.isEmpty()) break;
            Iterator iterator = hashSet.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block28;
                List row = (List)iterator.next();
                System.out.println("Idempotence: dropping mapping " + (String)row.get(0) + " to " + (String)row.get(1) + " since the target maps further to " + (String)row.get(2));
                toMaximized.remove(row.get(0));
            }
            break;
        }
        return CldrUtility.protectCollection(toMaximized);
    }

    private static int getErrorCount(Map<String, String> toMaximized, String source, String target, String modSource) {
        String modTarget = toMaximized.get(modSource);
        if (modTarget != null && !target.equals(modTarget)) {
            System.out.println(JOIN_SPACE.join("Non-additive: ", source, target, modSource, modTarget));
            return 1;
        }
        return 0;
    }

    public static int countNonEmpty(String ... items) {
        int count = 0;
        for (String item : items) {
            if (item.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private static long getWritingPopulation(SupplementalDataInfo.PopulationData popData) {
        double writingPopulation = popData.getWritingPopulation();
        if (!Double.isNaN(writingPopulation)) {
            return (long)writingPopulation;
        }
        return (long)popData.getLiteratePopulation();
    }

    private static void add(String key, String value, Map<String, String> toAdd, String kind, LocaleOverride override) {
        GenerateLikelySubtags.add(key, value, toAdd, kind, override, SHOW_ADD);
    }

    private static void add(String key, String value, Map<String, String> toAdd, String kind, LocaleOverride override, boolean showAction) {
        String oldValue = toAdd.get(key);
        if (oldValue == null) {
            if (GenerateLikelySubtags.watching(showAction, key, value)) {
                System.out.println(JOIN_TAB.join("", "Adding:", key, GenerateLikelySubtags.getNameSafe(key), "\u2192", value, GenerateLikelySubtags.getNameSafe(value), "", "", kind));
            }
            toAdd.put(key, value);
        } else if (override != LocaleOverride.KEEP_EXISTING && !value.equals(oldValue)) {
            if (GenerateLikelySubtags.watching(showAction, key, value)) {
                System.out.println(JOIN_TAB.join("", "Replacing:", key, GenerateLikelySubtags.getNameSafe(key), "\u2192", value, GenerateLikelySubtags.getNameSafe(value), ", was", oldValue, GenerateLikelySubtags.getNameSafe(oldValue), kind));
            }
            toAdd.put(key, value);
        }
    }

    public static String truncateLongString(Object data, int maxLen) {
        Object info = data.toString();
        if (((String)info).length() > maxLen) {
            if (UCharacter.codePointAt((CharSequence)info, maxLen - 1) > 65535) {
                --maxLen;
            }
            info = ((String)info).substring(0, maxLen) + "\u2026";
        }
        return info;
    }

    public static Map<String, String> minimize(Map<String, String> max, Map<String, String> itemsRemoved) {
        LanguageTagParser sourceParser = new LanguageTagParser();
        TreeMap<String, String> removals = new TreeMap<String, String>();
        TreeMap<String, String> toMinimize = new TreeMap<String, String>(LOCALE_SOURCE);
        Output<String> intermediate = new Output<String>();
        toMinimize.putAll(max);
        int pass = 0;
        while (true) {
            removals.clear();
            for (Map.Entry entry : toMinimize.entrySet()) {
                String result;
                String trial;
                String source = (String)entry.getKey();
                if (source.equals("und")) continue;
                String target = (String)entry.getValue();
                if (source.equals("aa_DJ") || source.equals("und_Arab_AF")) {
                    boolean bl = false;
                }
                sourceParser.set(source);
                if (!(sourceParser.getLanguage().equals("und") || sourceParser.getScript().isEmpty() || sourceParser.getRegion().isEmpty())) {
                    throw new IllegalArgumentException("Bogus source: " + source);
                }
                if (!sourceParser.getScript().isEmpty() && !sourceParser.getRegion().isEmpty() && !(trial = GenerateLikelySubtags.compose(sourceParser.getLanguage(), sourceParser.getScript(), sourceParser.getRegion())).equals(source) && target.equals(result = GenerateLikelySubtags.matchAndFill(sourceParser, trial, removals, toMinimize, intermediate))) {
                    removals.put(source, target);
                    GenerateLikelySubtags.showRemoving((Object)LsrType.LSR, source, target, trial, (String)intermediate.value);
                    continue;
                }
                if (!sourceParser.getScript().isEmpty() && !(trial = GenerateLikelySubtags.compose(sourceParser.getLanguage(), sourceParser.getScript(), "")).equals(source) && target.equals(result = GenerateLikelySubtags.matchAndFill(sourceParser, trial, removals, toMinimize, intermediate))) {
                    removals.put(source, target);
                    GenerateLikelySubtags.showRemoving((Object)LsrType.LS, source, target, trial, (String)intermediate.value);
                    continue;
                }
                if (!sourceParser.getRegion().isEmpty() && !(trial = GenerateLikelySubtags.compose(sourceParser.getLanguage(), "", sourceParser.getRegion())).equals(source) && target.equals(result = GenerateLikelySubtags.matchAndFill(sourceParser, trial, removals, toMinimize, intermediate)) && !GenerateLikelySubtags.fieldChangesLanguage(LsrType.S, sourceParser, removals, toMinimize)) {
                    removals.put(source, target);
                    GenerateLikelySubtags.showRemoving((Object)LsrType.LR, source, target, trial, (String)intermediate.value);
                    continue;
                }
                trial = sourceParser.getLanguage();
                if (trial.equals(source) || !target.equals(result = GenerateLikelySubtags.matchAndFill(sourceParser, trial, removals, toMinimize, intermediate)) || !sourceParser.getScript().isEmpty() && !sourceParser.getRegion().isEmpty() && (GenerateLikelySubtags.fieldChangesLanguage(LsrType.S, sourceParser, removals, toMinimize) || GenerateLikelySubtags.fieldChangesLanguage(LsrType.R, sourceParser, removals, toMinimize))) continue;
                removals.put(source, target);
                GenerateLikelySubtags.showRemoving((Object)LsrType.L, source, target, trial, (String)intermediate.value);
            }
            if (removals.size() == 0) break;
            itemsRemoved.putAll(removals);
            for (String locale : removals.keySet()) {
                toMinimize.remove(locale);
            }
            ++pass;
        }
        return CldrUtility.protectCollection(toMinimize);
    }

    public static boolean fieldChangesLanguage(LsrType lsrType, LanguageTagParser sourceParser, Map<String, String> removals, Map<String, String> toMinimize) {
        if (!GenerateLikelySubtags.isEmpty(sourceParser, lsrType)) {
            LanguageTagParser tempParser = new LanguageTagParser();
            GenerateLikelySubtags.copyFrom(tempParser, LsrType.L, sourceParser);
            GenerateLikelySubtags.copyFrom(tempParser, lsrType, sourceParser);
            String trial2 = GenerateLikelySubtags.compose(sourceParser.getLanguage(), GenerateLikelySubtags.getField(sourceParser, lsrType), "");
            String result2 = GenerateLikelySubtags.matchAndFill(sourceParser, trial2, removals, toMinimize, null);
            if (result2 != null) {
                LanguageTagParser tempParser2 = new LanguageTagParser();
                tempParser2.set(result2);
                String lang2 = tempParser2.getLanguage();
                String tempLang = tempParser.getLanguage();
                if (tempLang != lang2) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getField(LanguageTagParser fromParser, LsrType lsr) {
        switch (lsr) {
            case L: {
                return fromParser.getLanguage();
            }
            case S: {
                return fromParser.getScript();
            }
            case R: {
                return fromParser.getRegion();
            }
        }
        throw new IllegalArgumentException();
    }

    public static LanguageTagParser copyFrom(LanguageTagParser intoParser, LsrType lsr, LanguageTagParser fromParser) {
        switch (lsr) {
            case L: {
                intoParser.setLanguage(fromParser.getLanguage());
                break;
            }
            case S: {
                intoParser.setScript(fromParser.getScript());
                break;
            }
            case R: {
                intoParser.setRegion(fromParser.getRegion());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return intoParser;
    }

    public static LanguageTagParser ifEmptyCopyFrom(LanguageTagParser intoParser, LsrType lsr, LanguageTagParser fromParser) {
        return GenerateLikelySubtags.isEmpty(intoParser, lsr) ? intoParser : GenerateLikelySubtags.copyFrom(intoParser, lsr, fromParser);
    }

    public static boolean isEmpty(LanguageTagParser intoParser, LsrType lsr) {
        return GenerateLikelySubtags.getField(intoParser, lsr).equals(lsr == LsrType.L ? "und" : "");
    }

    public static String matchAndFill(LanguageTagParser sourceParser, String trial, Map<String, String> removals, Map<String, String> toMinimize, Output<String> intermediate) {
        String possibleSuper = removals.containsKey(trial) ? null : toMinimize.get(trial);
        String result = null;
        if (possibleSuper != null) {
            LanguageTagParser tempParser3 = new LanguageTagParser();
            tempParser3.set(possibleSuper);
            if (!sourceParser.getLanguage().equals("und")) {
                tempParser3.setLanguage(sourceParser.getLanguage());
            }
            if (!GenerateLikelySubtags.getField(sourceParser, LsrType.S).isEmpty()) {
                GenerateLikelySubtags.copyFrom(tempParser3, LsrType.S, sourceParser);
            }
            if (!sourceParser.getRegion().isEmpty()) {
                tempParser3.setRegion(sourceParser.getRegion());
            }
            result = tempParser3.toString();
        }
        if (intermediate != null) {
            intermediate.value = possibleSuper;
        }
        return result;
    }

    private static String compose(String lang, String script, String region) {
        Object result = lang;
        if (!script.isEmpty()) {
            result = (String)result + "_" + script;
        }
        if (!region.isEmpty()) {
            result = (String)result + "_" + region;
        }
        return result;
    }

    public static void showRemoving(Object pass, String locale, String target, String fallback, String fallbackTarget) {
        if (GenerateLikelySubtags.watching(SHOW_MIN, locale, target, fallback, fallbackTarget)) {
            System.out.println(JOIN_TAB.join(pass, "Removing: ", locale, "\u2192", target, fallback, fallbackTarget));
        }
    }

    public static String printingName(String locale, Joiner spacing) {
        if (locale == null) {
            return null;
        }
        CLDRLocale cLocale = CLDRLocale.getInstance(locale);
        String lang = cLocale.getLanguage();
        String script = cLocale.getScript();
        String region = cLocale.getCountry();
        return spacing.join(lang.equals("und") ? "?" : english.getName(0, lang), script == null || script.equals("") ? "?" : english.getName(1, script), region == null || region.equals("") ? "?" : english.getName(2, region));
    }

    private static File printLikelySubtags(Map<String, String> fluffup) throws IOException {
        File genDir = new File(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
        File genFile = new File(genDir, "likelySubtags" + (OUTPUT_STYLE == OutputStyle.XML ? ".xml" : ".txt"));
        System.out.println("Writing to " + genFile);
        try (PrintWriter out = FileUtilities.openUTF8Writer(genFile);){
            String header = OUTPUT_STYLE != OutputStyle.XML ? "const MapToMaximalSubtags default_subtags[] = {" : JOIN_LS.join("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", "<!DOCTYPE supplementalData SYSTEM \"../../common/dtd/ldmlSupplemental.dtd\">", "<!--", CldrUtility.getCopyrightString(), "-->", "<!--", "Likely subtags data is generated programatically from CLDR's language/territory/population", "data using the GenerateMaximalLocales tool. Under normal circumstances this file should", "not be patched by hand, as any changes made in that fashion may be lost.", "-->", "<supplementalData>", "    <version number=\"$Revision$\"/>", "    <likelySubtags>");
            Object footer = OUTPUT_STYLE != OutputStyle.XML ? SEPARATOR + "};" : "    </likelySubtags>\n</supplementalData>";
            out.println(header);
            boolean first = true;
            GenerateLikelySubtags.printLine(fluffup, Map.of(), first, out);
            if (OUTPUT_STYLE == OutputStyle.XML) {
                out.println("       <!-- Data donated by SIL -->");
            }
            HashMap<String, String> silMap = new HashMap<String, String>();
            HashMap<String, String> silOrigins = new HashMap<String, String>();
            for (Map.Entry<String, LSRSource> entry : silData.entrySet()) {
                CLDRLocale source = CLDRLocale.getInstance(entry.getKey());
                String lang = source.getLanguage();
                if (fluffup.containsKey(lang)) continue;
                silMap.put(entry.getKey(), entry.getValue().getLsrString());
                if (entry.getValue().getSources().isEmpty()) continue;
                silOrigins.put(entry.getKey(), entry.getValue().getSourceString());
            }
            GenerateLikelySubtags.printLine(silMap, silOrigins, first, out);
            out.println((String)footer);
            out.close();
        }
        return genFile;
    }

    public static void printLine(Map<String, String> toPrint, Map<String, String> origins, boolean first, PrintWriter out) {
        TreeSet<String> keys = new TreeSet<String>(LOCALE_SOURCE);
        keys.addAll(toPrint.keySet());
        boolean noUndYet = true;
        for (String printingLocale : keys) {
            String printingTarget = toPrint.get(printingLocale);
            String origin = origins.get(printingLocale);
            String comment = GenerateLikelySubtags.printingName(printingLocale, spacing) + arrow + GenerateLikelySubtags.printingName(printingTarget, spacing);
            if (OUTPUT_STYLE == OutputStyle.XML) {
                if (noUndYet && printingLocale.startsWith("und")) {
                    noUndYet = false;
                    out.println("       <!-- Data to find likely language; some implementations may omit -->");
                }
                out.println("\t\t<likelySubtag from=\"" + printingLocale + "\" to=\"" + printingTarget + "\"" + (String)(origin == null ? "" : " origin=\"" + origin + "\"") + "/>\t\t<!--" + comment + "-->");
                continue;
            }
            if (first) {
                first = false;
            } else {
                out.print(",");
            }
            if (comment.length() > 70 && SEPARATOR.equals("\n")) {
                comment = GenerateLikelySubtags.printingName(printingLocale, spacing) + SEPARATOR + "    // " + arrow + GenerateLikelySubtags.printingName(printingTarget, spacing);
            }
            out.print("  {" + SEPARATOR + "    // " + comment + SEPARATOR + "    \"" + printingLocale + "\"," + SEPARATOR + "    \"" + printingTarget + "\"\n  }");
        }
    }

    static {
        Object[][] objectArray;
        JOIN_TAB = Joiner.on('\t').useForNull("\u2205");
        CLDR_CONFIG = CLDRConfig.getInstance();
        LANGUAGE_CODE_TO_STATUS = Validity.getInstance().getCodeToStatus(StandardCodes.LstrType.language);
        SCRIPT_CODE_TO_STATUS = Validity.getInstance().getCodeToStatus(StandardCodes.LstrType.script);
        list = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.EXEMPLARS_DIRECTORY)};
        factory = SimpleFactory.make(list, ".*");
        mainFactory = CLDR_CONFIG.getCldrFactory();
        supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
        standardCodes = StandardCodes.make();
        english = factory.make("en", false);
        cldrContainerToLanguages = Relation.of(new HashMap(), HashSet.class);
        percent = NumberFormat.getPercentInstance();
        integer = NumberFormat.getIntegerInstance();
        DROP_HARDCODED = false;
        WATCH_PAIRS = null;
        silData = LangTagsData.getJsonData();
        for (CLDRLocale locale : mainFactory.getAvailableCLDRLocales()) {
            String region = locale.getCountry();
            if (region == null || region.isEmpty() || Containment.isLeaf(region)) continue;
            cldrContainerToLanguages.put(region, locale.getLanguage());
        }
        cldrContainerToLanguages.freeze();
        System.out.println("Keeping macroregions used in cldr " + cldrContainerToLanguages);
        KEEP_TARGETS = DROP_HARDCODED ? List.of() : List.of("und_Arab_PK", "und_Latn_ET");
        deprecatedISONotInLST = DROP_HARDCODED ? ImmutableSet.of() : ImmutableSet.of("scc", "scr");
        List<Object> list = MAX_ADDITIONS = DROP_HARDCODED ? List.of() : List.of("bss_Latn_CM", "gez_Ethi_ET", "ken_Latn_CM", "und_Arab_PK", "wa_Latn_BE", "fub_Arab_CM", "fuf_Latn_GN", "kby_Arab_NE", "kdh_Latn_TG", "apd_Arab_TG", "zlm_Latn_TG", "cr_Cans_CA", "hif_Latn_FJ", "gon_Telu_IN", "lzz_Latn_TR", "lif_Deva_NP", "unx_Beng_IN", "unr_Beng_IN", "ttt_Latn_AZ", "pnt_Grek_GR", "tly_Latn_AZ", "tkr_Latn_AZ", "bsq_Bass_LR", "ccp_Cakm_BD", "blt_Tavt_VN", "rhg_Arab_MM", "rhg_Rohg_MM", "clc_Latn_CA", "crg_Latn_CA", "hur_Latn_CA", "kwk_Latn_CA", "lil_Latn_CA", "ojs_Cans_CA", "oka_Latn_CA", "pqm_Latn_CA", "no_Latn_NO", "tok_Latn_001", "prg_Latn_PL", "ie_Latn_EE");
        if (DROP_HARDCODED) {
            Object[][] objectArray2 = new String[1][];
            objectArray = objectArray2;
            objectArray2[0] = new String[]{"und", "en_Latn_US"};
        } else {
            String[][] stringArrayArray = new String[134][];
            stringArrayArray[0] = new String[]{"cic", "cic_Latn_US"};
            stringArrayArray[1] = new String[]{"cic_Latn", "cic_Latn_US"};
            stringArrayArray[2] = new String[]{"eo", "eo_Latn_001"};
            stringArrayArray[3] = new String[]{"eo_Latn", "eo_Latn_001"};
            stringArrayArray[4] = new String[]{"es", "es_Latn_ES"};
            stringArrayArray[5] = new String[]{"es_Latn", "es_Latn_ES"};
            stringArrayArray[6] = new String[]{"ff_BF", "ff_Latn_BF"};
            stringArrayArray[7] = new String[]{"ff_GM", "ff_Latn_GM"};
            stringArrayArray[8] = new String[]{"ff_GH", "ff_Latn_GH"};
            stringArrayArray[9] = new String[]{"ff_GW", "ff_Latn_GW"};
            stringArrayArray[10] = new String[]{"ff_LR", "ff_Latn_LR"};
            stringArrayArray[11] = new String[]{"ff_NE", "ff_Latn_NE"};
            stringArrayArray[12] = new String[]{"ff_NG", "ff_Latn_NG"};
            stringArrayArray[13] = new String[]{"ff_SL", "ff_Latn_SL"};
            stringArrayArray[14] = new String[]{"ff_Adlm", "ff_Adlm_GN"};
            stringArrayArray[15] = new String[]{"ia", "ia_Latn_001"};
            stringArrayArray[16] = new String[]{"ia_Latn", "ia_Latn_001"};
            stringArrayArray[17] = new String[]{"io", "io_Latn_001"};
            stringArrayArray[18] = new String[]{"io_Latn", "io_Latn_001"};
            stringArrayArray[19] = new String[]{"jbo", "jbo_Latn_001"};
            stringArrayArray[20] = new String[]{"jbo_Latn", "jbo_Latn_001"};
            stringArrayArray[21] = new String[]{"ku_Arab", "ku_Arab_IQ"};
            stringArrayArray[22] = new String[]{"lrc", "lrc_Arab_IR"};
            stringArrayArray[23] = new String[]{"lrc_Arab", "lrc_Arab_IR"};
            stringArrayArray[24] = new String[]{"man", "man_Latn_GM"};
            stringArrayArray[25] = new String[]{"man_Latn", "man_Latn_GM"};
            stringArrayArray[26] = new String[]{"mas", "mas_Latn_KE"};
            stringArrayArray[27] = new String[]{"mas_Latn", "mas_Latn_KE"};
            stringArrayArray[28] = new String[]{"mn", "mn_Cyrl_MN"};
            stringArrayArray[29] = new String[]{"mn_Cyrl", "mn_Cyrl_MN"};
            stringArrayArray[30] = new String[]{"mro", "mro_Mroo_BD"};
            stringArrayArray[31] = new String[]{"mro_BD", "mro_Mroo_BD"};
            stringArrayArray[32] = new String[]{"ms_Arab", "ms_Arab_MY"};
            stringArrayArray[33] = new String[]{"pap", "pap_Latn_CW"};
            stringArrayArray[34] = new String[]{"pap_Latn", "pap_Latn_CW"};
            stringArrayArray[35] = new String[]{"rif", "rif_Latn_MA"};
            stringArrayArray[36] = new String[]{"rif_Latn", "rif_Latn_MA"};
            stringArrayArray[37] = new String[]{"rif_Tfng", "rif_Tfng_MA"};
            stringArrayArray[38] = new String[]{"rif_MA", "rif_Latn_MA"};
            stringArrayArray[39] = new String[]{"shi", "shi_Tfng_MA"};
            stringArrayArray[40] = new String[]{"shi_Tfng", "shi_Tfng_MA"};
            stringArrayArray[41] = new String[]{"shi_MA", "shi_Tfng_MA"};
            stringArrayArray[42] = new String[]{"sr_Latn", "sr_Latn_RS"};
            stringArrayArray[43] = new String[]{"ss", "ss_Latn_ZA"};
            stringArrayArray[44] = new String[]{"ss_Latn", "ss_Latn_ZA"};
            stringArrayArray[45] = new String[]{"ti", "ti_Ethi_ET"};
            stringArrayArray[46] = new String[]{"ti_Ethi", "ti_Ethi_ET"};
            stringArrayArray[47] = new String[]{"und", "en_Latn_US"};
            stringArrayArray[48] = new String[]{"und_Adlm", "ff_Adlm_GN"};
            stringArrayArray[49] = new String[]{"und_Adlm_GN", "ff_Adlm_GN"};
            stringArrayArray[50] = new String[]{"und_Arab", "ar_Arab_EG"};
            stringArrayArray[51] = new String[]{"und_Arab_PK", "ur_Arab_PK"};
            stringArrayArray[52] = new String[]{"und_Bopo", "zh_Bopo_TW"};
            stringArrayArray[53] = new String[]{"und_Deva_FJ", "hif_Deva_FJ"};
            stringArrayArray[54] = new String[]{"und_Hani", "zh_Hani_CN"};
            stringArrayArray[55] = new String[]{"und_Hani_CN", "zh_Hani_CN"};
            stringArrayArray[56] = new String[]{"und_Kana", "ja_Kana_JP"};
            stringArrayArray[57] = new String[]{"und_Kana_JP", "ja_Kana_JP"};
            stringArrayArray[58] = new String[]{"und_Latn", "en_Latn_US"};
            stringArrayArray[59] = new String[]{"und_001", "en_Latn_001"};
            stringArrayArray[60] = new String[]{"und_Latn_001", "en_Latn_001"};
            stringArrayArray[61] = new String[]{"und_Latn_ET", "en_Latn_ET"};
            stringArrayArray[62] = new String[]{"und_Latn_NE", "ha_Latn_NE"};
            stringArrayArray[63] = new String[]{"und_Latn_PH", "fil_Latn_PH"};
            stringArrayArray[64] = new String[]{"und_ML", "bm_Latn_ML"};
            stringArrayArray[65] = new String[]{"und_Latn_ML", "bm_Latn_ML"};
            stringArrayArray[66] = new String[]{"und_MU", "mfe_Latn_MU"};
            stringArrayArray[67] = new String[]{"und_Latn_MU", "mfe_Latn_MU"};
            stringArrayArray[68] = new String[]{"und_NE", "ha_Latn_NE"};
            stringArrayArray[69] = new String[]{"und_PH", "fil_Latn_PH"};
            stringArrayArray[70] = new String[]{"und_PK", "ur_Arab_PK"};
            stringArrayArray[71] = new String[]{"und_SO", "so_Latn_SO"};
            stringArrayArray[72] = new String[]{"und_SS", "en_Latn_SS"};
            stringArrayArray[73] = new String[]{"und_TK", "tkl_Latn_TK"};
            stringArrayArray[74] = new String[]{"und_Latn_TK", "tkl_Latn_TK"};
            stringArrayArray[75] = new String[]{"vo", "vo_Latn_001"};
            stringArrayArray[76] = new String[]{"vo_Latn", "vo_Latn_001"};
            stringArrayArray[77] = new String[]{"yue", "yue_Hant_HK"};
            stringArrayArray[78] = new String[]{"yue_Hant", "yue_Hant_HK"};
            stringArrayArray[79] = new String[]{"yue_Hans", "yue_Hans_CN"};
            stringArrayArray[80] = new String[]{"yue_CN", "yue_Hans_CN"};
            stringArrayArray[81] = new String[]{"zh_Hani", "zh_Hani_CN"};
            stringArrayArray[82] = new String[]{"zh_Bopo", "zh_Bopo_TW"};
            stringArrayArray[83] = new String[]{"ccp", "ccp_Cakm_BD"};
            stringArrayArray[84] = new String[]{"ccp_Cakm", "ccp_Cakm_BD"};
            stringArrayArray[85] = new String[]{"und_Cakm", "ccp_Cakm_BD"};
            stringArrayArray[86] = new String[]{"cu_Glag", "cu_Glag_BG"};
            stringArrayArray[87] = new String[]{"sd_Khoj", "sd_Khoj_IN"};
            stringArrayArray[88] = new String[]{"lif_Limb", "lif_Limb_IN"};
            stringArrayArray[89] = new String[]{"arc_Nbat", "arc_Nbat_JO"};
            stringArrayArray[90] = new String[]{"arc_Palm", "arc_Palm_SY"};
            stringArrayArray[91] = new String[]{"pal_Phlp", "pal_Phlp_CN"};
            stringArrayArray[92] = new String[]{"en_Shaw", "en_Shaw_GB"};
            stringArrayArray[93] = new String[]{"sd_Sind", "sd_Sind_IN"};
            stringArrayArray[94] = new String[]{"und_Brai", "fr_Brai_FR"};
            stringArrayArray[95] = new String[]{"und_Hanb", "zh_Hanb_TW"};
            stringArrayArray[96] = new String[]{"zh_Hanb", "zh_Hanb_TW"};
            stringArrayArray[97] = new String[]{"und_Jamo", "ko_Jamo_KR"};
            stringArrayArray[98] = new String[]{"ku_Yezi", "ku_Yezi_GE"};
            stringArrayArray[99] = new String[]{"hnj", "hnj_Hmnp_US"};
            stringArrayArray[100] = new String[]{"hnj_Hmnp", "hnj_Hmnp_US"};
            stringArrayArray[101] = new String[]{"und_Hmnp", "hnj_Hmnp_US"};
            stringArrayArray[102] = new String[]{"rhg", "rhg_Rohg_MM"};
            stringArrayArray[103] = new String[]{"rhg_Arab", "rhg_Arab_MM"};
            stringArrayArray[104] = new String[]{"und_Arab_MM", "rhg_Arab_MM"};
            stringArrayArray[105] = new String[]{"sd_IN", "sd_Deva_IN"};
            stringArrayArray[106] = new String[]{"und_Cpmn", "und_Cpmn_CY"};
            stringArrayArray[107] = new String[]{"oc_ES", "oc_Latn_ES"};
            stringArrayArray[108] = new String[]{"os", "os_Cyrl_GE"};
            stringArrayArray[109] = new String[]{"os_Cyrl", "os_Cyrl_GE"};
            stringArrayArray[110] = new String[]{"und_419", "es_Latn_419"};
            stringArrayArray[111] = new String[]{"und_ZM", "bem_Latn_ZM"};
            stringArrayArray[112] = new String[]{"und_Latn_ZM", "bem_Latn_ZM"};
            stringArrayArray[113] = new String[]{"und_CC", "ms_Arab_CC"};
            stringArrayArray[114] = new String[]{"und_SL", "kri_Latn_SL"};
            stringArrayArray[115] = new String[]{"und_Latn_SL", "kri_Latn_SL"};
            stringArrayArray[116] = new String[]{"und_SS", "ar_Arab_SS"};
            stringArrayArray[117] = new String[]{"und_Arab_AF", "fa_Arab_AF"};
            stringArrayArray[118] = new String[]{"und_Cyrl_BG", "bg_Cyrl_BG"};
            stringArrayArray[119] = new String[]{"und_Tibt_BT", "dz_Tibt_BT"};
            stringArrayArray[120] = new String[]{"und_Cyrl_BY", "be_Cyrl_BY"};
            stringArrayArray[121] = new String[]{"und_Arab_CC", "ms_Arab_CC"};
            stringArrayArray[122] = new String[]{"und_Ethi_ER", "ti_Ethi_ER"};
            stringArrayArray[123] = new String[]{"und_Arab_IR", "fa_Arab_IR"};
            stringArrayArray[124] = new String[]{"und_Cyrl_KG", "ky_Cyrl_KG"};
            stringArrayArray[125] = new String[]{"und_Cyrl_MK", "mk_Cyrl_MK"};
            stringArrayArray[126] = new String[]{"und_Cyrl_MN", "mn_Cyrl_MN"};
            stringArrayArray[127] = new String[]{"und_Deva_NP", "ne_Deva_NP"};
            stringArrayArray[128] = new String[]{"und_Cyrl_RS", "sr_Cyrl_RS"};
            stringArrayArray[129] = new String[]{"und_Cyrl_TJ", "tg_Cyrl_TJ"};
            stringArrayArray[130] = new String[]{"und_Cyrl_UA", "uk_Cyrl_UA"};
            stringArrayArray[131] = new String[]{"arc_Hatr", "arc_Hatr_IQ"};
            stringArrayArray[132] = new String[]{"hnj_Hmng", "hnj_Hmng_LA"};
            objectArray = stringArrayArray;
            stringArrayArray[133] = new String[]{"bap_Krai", "bap_Krai_IN"};
        }
        LANGUAGE_OVERRIDES = CldrUtility.asMap(objectArray);
        SpecialScripts = new String[][]{{"zh", "Hans"}, {"yue", "Hant"}, {"ko", "Kore"}, {"ko_KR", "Kore"}, {"ja", "Jpan"}};
        localeToScriptCache = new TreeMap<String, String>();
        for (String language : standardCodes.getAvailableCodes("language")) {
            Map<String, String> info = standardCodes.getLangData("language", language);
            String string = info.get("Suppress-Script");
            if (string == null) continue;
            localeToScriptCache.put(language, string);
        }
        for (Iterator<Object> iterator : SpecialScripts) {
            localeToScriptCache.put((String)((Object)iterator[0]), (String)((Object)iterator[1]));
        }
        LanguageTagParser additionLtp = new LanguageTagParser();
        TreeMap<String, String> _FALLBACK_SCRIPTS = new TreeMap<String, String>();
        for (String string : MAX_ADDITIONS) {
            additionLtp.set(string);
            String lan = additionLtp.getLanguage();
            _FALLBACK_SCRIPTS.put(lan, additionLtp.getScript());
        }
        FALLBACK_SCRIPTS = ImmutableMap.copyOf(_FALLBACK_SCRIPTS);
        LOCALE_SOURCE = new Comparator<String>(){

            @Override
            public int compare(String locale1, String locale2) {
                CLDRLocale l1 = CLDRLocale.getInstance(locale1);
                CLDRLocale l2 = CLDRLocale.getInstance(locale2);
                int result = ComparisonChain.start().compare((Comparable<?>)((Object)this.getLanguage(l1)), (Comparable<?>)((Object)this.getLanguage(l2))).compare((Comparable<?>)((Object)this.getScript(l1)), (Comparable<?>)((Object)this.getScript(l2))).compare((Comparable<?>)((Object)this.getRegion(l1)), (Comparable<?>)((Object)this.getRegion(l2))).result();
                if (result == 0 && !locale1.equals(locale2)) {
                    throw new IllegalArgumentException();
                }
                return result;
            }

            private String getLanguage(CLDRLocale loc) {
                return this.replaceMissing(loc.getLanguage(), "und", "\u03a9");
            }

            private String getScript(CLDRLocale loc) {
                return loc.getScript();
            }

            private String getRegion(CLDRLocale loc) {
                return loc.getCountry();
            }

            private String replaceMissing(String field, String ifEqual, String replacement) {
                return ifEqual.equals(field) ? replacement : field;
            }
        };
        LOCALE_SOURCE.compare("hnj_MM", "hnj_Laoo");
        OUTPUT_STYLE = OutputStyle.valueOf(CldrUtility.getProperty("OutputStyle", "XML", "XML").toUpperCase());
        TAG_SEPARATOR = OUTPUT_STYLE == OutputStyle.C_ALT ? "-" : "_";
        JOIN_SPACE = Joiner.on(' ');
        JOIN_UBAR = Joiner.on('_');
        JOIN_LS = Joiner.on("\n");
        SEPARATOR = OUTPUT_STYLE == OutputStyle.C || OUTPUT_STYLE == OutputStyle.C_ALT ? "\n" : "\t";
        spacing = Joiner.on(OUTPUT_STYLE == OutputStyle.PLAINTEXT ? "\t" : "\u2027").useForNull("\u2205");
        arrow = OUTPUT_STYLE == OutputStyle.PLAINTEXT ? "\t\u21d2\t" : "\t\u27a1 ";
    }

    static class MapView<K, V> {
        K skip;

        MapView() {
        }
    }

    static enum LsrType {
        LSR,
        LS,
        LR,
        SR,
        L,
        S,
        R;

    }

    public static class MaxData {
        Relation<String, Row.R3<Double, String, String>> languages = Relation.of(new TreeMap(), TreeSet.class);
        Map<String, Counter<String>> languagesToScripts = new TreeMap<String, Counter<String>>();
        Map<String, Counter<String>> languagesToRegions = new TreeMap<String, Counter<String>>();
        Relation<String, Row.R3<Double, String, String>> scripts = Relation.of(new TreeMap(), TreeSet.class);
        Map<String, Counter<String>> scriptsToLanguages = new TreeMap<String, Counter<String>>();
        Map<String, Counter<String>> scriptsToRegions = new TreeMap<String, Counter<String>>();
        Relation<String, Row.R3<Double, String, String>> regions = Relation.of(new TreeMap(), TreeSet.class);
        Map<String, Counter<String>> regionsToLanguages = new TreeMap<String, Counter<String>>();
        Map<String, Counter<String>> regionsToScripts = new TreeMap<String, Counter<String>>();
        Relation<Row.R2<String, String>, Row.R2<Double, String>> languageScripts = Relation.of(new TreeMap(), TreeSet.class);
        Relation<Row.R2<String, String>, Row.R2<Double, String>> scriptRegions = Relation.of(new TreeMap(), TreeSet.class);
        Relation<Row.R2<String, String>, Row.R2<Double, String>> languageRegions = Relation.of(new TreeMap(), TreeSet.class);

        void add(String language, String script, String region, Double order) {
            LinkedHashSet<String> errors;
            LanguageTagParser ltp = new LanguageTagParser().setLanguage(language).setScript(script).setRegion(region);
            if (!LocaleValidator.isValid(ltp, LocaleValidator.ALLOW_IN_LIKELY, errors = new LinkedHashSet<String>())) {
                System.out.println(JOIN_LS.join("Bad Add of " + ltp, errors, new Object[0]));
            }
            if (GenerateLikelySubtags.watching(SHOW_ORDER, language)) {
                System.out.println(JOIN_TAB.join("Add Data:", language, script, region, integer.format(order)));
            }
            this.languages.put(language, Row.of(order, script, region));
            this.scripts.put(script, Row.of(order, language, region));
            this.regions.put(region, Row.of(order, language, script));
            this.languageScripts.put(Row.of(language, script), Row.of(order, region));
            this.scriptRegions.put(Row.of(script, region), Row.of(order, language));
            this.languageRegions.put(Row.of(language, region), Row.of(order, script));
        }
    }

    private static enum MyOptions {
        minimize(new Option.Params().setHelp("Show minimization actions (")),
        add(new Option.Params().setHelp("Show additions")),
        population(new Option.Params().setHelp("Show population data used")),
        order(new Option.Params().setHelp("Show the priority order for langauge data")),
        debug(new Option.Params().setHelp("Show other debug info")),
        json(new Option.Params().setHelp("Show json error data")),
        watch(new Option.Params().setHelp("Only show info for locales with listed fields ('|' separated), eg -w419|Aghb|AU|bjt will show info for bjt_Latn or und_Laoo_AU").setMatch(".*"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }

    public static enum LocaleOverride {
        KEEP_EXISTING,
        REPLACE_EXISTING;

    }

    public static enum OutputStyle {
        PLAINTEXT,
        C,
        C_ALT,
        XML;

    }
}

