/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.ListFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.lang.invoke.CallSite;
import java.util.LinkedHashSet;
import org.unicode.cldr.tool.ExtractListInfo;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.Factory;

public class GenerateSeedDurations {
    static CLDRConfig testInfo = ToolConfig.getToolInstance();
    static String[] numericUnits = new String[]{"ms", "Hm", "Hms"};
    static String[] combinationUnits = new String[]{"ms", "Hm", "Hms", "dH", "dHm", "wd", "md", "ym", "ymd"};

    public static void main(String[] args) {
        Factory cldrFactory = testInfo.getCldrFactory();
        String[] data = new String[4];
        LinkedHashSet<CallSite> warnings = new LinkedHashSet<CallSite>();
        for (String string : cldrFactory.getAvailableLanguages()) {
            CLDRFile cldrFile = cldrFactory.make(string, true);
            String localeString = string + "\t" + testInfo.getEnglish().getName(string);
            System.out.println("\n" + localeString);
            DateTimeFormats formats = new DateTimeFormats().set(cldrFile, "gregorian");
            System.out.println("    <numericUnits>");
            for (String numericUnit : numericUnits) {
                SimpleDateFormat pattern = formats.getDateFormatFromSkeleton(numericUnit);
                String patternString = pattern.toPattern();
                if (numericUnit.contains("H")) {
                    if (!patternString.contains("H")) {
                        warnings.add((CallSite)((Object)(localeString + "\t" + patternString + "\t ***No 'H'")));
                    }
                    patternString = patternString.replace("HH", "H");
                } else {
                    patternString = patternString.replace("mm", "m");
                }
                if (!patternString.contains(":")) {
                    warnings.add((CallSite)((Object)(localeString + "\t" + patternString + "\t ***No ':'")));
                }
                System.out.println("        <numericUnit type=\"" + numericUnit + "\">" + patternString + "<numericUnit>");
            }
            System.out.println("    </numericUnits>");
            for (int i = 0; i < ExtractListInfo.paths.length; ++i) {
                data[i] = cldrFile.getStringValue(ExtractListInfo.paths[i]);
            }
            ListFormat listFormat = new ListFormat(data[0], data[1], data[2], data[3]);
            System.out.println("    <combinationUnits>");
            for (String combinationUnit : combinationUnits) {
                String pattern = combinationUnit.length() == 2 ? listFormat.format("{0}", "{1}") : listFormat.format("{0}", "{1}", "{2}");
                System.out.println("        <combinationUnit type=\"" + combinationUnit + "\">" + pattern + "<combinationUnit>");
            }
            System.out.println("    </combinationUnits>");
        }
        for (String string : warnings) {
            System.out.println(string);
        }
    }
}

