/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.util.UOption;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.MultiComparator;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.SAXException;

public class GenerateSidewaysView {
    private static final boolean TOO_BIG_FOR_GITHUB = true;
    private static final String DIR_NAME = "by_type";
    static final boolean DEBUG = false;
    static final boolean DEBUG2 = false;
    static final boolean DEBUG_SHOW_ADD = false;
    static final boolean DEBUG_ELEMENT = false;
    static final boolean DEBUG_SHOW_BAT = false;
    static final boolean FIX_ZONE_ALIASES = true;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int SKIP = 5;
    private static final int TZADIR = 6;
    private static final int NONVALIDATING = 7;
    private static final int SHOW_DTD = 8;
    private static final int TRANSLIT = 9;
    private static final int PATH = 10;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault(CLDRPaths.MAIN_DIRECTORY), UOption.DESTDIR().setDefault(CLDRPaths.CHART_DIRECTORY + "by_type/"), UOption.create("match", 'm', 1).setDefault(".*"), UOption.create("skip", 'z', 1).setDefault("zh_(C|S|HK|M).*"), UOption.create("tzadir", 't', 1).setDefault("C:\\ICU4J\\icu4j\\src\\com\\ibm\\icu\\dev\\tool\\cldr\\"), UOption.create("nonvalidating", 'n', 0), UOption.create("dtd", 'w', 0), UOption.create("transliterate", 'y', 0), UOption.create("path", 'p', 1)};
    private static final Matcher altProposedMatcher = CLDRFile.ALT_PROPOSED_PATTERN.matcher("");
    protected static final UnicodeSet COMBINING = new UnicodeSet("[[:m:]]").freeze();
    static Comparator<Object> UCA;
    private static Map<PathHeader, Map<String, Set<String>>> path_value_locales;
    private static long startTime;
    static RuleBasedCollator standardCollation;
    private static CLDRFile english;
    private static Matcher pathMatcher;
    static final String[][] EXEMPLARS;
    static final UnicodeSet NONSPACING;
    static LanguageTagParser cleanLocaleParser;
    static Set<LanguageTagParser.Fields> allButScripts;
    static UnicodeMap.Composer<Set<String>> setComposer;
    static Map<String, String> LOCALE_TO_SCRIPT;
    static PathHeader.Factory pathHeaderFactory;
    static final Set<String> skipSet;
    static CLDRFile.Status status;
    static String[] headerAndFooter;
    private static Transliterator toHTML;

    static int getFirstScript(UnicodeSet exemplars) {
        UnicodeSetIterator it = new UnicodeSetIterator(exemplars);
        while (it.next()) {
            int script = UScript.getScript(it.codepoint);
            if (script == 0 || script == 1) continue;
            return script;
        }
        return 0;
    }

    public static void main(String[] args) throws SAXException, IOException {
        startTime = System.currentTimeMillis();
        ToolUtilities.registerExtraTransliterators();
        UOption.parseArgs(args, options);
        pathMatcher = GenerateSidewaysView.options[10].value == null ? null : PatternCache.get(GenerateSidewaysView.options[10].value).matcher("");
        File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.ANNOTATIONS_DIRECTORY), new File(CLDRPaths.SUBDIVISIONS_DIRECTORY)};
        Factory cldrFactory = SimpleFactory.make(paths, GenerateSidewaysView.options[4].value);
        english = cldrFactory.make("en", true);
        pathHeaderFactory = PathHeader.getFactory(english);
        FileCopier.ensureDirectoryExists(GenerateSidewaysView.options[3].value);
        FileCopier.copy(GenerateSidewaysView.class, "bytype-index.css", GenerateSidewaysView.options[3].value, "index.css");
        FormattedFileWriter.copyIncludeHtmls(GenerateSidewaysView.options[3].value);
        GenerateSidewaysView.loadInformation(cldrFactory);
        String oldMain = "";
        PrintWriter out = null;
        System.out.println("Getting types " + path_value_locales.size());
        String headerString = GenerateSidewaysView.getHeader(path_value_locales.keySet());
        FileCopier.copyAndReplace(GenerateSidewaysView.class, "bytype-index.html", GenerateSidewaysView.options[3].value, "index.html", ImmutableMap.of("%header%", headerString, "%version%", ToolConstants.CHART_DISPLAY_VERSION, "%index%", "../index.html", "%index-title%", "Main Charts Index", "%date%", CldrUtility.isoFormatDateOnly(new Date())));
        System.out.println("Printing files in " + new File(GenerateSidewaysView.options[3].value).getAbsolutePath());
        toHTML = TransliteratorUtilities.toHTML;
        String oldHeader = "";
        OptionalPrinter tsvFile = new OptionalPrinter();
        for (PathHeader path : path_value_locales.keySet()) {
            String main = GenerateSidewaysView.getFileName2(path, null);
            if (!main.equals(oldMain)) {
                oldMain = main;
                out = GenerateSidewaysView.start(out, main, headerString, path.getSection() + ":" + path.getPage(), tsvFile);
                out.println("<table class='table'>");
                oldHeader = "";
            }
            String key = path.getCode();
            String anchor = toHTML.transliterate(key);
            String originalPath = path.getOriginalPath();
            Object englishValue = english.getStringValue(originalPath);
            englishValue = englishValue != null ? "English: \u2039" + (String)englishValue + "\u203a" : "";
            String header = path.getHeader();
            if (!header.equals(oldHeader) && !header.equals("null")) {
                out.println("<tr><th colSpan='2' class='pathHeader'>" + CldrUtility.getDoubleLinkedText(header) + "</th></tr>");
                oldHeader = header;
            }
            String anchorId = Long.toHexString(StringId.getId(path.getOriginalPath()));
            out.println("<tr><th class='path'>" + CldrUtility.getDoubleLinkedText(anchorId, anchor) + "</th><th class='path'>" + toHTML.transliterate((String)englishValue) + "</th></tr>");
            Map<String, Set<String>> value_locales = path_value_locales.get(path);
            for (String value : value_locales.keySet()) {
                String valueClass = " class='value'";
                if (ShowData.DataShower.getBidiStyle(value).length() != 0) {
                    valueClass = " class='rtl_value'";
                }
                out.println("<tr><th" + valueClass + ">" + ShowData.DataShower.getPrettyValue(value) + "</th><td class='td'>");
                tsvFile.print(path.getSection() + "\t" + path.getPage() + "\t" + path.getHeader() + "\t" + path.getCode() + "\t" + value + "\t");
                Set<String> locales = value_locales.get(value);
                boolean first = true;
                boolean containsRoot = locales.contains("root");
                for (String locale : locales) {
                    String parent;
                    if (first) {
                        first = false;
                    } else {
                        out.print(" ");
                    }
                    if (locale.endsWith("*")) {
                        locale = locale.substring(0, locale.length() - 1);
                        out.print("<i>\u00b7" + locale + "\u00b7</i>");
                        tsvFile.print("\u00b7" + locale + "\u00b7");
                        continue;
                    }
                    if (!containsRoot) {
                        out.print("\u00b7" + locale + "\u00b7");
                        tsvFile.print("\u00b7" + locale + "\u00b7");
                        continue;
                    }
                    if (!locale.contains("_") || locales.contains(parent = LocaleIDParser.getParent(locale))) continue;
                    out.print("<b>\u00b7" + locale + "\u00b7</b>");
                    tsvFile.print("\u00b7" + locale + "\u00b7");
                }
                if (containsRoot) {
                    out.print("<b>\u00b7all\u00b7others\u00b7</b>");
                    tsvFile.print("\u00b7all-others\u00b7");
                }
                out.println("</td></tr>");
                tsvFile.println();
            }
        }
        for (String[] pair : EXEMPLARS) {
            GenerateSidewaysView.showExemplars(out, headerString, pair[0], pair[1], pair[2], tsvFile);
        }
        GenerateSidewaysView.finish(out, tsvFile);
        GenerateSidewaysView.finishAll(out, tsvFile);
        System.out.println("Done in " + new RuleBasedNumberFormat(new ULocale("en"), 3).format((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    private static PrintWriter showExemplars(PrintWriter out, String headerString, String pathName, String variant, String title, OptionalPrinter tsvFile) throws IOException {
        PathHeader ph = GenerateSidewaysView.fixPath(pathName, null);
        String filename = GenerateSidewaysView.getFileName2(ph, variant);
        out = GenerateSidewaysView.start(out, filename, headerString, title, tsvFile);
        Map<String, Set<String>> value_locales = path_value_locales.get(ph);
        TreeMap<String, UnicodeMap<Set<String>>> script_UnicodeMap = new TreeMap<String, UnicodeMap<Set<String>>>();
        UnicodeSet stuffToSkip = new UnicodeSet("[:Han:]");
        UnicodeSet totalExemplars = new UnicodeSet();
        for (String value : value_locales.keySet()) {
            UnicodeSet exemplars = new UnicodeSet(value);
            if (variant.equals("main")) {
                UnicodeSet extras = new UnicodeSet();
                for (String item : exemplars) {
                    extras.addAll(Normalizer.normalize(item, Normalizer.NFD));
                }
                exemplars.addAll(extras);
            }
            totalExemplars.addAll(exemplars);
            exemplars.removeAll(stuffToSkip);
            Set<String> locales = value_locales.get(value);
            for (String locale : locales) {
                String simpleParent;
                GenerateSidewaysView.checkTr(script_UnicodeMap);
                String key = locale.endsWith("*") ? locale.substring(0, locale.length() - 1) : locale;
                String script = LOCALE_TO_SCRIPT.get(key);
                if (script == null && key.contains("_") && (script = LOCALE_TO_SCRIPT.get(simpleParent = LanguageTagParser.getSimpleParent(key))) == null && simpleParent.contains("_")) {
                    simpleParent = LanguageTagParser.getSimpleParent(simpleParent);
                    script = LOCALE_TO_SCRIPT.get(simpleParent);
                }
                if (script == null) {
                    script = UScript.getName(103);
                }
                HashSet<String> temp = new HashSet<String>();
                temp.add(locale);
                GenerateSidewaysView.checkTr(script_UnicodeMap);
                UnicodeMap<Set<String>> mapping = (UnicodeMap<Set<String>>)script_UnicodeMap.get(script);
                if (mapping == null) {
                    mapping = new UnicodeMap<Set<String>>();
                    script_UnicodeMap.put(script, mapping);
                }
                GenerateSidewaysView.checkTr(script_UnicodeMap);
                mapping.composeWith(exemplars, temp, setComposer);
                GenerateSidewaysView.checkTr(script_UnicodeMap);
            }
        }
        System.out.println("@@@TOTAL:\t" + variant + "\t" + totalExemplars.toPattern(false));
        for (String script : script_UnicodeMap.keySet()) {
            UnicodeMap mapping = (UnicodeMap)script_UnicodeMap.get(script);
            GenerateSidewaysView.writeCharToLocaleMapping(out, script, mapping);
        }
        return out;
    }

    private static void checkTr(Map<String, UnicodeMap<Set<String>>> script_UnicodeMap) {
        UnicodeMap<Set<String>> unicodeMap = script_UnicodeMap.get("Cyrillic");
        if (unicodeMap == null) {
            return;
        }
        Set<String> foo = unicodeMap.get(33);
        if (foo == null) {
            return;
        }
        if (foo.contains("tr")) {
            System.out.println("huh?");
        }
    }

    private static void writeCharToLocaleMapping(PrintWriter out, String script, UnicodeMap<Set<String>> mapping) {
        BreakIterator charBreaks = BreakIterator.getCharacterInstance(ULocale.ROOT);
        System.out.println("@@Exemplars for\t" + script + "\t" + mapping.keySet());
        if (script.equals("Hangul")) {
            return;
        }
        TreeSet<Object> allLocales = new TreeSet<Object>(UCA);
        TreeSet<Object> allChars = new TreeSet<Object>(UCA);
        TreeSet<Object> allStrings = new TreeSet<Object>(UCA);
        for (Set<String> set : mapping.getAvailableValues()) {
            allLocales.addAll(set);
            UnicodeSet unicodeSet = mapping.keySet(set);
            for (String string : unicodeSet) {
                charBreaks.setText(string);
                int endFirst = charBreaks.next();
                if (endFirst == string.length()) {
                    allChars.add(string);
                    continue;
                }
                allStrings.add(string);
            }
        }
        out.println("<table class='table' style='width:1%'>");
        out.println("<caption>" + script + "</caption>");
        GenerateSidewaysView.exemplarHeader(out, allChars);
        for (String string : allLocales) {
            String headerHeader = "<th class='head'>" + GenerateSidewaysView.cleanLocale(string, false) + "</th><td class='head nowrap left'>" + GenerateSidewaysView.cleanLocale(string, true) + "</td>";
            out.println("<tr>");
            out.println(headerHeader);
            for (String string2 : allChars) {
                if (mapping.get(string2).contains(string)) {
                    out.println("<td class='cell'>" + GenerateSidewaysView.displayCharacter(string2) + "</td>");
                    continue;
                }
                out.println("<td class='empty'>\u00a0</td>");
            }
            StringBuilder strings = new StringBuilder();
            boolean bl = false;
            for (String string3 : allStrings) {
                if (!mapping.get(string3).contains(string)) continue;
                int str_len = strings.length();
                if (str_len != 0) {
                    int n;
                    if (str_len - n > 20) {
                        strings.append(System.lineSeparator());
                        n = str_len;
                    } else {
                        strings.append(' ');
                    }
                }
                strings.append(GenerateSidewaysView.displayCharacter(string3));
            }
            if (strings.length() == 0) {
                out.println("<td class='empty'>\u00a0</td>");
            } else {
                out.println("<td class='cell nowrap'>" + GenerateSidewaysView.displayCharacter(strings.toString()).replace(System.lineSeparator(), "<br>") + "</td>");
            }
            out.println(headerHeader);
            out.println("</tr>");
        }
        GenerateSidewaysView.exemplarHeader(out, allChars);
        out.println("</table>");
        out.flush();
    }

    private static String characterTitle(String item) {
        return "title='U+" + toHTML.transform(Utility.hex(item, 4, ", U+", true, new StringBuilder()) + " " + UCharacter.getName(item, ", ")) + "'";
    }

    private static void exemplarHeader(PrintWriter out, Set<String> allChars) {
        out.println("<tr>");
        out.println("<th class='head nowrap' colSpan='2'>Locale \\\u00a0Chars</th>");
        for (String item : allChars) {
            out.println("<th class='head' " + GenerateSidewaysView.characterTitle(item) + ">" + GenerateSidewaysView.displayCharacter(item) + "</th>");
        }
        out.println("<th class='head'>Clusters</th>");
        out.println("<th class='head nowrap' colSpan='2'>Locale \\\u00a0Chars</th>");
        out.println("</tr>");
    }

    public static String displayCharacter(String item) {
        if (((String)item).length() == 0) {
            return "<i>none</i>";
        }
        int ch = ((String)item).codePointAt(0);
        if (NONSPACING.contains(ch)) {
            item = "\u00a0" + (String)item + "\u00a0";
        }
        String result = toHTML.transform((String)item);
        return result;
    }

    private static String cleanLocale(String item, boolean name) {
        if (item == null) {
            return "<i>null</i>";
        }
        boolean draft = ((String)item).endsWith("*");
        if (draft) {
            item = ((String)item).substring(0, ((String)item).length() - 1);
        }
        cleanLocaleParser.set((String)item);
        item = cleanLocaleParser.toString(allButScripts);
        String core = item;
        item = toHTML.transform((String)item);
        if (name) {
            item = english.getName(core);
            Object object = item = item == null ? "<i>null</i>" : toHTML.transform((String)item);
        }
        if (draft) {
            item = "<i>" + (String)item + "</i>";
        }
        return item;
    }

    private static void loadInformation(Factory cldrFactory) {
        Set<String> alllocales = cldrFactory.getAvailable();
        String[] postFix = new String[]{""};
        for (String localeID : alllocales) {
            CLDRFile cLDRFile;
            System.out.println("Loading: " + localeID);
            System.out.flush();
            try {
                cLDRFile = cldrFactory.make(localeID, localeID.equals("root"));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Couldn't open " + localeID);
                continue;
            }
            if (cLDRFile.isNonInheriting()) continue;
            for (String path : cLDRFile) {
                Set<String> locales;
                Map<String, Set<String>> value_locales;
                String fullPath;
                String value;
                PathHeader ph;
                if (pathMatcher != null && !pathMatcher.reset(path).matches() || altProposedMatcher.reset(path).matches() || path.indexOf("/alias") >= 0 || path.indexOf("/identity") >= 0 || path.indexOf("/references") >= 0 || (ph = GenerateSidewaysView.fixPath(path, postFix)) == null || ph.shouldHide() || (value = GenerateSidewaysView.getValue(cLDRFile, path, fullPath = cLDRFile.getFullXPath(path))) == null || CldrUtility.INHERITANCE_MARKER.equals(value)) continue;
                if (fullPath.indexOf("[@draft=\"unconfirmed\"]") >= 0 || fullPath.indexOf("[@draft=\"provisional\"]") >= 0) {
                    postFix[0] = "*";
                }
                if (path.equals("//ldml/characters/exemplarCharacters")) {
                    try {
                        UnicodeSet exemplars = new UnicodeSet(value);
                        String script = UScript.getName(GenerateSidewaysView.getFirstScript(exemplars));
                        LOCALE_TO_SCRIPT.put(localeID, script);
                    }
                    catch (Exception script) {
                        // empty catch block
                    }
                }
                if ((value_locales = path_value_locales.get(ph)) == null) {
                    value_locales = new TreeMap<Object, Set<String>>(standardCollation);
                    path_value_locales.put(ph, value_locales);
                }
                if ((locales = value_locales.get(value)) == null) {
                    locales = new TreeSet<String>();
                    value_locales.put(value, locales);
                }
                locales.add(localeID + postFix[0]);
            }
        }
        Relation<String, String> sorted = Relation.of(new TreeMap(), TreeSet.class);
        for (Map.Entry<String, String> entry : LOCALE_TO_SCRIPT.entrySet()) {
            sorted.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : sorted.keyValuesSet()) {
            System.out.println(entry);
        }
    }

    private static PathHeader fixPath(String path, String[] localePrefix) {
        if (localePrefix != null) {
            localePrefix[0] = "";
        }
        return pathHeaderFactory.fromPath(path);
    }

    private static String getValueAttributes(XPathParts parts) {
        String element = parts.getElement(-1);
        Collection<String> attributes = parts.getAttributeKeys(-1);
        DtdData dtdData = parts.getDtdData();
        StringBuilder sb = new StringBuilder();
        for (String attributeName : attributes) {
            if (skipSet.contains(attributeName)) continue;
            DtdData.Attribute attribute = dtdData.getAttribute(element, attributeName);
            DtdData.AttributeStatus status = attribute.getStatus();
            switch (status) {
                case distinguished: 
                case metadata: {
                    break;
                }
                case value: {
                    sb.append(attributeName + "=" + parts.getAttributeValue(-1, attributeName) + " ");
                }
            }
        }
        return sb.toString();
    }

    private static String getValue(CLDRFile cldrFile, String path, String fullPath) {
        String value = cldrFile.getStringValue(path);
        if (value == null) {
            System.out.println("Null value for " + path);
            return value;
        }
        cldrFile.getSourceLocaleID(path, status);
        if (!path.equals(GenerateSidewaysView.status.pathWhereFound)) {
            value = null;
            return value;
        }
        if (value.length() == 0) {
            XPathParts parts = XPathParts.getFrozenInstance(fullPath);
            value = GenerateSidewaysView.getValueAttributes(parts);
        }
        return value;
    }

    private static String getFileName2(PathHeader header, String suffix) {
        Object result = (header.getSection() + "." + header.getPage()).replace(" ", "_").replace("/", "_").replace("(", "_").replace(")", "_");
        if (suffix != null) {
            result = (String)result + "." + suffix;
        }
        return ((String)result).toLowerCase(Locale.ENGLISH);
    }

    private static PrintWriter start(PrintWriter out, String main, String headerString, String title, OptionalPrinter tsvFile) throws IOException {
        GenerateSidewaysView.finish(out, tsvFile);
        out = GenerateSidewaysView.writeHeader(main, title, tsvFile);
        out.println(headerString);
        return out;
    }

    public static String getHeader(Set<PathHeader> set) {
        StringBuffer out = new StringBuffer("<table class='simple'><tr>");
        String lastMain = "";
        String lastSub = "";
        for (PathHeader pathHeader : set) {
            String mainName = pathHeader.getSection();
            String subName = TransliteratorUtilities.toHTML.transform(pathHeader.getPage());
            if (!mainName.equals(lastMain)) {
                if (lastMain.length() != 0) {
                    out.append("</tr>" + System.lineSeparator() + "<tr>");
                }
                out.append("<th align='right' nowrap style='vertical-align: top'><b>" + TransliteratorUtilities.toHTML.transform(mainName) + ":&nbsp;</b></th><td>");
                lastMain = mainName;
                lastSub = subName;
            } else {
                if (subName.equals(lastSub)) continue;
                out.append(" | ");
                lastSub = subName;
            }
            out.append("<a href='" + GenerateSidewaysView.getFileName2(pathHeader, null) + ".html'>" + subName + "</a>");
            if (pathHeader.getPageId() != PathHeader.PageId.Alphabetic_Information) continue;
            for (String[] pair : EXEMPLARS) {
                out.append(" | <a href='" + GenerateSidewaysView.getFileName2(pathHeader, pair[1]) + ".html'>" + pair[2] + "</a>");
            }
        }
        return out.append("</td></tr>" + System.lineSeparator() + "</table>").toString();
    }

    private static PrintWriter writeHeader(String main, String title, OptionalPrinter tsvFile) throws IOException {
        PrintWriter out = FileUtilities.openUTF8Writer(GenerateSidewaysView.options[3].value, main + ".html");
        ShowData.getChartTemplate("By-Type Chart: " + title, ToolConstants.CHART_DISPLAY_VERSION, "", headerAndFooter, null, false);
        out.println(headerAndFooter[0]);
        return out;
    }

    private static void finish(PrintWriter out, OptionalPrinter tsvFile) {
        if (out == null) {
            return;
        }
        out.println("</table>");
        out.println(headerAndFooter[1]);
        out.close();
    }

    private static void finishAll(PrintWriter out, OptionalPrinter tsvFile) {
        tsvFile.close();
    }

    static {
        RuleBasedCollator UCA2 = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        UCA2.setNumericCollation(true);
        UCA2.setStrength(15);
        UCA = new MultiComparator<Object>(UCA2, new UTF16.StringComparator(true, false, 0));
        path_value_locales = new TreeMap<PathHeader, Map<String, Set<String>>>();
        startTime = System.currentTimeMillis();
        standardCollation = (RuleBasedCollator)Collator.getInstance(ULocale.ENGLISH);
        standardCollation.setStrength(15);
        standardCollation.setNumericCollation(true);
        EXEMPLARS = new String[][]{{"//ldml/characters/exemplarCharacters", "main", "Main Exemplars"}, {"//ldml/characters/exemplarCharacters[@type=\"punctuation\"]", "punctuation", "Punctuation Exemplars"}, {"//ldml/characters/exemplarCharacters[@type=\"index\"]", "index", "Index Exemplars"}};
        NONSPACING = new UnicodeSet("[[:Mn:][:Me:][:default_ignorable_code_point:]]").freeze();
        cleanLocaleParser = new LanguageTagParser();
        allButScripts = EnumSet.allOf(LanguageTagParser.Fields.class);
        allButScripts.remove((Object)LanguageTagParser.Fields.SCRIPT);
        setComposer = new UnicodeMap.Composer<Set<String>>(){

            @Override
            public Set<String> compose(int codepoint, String string, Set<String> a, Set<String> b) {
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                TreeSet<String> result = new TreeSet<String>(a);
                result.addAll(b);
                return result;
            }
        };
        LOCALE_TO_SCRIPT = new HashMap<String, String>();
        skipSet = ImmutableSet.of("draft", "alt");
        status = new CLDRFile.Status();
        headerAndFooter = new String[2];
    }

    static final class OptionalPrinter {
        PrintWriter printWriter;

        OptionalPrinter() {
        }

        public void print(String s2) {
            if (this.printWriter != null) {
                this.print(s2);
            }
        }

        public void println() {
            this.print("\n");
        }

        public void close() {
            if (this.printWriter != null) {
                this.close();
            }
        }
    }
}

