/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.LSRSource;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Validity;

public class LangTagsData {
    private final Pattern fullTagMatch = Pattern.compile("\\s*\"(full|tag)\": \"([^\"]+)\",");
    private final String SIL = "sil1";
    private final Splitter TAB_SPLITTER = Splitter.on('\t');
    private final Set<String> LIKELY_SPECIALS = ImmutableSet.of("in", "iw", "ji", "jw", "mo");
    private final Set<String> FIX_VALIDITY = ImmutableSet.of("Zanb");
    private final Set<String> FIX_COUNTRY = ImmutableSet.of("yi");
    private final Validity validity = Validity.getInstance();
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    static final CLDRFile english = CLDR_CONFIG.getEnglish();
    private static final LangTagsData INSTANCE = new LangTagsData();
    private final Multimap<String, String> wikiData;
    private final Map<String, LSRSource> jsonData;
    private final Errors processErrors = new Errors();

    private LangTagsData() {
        this.wikiData = this.readWikidata();
        this.jsonData = this.readJson();
    }

    public static LangTagsData getInstance() {
        return INSTANCE;
    }

    public static Multimap<String, String> getWikiData() {
        return LangTagsData.getInstance().wikiData;
    }

    public static Map<String, LSRSource> getJsonData() {
        return LangTagsData.getInstance().jsonData;
    }

    public static Errors getProcessErrors() {
        return LangTagsData.getInstance().processErrors;
    }

    private Map<String, LSRSource> readJson() {
        LanguageTagParser ltpFull = new LanguageTagParser();
        LanguageTagParser ltpTag = new LanguageTagParser();
        Path path = Paths.get(CLDRPaths.BIRTH_DATA_DIR, "/../external/langtags.json");
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path + " does not exist");
        }
        Matcher full = this.fullTagMatch.matcher("");
        TreeMap errors = new TreeMap();
        Output lastFull = new Output();
        TreeMap result = new TreeMap();
        LanguageTagCanonicalizer langCanoner = new LanguageTagCanonicalizer(null);
        try {
            Files.lines(path).forEach(x -> {
                if (full.reset((CharSequence)x).matches()) {
                    String key = full.group(1);
                    String value = full.group(2).replace("-", "_");
                    if (value.startsWith("aai")) {
                        boolean bl = false;
                    }
                    switch (key) {
                        case "full": {
                            lastFull.value = value;
                            break;
                        }
                        case "tag": {
                            if (lastFull.value == null) break;
                            try {
                                Collection<String> tempRegions;
                                ltpFull.set((String)lastFull.value);
                                ltpTag.set(value);
                                if (this.isIllFormed((String)lastFull.value, ltpFull) || this.isIllFormed(value, ltpTag)) {
                                    this.processErrors.put(Errors.Type.ill_formed_tags, value, (String)lastFull.value, "");
                                    break;
                                }
                                String fixedTag = langCanoner.transform(value);
                                String fixedFull = langCanoner.transform((String)lastFull.value);
                                if (!fixedTag.equals(value) || !fixedFull.equals(lastFull.value)) {
                                    this.processErrors.put(Errors.Type.canonicalizing, value, (String)lastFull.value, "mapped to: " + fixedTag + " \u27a1 " + fixedFull);
                                    ltpTag.set(fixedTag);
                                    ltpFull.set(fixedFull);
                                }
                                String fullLang = ltpFull.getLanguage();
                                String fullScript = ltpFull.getScript();
                                String fullRegion = ltpFull.getRegion();
                                Object reference = "sil1";
                                if ((fullRegion.equals("ZZ") || fullRegion.equals("001")) && !(tempRegions = this.wikiData.get(fullLang)).isEmpty()) {
                                    fullRegion = tempRegions.iterator().next();
                                    reference = (String)reference + " wikidata";
                                }
                                String tagLang = ltpTag.getLanguage();
                                String tagScript = ltpTag.getScript();
                                String tagRegion = ltpTag.getRegion();
                                if (!tagScript.isEmpty() && !tagRegion.isEmpty()) {
                                    this.processErrors.put(Errors.Type.tag_is_full, value, (String)lastFull.value, "");
                                    break;
                                }
                                if (!tagLang.equals(fullLang) || !tagScript.isEmpty() && !tagScript.equals(fullScript) || !tagRegion.isEmpty() && !tagRegion.equals(fullRegion)) {
                                    this.processErrors.put(Errors.Type.tag_not_in_full, value, (String)lastFull.value, "");
                                    break;
                                }
                                if (this.isOk(fullLang, fullScript, fullRegion, errors)) {
                                    this.add(result, fixedTag, fullLang, fullScript, fullRegion, (String)reference);
                                    break;
                                }
                                this.processErrors.put(Errors.Type.skipping_scope, value, ltpFull.toString(), errors.toString());
                            }
                            catch (Exception e) {
                                this.processErrors.put(Errors.Type.exception, value, (String)lastFull.value, e.getMessage());
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            });
            LinkedHashSet<String> toRemove = new LinkedHashSet<String>();
            for (Map.Entry entry : result.entrySet()) {
                String source = (String)entry.getKey();
                if (source.equals("lfn_Cyrl")) {
                    boolean bl = false;
                }
                if (!source.contains("_")) continue;
                CLDRLocale clocale = CLDRLocale.getInstance(source);
                String language = clocale.getLanguage();
                LSRSource fullForLanguage = (LSRSource)result.get(language);
                if (fullForLanguage == null) {
                    toRemove.add(source);
                    this.processErrors.put(Errors.Type.language_of_tag_missing, source, ((LSRSource)entry.getValue()).getLsrString(), "but no mapping for " + language);
                    continue;
                }
                CLDRLocale targetForLanguage = fullForLanguage.getCldrLocale();
                CLDRLocale target = ((LSRSource)entry.getValue()).getCldrLocale();
                if (!target.getLanguage().equals(targetForLanguage.getLanguage()) && !target.getScript().equals(targetForLanguage.getScript())) continue;
                toRemove.add(source);
                this.processErrors.put(Errors.Type.redundant_mapping, source, ((LSRSource)entry.getValue()).getLsrString(), "because: " + language + " \u27a1 " + targetForLanguage);
            }
            for (String badKey : toRemove) {
                result.remove(badKey);
            }
            this.processErrors.data = CldrUtility.protectCollection(this.processErrors.data);
            return CldrUtility.protectCollection(result);
        }
        catch (IOException ex) {
            throw new ICUUncheckedIOException(ex);
        }
    }

    private boolean isIllFormed(String source, LanguageTagParser languageTagParser) {
        return languageTagParser.getLanguage().isEmpty() || !languageTagParser.getVariants().isEmpty() || !languageTagParser.getExtensions().isEmpty() || !languageTagParser.getLocaleExtensions().isEmpty() || source.contains("@");
    }

    private boolean isOk(String lang, String script, String region, Map<StandardCodes.LstrType, Validity.Status> errors) {
        errors.clear();
        if (!this.LIKELY_SPECIALS.contains(lang)) {
            this.check(StandardCodes.LstrType.language, lang, errors);
        }
        if (!this.FIX_VALIDITY.contains(script)) {
            this.check(StandardCodes.LstrType.script, script, errors);
        }
        if (!region.equals("001") || Iso639Data.getType(lang) != Iso639Data.Type.Constructed) {
            this.check(StandardCodes.LstrType.region, region, errors);
        }
        return errors.isEmpty();
    }

    private void check(StandardCodes.LstrType lstrType, String lang, Map<StandardCodes.LstrType, Validity.Status> errors) {
        Validity.Status status = this.validity.getCodeToStatus(lstrType).get(lang);
        if (status != Validity.Status.regular) {
            errors.put(lstrType, status);
        }
    }

    private Multimap<String, String> readWikidata() {
        TreeMultimap result = TreeMultimap.create();
        Path path = Paths.get(CLDRPaths.BIRTH_DATA_DIR, "/../external/wididata_lang_region.tsv").normalize();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path + " does not exist");
        }
        try {
            Files.lines(path).forEach(x -> {
                if (!x.startsWith("#")) {
                    List<String> list = this.TAB_SPLITTER.splitToList((CharSequence)x);
                    String lang = list.get(1);
                    String region = list.get(3);
                    result.put(lang, region);
                }
            });
        }
        catch (IOException ex) {
            throw new ICUUncheckedIOException(ex);
        }
        return ImmutableMultimap.copyOf(result);
    }

    private void add(Map<String, LSRSource> result, String source, String lang, String script, String region, String reference) {
        LSRSource old = result.get(source);
        LSRSource newVersion = new LSRSource(lang, script, region, reference);
        if (old != null && !old.equals(newVersion)) {
            throw new IllegalArgumentException("Data already exists for " + source + ": old=" + old + ", new: " + newVersion);
        }
        result.put(source, newVersion);
    }

    public static class Errors {
        private Multimap<Type, String> data = TreeMultimap.create();

        public Multimap<Type, String> getData() {
            return this.data;
        }

        public void put(Type illFormedTags, String tagValue, String fullValue, String errorMessage) {
            this.data.put(illFormedTags, tagValue + " \u27a1 " + fullValue + (String)(errorMessage == null || errorMessage.isEmpty() ? "" : "\t\u2014\t" + errorMessage));
        }

        public void printAll() {
            for (Map.Entry<Type, Collection<String>> entry : this.data.asMap().entrySet()) {
                Type type = entry.getKey();
                System.out.println();
                for (String message : entry.getValue()) {
                    System.out.println(type + "\t" + message);
                }
            }
        }

        public static enum Type {
            ill_formed_tags("Ill-formed tags"),
            already_CLDR("Language already in CLDR"),
            tag_not_in_full("tag \u2284 full"),
            exception("exception"),
            skipping_scope("Skipping scope, SIL"),
            tag_is_full("Tag must not have both script and region"),
            language_of_tag_missing("Missing tag for just the language"),
            redundant_mapping("aaa => aaa_Bbbb_CC makes redundant aaa_Dddd => aaa_Dddd_CC & aaa_EE => aaa_Bbbb_EE"),
            canonicalizing("either the source or target are not canonical");

            private final String printable;

            private Type(String printable) {
                this.printable = printable;
            }
        }
    }
}

