/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ListCoverageLevels {
    public static void main(String[] args) {
        CLDRConfig config = CLDRConfig.getInstance();
        StandardCodes sc = StandardCodes.make();
        SupplementalDataInfo sdi = config.getSupplementalDataInfo();
        LanguageTagParser ltp = new LanguageTagParser();
        Set<String> defaultContents = sdi.getDefaultContentLocales();
        PathStarrer starrer = new PathStarrer().setSubstitutionPattern("*");
        Factory mainAndAnnotationsFactory = config.getMainAndAnnotationsFactory();
        Set<String> toTest = sc.getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
        LinkedHashSet _ALL = new LinkedHashSet();
        toTest.forEach(locale -> _ALL.add(CLDRLocale.getInstance(locale)));
        ImmutableSet ALL = ImmutableSet.copyOf(_ALL);
        TreeMap levelToCounter = new TreeMap();
        for (Level level : Level.values()) {
            levelToCounter.put(level, TreeMultiset.create());
        }
        for (String string : toTest) {
            CLDRFile file = mainAndAnnotationsFactory.make(string, false);
            CoverageLevel2 coverageLeveler = CoverageLevel2.getInstance(string);
            System.out.println(string);
            for (String string2 : file) {
                Level level = coverageLeveler.getLevel(string2);
                String skeleton = starrer.set(string2);
                ((Multiset)levelToCounter.get((Object)level)).add(skeleton);
            }
        }
        for (Map.Entry entry : levelToCounter.entrySet()) {
            Level level = (Level)((Object)entry.getKey());
            Multiset counter = (Multiset)entry.getValue();
            for (Multiset.Entry entry2 : counter.entrySet()) {
                System.out.println(level + "\t" + entry2.getCount() + "\t" + (String)entry2.getElement());
            }
        }
    }

    private static String getLocaleName(Set<CLDRLocale> all, Set<CLDRLocale> locales) {
        Function<Set, String> remainderName = x -> {
            LinkedHashSet y = new LinkedHashSet(all);
            y.removeAll((Collection<?>)x);
            return "AllLcs-(" + Joiner.on("|").join(y) + ")";
        };
        return all == null ? Joiner.on("|").join(locales) : (locales.equals(all) ? "AllLcs" : (locales.size() * 2 > all.size() ? remainderName.apply(locales) : Joiner.on("|").join(locales)));
    }

    static class Attributes
    implements Comparable<Attributes> {
        private static final Comparator<Iterable<String>> COLLECTION_COMPARATOR = Comparators.lexicographical(Comparator.naturalOrder());
        private final CLDRLocale cLoc;
        private final List<String> attributes;

        public Attributes(CLDRLocale cLoc, List<String> attributes2) {
            this.cLoc = cLoc;
            this.attributes = ImmutableList.copyOf(attributes2);
        }

        public static StringBuilder compact(Collection<List<String>> attrList, StringBuilder result) {
            Map<String, Map> map = Attributes.getMap(attrList);
            Attributes.getName(map, result);
            return result;
        }

        public static Multimap<String, List<String>> getLocaleNameToAttributeList(Set<CLDRLocale> all, Set<Attributes> attributeSet) {
            TreeMultimap localeNameToAttributeList = TreeMultimap.create(Comparator.naturalOrder(), COLLECTION_COMPARATOR);
            TreeMultimap attributesToLocales = TreeMultimap.create(COLLECTION_COMPARATOR, Comparator.naturalOrder());
            int count = 0;
            for (Attributes attributes : attributeSet) {
                count = attributes.attributes.size();
                attributesToLocales.put(attributes.attributes, attributes.cLoc);
            }
            if (count > 1) {
                boolean bl = false;
            }
            for (Map.Entry entry : attributesToLocales.asMap().entrySet()) {
                List attributeList = (List)entry.getKey();
                Set locales = (Set)entry.getValue();
                String localeName = ListCoverageLevels.getLocaleName(all, locales);
                localeNameToAttributeList.put(localeName, attributeList);
            }
            return localeNameToAttributeList;
        }

        private static void getName(Map<String, Map> map, StringBuilder result) {
            if (map.isEmpty()) {
                return;
            }
            result.append("(");
            boolean first = true;
            for (Map.Entry<String, Map> entry : map.entrySet()) {
                if (!first) {
                    result.append('|');
                } else {
                    first = false;
                }
                result.append(entry.getKey());
                Attributes.getName(entry.getValue(), result);
            }
            result.append(")");
        }

        private static <T, U extends Iterable<T>, V extends Iterable<U>> Map<T, Map> getMap(V source) {
            if (!source.iterator().hasNext()) {
                return Collections.emptyMap();
            }
            LinkedHashMap items = new LinkedHashMap();
            for (Iterable list : source) {
                LinkedHashMap top = items;
                for (Object item : list) {
                    LinkedHashMap value = (LinkedHashMap)top.get(item);
                    if (value == null) {
                        value = new LinkedHashMap();
                        top.put(item, value);
                    }
                    top = value;
                }
            }
            return items;
        }

        @Override
        public int compareTo(Attributes o) {
            return ComparisonChain.start().compare(this.cLoc, o.cLoc).compare(this.attributes, o.attributes, COLLECTION_COMPARATOR).result();
        }

        public String toString() {
            return this.attributes.isEmpty() ? this.cLoc.toString() : this.cLoc + "|" + Joiner.on("|").join(this.attributes);
        }
    }
}

