/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ShowLanguageData {
    static SupplementalDataInfo data = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static CLDRFile english = SimpleFactory.makeFile("en", CLDRPaths.MAIN_DIRECTORY, true);

    public static void main(String[] args) {
        long litPop;
        TreeMap map = new TreeMap();
        for (String language : data.getLanguagesForTerritoriesPopulationData()) {
            if (language.equals("und")) continue;
            for (String territory : data.getTerritoriesForPopulationData(language)) {
                SupplementalDataInfo.PopulationData popData;
                SupplementalDataInfo.OfficialStatus status;
                Counter<String> langCounter = (Counter<String>)map.get(territory);
                if (langCounter == null) {
                    langCounter = new Counter<String>();
                    map.put(territory, langCounter);
                }
                if (!(status = (popData = data.getLanguageAndTerritoryPopulationData(language, territory)).getOfficialStatus()).isMajor()) continue;
                litPop = (long)popData.getLiteratePopulation();
                langCounter.add(language, litPop);
            }
        }
        for (String territory : map.keySet()) {
            Counter langCounter = (Counter)map.get(territory);
            long total = langCounter.getTotal();
            if (total == 0L) continue;
            for (String language : langCounter.getKeysetSortedByCount(false)) {
                litPop = langCounter.getCount(language);
                System.out.println(language + "\t" + english.getName(language) + "\t" + territory + "\t" + english.getName(2, territory) + "\t" + (double)litPop / (double)total);
            }
        }
    }
}

