/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.ChartDayPeriods;
import org.unicode.cldr.tool.ChartDtdDelta;
import org.unicode.cldr.tool.ChartLanguageGroups;
import org.unicode.cldr.tool.ChartLanguageMatching;
import org.unicode.cldr.tool.ChartSubdivisions;
import org.unicode.cldr.tool.ChartUnitConversions;
import org.unicode.cldr.tool.ChartUnitPreferences;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.ShowLocaleCoverage;
import org.unicode.cldr.tool.ShowPlurals;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.ArrayComparator;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.MultiComparator;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="showlanguages", description="Generate Language info charts")
public class ShowLanguages {
    private static final boolean SHOW_NATIVE = true;
    static Comparator col = new MultiComparator(Collator.getInstance(new ULocale("en")), new UTF16.StringComparator(true, false, 0));
    static StandardCodes sc = StandardCodes.make();
    static Factory cldrFactory = CLDRConfig.getInstance().getCldrFactory();
    static CLDRFile english = CLDRConfig.getInstance().getEnglish();
    public static FormattedFileWriter.Anchors SUPPLEMENTAL_INDEX_ANCHORS = new FormattedFileWriter.Anchors();
    static SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
    static final Map<String, SupplementalDataInfo.OfficialStatus> languageToBestStatus = new HashMap<String, SupplementalDataInfo.OfficialStatus>();
    private static Relation<String, String> territoryFix;
    static ImmutableMap<String, String> fixScriptGif;
    private static Set<Iso639Data.Type> oldLanguage;
    static final Map<String, String> NAME_TO_REGION;
    static final Map<String, String> NAME_TO_CURRENCY;

    public static void main(String[] args) throws IOException {
        System.out.println("Writing into " + FormattedFileWriter.CHART_TARGET_DIR);
        FileCopier.ensureDirectoryExists(FormattedFileWriter.CHART_TARGET_DIR);
        FileCopier.copy(ShowLanguages.class, "index.css", FormattedFileWriter.CHART_TARGET_DIR);
        FormattedFileWriter.copyIncludeHtmls(FormattedFileWriter.CHART_TARGET_DIR);
        StringWriter sw = ShowLanguages.printLanguageData(cldrFactory, "index.html");
        ShowLanguages.writeSupplementalIndex("index.html", sw);
        System.out.println("Done - wrote into " + FormattedFileWriter.CHART_TARGET_DIR);
    }

    private static StringWriter printLanguageData(Factory cldrFactory, String filename) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        LanguageInfo linfo = new LanguageInfo(cldrFactory);
        linfo.showCoverageGoals(pw);
        new ChartDtdDelta().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
        ShowLocaleCoverage.showCoverage(SUPPLEMENTAL_INDEX_ANCHORS, null);
        new ChartDayPeriods().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
        new ChartLanguageMatching().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
        new ChartLanguageGroups().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
        new ChartSubdivisions().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
        if (ToolConstants.CHART_VERSION.compareTo("37") >= 0) {
            new ChartUnitConversions().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
            new ChartUnitPreferences().writeChart(SUPPLEMENTAL_INDEX_ANCHORS);
        }
        new ShowPlurals().printPlurals(english, null, pw, cldrFactory);
        linfo.printLikelySubtags(pw);
        linfo.showCountryLanguageInfo(pw);
        linfo.showLanguageCountryInfo(pw);
        ShowLanguages.printLanguageScript(linfo, pw);
        ShowLanguages.printScriptLanguageTerritory(linfo, pw);
        linfo.showCorrespondances();
        linfo.showCountryInfo(pw);
        linfo.printCurrency(pw);
        linfo.printContains(pw);
        linfo.printWindows_Tzid(pw);
        linfo.printAliases(pw);
        linfo.printCharacters(pw);
        pw.close();
        return sw;
    }

    private static void writeSupplementalIndex(String filename, StringWriter sw) throws IOException {
        String[] replacements = new String[]{"%date%", CldrUtility.isoFormatDateOnly(new Date()), "%contents%", SUPPLEMENTAL_INDEX_ANCHORS.toString(), "%data%", sw.toString(), "%index%", "../index.html"};
        PrintWriter pw2 = FileUtilities.openUTF8Writer(FormattedFileWriter.CHART_TARGET_DIR, filename);
        FileUtilities.appendFile(ShowLanguages.class, "supplemental.html", replacements, pw2);
        pw2.close();
    }

    private static void printLanguageScript(LanguageInfo linfo, PrintWriter pw) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Language", "class='source'", null, "class='source'", true).setSpanRows(true).setSortPriority(0).setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSpanRows(true).addColumn("ML", "class='target' title='modern language'", null, "class='target'", true).setSpanRows(true).setSortPriority(1).addColumn("P", "class='target' title='primary'", null, "class='target'", true).setSortPriority(3).addColumn("Script", "class='target'", null, "class='target'", true).setSortPriority(3).addColumn("Code", "class='target'", null, "class='target'", true).addColumn("MS", "class='target' title='modern script'", null, "class='target'", true).setSortPriority(2);
        TablePrinter tablePrinter2 = new TablePrinter().addColumn("Script", "class='source'", null, "class='source'", true).setSpanRows(true).setSortPriority(0).setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSpanRows(true).addColumn("MS", "class='target' title='modern script'", null, "class='target'", true).setSpanRows(true).setSortPriority(1).addColumn("Language", "class='target'", null, "class='target'", true).setSortPriority(3).addColumn("Code", "class='target'", null, "class='target'", true).addColumn("ML", "class='target' title='modern language'", null, "class='target'", true).setSortPriority(2).addColumn("P", "class='target' title='primary'", null, "class='target'", true).setSortPriority(3);
        TreeSet<String> remainingScripts = new TreeSet<String>(ShowLanguages.getScriptsToShow());
        UnicodeSet temp = new UnicodeSet();
        for (String string : ShowLanguages.getScriptsToShow()) {
            temp.clear();
            try {
                temp.applyPropertyAlias("script", string);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (temp.size() == 0) {
                remainingScripts.remove(string);
                System.out.println("Removing: " + string);
                continue;
            }
            System.out.println("Keeping: " + string);
        }
        remainingScripts.remove("Brai");
        remainingScripts.remove("Hira");
        remainingScripts.remove("Qaai");
        remainingScripts.remove("Hrkt");
        remainingScripts.remove("Zzzz");
        remainingScripts.remove("Zyyy");
        TreeSet<String> remainingLanguages = new TreeSet<String>(ShowLanguages.getLanguagesToShow());
        for (String language : ShowLanguages.getLanguagesToShow()) {
            Iso639Data.Scope s2 = Iso639Data.getScope(language);
            Iso639Data.Type t2 = Iso639Data.getType(language);
            if ((s2 == Iso639Data.Scope.Individual || s2 == Iso639Data.Scope.Macrolanguage) && t2 == Iso639Data.Type.Living) continue;
            remainingLanguages.remove(language);
        }
        Set<String> set = supplementalDataInfo.getBasicLanguageDataLanguages();
        for (String language : set) {
            Set<SupplementalDataInfo.BasicLanguageData> basicLanguageData = supplementalDataInfo.getBasicLanguageData(language);
            for (SupplementalDataInfo.BasicLanguageData basicData : basicLanguageData) {
                String secondary = ShowLanguages.isOfficial(language) ? "\u00a0" : "N";
                for (String script : basicData.getScripts()) {
                    ShowLanguages.addLanguageScriptCells(tablePrinter, tablePrinter2, language, script, secondary);
                    remainingScripts.remove(script);
                    remainingLanguages.remove(language);
                }
            }
        }
        for (String language : remainingLanguages) {
            ShowLanguages.addLanguageScriptCells(tablePrinter, tablePrinter2, language, "Zzzz", "?");
        }
        for (String script : remainingScripts) {
            ShowLanguages.addLanguageScriptCells(tablePrinter, tablePrinter2, "und", script, "?");
        }
        PrintWriter pw1 = new PrintWriter(new FormattedFileWriter(null, "Languages and Scripts", null, SUPPLEMENTAL_INDEX_ANCHORS));
        pw1.println(tablePrinter.toTable());
        pw1.close();
        pw1 = new PrintWriter(new FormattedFileWriter(null, "Scripts and Languages", null, SUPPLEMENTAL_INDEX_ANCHORS));
        pw1.println(tablePrinter2.toTable());
        pw1.close();
    }

    private static boolean isOfficial(String language) {
        SupplementalDataInfo.OfficialStatus status = languageToBestStatus.get(language);
        if (status != null && status.isMajor()) {
            return true;
        }
        int underbar = language.indexOf(95);
        if (underbar < 0) {
            return false;
        }
        return ShowLanguages.isOfficial(language.substring(0, underbar));
    }

    private static Set<String> getLanguagesToShow() {
        return ShowLanguages.getEnglishTypes("language", 0);
    }

    private static Set<String> getEnglishTypes(String type, int code) {
        HashSet<String> result = new HashSet<String>(sc.getSurveyToolDisplayCodes(type));
        Iterator<String> it = english.getAvailableIterator(code);
        while (it.hasNext()) {
            XPathParts parts = XPathParts.getFrozenInstance(it.next());
            String newType = parts.getAttributeValue(-1, "type");
            if (result.contains(newType)) continue;
            result.add(newType);
        }
        return result;
    }

    private static Set<String> getScriptsToShow() {
        return ShowLanguages.getEnglishTypes("script", 1);
    }

    private static void printScriptLanguageTerritory(LanguageInfo linfo, PrintWriter pw) throws IOException {
        TablePrinter tablePrinter2 = new TablePrinter().addColumn("Sample Char", "class='source'", null, "class='source sample'", true).setSpanRows(true).addColumn("Script", "class='source'", null, "class='source'", true).setSpanRows(true).setSortPriority(0).setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSpanRows(true).addColumn("T", "class='target'", null, "class='target'", true).setSortPriority(1).addColumn("Language", "class='target'", null, "class='target'", true).setSortPriority(2).addColumn("Native", "class='target'", null, "class='target'", true).addColumn("Code", "class='target'", null, "class='target'", true).addColumn("T", "class='target'", null, "class='target'", true).setSortPriority(3).addColumn("Territory", "class='target'", null, "class='target'", true).setSortPriority(4).addColumn("Native", "class='target'", null, "class='target'", true).addColumn("Code", "class='target'", null, "class='target'", true);
        TreeSet<String> remainingScripts = new TreeSet<String>(ShowLanguages.getScriptsToShow());
        TreeSet<String> remainingTerritories = new TreeSet<String>(sc.getGoodAvailableCodes("territory"));
        UnicodeSet temp = new UnicodeSet();
        for (String string : ShowLanguages.getScriptsToShow()) {
            temp.clear();
            try {
                temp.applyPropertyAlias("script", string);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (temp.size() == 0) {
                remainingScripts.remove(string);
                System.out.println("Removing: " + string);
                continue;
            }
            System.out.println("Keeping: " + string);
        }
        remainingScripts.remove("Brai");
        remainingScripts.remove("Hira");
        remainingScripts.remove("Qaai");
        remainingScripts.remove("Hrkt");
        remainingScripts.remove("Zzzz");
        remainingScripts.remove("Zyyy");
        TreeSet<String> remainingLanguages = new TreeSet<String>(ShowLanguages.getLanguagesToShow());
        for (String language : ShowLanguages.getLanguagesToShow()) {
            Iso639Data.Scope s2 = Iso639Data.getScope(language);
            Iso639Data.Type t2 = Iso639Data.getType(language);
            if ((s2 == Iso639Data.Scope.Individual || s2 == Iso639Data.Scope.Macrolanguage) && t2 == Iso639Data.Type.Living) continue;
            remainingLanguages.remove(language);
        }
        Set<String> set = supplementalDataInfo.getBasicLanguageDataLanguages();
        for (String language : set) {
            Set<SupplementalDataInfo.BasicLanguageData> basicLanguageData = supplementalDataInfo.getBasicLanguageData(language);
            for (SupplementalDataInfo.BasicLanguageData basicData : basicLanguageData) {
                TreeSet<String> mainScripts;
                Set<String> mainTerritories;
                if (basicData.getType() != SupplementalDataInfo.BasicLanguageData.Type.primary || (mainTerritories = ShowLanguages.getTerritories(language)).size() == 0 || (mainScripts = new TreeSet<String>(basicData.getScripts())).size() == 0) continue;
                for (String script : mainScripts) {
                    for (String territory : mainTerritories) {
                        ShowLanguages.addLanguageScriptCells2(tablePrinter2, language, script, territory);
                        remainingTerritories.remove(territory);
                    }
                    remainingScripts.remove(script);
                }
            }
            remainingLanguages.remove(language);
        }
        PrintWriter pw1 = new PrintWriter(new FormattedFileWriter(null, "Scripts, Languages, and Territories", null, SUPPLEMENTAL_INDEX_ANCHORS));
        pw1.println(tablePrinter2.toTable());
        pw1.close();
    }

    private static Set<String> getTerritories(String language) {
        Set<String> territories;
        if (territoryFix == null) {
            ShowLanguages.initTerritoryFix();
        }
        if ((territories = territoryFix.getAll(language)) == null) {
            territories = new TreeSet<String>();
        }
        return territories;
    }

    private static void initTerritoryFix() {
        territoryFix = Relation.of(new TreeMap(), TreeSet.class);
        Set<String> languages = supplementalDataInfo.getLanguages();
        LanguageTagParser ltp = new LanguageTagParser();
        for (String language2 : languages) {
            if (language2.contains("_")) {
                ltp.set(language2).getLanguage();
                ShowLanguages.addOfficialTerritory(ltp, language2, ltp.getLanguage());
                continue;
            }
            ShowLanguages.addOfficialTerritory(ltp, language2, language2);
        }
    }

    private static void addOfficialTerritory(LanguageTagParser ltp, String language, String baseLanguage) {
        Set<String> territories = supplementalDataInfo.getTerritoriesForPopulationData(language);
        if (territories == null) {
            return;
        }
        for (String territory : territories) {
            SupplementalDataInfo.PopulationData data = supplementalDataInfo.getLanguageAndTerritoryPopulationData(language, territory);
            SupplementalDataInfo.OfficialStatus status = data.getOfficialStatus();
            if (!status.isMajor()) continue;
            territoryFix.put(baseLanguage, territory);
            System.out.println("\tAdding\t" + baseLanguage + "\t" + territory + "\t" + language);
        }
    }

    private static void addLanguageScriptCells2(TablePrinter tablePrinter2, String language, String script, String territory) {
        String nativeTerritoryName;
        String nativeLanguageName;
        String languageName;
        CLDRFile nativeLanguage = null;
        try {
            nativeLanguage = cldrFactory.make(language + "_" + script + "_" + territory, true);
        }
        catch (RuntimeException e) {
            try {
                nativeLanguage = cldrFactory.make(language + "_" + script, true);
            }
            catch (RuntimeException e2) {
                try {
                    nativeLanguage = cldrFactory.make(language, true);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        if (!(nativeLanguage == null || script.equals("Jpan") || script.equals("Hans") || script.equals("Hant"))) {
            UnicodeSet scriptSet;
            try {
                String tempScript = script.equals("Kore") ? "Hang" : script;
                scriptSet = new UnicodeSet("[:script=" + tempScript + ":]");
            }
            catch (RuntimeException e) {
                scriptSet = new UnicodeSet();
            }
            UnicodeSet exemplars = nativeLanguage.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
            if (scriptSet.containsNone(exemplars)) {
                System.out.println("Skipping CLDR file -- exemplars differ: " + language + "\t" + nativeLanguage.getLocaleID() + "\t" + scriptSet + "\t" + exemplars);
                nativeLanguage = null;
            }
        }
        if ((languageName = english.getName(0, language)) == null) {
            languageName = "???";
        }
        String isLanguageTranslated = "";
        String string = nativeLanguageName = nativeLanguage == null ? null : nativeLanguage.getName(0, language);
        if (nativeLanguageName == null || nativeLanguageName.equals(language)) {
            nativeLanguageName = "<i>n/a</i>";
            isLanguageTranslated = "n";
        }
        String scriptName = english.getName(1, script);
        String isTerritoryTranslated = "";
        String territoryName = english.getName(2, territory);
        String string2 = nativeTerritoryName = nativeLanguage == null ? null : nativeLanguage.getName(2, territory);
        if (nativeTerritoryName == null || nativeTerritoryName.equals(territory)) {
            nativeTerritoryName = "<i>n/a</i>";
            isTerritoryTranslated = "n";
        }
        ScriptMetadata.Info scriptMetatdata = ScriptMetadata.getInfo(script);
        tablePrinter2.addRow().addCell((Comparable)((Object)scriptMetatdata.sampleChar)).addCell((Comparable)((Object)scriptName)).addCell((Comparable)((Object)script)).addCell((Comparable)((Object)isLanguageTranslated)).addCell((Comparable)((Object)languageName)).addCell((Comparable)((Object)nativeLanguageName)).addCell((Comparable)((Object)language)).addCell((Comparable)((Object)isTerritoryTranslated)).addCell((Comparable)((Object)territoryName)).addCell((Comparable)((Object)nativeTerritoryName)).addCell((Comparable)((Object)territory)).finishRow();
    }

    private static String getGifName(String script) {
        String temp = fixScriptGif.get(script);
        if (temp != null) {
            return temp;
        }
        String scriptName = english.getName(1, script);
        temp = fixScriptGif.get(scriptName = scriptName.toLowerCase(Locale.ENGLISH));
        if (temp != null) {
            return temp;
        }
        return scriptName;
    }

    private static void addLanguageScriptCells(TablePrinter tablePrinter, TablePrinter tablePrinter2, String language, String script, String secondary) {
        Object scriptName;
        Object languageName = english.getName(0, language);
        if (languageName == null) {
            languageName = "\u00bf" + language + "?";
            System.err.println("No English Language Name for:" + language);
        }
        if ((scriptName = english.getName(1, script)) == null) {
            scriptName = "\u00bf" + script + "?";
            System.err.println("No English Language Name for:" + script);
        }
        String scriptModern = StandardCodes.isScriptModern(script) ? "" : (script.equals("Zzzz") ? "n/a" : "N");
        Iso639Data.Type t2 = Iso639Data.getType(language);
        String languageModern = oldLanguage.contains((Object)t2) ? "O" : (language.equals("und") ? "?" : "");
        tablePrinter.addRow().addCell((Comparable)languageName).addCell((Comparable)((Object)language)).addCell((Comparable)((Object)languageModern)).addCell((Comparable)((Object)secondary)).addCell((Comparable)scriptName).addCell((Comparable)((Object)script)).addCell((Comparable)((Object)scriptModern)).finishRow();
        tablePrinter2.addRow().addCell((Comparable)scriptName).addCell((Comparable)((Object)script)).addCell((Comparable)((Object)scriptModern)).addCell((Comparable)languageName).addCell((Comparable)((Object)language)).addCell((Comparable)((Object)languageModern)).addCell((Comparable)((Object)secondary)).finishRow();
    }

    private static Map<String, Set<String>> getInverse(Map<String, Set<String>> language_territories) {
        TreeMap<String, Set<String>> territory_languages = new TreeMap<String, Set<String>>();
        for (String language : language_territories.keySet()) {
            Set<String> territories = language_territories.get(language);
            for (String territory : territories) {
                TreeSet<String> languages = (TreeSet<String>)territory_languages.get(territory);
                if (languages == null) {
                    languages = new TreeSet<String>(col);
                    territory_languages.put(territory, languages);
                }
                languages.add(language);
            }
        }
        return territory_languages;
    }

    private static SortedMap<String, String> getNameToCode(StandardCodes.CodeType codeType, String cldrCodeType) {
        TreeMap<String, String> temp = new TreeMap(col);
        for (String territory : StandardCodes.make().getAvailableCodes(codeType)) {
            String name = english.getName(cldrCodeType, territory);
            temp.put(name == null ? territory : name, territory);
        }
        temp = Collections.unmodifiableSortedMap(temp);
        return temp;
    }

    private static void addTokens(String key, String values, String value_delimiter, Map<String, Set<String>> key_value) {
        if (values != null) {
            Set<String> s2 = key_value.get(key);
            if (s2 == null) {
                s2 = new TreeSet<String>(col);
                key_value.put(key, s2);
            }
            s2.addAll(Arrays.asList(values.split(value_delimiter)));
        }
    }

    private static void addTokens(String key, String values, String value_delimiter, Multimap<String, String> key_value) {
        if (values != null) {
            key_value.putAll(key, Arrays.asList(values.split(value_delimiter)));
        }
    }

    public static void showContents(Appendable pw, String ... items) {
        try {
            pw.append("</div>" + System.lineSeparator());
            pw.append("<h3>Contents</h3>" + System.lineSeparator());
            pw.append("<ol>" + System.lineSeparator());
            for (int i = 0; i < items.length; i += 2) {
                pw.append("<li><a href='#" + items[i] + "'>" + items[i + 1] + "</a></li>" + System.lineSeparator());
            }
            pw.append("</ol><hr>" + System.lineSeparator());
            pw.append("<div align='center'>" + System.lineSeparator());
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    static {
        for (String language : supplementalDataInfo.getLanguagesForTerritoriesPopulationData()) {
            Set<String> territories = supplementalDataInfo.getTerritoriesForPopulationData(language);
            if (territories == null) continue;
            int underbar = language.indexOf(95);
            String base = underbar < 0 ? null : language.substring(0, underbar);
            for (String territory : territories) {
                SupplementalDataInfo.PopulationData data = supplementalDataInfo.getLanguageAndTerritoryPopulationData(language, territory);
                SupplementalDataInfo.OfficialStatus status = data.getOfficialStatus();
                SupplementalDataInfo.OfficialStatus old = languageToBestStatus.get(language);
                if (old == null || status.compareTo(old) > 0) {
                    languageToBestStatus.put(language, status);
                }
                if (base == null || (old = languageToBestStatus.get(base)) != null && status.compareTo(old) <= 0) continue;
                languageToBestStatus.put(base, status);
            }
        }
        fixScriptGif = ImmutableMap.builder().put("hangul", "hangulsyllables").put("japanese", "hiragana").put("unknown or invalid script", "unknown").put("Hant", "Hant").put("Hans", "Hans").build();
        oldLanguage = Collections.unmodifiableSet(EnumSet.of(Iso639Data.Type.Ancient, Iso639Data.Type.Extinct, Iso639Data.Type.Historical, Iso639Data.Type.Constructed));
        NAME_TO_REGION = ShowLanguages.getNameToCode(StandardCodes.CodeType.territory, "region");
        NAME_TO_CURRENCY = ShowLanguages.getNameToCode(StandardCodes.CodeType.currency, "currency");
    }

    static class LanguageInfo {
        private static final Map<String, Map<String, String>> localeAliasInfo = new TreeMap<String, Map<String, String>>();
        Multimap<String, String> language_scripts = TreeMultimap.create();
        Multimap<String, String> language_territories = TreeMultimap.create();
        List<Map<String, String>> deprecatedItems = new ArrayList<Map<String, String>>();
        Multimap<String, String> territory_languages;
        Multimap<String, String> script_languages;
        Set<String[]> aliases = new TreeSet<String[]>(new ArrayComparator(new UTF16.StringComparator(), col));
        Comparator col3 = new ArrayComparator(col, col, col);
        Map<String, String> currency_fractions = new TreeMap<String, String>(col);
        Map<String, Set> currency_territory = new TreeMap<String, Set>(col);
        Map<String, Set> territory_currency = new TreeMap<String, Set>(col);
        Set<String> territoriesWithCurrencies = new TreeSet<String>();
        Set<String> currenciesWithTerritories = new TreeSet<String>();
        Map<String, Map<String, Set<String>>> territoryData = new TreeMap<String, Map<String, Set<String>>>();
        Set<String> territoryTypes = new TreeSet<String>();
        Map<String, LinkedHashSet<String>> charSubstitutions = new TreeMap<String, LinkedHashSet<String>>(col);
        String defaultDigits = null;
        Map<String, Map<String, Object>> territoryLanguageData = new TreeMap<String, Map<String, Object>>();
        private Relation<String, String> territoriesToModernCurrencies = Relation.of(new TreeMap(), TreeSet.class, null);
        static final Comparator INVERSE_COMPARABLE = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)o2).compareTo(o1);
            }
        };
        static final UnicodeSet ESCAPED_URI_QUERY = new UnicodeSet("[\\u0000-\\u0020\\u007F <>#%\"\\{}|\\\\\\^\\[\\]`;/?:@\\&=+,$\\u0080-\\U0001FFFF]").freeze();
        private static final int MINIMAL_BIG_VENDOR = 8;
        static final Set<Organization> TC_Vendors;
        LanguageTagParser lpt2 = new LanguageTagParser();
        static Normalizer2 nfd;
        Comparator territoryNameComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return col.compare(this.getName(2, (String)o1, false), this.getName(2, (String)o2, false));
            }
        };
        static String[] stringArrayPattern;
        static String[][] string2ArrayPattern;
        public static Map<String, String> territoryAliases;

        public LanguageInfo(Factory cldrFactory) throws IOException {
            CLDRFile supp = cldrFactory.make("supplementalData", false);
            for (String path : supp) {
                Map<String, String> attributes;
                String element;
                String type;
                Map<String, String> attributes2;
                String fullPath = supp.getFullXPath(path);
                if (fullPath == null) {
                    supp.getFullXPath(path);
                }
                XPathParts parts = XPathParts.getFrozenInstance(fullPath);
                if (path.indexOf("/zoneItem") >= 0) {
                    attributes2 = parts.getAttributes(parts.size() - 1);
                    type = attributes2.get("type");
                    String aliasAttributes = attributes2.get("aliases");
                    if (aliasAttributes == null) continue;
                    String[] aliasesList = aliasAttributes.split("\\s+");
                    for (int i = 0; i < aliasesList.length; ++i) {
                        String alias = aliasesList[i];
                        this.aliases.add(new String[]{"timezone", alias, type});
                    }
                    continue;
                }
                if (path.indexOf("/currencyData") >= 0) {
                    String iso4217;
                    if (path.indexOf("/fractions") >= 0) {
                        element = parts.getElement(parts.size() - 1);
                        if (!element.equals("info")) {
                            throw new IllegalArgumentException("Unexpected fractions element: " + element);
                        }
                        attributes = parts.getAttributes(parts.size() - 1);
                        iso4217 = attributes.get("iso4217");
                        Object digits = attributes.get("digits");
                        String rounding = attributes.get("rounding");
                        digits = (String)digits + (String)(rounding.equals("0") ? "" : " (" + rounding + ")");
                        if (iso4217.equals("DEFAULT")) {
                            this.defaultDigits = digits;
                            continue;
                        }
                        this.currency_fractions.put(this.getName(4, iso4217, false), (String)digits);
                        continue;
                    }
                    if (path.indexOf("/region") >= 0) {
                        String from;
                        attributes2 = parts.getAttributes(parts.size() - 2);
                        String iso3166 = attributes2.get("iso3166");
                        attributes2 = parts.getAttributes(parts.size() - 1);
                        iso4217 = attributes2.get("iso4217");
                        String to = attributes2.get("to");
                        if (to == null) {
                            to = "\u221e";
                        }
                        if ((from = attributes2.get("from")) == null) {
                            from = "-\u221e";
                        }
                        String countryName = this.getName(2, iso3166, false);
                        String currencyName = this.getName(4, iso4217, false);
                        Set<CallSite> info = this.territory_currency.get(countryName);
                        if (info == null) {
                            info = new TreeSet<String[]>(this.col3);
                            this.territory_currency.put(countryName, info);
                        }
                        info.add((CallSite)new String[]{from, to, currencyName});
                        info = this.currency_territory.get(currencyName);
                        if (info == null) {
                            info = new TreeSet(col);
                            this.currency_territory.put(currencyName, info);
                        }
                        this.territoriesWithCurrencies.add(iso3166);
                        this.currenciesWithTerritories.add(iso4217);
                        if (to.equals("\u221e") || to.compareTo("2006") > 0) {
                            this.territoriesToModernCurrencies.put(iso3166, iso4217);
                            info.add((CallSite)((Object)("<b>" + countryName + "</b>")));
                            continue;
                        }
                        info.add((CallSite)((Object)("<i>" + countryName + "</i>")));
                        continue;
                    }
                }
                if (path.indexOf("/languageData") >= 0) {
                    attributes2 = parts.findAttributes("language");
                    Object language = attributes2.get("type");
                    String alt = attributes2.get("alt");
                    ShowLanguages.addTokens((String)language, attributes2.get("scripts"), " ", this.language_scripts);
                    if (alt != null) {
                        language = "secondary".equals(alt) ? (String)language + "*" : (String)language + "*" + alt;
                    }
                    ShowLanguages.addTokens((String)language, attributes2.get("territories"), " ", this.language_territories);
                    continue;
                }
                if (path.indexOf("/deprecatedItems") >= 0) {
                    this.deprecatedItems.add(parts.findAttributes("deprecatedItems"));
                    continue;
                }
                if (path.indexOf("/calendarData") >= 0) {
                    attributes2 = parts.findAttributes("calendar");
                    if (attributes2 == null) {
                        System.err.println("Err: on path " + (String)fullPath + " , no attributes on 'calendar'. Probably, this tool is out of date.");
                    } else {
                        type = attributes2.get("type");
                        String territories = attributes2.get("territories");
                        if (territories == null) {
                            System.err.println("Err: on path " + (String)fullPath + ", missing territories. Probably, this tool is out of date.");
                        } else if (type == null) {
                            System.err.println("Err: on path " + (String)fullPath + ", missing type. Probably, this tool is out of date.");
                        } else {
                            this.addTerritoryInfo(territories, "calendar", type);
                        }
                    }
                }
                if (path.indexOf("/weekData") >= 0 || path.indexOf("measurementData") >= 0) {
                    element = parts.getElement(parts.size() - 1);
                    attributes = parts.getAttributes(parts.size() - 1);
                    String key = "count";
                    String display = "Days in week (min)";
                    boolean useTerritory = true;
                    switch (element) {
                        case "firstDay": {
                            key = "day";
                            display = "First day of week";
                            break;
                        }
                        case "weekendStart": {
                            key = "day";
                            display = "First day of weekend";
                            break;
                        }
                        case "weekendEnd": {
                            key = "day";
                            display = "Last day of weekend";
                            break;
                        }
                        case "measurementSystem": {
                            key = "type";
                            display = "Meas. system";
                            break;
                        }
                        case "paperSize": {
                            key = "type";
                            display = "Paper Size";
                            break;
                        }
                        case "weekOfPreference": {
                            useTerritory = false;
                        }
                    }
                    if (useTerritory) {
                        String type2 = attributes.get(key);
                        String territories = attributes.get("territories");
                        this.addTerritoryInfo(territories, display, type2);
                    }
                }
                if (path.indexOf("/generation") >= 0 || path.indexOf("/version") >= 0) continue;
                System.out.println("Skipped Element: " + path);
            }
            for (String territory : supplementalDataInfo.getTerritoriesWithPopulationData()) {
                for (String language : supplementalDataInfo.getLanguagesForTerritoryWithPopulationData(territory)) {
                    this.language_territories.put(language, territory);
                }
            }
            this.territory_languages = Multimaps.invertFrom(this.language_territories, TreeMultimap.create());
            this.script_languages = Multimaps.invertFrom(this.language_scripts, TreeMultimap.create());
            localeAliasInfo.put("language", new TreeMap());
            localeAliasInfo.put("script", new TreeMap());
            localeAliasInfo.put("territory", new TreeMap());
            localeAliasInfo.put("variant", new TreeMap());
            localeAliasInfo.put("zone", new TreeMap());
            localeAliasInfo.put("subdivision", new TreeMap());
            localeAliasInfo.put("unit", new TreeMap());
            localeAliasInfo.put("usage", new TreeMap());
            localeAliasInfo.get("language").put("zh_CN", "zh_Hans_CN");
            localeAliasInfo.get("language").put("zh_SG", "zh_Hans_SG");
            localeAliasInfo.get("language").put("zh_TW", "zh_Hant_TW");
            localeAliasInfo.get("language").put("zh_MO", "zh_Hant_MO");
            localeAliasInfo.get("language").put("zh_HK", "zh_Hant_HK");
            Map<String, Map<String, Row.R2<List<String>, String>>> localeAliasInfo2 = supplementalDataInfo.getLocaleAliasInfo();
            for (Map.Entry<String, Map<String, Row.R2<List<String>, String>>> entry1 : localeAliasInfo2.entrySet()) {
                String element = entry1.getKey();
                for (Map.Entry<String, Row.R2<List<String>, String>> entry2 : entry1.getValue().entrySet()) {
                    String type = entry2.getKey();
                    Row.R2<List<String>, String> replacementReason = entry2.getValue();
                    List replacementList = (List)replacementReason.get0();
                    String replacement = replacementList == null ? null : Joiner.on(" ").join(replacementList);
                    String reason = (String)replacementReason.get1();
                    if (element.equals("timezone")) {
                        element = "zone";
                    }
                    try {
                        localeAliasInfo.get(element).put(type, replacement == null ? "?" : replacement);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Can't find alias data for '" + element + "'", e);
                    }
                    Object name = "";
                    if (replacement == null) {
                        name = "(none)";
                    } else if (element.equals("language")) {
                        name = this.getName(replacement, false);
                    } else if (element.equals("zone")) {
                        element = "timezone";
                        name = replacement + "*";
                    } else {
                        int typeCode = CLDRFile.typeNameToCode(element);
                        name = typeCode >= 0 ? this.getName(typeCode, replacement, false) : "*" + replacement;
                    }
                    if (element.equals("territory")) {
                        territoryAliases.put(type, (String)name);
                        this.aliases.add(new String[]{element, this.getName(2, type, false), name, reason});
                        continue;
                    }
                    this.aliases.add(new String[]{element, type, name, reason});
                }
            }
            Log.setLog(CLDRPaths.CHART_DIRECTORY + "supplemental/", "characterLog.txt");
            Log.close();
        }

        public void printLikelySubtags(PrintWriter index) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Likely Subtags", null, SUPPLEMENTAL_INDEX_ANCHORS));
            TablePrinter tablePrinter = new TablePrinter().addColumn("Source Lang", "class='source'", null, "class='source'", true).setSortPriority(1).setSpanRows(false).addColumn("Source Script", "class='source'", null, "class='source'", true).setSortPriority(0).setSpanRows(false).setBreakSpans(true).addColumn("Source Region", "class='source'", null, "class='source'", true).setSortPriority(2).setSpanRows(false).addColumn("Target Lang", "class='target'", null, "class='target'", true).setSortPriority(3).setBreakSpans(true).addColumn("Target Script", "class='target'", null, "class='target'", true).setSortPriority(4).addColumn("Target Region", "class='target'", null, "class='target'", true).setSortPriority(5).addColumn("Source ID", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Target ID", "class='target'", null, "class='target'", true);
            Map<String, String> subtags = supplementalDataInfo.getLikelySubtags();
            LanguageTagParser sourceParsed = new LanguageTagParser();
            LanguageTagParser targetParsed = new LanguageTagParser();
            for (String source : subtags.keySet()) {
                String target = subtags.get(source);
                sourceParsed.set(source);
                targetParsed.set(target);
                tablePrinter.addRow().addCell((Comparable)((Object)this.getName(0, sourceParsed.getLanguage()))).addCell((Comparable)((Object)this.getName(1, sourceParsed.getScript()))).addCell((Comparable)((Object)this.getName(2, sourceParsed.getRegion()))).addCell((Comparable)((Object)this.getName(0, targetParsed.getLanguage()))).addCell((Comparable)((Object)this.getName(1, targetParsed.getScript()))).addCell((Comparable)((Object)this.getName(2, targetParsed.getRegion()))).addCell((Comparable)((Object)source)).addCell((Comparable)((Object)target)).finishRow();
            }
            pw.println(tablePrinter.toTable());
            pw.close();
        }

        private String getName(int type, String value) {
            if (value == null || value.equals("") || value.equals("und")) {
                return "\u00a0";
            }
            String result = english.getName(type, value);
            if (result == null) {
                result = value;
            }
            return result;
        }

        private String urlEncode(String input) {
            try {
                byte[] utf8 = input.getBytes("utf-8");
                StringBuffer output = new StringBuffer();
                for (int i = 0; i < utf8.length; ++i) {
                    int b = utf8[i] & 0xFF;
                    if (ESCAPED_URI_QUERY.contains(b)) {
                        output.append('%');
                        if (b < 16) {
                            output.append('0');
                        }
                        output.append(Integer.toString(b, 16));
                        continue;
                    }
                    output.append((char)b);
                }
                return output.toString();
            }
            catch (UnsupportedEncodingException e) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
            }
        }

        private String addBug(int bugNumber, String text, String from, String subject, String body) {
            return "<a target='_blank' href='https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>" + text + "</a>";
        }

        private void showLanguageCountryInfo(PrintWriter pw) throws IOException {
            PrintWriter pw21;
            FormattedFileWriter ffw = new FormattedFileWriter(null, "Language-Territory Information", null, SUPPLEMENTAL_INDEX_ANCHORS);
            PrintWriter pw2 = pw21 = new PrintWriter(ffw);
            NumberFormat nf = NumberFormat.getInstance(ULocale.ENGLISH);
            nf.setGroupingUsed(true);
            TablePrinter tablePrinter = new TablePrinter().addColumn("L", "class='source'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).setRepeatHeader(true).setHidden(true).addColumn("Language", "class='source'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Territory", "class='target'", null, "class='target'", true).addColumn("Code", "class='target'", "<a href=\"territory_language_information.html#{0}\">{0}</a>", "class='target'", true).addColumn("Language Population", "class='target'", "{0,number,#,#@@}", "class='targetRight'", true).setSortPriority(1).setSortAscending(false);
            TreeSet<String> languages = new TreeSet<String>();
            ArrayList<Comparable[]> data = new ArrayList<Comparable[]>();
            String msg = "<br><i>Please click on each country code</i>";
            ArrayList<Comparable[]> plainData = new ArrayList<Comparable[]>();
            for (String territoryCode : supplementalDataInfo.getTerritoriesWithPopulationData()) {
                String territoryName = english.getName(2, territoryCode);
                for (String string : supplementalDataInfo.getLanguagesForTerritoryWithPopulationData(territoryCode)) {
                    SupplementalDataInfo.PopulationData languageData = supplementalDataInfo.getLanguageAndTerritoryPopulationData(string, territoryCode);
                    languages.add(string);
                    Comparable[] items = new Comparable[]{this.getFirstPrimaryWeight(this.getLanguageName(string)), this.getLanguageName(string), string, territoryName + this.getOfficialStatus(territoryCode, string), territoryCode, Double.valueOf(languageData.getPopulation())};
                    Comparable[] plainItems = new Comparable[]{this.getLanguageName(string), string, territoryName, territoryCode, this.getRawOfficialStatus(territoryCode, string), Double.valueOf(languageData.getPopulation()), Double.valueOf(languageData.getLiteratePopulation())};
                    data.add(items);
                    plainData.add(plainItems);
                }
            }
            for (String languageCode : languages) {
                Comparable[] items = new Comparable[]{this.getFirstPrimaryWeight(this.getLanguageName(languageCode)), this.getLanguageName(languageCode), languageCode, this.addBug(1217, "<i>add new</i>", "<email>", "Add territory to " + this.getLanguageName(languageCode) + " (" + languageCode + ")", "<territory, speaker population in territory, and references>"), "", Double.valueOf(0.0)};
                data.add(items);
            }
            Comparable[][] flattened = (Comparable[][])data.toArray((T[])new Comparable[data.size()][]);
            String value = tablePrinter.addRows(flattened).toTable();
            pw2.println(value);
            pw2.close();
            try (PrintWriter pw21plain = FileUtilities.openUTF8Writer(ffw.getDir(), ffw.getBaseFileName() + ".txt");){
                for (Object[] objectArray : plainData) {
                    pw21plain.println(Joiner.on("\t").join(objectArray));
                }
            }
        }

        private String getLanguagePluralMessage(String msg, String languageCode) {
            String mainLanguageCode = new LanguageTagParser().set(languageCode).getLanguage();
            String messageWithPlurals = msg + ", on <a href='language_plural_rules.html#" + mainLanguageCode + "'>plurals</a>, and on <a href='likely_subtags.html#" + mainLanguageCode + "'>likely-subtags</a>";
            return messageWithPlurals;
        }

        private String getLanguageName(String languageCode) {
            String result = english.getName(languageCode, true, CLDRFile.SHORT_ALTS);
            if (!result.equals(languageCode)) {
                return result;
            }
            Set<String> names = Iso639Data.getNames(languageCode);
            if (names != null && names.size() != 0) {
                return names.iterator().next();
            }
            return languageCode;
        }

        private void showCoverageGoals(PrintWriter pw) throws IOException {
            try (PrintWriter pw2 = new PrintWriter(new FormattedFileWriter(null, "Coverage Goals", null, SUPPLEMENTAL_INDEX_ANCHORS));
                 PrintWriter coverageGoalsTsv = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "coverage_goals.tsv");){
                TablePrinter tablePrinter = new TablePrinter().addColumn("Language", "class='source'", null, "class='source'", false).setSortPriority(0).setBreakSpans(false).addColumn("Code", "class='source'", "<a href=\"https://github.com/unicode-org/cldr/blob/main/common/main/{0}.xml\">{0}</a>", "class='source'", false).addColumn("D. Votes", "class='target'", null, "class='target'", false);
                Map<Organization, Map<String, Level>> vendordata = sc.getLocaleTypes();
                TreeSet<String> locales = new TreeSet<String>();
                LinkedHashSet<Organization> vendors = new LinkedHashSet<Organization>();
                LinkedHashSet<Organization> smallVendors = new LinkedHashSet<Organization>();
                for (Organization organization : TC_Vendors) {
                    Map<String, Level> data = vendordata.get((Object)organization);
                    vendors.add(organization);
                    tablePrinter.addColumn(organization.getDisplayName(), "class='target'", null, "class='target'", false).setSpanRows(false);
                    locales.addAll(data.keySet());
                    this.showTabbedOrgLevels(coverageGoalsTsv, organization, data);
                }
                for (Map.Entry entry : vendordata.entrySet()) {
                    Organization organization = (Organization)((Object)entry.getKey());
                    if (TC_Vendors.contains((Object)organization)) continue;
                    smallVendors.add(organization);
                    Map<String, Level> data = vendordata.get((Object)organization);
                    this.showTabbedOrgLevels(coverageGoalsTsv, organization, data);
                }
                ArrayList<Comparable[]> data = new ArrayList<Comparable[]>();
                ArrayList<String> arrayList = new ArrayList<String>();
                LanguageTagParser ltp = new LanguageTagParser();
                pw2.append("<h2>TC Orgs</h2>");
                for (String locale : locales) {
                    arrayList.clear();
                    String localeCode = locale.equals("*") ? "und" : locale;
                    String alias = this.getAlias(localeCode);
                    if (!alias.equals(localeCode)) {
                        throw new IllegalArgumentException("Should use canonical form: " + locale + " => " + alias);
                    }
                    String baseLangName = this.getLanguageName(localeCode);
                    arrayList.add("und".equals(localeCode) ? "other" : baseLangName);
                    arrayList.add(locale);
                    int defaultVotes = supplementalDataInfo.getRequiredVotes(CLDRLocale.getInstance(locale), null);
                    arrayList.add(String.valueOf(defaultVotes));
                    for (Organization vendor : vendors) {
                        String status = this.getVendorStatus(locale, vendor, vendordata);
                        arrayList.add(status);
                    }
                    data.add((Comparable[])arrayList.toArray(new String[arrayList.size()]));
                }
                Comparable[][] flattened = (Comparable[][])data.toArray((T[])new Comparable[data.size()][]);
                String value = tablePrinter.addRows(flattened).toTable();
                pw2.println(value);
                pw2.append("<h2>Others</h2><div align='left'><ul>");
                for (Organization vendor2 : smallVendors) {
                    pw2.append("<li><b>");
                    pw2.append(TransliteratorUtilities.toHTML.transform(vendor2.getDisplayName())).append(": </b>");
                    boolean first1 = true;
                    for (Level level : Level.values()) {
                        boolean first2 = true;
                        Level other = null;
                        for (Map.Entry<String, Level> data2 : vendordata.get((Object)vendor2).entrySet()) {
                            String key = data2.getKey();
                            Level level2 = data2.getValue();
                            if (level != level2) continue;
                            if (key.equals("*")) {
                                other = level2;
                                continue;
                            }
                            if (first2) {
                                if (first1) {
                                    first1 = false;
                                } else {
                                    pw2.append("; ");
                                }
                                pw2.append(level2.toString()).append(": ");
                                first2 = false;
                            } else {
                                pw2.append(", ");
                            }
                            pw2.append(TransliteratorUtilities.toHTML.transform(key));
                        }
                        if (other == null) continue;
                        if (first2) {
                            if (first1) {
                                first1 = false;
                            } else {
                                pw2.append("; ");
                            }
                            pw2.append(level.toString()).append(": ");
                            first2 = false;
                        } else {
                            pw2.append(", ");
                        }
                        pw2.append("<i>other</i>");
                    }
                    pw2.append("</li>");
                }
                pw2.append("</ul></div>");
            }
        }

        public void showTabbedOrgLevels(PrintWriter coverageGoalsTsv, Organization organization, Map<String, Level> data) {
            coverageGoalsTsv.println(String.format("\n#%s\t;\t%s\t;\t%s\t;\t%s\n", "Org", "Locale", "Level", "Locale Name"));
            for (Map.Entry<String, Level> entry : data.entrySet()) {
                String locale = entry.getKey();
                Level level = entry.getValue();
                String name = locale.equals("*") ? "ALL" : english.getName(locale, true, CLDRFile.SHORT_ALTS);
                coverageGoalsTsv.println(String.format("%s\t;\t%s\t;\t%s\t;\t%s", new Object[]{organization, locale, level, name}));
            }
        }

        private String getAlias(String locale) {
            String temp;
            this.lpt2.set(locale);
            locale = this.lpt2.toString();
            String script = this.lpt2.getScript();
            String region = this.lpt2.getRegion();
            for (String old : localeAliasInfo.get("language").keySet()) {
                if (!locale.startsWith(old) || !locale.equals(old) && !locale.startsWith(old + "_")) continue;
                temp = localeAliasInfo.get("language").get(old);
                this.lpt2.setLanguage(temp.split("\\s+")[0] + locale.substring(old.length()));
                break;
            }
            if ((temp = localeAliasInfo.get("script").get(script)) != null) {
                this.lpt2.setScript(temp.split("\\s+")[0]);
            }
            if ((temp = localeAliasInfo.get("territory").get(region)) != null) {
                this.lpt2.setRegion(temp.split("\\s+")[0]);
            }
            return this.lpt2.toString();
        }

        private String getVendorStatus(String locale, Organization vendor, Map<Organization, Map<String, Level>> vendordata) {
            Level statusLevel = vendordata.get((Object)vendor).get(locale);
            return statusLevel == null ? "" : statusLevel.toString();
        }

        private void showCountryLanguageInfo(PrintWriter pw) throws IOException {
            PrintWriter pw21;
            PrintWriter pw2 = pw21 = new PrintWriter(new FormattedFileWriter(null, "Territory-Language Information", null, SUPPLEMENTAL_INDEX_ANCHORS));
            NumberFormat nf = NumberFormat.getInstance(ULocale.ENGLISH);
            nf.setGroupingUsed(true);
            TablePrinter tablePrinter = new TablePrinter().addColumn("T", "class='source'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).setRepeatHeader(true).setHidden(true).addColumn("Territory", "class='source'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Terr. Literacy", "class='target'", "{0,number,@@}%", "class='targetRight'", true);
            tablePrinter.addColumn("Language", "class='target'", null, "class='target'", false).addColumn("Code", "class='target'", "<a href=\"language_territory_information.html#{0}\">{0}</a>", "class='target'", false).addColumn("Lang. Pop.", "class='target'", "{0,number,#,#@@}", "class='targetRight'", true).addColumn("Pop.%", "class='target'", "{0,number,@@}%", "class='targetRight'", true).setSortAscending(false).setSortPriority(1).addColumn("Literacy%", "class='target'", "{0,number,@@}%", "class='targetRight'", true).addColumn("Written%", "class='target'", "{0,number,@@}%", "class='targetRight'", true).addColumn("Report Bug", "class='target'", null, "class='target'", false);
            for (String territoryCode : supplementalDataInfo.getTerritoriesWithPopulationData()) {
                String territoryName = english.getName(2, territoryCode);
                SupplementalDataInfo.PopulationData territoryData2 = supplementalDataInfo.getPopulationDataForTerritory(territoryCode);
                double territoryLiteracy = territoryData2.getLiteratePopulationPercent();
                for (String languageCode : supplementalDataInfo.getLanguagesForTerritoryWithPopulationData(territoryCode)) {
                    SupplementalDataInfo.PopulationData languageData = supplementalDataInfo.getLanguageAndTerritoryPopulationData(languageCode, territoryCode);
                    double languagePopulationPercent = 100.0 * languageData.getPopulation() / territoryData2.getPopulation();
                    double languageliteracy = languageData.getLiteratePopulationPercent();
                    double writingFrequency = languageData.getWritingPercent();
                    tablePrinter.addRow().addCell((Comparable)((Object)this.getFirstPrimaryWeight(territoryName))).addCell((Comparable)((Object)territoryName)).addCell((Comparable)((Object)territoryCode)).addCell(Double.valueOf(territoryLiteracy)).addCell((Comparable)((Object)(this.getLanguageName(languageCode) + this.getOfficialStatus(territoryCode, languageCode)))).addCell((Comparable)((Object)languageCode)).addCell(Double.valueOf(languageData.getPopulation())).addCell(Double.valueOf(languagePopulationPercent)).addCell(Double.valueOf(languageliteracy)).addCell(Double.valueOf(writingFrequency)).addCell((Comparable)((Object)this.addBug(1217, "<i>bug</i>", "<email>", "Fix info for " + this.getLanguageName(languageCode) + " (" + languageCode + ") in " + territoryName + " (" + territoryCode + ")", "<fixed data for territory, plus references>"))).finishRow();
                }
                tablePrinter.addRow().addCell((Comparable)((Object)this.getFirstPrimaryWeight(territoryName))).addCell((Comparable)((Object)territoryName)).addCell((Comparable)((Object)territoryCode)).addCell(Double.valueOf(territoryLiteracy)).addCell((Comparable)((Object)this.addBug(1217, "<i>add new</i>", "<email>", "Add language to " + territoryName + "(" + territoryCode + ")", "<language, speaker pop. and literacy in territory, plus references>"))).addCell((Comparable)((Object)"")).addCell(Double.valueOf(0.0)).addCell(Double.valueOf(0.0)).addCell(Double.valueOf(0.0)).addCell(Double.valueOf(0.0)).addCell((Comparable)((Object)"")).finishRow();
            }
            String value = tablePrinter.toTable();
            pw2.println(value);
            pw2.close();
        }

        private void showCountryInfo(PrintWriter pw) throws IOException {
            PrintWriter pw21;
            PrintWriter pw2 = pw21 = new PrintWriter(new FormattedFileWriter(null, "Territory Information", null, SUPPLEMENTAL_INDEX_ANCHORS));
            NumberFormat nf = NumberFormat.getInstance(ULocale.ENGLISH);
            nf.setGroupingUsed(true);
            TablePrinter tablePrinter = new TablePrinter().addColumn("T", "class='source'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).setRepeatHeader(true).setHidden(true).addColumn("Territory", "class='source'", null, "class='source'", true).setSortPriority(0).setBreakSpans(true).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Terr. Pop (M)", "class='target'", "{0,number,#,#@@}", "class='targetRight'", true).addColumn("Terr. GDP ($M PPP)", "class='target'", "{0,number,#,#@@}", "class='targetRight'", true).addColumn("Currencies (2006...)", "class='target'", null, "class='target'", true);
            for (String header : this.territoryTypes) {
                if (header.equals("calendar")) {
                    header = "calendar (+gregorian)";
                }
                tablePrinter.addColumn(header).setHeaderAttributes("class='target'").setCellAttributes("class='target'").setSpanRows(true);
            }
            tablePrinter.addColumn("Report Bug", "class='target'", null, "class='target'", false);
            for (String territoryCode : supplementalDataInfo.getTerritoriesWithPopulationData()) {
                String territoryName = english.getName(2, territoryCode);
                SupplementalDataInfo.PopulationData territoryData2 = supplementalDataInfo.getPopulationDataForTerritory(territoryCode);
                double population = territoryData2.getPopulation() / 1000000.0;
                double gdp = territoryData2.getGdp() / 1000000.0;
                Map<String, Set<String>> worldData = this.territoryData.get(this.getName(2, "001", false));
                Map<String, Set<String>> countryData = this.territoryData.get(this.getName(2, territoryCode, false));
                tablePrinter.addRow().addCell((Comparable)((Object)this.getFirstPrimaryWeight(territoryName))).addCell((Comparable)((Object)territoryName)).addCell((Comparable)((Object)territoryCode)).addCell(Double.valueOf(population)).addCell(Double.valueOf(gdp)).addCell((Comparable)((Object)this.getCurrencyNames(territoryCode)));
                this.addOtherCountryData(tablePrinter, worldData, countryData);
                tablePrinter.addCell((Comparable)((Object)this.addBug(1217, "<i>bug</i>", "<email>", "Fix info for " + territoryName + " (" + territoryCode + ")", "<fixed data for territory, plus references>"))).finishRow();
            }
            String value = tablePrinter.toTable();
            pw2.println(value);
            pw2.close();
        }

        private String getFirstPrimaryWeight(String territoryName) {
            char first = territoryName.charAt(0);
            String result = nfd.getDecomposition(first);
            if (result == null) {
                return UTF16.valueOf(first);
            }
            return UTF16.valueOf(result.codePointAt(0));
        }

        private String getOfficialStatus(String territoryCode, String languageCode) {
            SupplementalDataInfo.PopulationData x = supplementalDataInfo.getLanguageAndTerritoryPopulationData(languageCode, territoryCode);
            if (x == null || x.getOfficialStatus() == SupplementalDataInfo.OfficialStatus.unknown) {
                return "";
            }
            return " <span title='" + x.getOfficialStatus().toString().replace('_', ' ') + "'>{" + x.getOfficialStatus().toShortString() + "}</span>";
        }

        private String getRawOfficialStatus(String territoryCode, String languageCode) {
            SupplementalDataInfo.PopulationData x = supplementalDataInfo.getLanguageAndTerritoryPopulationData(languageCode, territoryCode);
            if (x == null || x.getOfficialStatus() == SupplementalDataInfo.OfficialStatus.unknown) {
                return "";
            }
            return x.getOfficialStatus().toString();
        }

        private void addOtherCountryData(TablePrinter tablePrinter, Map<String, Set<String>> worldData, Map<String, Set<String>> countryData) {
            for (String type : this.territoryTypes) {
                Set<String> worldResults = worldData.get(type);
                Set<String> territoryResults = null;
                if (countryData != null) {
                    territoryResults = countryData.get(type);
                }
                if (territoryResults == null) {
                    territoryResults = worldResults;
                }
                Object out = "";
                if (territoryResults != null) {
                    out = "" + territoryResults;
                    out = ((String)out).substring(1, ((String)out).length() - 1);
                }
                tablePrinter.addCell((Comparable)out);
            }
        }

        private String getCurrencyNames(String territoryCode) {
            Set<String> currencies = this.territoriesToModernCurrencies.getAll(territoryCode);
            if (currencies == null || currencies.size() == 0) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            for (String code : currencies) {
                if (buffer.length() != 0) {
                    buffer.append(",<br>");
                }
                buffer.append(this.getName(4, code, false));
            }
            return buffer.toString();
        }

        private void addCharSubstitution(String value, String substitute) {
            if (substitute.equals(value)) {
                return;
            }
            LinkedHashSet<String> already = this.charSubstitutions.get(value);
            if (already == null) {
                already = new LinkedHashSet(0);
                this.charSubstitutions.put(value, already);
            }
            already.add(substitute);
            Log.logln(LanguageInfo.hex(value, " ") + "; " + LanguageInfo.hex(substitute, " "));
        }

        private void addTerritoryInfo(String territoriesList, String type, String info) {
            String[] territories = territoriesList.split("\\s+");
            this.territoryTypes.add(type);
            for (int i = 0; i < territories.length; ++i) {
                Set<String> ss;
                String territory = this.getName(2, territories[i], false);
                Map<String, Set<String>> s2 = this.territoryData.get(territory);
                if (s2 == null) {
                    s2 = new TreeMap<String, Set<String>>();
                    this.territoryData.put(territory, s2);
                }
                if ((ss = s2.get(type)) == null) {
                    ss = new TreeSet<String>();
                    s2.put(type, ss);
                }
                ss.add(info);
            }
        }

        public void showCalendarData(PrintWriter pw0) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Other Territory Data", null, SUPPLEMENTAL_INDEX_ANCHORS));
            pw.println("<table>");
            pw.println("<tr><th class='source'>Territory</th>");
            for (String header : this.territoryTypes) {
                if (header.equals("calendar")) {
                    header = "calendar (+gregorian)";
                }
                pw.println("<th class='target'>" + header + "</th>");
            }
            pw.println("</tr>");
            String worldName = this.getName(2, "001", false);
            Map<String, Set<String>> worldData = this.territoryData.get(worldName);
            for (String country : this.territoryData.keySet()) {
                if (country.equals(worldName)) continue;
                this.showCountry(pw, country, country, worldData);
            }
            this.showCountry(pw, worldName, "Other", worldData);
            pw.println("</table>");
            pw.close();
        }

        private void showCountry(PrintWriter pw, String country, String countryTitle, Map<String, Set<String>> worldData) {
            pw.println("<tr><td class='source'>" + countryTitle + "</td>");
            Map<String, Set<String>> data = this.territoryData.get(country);
            for (String type : this.territoryTypes) {
                String target = "target";
                Set<String> results = data.get(type);
                Set<String> worldResults = worldData.get(type);
                if (results == null) {
                    results = worldResults;
                    target = "target2";
                } else if (results.equals(worldResults)) {
                    target = "target2";
                }
                Object out = "";
                if (results != null) {
                    out = "" + results;
                    out = ((String)out).substring(1, ((String)out).length() - 1);
                }
                pw.println("<td class='" + target + "'>" + (String)out + "</td>");
            }
            pw.println("</tr>");
        }

        public void showCorrespondances() {
            String names;
            TreeMap<String, String> name_script = new TreeMap<String, String>();
            for (String script : sc.getAvailableCodes("script")) {
                String name = english.getName(1, script);
                if (name == null) {
                    name = script;
                }
                name_script.put(name, script);
            }
            String delimiter = "\\P{L}+";
            TreeMap<String, String> name_language = new TreeMap<String, String>();
            for (String language : sc.getAvailableCodes("language")) {
                names = english.getName(0, language);
                if (names == null) {
                    names = language;
                }
                name_language.put(names, language);
            }
            for (String language : sc.getAvailableCodes("language")) {
                String[] words;
                names = english.getName(0, language);
                if (names == null) {
                    names = language;
                }
                if ((words = names.split(delimiter)).length > 1) {
                    // empty if block
                }
                for (int i = 0; i < words.length; ++i) {
                    String name = words[i];
                    String script = (String)name_script.get(name);
                    if (script != null) {
                        Set langSet = (Set)this.script_languages.asMap().get(script);
                        if (langSet != null && langSet.contains(language)) {
                            System.out.print("*");
                        }
                        System.out.println("\t" + name + " [" + language + "]\t=> " + name + " [" + script + "]");
                        continue;
                    }
                    String language2 = (String)name_language.get(name);
                    if (language2 == null || language.equals(language2)) continue;
                    Set langSet = (Set)this.language_scripts.get(language);
                    if (langSet != null) {
                        System.out.print("*");
                    }
                    System.out.print("?\tSame script?\t + " + this.getName(0, language, false) + "\t & " + this.getName(0, language2, false));
                    langSet = (Set)this.language_scripts.get(language2);
                    if (langSet != null) {
                        System.out.print("*");
                    }
                    System.out.println();
                }
            }
        }

        public void printCurrency(PrintWriter index) throws IOException {
            Object info;
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Detailed Territory-Currency Information", null, SUPPLEMENTAL_INDEX_ANCHORS));
            String section1 = "Territory to Currency";
            String section2 = "Decimal Digits and Rounding";
            ShowLanguages.showContents(pw, "territory_currency", section1, "format_info", section2);
            pw.println("<h2>" + CldrUtility.getDoubleLinkedText("territory_currency", "1. " + section1) + "</h2>");
            pw.println("<table>");
            pw.println("<tr><th class='source'>Territory</th><th class='source'>Code</th><th class='target'>From</th><th class='target'>To</th><th class='target'>Currency</th><th class='target'>Name</th></tr>");
            Relation<String, String> currencyToTerritory = Relation.of(new HashMap(), HashSet.class);
            Relation<String, String> modernCurrencyToTerritory = Relation.of(new HashMap(), HashSet.class);
            for (Map.Entry<String, String> nameCode : NAME_TO_REGION.entrySet()) {
                String name = nameCode.getKey();
                String regionCode = nameCode.getValue();
                if (!StandardCodes.isCountry(regionCode) || sc.isLstregPrivateUse("region", regionCode)) continue;
                info = supplementalDataInfo.getCurrencyDateInfo(regionCode);
                int infoSize = 1;
                if (info != null) {
                    infoSize = info.size();
                }
                pw.println("<tr><td class='source' rowSpan='" + infoSize + "'>" + name + "</td><td class='source' rowSpan='" + infoSize + "'>" + CldrUtility.getDoubleLinkedText(regionCode) + "</td>");
                if (info == null) {
                    pw.println("<td class='target'><i>na</i></td><td class='target'><i>na</i></td><td class='target'><i>na</i></td><td class='target'><i>na</i></td></tr>");
                    continue;
                }
                boolean first = true;
                Iterator<SupplementalDataInfo.CurrencyDateInfo> iterator = info.iterator();
                while (iterator.hasNext()) {
                    SupplementalDataInfo.CurrencyDateInfo infoItem = iterator.next();
                    Date endData = infoItem.getEnd();
                    if (endData.equals(SupplementalDataInfo.CurrencyDateInfo.END_OF_TIME)) {
                        modernCurrencyToTerritory.put(infoItem.getCurrency(), this.getTerritoryName(regionCode));
                    } else {
                        currencyToTerritory.put(infoItem.getCurrency(), this.getTerritoryName(regionCode));
                    }
                    if (first) {
                        first = false;
                    } else {
                        pw.println("<tr>");
                    }
                    pw.println("<td class='target'>" + SupplementalDataInfo.CurrencyDateInfo.formatDate(infoItem.getStart()) + "</td><td class='target'>" + SupplementalDataInfo.CurrencyDateInfo.formatDate(endData) + "</td><td class='target'>" + infoItem.getCurrency() + "</td><td class='target'>" + english.getName("currency", infoItem.getCurrency()) + "</td></tr>");
                }
            }
            pw.write("</table>");
            pw.println("<h2>" + CldrUtility.getDoubleLinkedText("format_info", "2. " + section2) + "</h2>");
            pw.write("<p>This table shows the number of digits used for each currency,  and the countries where it is or was in use. Countries where the currency is in current use are bolded. If the currency uses \u2018nickel rounding\u2019 in transactions, the digits are followed by \u2018(5)\u2019. Where the values are different in a cash context, that is shown in a second column.</p>");
            pw.write("<div align='center'><table>");
            pw.println("<tr><th class='source nowrap'>Name</th><th class='source'>Currency</th><th class='target'>Digits</th><th class='target'>Cash Digits</th><th class='target'>Countries</th></tr>");
            TreeSet<String> currencyList = new TreeSet<String>(col);
            currencyList.addAll(this.currency_fractions.keySet());
            currencyList.addAll(this.currency_territory.keySet());
            for (Map.Entry<String, String> nameCode : NAME_TO_CURRENCY.entrySet()) {
                String currency = nameCode.getValue();
                info = supplementalDataInfo.getCurrencyNumberInfo(currency);
                Set territories = currencyToTerritory.get(currency);
                Set modernTerritories = modernCurrencyToTerritory.get(currency);
                pw.print("<tr><td class='source nowrap'>" + TransliteratorUtilities.toHTML.transform(english.getName("currency", currency)) + "</td><td class='source'>" + CldrUtility.getDoubleLinkedText(currency) + "</td><td class='target'>" + ((SupplementalDataInfo.CurrencyNumberInfo)info).getDigits() + (String)(((SupplementalDataInfo.CurrencyNumberInfo)info).getRounding() == 0 ? "" : " (" + ((SupplementalDataInfo.CurrencyNumberInfo)info).getRounding() + ")") + "</td><td class='target'>" + (String)(((SupplementalDataInfo.CurrencyNumberInfo)info).cashDigits == ((SupplementalDataInfo.CurrencyNumberInfo)info).getDigits() && ((SupplementalDataInfo.CurrencyNumberInfo)info).cashRounding == ((SupplementalDataInfo.CurrencyNumberInfo)info).getRounding() ? "" : ((SupplementalDataInfo.CurrencyNumberInfo)info).cashDigits + (String)(((SupplementalDataInfo.CurrencyNumberInfo)info).cashRounding == 0 ? "" : " (" + ((SupplementalDataInfo.CurrencyNumberInfo)info).cashRounding + ")")) + "</td><td class='target'>");
                boolean first = true;
                boolean needBreak = false;
                if (modernTerritories != null) {
                    needBreak = true;
                    for (String territory : modernTerritories) {
                        if (first) {
                            first = false;
                        } else {
                            pw.print(", ");
                        }
                        pw.print("<b>" + territory + "</b>");
                    }
                }
                if (territories != null) {
                    for (String territory : territories) {
                        if (first) {
                            first = false;
                        } else if (!needBreak) {
                            pw.print(", ");
                        } else {
                            pw.print(",<br>");
                            needBreak = false;
                        }
                        pw.print(territory);
                    }
                }
                pw.println("</td></tr>");
            }
            pw.println("</table>");
            pw.close();
        }

        private String getTerritoryName(String territory) {
            String name = english.getName("territory", territory);
            if (name == null) {
                name = sc.getData("territory", territory);
            }
            if (name != null) {
                return TransliteratorUtilities.toHTML.transform(name) + " (" + territory + ")";
            }
            return territory;
        }

        public void printAliases(PrintWriter index) throws IOException {
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Aliases", null, SUPPLEMENTAL_INDEX_ANCHORS));
            pw.println("<table>");
            pw.println("<tr><th class='source'>Type</th><th class='source'>Code</th><th class='target'>Reason</th><th class='target'>Substitute (if available)</th></tr>");
            for (String[] items : this.aliases) {
                pw.println("<tr><td class='source'>" + items[0] + "</td><td class='source'>" + CldrUtility.getDoubleLinkedText(items[1]) + "</td><td class='target'>" + items[3] + "</td><td class='target'>" + items[2] + "</td></tr>");
            }
            pw.println("</table>");
            pw.close();
        }

        public void printWindows_Tzid(PrintWriter index) throws IOException {
            Map<String, Map<String, Map<String, String>>> zoneMapping = supplementalDataInfo.getTypeToZoneToRegionToZone();
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Zone \u2192 Tzid", null, SUPPLEMENTAL_INDEX_ANCHORS));
            for (Map.Entry<String, Map<String, Map<String, String>>> typeAndZoneToRegionToZone : zoneMapping.entrySet()) {
                String type = typeAndZoneToRegionToZone.getKey();
                Map<String, Map<String, String>> zoneToRegionToZone = typeAndZoneToRegionToZone.getValue();
                pw.println("<br><h1>Mapping for: " + type + "</h1><br>");
                pw.println("<table>");
                pw.println("<tr><th class='source'>" + type + "</th><th class='source'>Region</th><th class='target'>TZID</th></tr>");
                for (Map.Entry<String, Map<String, String>> zoneAndregionToZone : zoneToRegionToZone.entrySet()) {
                    String source = zoneAndregionToZone.getKey();
                    Map<String, String> regionToZone = zoneAndregionToZone.getValue();
                    for (Map.Entry<String, String> regionAndZone : regionToZone.entrySet()) {
                        String region = regionAndZone.getKey();
                        String target = regionAndZone.getValue();
                        if (region == null) {
                            region = "<i>any</a>";
                        }
                        pw.println("<tr><td class='source'>" + source + "</td><td class='source'>" + region + "</td><td class='target'>" + target + "</td></tr>");
                    }
                }
                pw.println("</table>");
            }
            pw.close();
        }

        public void printCharacters(PrintWriter index) throws IOException {
            String title = "Character Fallback Substitutions";
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, title, null, SUPPLEMENTAL_INDEX_ANCHORS));
            pw.println("<table>");
            pw.println("<tr><th colSpan='3'>Substitute for character (if not in repertoire)</th><th colSpan='4'>The following (in priority order, first string that <i>is</i> in repertoire)</th></tr>");
            UnicodeSet chars = new UnicodeSet("[:NFKC_QuickCheck=N:]");
            UnicodeSetIterator it = new UnicodeSetIterator(chars);
            while (it.next()) {
                String value = it.getString();
                this.addCharSubstitution(value, Normalizer.normalize(value, Normalizer.NFC));
                this.addCharSubstitution(value, Normalizer.normalize(value, Normalizer.NFKC));
            }
            int[] counts = new int[4];
            for (String value : this.charSubstitutions.keySet()) {
                LinkedHashSet<String> substitutes = this.charSubstitutions.get(value);
                String nfc = Normalizer.normalize(value, Normalizer.NFC);
                String nfkc = Normalizer.normalize(value, Normalizer.NFKC);
                Object sourceTag = "<td class='source'>";
                if (substitutes.size() > 1) {
                    sourceTag = "<td class='source' rowSpan='" + substitutes.size() + "'>";
                }
                boolean first = true;
                for (String substitute : substitutes) {
                    String type = "Explicit";
                    String targetTag = "<td class='target3'>";
                    if (substitute.equals(nfc)) {
                        type = "NFC";
                        targetTag = "<td class='target'>";
                        counts[2] = counts[2] + 1;
                    } else if (substitute.equals(nfkc)) {
                        type = "NFKC";
                        targetTag = "<td class='target4'>";
                        counts[3] = counts[3] + 1;
                    } else {
                        counts[0] = counts[0] + 1;
                    }
                    pw.println("<tr>" + (String)(!first ? "" : (String)sourceTag + LanguageInfo.hex(value, ", ") + "</td>" + (String)sourceTag + TransliteratorUtilities.toHTML.transliterate(value) + "</td>" + (String)sourceTag + UCharacter.getName(value, ", ") + "</td>") + targetTag + type + "</td>" + targetTag + LanguageInfo.hex(substitute, ", ") + "</td>" + targetTag + TransliteratorUtilities.toHTML.transliterate(substitute) + "</td>" + targetTag + UCharacter.getName(substitute, ", ") + "</td></tr>");
                    first = false;
                }
            }
            pw.println("</table>");
            pw.close();
            for (int i = 0; i < counts.length; ++i) {
                System.out.println("Count\t" + i + "\t" + counts[i]);
            }
        }

        public static String hex(String s2, String separator) {
            int cp;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
                cp = UTF16.charAt(s2, i);
                if (i != 0) {
                    result.append(separator);
                }
                result.append(Utility.hex(cp));
            }
            return result.toString();
        }

        public void printContains2(PrintWriter pw, String lead, String start, int depth, boolean isFirst) {
            Collection<String> contains;
            String name;
            String string = name = depth == 4 ? start : this.getName(2, start, false);
            if (!isFirst) {
                pw.print(lead);
            }
            int count = this.getTotalContainedItems(start, depth);
            pw.print("<td class='z" + depth + "' rowSpan='" + count + "'>" + name + "</td>");
            if (depth == 4) {
                pw.println("</tr>");
            }
            if ((contains = this.getContainedCollection(start, depth)) != null) {
                TreeSet<String> contains2 = new TreeSet<String>(this.territoryNameComparator);
                contains2.addAll(contains);
                boolean first = true;
                for (String item : contains2) {
                    this.printContains2(pw, lead, item, depth + 1, first);
                    first = false;
                }
            }
        }

        private int getTotalContainedItems(String start, int depth) {
            Collection<String> c = this.getContainedCollection(start, depth);
            if (c == null) {
                return 1;
            }
            int sum = 0;
            Iterator<String> it = c.iterator();
            while (it.hasNext()) {
                sum += this.getTotalContainedItems(it.next(), depth + 1);
            }
            return sum;
        }

        private Collection<String> getContainedCollection(String start, int depth) {
            Collection<String> contains = supplementalDataInfo.getContainmentCore().get(start);
            if (contains == null && (contains = (Collection)sc.getCountryToZoneSet().get(start)) == null && depth == 3) {
                contains = new TreeSet<String>();
                if (start.compareTo("A") >= 0) {
                    contains.add("<font color='red'>MISSING TZID</font>");
                } else {
                    contains.add("<font color='red'>Not yet ISO code</font>");
                }
            }
            return contains;
        }

        public void printMissing(PrintWriter pw, int source, int table) {
            HashSet<String> missingItems = new HashSet<String>();
            String type = null;
            if (source == 2) {
                type = "territory";
                missingItems.addAll(sc.getAvailableCodes(type));
                missingItems.removeAll(this.territory_languages.keySet());
                missingItems.removeAll(supplementalDataInfo.getContainmentCore().keySet());
                missingItems.remove("200");
            } else if (source == 1) {
                type = "script";
                missingItems.addAll(sc.getAvailableCodes(type));
                missingItems.removeAll(this.script_languages.keySet());
            } else if (source == 0) {
                type = "language";
                missingItems.addAll(sc.getAvailableCodes(type));
                if (table == 1) {
                    missingItems.removeAll(this.language_scripts.keySet());
                }
                if (table == 2) {
                    missingItems.removeAll(this.language_territories.keySet());
                }
            } else {
                throw new IllegalArgumentException("Illegal code");
            }
            TreeSet<String> missingItemsNamed = new TreeSet<String>(col);
            for (String item : missingItems) {
                List<String> data = sc.getFullData(type, item);
                if (data.get(0).equals("PRIVATE USE") || data.size() < 3 || !"".equals(data.get(2))) continue;
                String itemName = this.getName(source, item, true);
                missingItemsNamed.add(itemName);
            }
            pw.println("<div align='center'><table>");
            Iterator it = missingItemsNamed.iterator();
            while (it.hasNext()) {
                pw.println("<tr><td class='target'>" + (String)it.next() + "</td></tr>");
            }
            pw.println("</table></div>");
        }

        public void print(PrintWriter pw, int source, int target) {
            Multimap<String, String> data = source == 2 && target == 0 ? this.territory_languages : (source == 0 && target == 2 ? this.language_territories : (source == 1 && target == 0 ? this.script_languages : (source == 0 && target == 1 ? this.language_scripts : null)));
            TreeMap territory_languageNames = new TreeMap(col);
            for (String territory : data.keySet()) {
                String territoryName = this.getName(source, territory, true);
                TreeSet<String> s2 = (TreeSet<String>)territory_languageNames.get(territoryName);
                if (s2 == null) {
                    s2 = new TreeSet<String>(col);
                    territory_languageNames.put(territoryName, s2);
                }
                for (String language : data.get(territory)) {
                    String languageName = this.getName(target, language, true);
                    s2.add(languageName);
                }
            }
            pw.println("<div align='center'><table>");
            for (String territoryName : territory_languageNames.keySet()) {
                pw.println("<tr><td class='source' colspan='2'>" + territoryName + "</td></tr>");
                Set s3 = (Set)territory_languageNames.get(territoryName);
                for (String languageName : s3) {
                    pw.println("<tr><td>&nbsp;</td><td class='target'>" + languageName + "</td></tr>");
                }
            }
            pw.println("</table></div>");
        }

        private String getName(int type, String oldcode, boolean codeFirst) {
            String nameString;
            if (oldcode.contains(" ")) {
                String[] result = oldcode.split("\\s+");
                for (int i = 0; i < result.length; ++i) {
                    result[i] = this.getName(type, result[i], codeFirst);
                }
                return CldrUtility.join(Arrays.asList(result), ", ");
            }
            int pos = oldcode.indexOf(42);
            String code = pos < 0 ? oldcode : oldcode.substring(0, pos);
            String ename = english.getName(type, code);
            String string = nameString = ename == null ? code : ename;
            return nameString.equals(oldcode) ? nameString : (codeFirst ? "[" + oldcode + "]\t" + nameString : nameString + "\t[" + oldcode + "]");
        }

        private String getName(String locale, boolean codeFirst) {
            String ename = this.getLanguageName(locale);
            return codeFirst ? "[" + locale + "]\t" + (ename == null ? locale : ename) : (ename == null ? locale : ename) + "\t[" + locale + "]";
        }

        public void printContains(PrintWriter index) throws IOException {
            String title = "Territory Containment (UN M.49)";
            PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, title, null, SUPPLEMENTAL_INDEX_ANCHORS));
            ArrayList<String[]> rows = new ArrayList<String[]>();
            this.printContains3("001", rows, new ArrayList<String>());
            TablePrinter tablePrinter = new TablePrinter().addColumn("World", "class='source'", null, "class='z0'", true).setSortPriority(0).addColumn("Continent", "class='source'", null, "class='z1'", true).setSortPriority(1).addColumn("Subcontinent", "class='source'", null, "class='z2'", true).setSortPriority(2).addColumn("Country (Territory)", "class='source'", null, "class='z3'", true).setSortPriority(3).addColumn("Time Zone", "class='source'", null, "class='z4'", true).setSortPriority(4);
            String[][] flatData = (String[][])rows.toArray((T[])string2ArrayPattern);
            pw.println(tablePrinter.addRows((Comparable[][])flatData).toTable());
            this.showSubtable(pw, SupplementalDataInfo.ContainmentStyle.grouping, "Groupings", "Grouping", "Contained Regions");
            this.showSubtable(pw, SupplementalDataInfo.ContainmentStyle.deprecated, "Deprecated", "Container", "Deprecated Region");
            pw.close();
        }

        public void showSubtable(PrintWriter pw, SupplementalDataInfo.ContainmentStyle containmentStyle, String title, String containerTitle, String containeeTitle) {
            pw.println("<h2>" + title + "</h2>");
            TablePrinter tablePrinter2 = new TablePrinter().addColumn(containerTitle, "class='source'", null, "class='z0'", true).setSortPriority(0).addColumn(containeeTitle, "class='source'", null, "class='z4'", true).setSortPriority(1);
            Relation<String, String> grouping = supplementalDataInfo.getTerritoryToContained(containmentStyle);
            for (Map.Entry<String, String> containerRegion : grouping.keyValueSet()) {
                String container = this.getName(2, containerRegion.getKey(), false);
                String containee = this.getName(2, containerRegion.getValue(), false);
                tablePrinter2.addRow().addCell((Comparable)((Object)container)).addCell((Comparable)((Object)containee)).finishRow();
            }
            pw.println(tablePrinter2.toTable());
        }

        public void showContainers(PrintWriter pw, Map.Entry<String, Set<String>> regionContained) {
            String region = regionContained.getKey();
            Set<String> contained = regionContained.getValue();
            pw.println("<ul><li>" + this.getName(2, region, false) + "<ul>");
            for (String sub : contained) {
                pw.println("<li>" + this.getName(2, sub, false) + "</li>");
            }
            pw.println("</ul></li></ul>");
        }

        private void printContains3(String start, List<String[]> rows, ArrayList<String> currentRow) {
            int len = currentRow.size();
            if (len > 3) {
                return;
            }
            currentRow.add(this.getName(2, start, false));
            Collection<String> contains = supplementalDataInfo.getContainmentCore().get(start);
            if (contains == null) {
                contains = sc.getCountryToZoneSet().get(start);
                currentRow.add("");
                if (contains == null) {
                    currentRow.set(len + 1, "???");
                    rows.add(currentRow.toArray(stringArrayPattern));
                } else {
                    for (String item : contains) {
                        currentRow.set(len + 1, item);
                        rows.add(currentRow.toArray(stringArrayPattern));
                    }
                }
                currentRow.remove(len + 1);
            } else {
                for (String item : contains) {
                    if (territoryAliases.keySet().contains(item)) continue;
                    this.printContains3(item, rows, currentRow);
                }
            }
            currentRow.remove(len);
        }

        static {
            System.out.println(new UnicodeSet(ESCAPED_URI_QUERY).complement());
            TC_Vendors = Sets.union(Organization.getTCOrgs(), Set.of(Organization.cldr));
            nfd = Normalizer2.getInstance(null, "nfc", Normalizer2.Mode.DECOMPOSE);
            stringArrayPattern = new String[0];
            string2ArrayPattern = new String[0][];
            territoryAliases = new HashMap<String, String>();
        }

        static class LanguageData
        extends Row.R4<Double, Double, Double, String> {
            public LanguageData(Double a, Double b, Double c, String d) {
                super(a, b, c, d);
            }
        }
    }
}

