/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.PatternCache;

class SimpleLocaleParser {
    private static final Pattern rootPattern = Pattern.compile("(?: (?: ( [a-z]{2,8} )   (?: [-_] ( [a-z]{4} ) )?   (?: [-_] ( [a-z]{2} | [0-9]{3} ) )?   (?: [-_] ( (?: [a-z 0-9]{5,8} | [0-9] [a-z 0-9]{3} ) (?: [-_] (?: [a-z 0-9]{5,8} | [0-9] [a-z 0-9]{3} ) )* ) )?   (?: [-_] ( [a-w y-z] (?: [-_] [a-z 0-9]{2,8} )+ (?: [-_] [a-w y-z] (?: [-_] [a-z 0-9]{2,8} )+ )* ) )?   (?: [-_] ( x (?: [-_] [a-z 0-9]{1,8} )+ ) )? ) | ( x (?: [-_] [a-z 0-9]{1,8} )+ ) | ( en [-_] GB [-_] oed   | i [-_] (?: ami | bnn | default | enochian | hak | klingon | lux | mingo | navajo | pwn | tao | tay | tsu )   | no [-_] (?: bok | nyn )   | sgn [-_] (?: BE [-_] (?: fr | nl) | CH [-_] de )   | zh [-_] (?: cmn (?: [-_] Hans | [-_] Hant )? | gan | min (?: [-_] nan)? | wuu | yue ) ) ) (?: \\@ ((?: [a-z 0-9]+ \\= [a-z 0-9]+) (?: \\; (?: [a-z 0-9]+ \\= [a-z 0-9]+))*))?", 6);
    private static final Pattern variantSeparatorPattern = PatternCache.get("[-_]");
    private static final Pattern extensionPattern = Pattern.compile("([a-z]) [-_] ( [a-z 0-9]{2,8} (?:[-_] [a-z 0-9]{2,8})* )", 4);
    private static final Pattern privateUsePattern = Pattern.compile("(x) [-_] ( [a-z 0-9]{1,8} (?:[-_] [a-z 0-9]{1,8})* )", 4);
    private static final Pattern keywordPattern = Pattern.compile("([a-z 0-9]+) \\= ([a-z 0-9]+)", 4);
    private String language;
    private String script;
    private String region;
    private List<String> variants;
    private Map<String, String> extensions;

    SimpleLocaleParser() {
    }

    public boolean set(String source) {
        Matcher root = rootPattern.matcher(source = source.toLowerCase(Locale.ENGLISH));
        if (!root.matches()) {
            return false;
        }
        this.language = root.group(1);
        if (this.language == null) {
            this.language = root.group(8);
            if (this.language == null) {
                this.language = "und";
            }
        }
        this.script = root.group(2);
        this.script = this.script == null ? "" : this.script.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.script.substring(1);
        this.region = root.group(3);
        this.region = this.region == null ? "" : this.region.toUpperCase(Locale.ENGLISH);
        String variantList = root.group(4);
        if (variantList == null) {
            this.variants = Collections.emptyList();
        } else {
            this.variants = Arrays.asList(variantSeparatorPattern.split(variantList.toUpperCase(Locale.ENGLISH)));
            if (new HashSet<String>(this.variants).size() != this.variants.size()) {
                throw new IllegalArgumentException("Duplicate variants");
            }
        }
        this.extensions = new LinkedHashMap<String, String>();
        this.addExtensions(root.group(5), extensionPattern);
        this.addExtensions(root.group(6), privateUsePattern);
        this.addExtensions(root.group(7), privateUsePattern);
        this.addExtensions(root.group(9), keywordPattern);
        this.extensions = Collections.unmodifiableMap(this.extensions);
        return true;
    }

    private void addExtensions(String item, Pattern pattern) {
        if (item != null) {
            Matcher extension = pattern.matcher(item);
            while (extension.find()) {
                String key = extension.group(1);
                if (this.extensions.containsKey(key)) {
                    throw new IllegalArgumentException("duplicate key: " + key);
                }
                this.extensions.put(key, extension.group(2));
            }
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String getCountry() {
        return this.region;
    }

    public List<String> getVariants() {
        return this.variants;
    }

    public String getVariant() {
        return this.variants.size() == 0 ? "" : this.variants.iterator().next();
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        return "{language=" + this.language + ", script=" + this.script + ", country=" + this.region + ", variants=" + this.variants + ", keywords=" + this.extensions + "}";
    }
}

