/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Row;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.SupplementalDataInfo;

public class UpdateAliasedCodes {
    static CLDRConfig config = CLDRConfig.getInstance();
    static SupplementalDataInfo sdi = config.getSupplementalDataInfo();

    public static void main(String[] args) {
        Map<String, Row.R2<List<String>, String>> togood = sdi.getLocaleAliasInfo().get("subdivision");
        for (Map.Entry<String, Row.R2<List<String>, String>> entry : togood.entrySet()) {
            String badCode = entry.getKey();
            Row.R2<List<String>, String> replacement = entry.getValue();
            for (String repl : (List)replacement.get0()) {
                Row.R2<List<String>, String> better = togood.get(repl);
                if (better == null) continue;
                System.out.println("Supp.Metadata mapping bad: " + badCode + " => " + replacement + "; " + repl + " should be " + better);
            }
        }
        for (String locale : SubdivisionNames.getAvailableLocales()) {
            if (!"en".equals(locale)) continue;
            TreeMap<String, String> ok = new TreeMap<String, String>();
            TreeMap<String, String> fixed = new TreeMap<String, String>();
            SubdivisionNames names = new SubdivisionNames(locale);
            for (Map.Entry<String, String> subdivisionAndName : names.entrySet()) {
                String name;
                String code = subdivisionAndName.getKey();
                if (code.equals("AS")) {
                    boolean bl = false;
                }
                if ((name = subdivisionAndName.getValue()).isEmpty()) continue;
                Row.R2<List<String>, String> aliasInfo = togood.get(code);
                if (aliasInfo == null) {
                    ok.put(code, name);
                    continue;
                }
                List replacements = (List)aliasInfo.get0();
                if (replacements.size() != 1) {
                    ok.put(code, name);
                    continue;
                }
                String goodCode = (String)replacements.get(0);
                if (goodCode.length() == 2) continue;
                String oldName = names.get(goodCode);
                if (oldName == null || oldName.isEmpty()) {
                    fixed.put(goodCode, name);
                    continue;
                }
                if (oldName.equals(name)) {
                    ok.put(code, name);
                    continue;
                }
                System.out.println(locale + " Conflicting name <old:\u00ab" + code + "\u00bb\u00ab" + name + "\u00bb><repl:\u00ab" + goodCode + "\u00bb\u00ab" + oldName + "\u00bb>");
            }
            System.out.println(locale + "\t" + fixed);
        }
    }
}

