/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.ArrayComparator;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.XPathParts;

public class VettingAdder {
    private Map<String, Set<String>> locale_files = new TreeMap<String, Set<String>>();
    private Comparator<String> scomp = new UTF16.StringComparator();
    private Set<Object[]> conflictSet = new TreeSet<Object[]>(new ArrayComparator(this.scomp, this.scomp, this.scomp));
    static Comparator PathAndValueComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((VettingInfo)o1).compareByPathAndValue((VettingInfo)o2);
        }
    };
    CLDRFile english;

    public VettingAdder(String sourceDirectory) throws IOException {
        this.addFiles(sourceDirectory);
    }

    private void addFiles(String sourceDirectory) throws IOException {
        File f = new File(sourceDirectory);
        String normalizedPath = PathUtilities.getNormalizedPathString(f);
        if (!f.isDirectory()) {
            String name = f.getName();
            if (name.startsWith("fixed-")) {
                return;
            }
            if (name.equals(".htaccess")) {
                return;
            }
            if (!name.endsWith(".xml")) {
                Log.logln("Wrong filename format: " + PathUtilities.getNormalizedPathString(f));
                return;
            }
            String localeName = name.substring(0, name.length() - 4);
            Set<String> s2 = this.locale_files.get(localeName);
            if (s2 == null) {
                s2 = new TreeSet<String>();
                this.locale_files.put(localeName, s2);
            }
            s2.add(f.getParent());
        } else {
            String[] subnames = f.list();
            for (int i = 0; i < subnames.length; ++i) {
                this.addFiles(normalizedPath + File.separatorChar + subnames[i]);
            }
        }
    }

    public Set<String> keySet() {
        return this.locale_files.keySet();
    }

    public void incorporateVetting(String locale, String targetDir) throws IOException {
        Set<String> s2 = this.locale_files.get(locale);
        Log.logln("Vetting Data for: " + locale);
        VettingInfoSet accum = new VettingInfoSet();
        Iterator<String> it2 = s2.iterator();
        while (it2.hasNext()) {
            String dir = it2.next() + File.separator;
            String fixedLocale = "fixed-" + locale + ".xml";
            this.fixXML(dir, locale + ".xml", dir, fixedLocale);
            CLDRFile cldr = SimpleFactory.makeFromFile(dir + fixedLocale, locale, CLDRFile.DraftStatus.approved);
            for (String path : cldr) {
                String value = cldr.getStringValue(path);
                String fullPath = cldr.getFullXPath(path);
                if (value.startsWith("//ldml") || value.length() == 0) {
                    Log.logln("Skipping: [" + value + "] for " + fullPath);
                    continue;
                }
                accum.add(this.stripAlt(path), dir, this.stripAlt(fullPath), value);
            }
        }
        TreeSet<VettingInfo> uniquePathAndValue = new TreeSet<VettingInfo>(PathAndValueComparator);
        CLDRFile cldrDelta = SimpleFactory.makeFile(locale);
        boolean gotOne = false;
        Iterator<String> it22 = accum.iterator();
        while (it22.hasNext()) {
            String path = it22.next();
            Collection<VettingInfo> c = accum.get(path);
            uniquePathAndValue.clear();
            uniquePathAndValue.addAll(c);
            if (uniquePathAndValue.size() == 1) {
                VettingInfo vi = (VettingInfo)uniquePathAndValue.iterator().next();
                cldrDelta.add(vi.fullPath, vi.value);
                gotOne = true;
                continue;
            }
            this.conflictSet.add(new Object[]{locale, path, c});
        }
        if (gotOne) {
            Log.logln("Writing: " + targetDir + locale + ".xml");
            PrintWriter pw = FileUtilities.openUTF8Writer(targetDir, locale + ".xml");
            cldrDelta.write(pw);
            pw.close();
        } else {
            Log.logln("No data left in: " + targetDir + locale + ".xml");
        }
    }

    public void showSources() {
        for (String key : this.locale_files.keySet()) {
            Set<String> s2 = this.locale_files.get(key);
            Iterator<String> it2 = s2.iterator();
            while (it2.hasNext()) {
                Log.logln(key + " \t" + it2.next());
                key = "";
            }
        }
    }

    public void fixXML(String inputDir, String inputFile, String outputDir, String outputFile) throws IOException {
        String line;
        BufferedReader in = FileUtilities.openUTF8Reader(inputDir, inputFile);
        PrintWriter out = FileUtilities.openUTF8Writer(outputDir, outputFile);
        int haveLanguages = 0;
        int haveScripts = 0;
        int haveTerritories = 0;
        int haveVariants = 0;
        int haveKeys = 0;
        int haveTypes = 0;
        int inLocaleDisplayNames = 0;
        while ((line = in.readLine()) != null) {
            String trimmed = line.trim();
            if (inLocaleDisplayNames == 1) {
                haveLanguages = this.fixItem(out, haveLanguages, trimmed, "<language ", "languages");
                haveScripts = this.fixItem(out, haveScripts, trimmed, "<script ", "scripts");
                haveTerritories = this.fixItem(out, haveTerritories, trimmed, "<territory ", "territories");
                haveVariants = this.fixItem(out, haveVariants, trimmed, "<variant ", "variants");
                haveKeys = this.fixItem(out, haveKeys, trimmed, "<key ", "keys");
                haveTypes = this.fixItem(out, haveTypes, trimmed, "<type ", "types");
            }
            if (trimmed.startsWith("<localeDisplayNames")) {
                inLocaleDisplayNames = 1;
            } else if (trimmed.startsWith("</localeDisplayNames")) {
                inLocaleDisplayNames = 2;
            }
            out.println(line);
        }
        in.close();
        out.close();
    }

    private int fixItem(PrintWriter out, int haveLanguages, String trimmed, String item, String fix) {
        if (trimmed.startsWith(item)) {
            if (haveLanguages == 0) {
                out.println("<" + fix + ">");
                haveLanguages = 1;
            }
            return haveLanguages;
        }
        if (haveLanguages == 1) {
            out.println("</" + fix + ">");
            haveLanguages = 2;
        }
        return haveLanguages;
    }

    public Set<Object[]> getConflictSet() {
        return this.conflictSet;
    }

    public void showFiles(Factory cldrFactory, String targetDir) throws IOException {
        this.english = cldrFactory.make("en", true);
        Log.logln("");
        Log.logln("A. Sources");
        Log.logln("");
        this.showSources();
        Log.logln("");
        Log.logln("B. Intermediate Results");
        Log.logln("");
        Set<String> vettedLocales = this.keySet();
        Iterator<String> it = vettedLocales.iterator();
        while (it.hasNext()) {
            this.incorporateVetting(it.next(), targetDir);
        }
        Log.logln("");
        Log.logln("C. Conflicts");
        Log.logln("");
        this.showConflicts(cldrFactory);
        Log.logln("");
        Log.logln("D. Missing Vetting");
        Log.logln("");
        TreeSet<String> availableLocales = new TreeSet<String>(cldrFactory.getAvailable());
        availableLocales.removeAll(vettedLocales);
        block1: for (String locale : availableLocales) {
            CLDRFile cldr = cldrFactory.make(locale, false);
            for (String path : cldr) {
                String fullPath = cldr.getFullXPath(path);
                if (fullPath.indexOf("[@draft=") < 0) continue;
                Log.logln(locale + " \t" + this.english.getName(locale) + "\texample: " + fullPath);
                continue block1;
            }
        }
    }

    private void showConflicts(Factory cldrFactory) {
        Set<Object[]> s2 = this.getConflictSet();
        String lastLocale = "";
        CLDRFile cldr = null;
        Transliterator any_latin = Transliterator.getInstance("any-latin");
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        String[] pieces = new String[5];
        for (Object[] items : s2) {
            Object entry = "";
            if (!lastLocale.equals(items[0])) {
                this.showSet(emails);
                lastLocale = (String)items[0];
                cldr = cldrFactory.make(lastLocale, false);
                entry = "==========" + Utility.LINE_SEPARATOR + lastLocale + Utility.LINE_SEPARATOR;
            }
            String path = CLDRFile.getDistinguishingXPath((String)items[1], null);
            String current = cldr.getStringValue(path);
            entry = (String)entry + "\tpath:\t" + path + Utility.LINE_SEPARATOR + "\tcurrent value:\t" + this.getValue(any_latin, current) + Utility.LINE_SEPARATOR;
            entry = (String)entry + "\tEnglish value:\t" + this.getValue(any_latin, this.english.getStringValue(path)) + Utility.LINE_SEPARATOR;
            Collection c = (Collection)items[2];
            for (VettingInfo vi : c) {
                entry = (String)entry + "\t\tvalue:\t" + this.getValue(any_latin, vi.value) + "\t source: " + vi.dir + Utility.LINE_SEPARATOR;
                Utility.split(vi.dir, '\\', pieces);
                emails.add(pieces[2]);
            }
            Log.logln(entry);
        }
        this.showSet(emails);
    }

    private void showSet(Set<String> emails) {
        if (emails.size() == 0) {
            return;
        }
        Object result = "Emails:\t";
        Iterator<String> it = emails.iterator();
        while (it.hasNext()) {
            result = (String)result + it.next() + ", ";
        }
        result = (String)result + "cldr@unicode.org";
        emails.clear();
        Log.logln(result);
    }

    private String getValue(Transliterator some, String current) {
        String other;
        if (current == null) {
            current = "NULL";
        }
        return "<" + current + ">" + (String)((other = some.transliterate(current)).equals(current) ? "" : "\t[" + other + "]");
    }

    private String stripAlt(String path) {
        XPathParts tempParts = XPathParts.getFrozenInstance(path);
        Map<String, String> x = tempParts.getAttributes(tempParts.size() - 1);
        String value = x.get("alt");
        if (value != null && value.startsWith("proposed")) {
            x.remove("alt");
            return tempParts.toString();
        }
        return path;
    }

    static class VettingInfoSet {
        private Map<String, List<VettingInfo>> path_vettingInfoList = new TreeMap<String, List<VettingInfo>>();

        VettingInfoSet() {
        }

        public void add(String path, String dir, String fullPath, String value) {
            VettingInfo vi = new VettingInfo(dir, fullPath, value);
            List<VettingInfo> s2 = this.path_vettingInfoList.get(path);
            if (s2 == null) {
                s2 = new ArrayList<VettingInfo>(1);
                this.path_vettingInfoList.put(path, s2);
            }
            s2.add(vi);
        }

        public Iterator<String> iterator() {
            return this.path_vettingInfoList.keySet().iterator();
        }

        public Collection<VettingInfo> get(String path) {
            return this.path_vettingInfoList.get(path);
        }
    }

    static class VettingInfo {
        private String value;
        private String fullPath;
        private String dir;

        public VettingInfo(String dir, String fullPath, String value) {
            this.value = value;
            this.fullPath = fullPath;
            this.dir = dir;
        }

        public String toString() {
            return "source: " + this.dir + ";\t value: <" + this.value + ">";
        }

        public int compareByPathAndValue(VettingInfo other) {
            int result = this.fullPath.compareTo(other.fullPath);
            if (0 != result) {
                return result;
            }
            result = this.value.compareTo(other.value);
            if (0 != result) {
                return result;
            }
            return 0;
        }
    }
}

