/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class XMLModify {
    public static void main(String[] args) {
        MyOptions.parse(args, true);
        File sourceDirectory = new File(MyOptions.sourceDirectory.option.getValue());
        Matcher fileMatcher = Pattern.compile(MyOptions.fileRegex.option.getValue()).matcher("");
        Matcher pathMatcher = Pattern.compile(MyOptions.pathRegex.option.getValue()).matcher("");
        ArrayList<Pair<String, String>> data = new ArrayList<Pair<String, String>>();
        try (PrintWriter out = new PrintWriter(System.out);){
            for (String file : sourceDirectory.list()) {
                if (!fileMatcher.reset(file).matches()) continue;
                data.clear();
                out.println(file);
                XPathParts lastParts = null;
                for (Pair<String, String> pathValue : XMLFileReader.loadPathValues(sourceDirectory.toString() + "/" + file, data, true, true)) {
                    String value = pathValue.getSecond();
                    String path = pathValue.getFirst();
                    if (path.equals("!")) {
                        out.println("<!--" + value + " -->");
                        continue;
                    }
                    XPathParts parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
                    if (pathMatcher.reset(path).matches()) {
                        String type = parts.getAttributeValue(-1, "type");
                        parts.setAttribute(-1, "type", type.toLowerCase(Locale.ROOT).replaceAll("-", ""));
                    }
                    parts.writeDifference(out, parts, lastParts, value, null);
                    out.flush();
                    lastParts = parts;
                }
            }
        }
    }

    static enum MyOptions {
        sourceDirectory(new Option.Params().setHelp("sourceDirectory").setDefault(CLDRPaths.COMMON_DIRECTORY).setMatch(".+")),
        targetDirectory(new Option.Params().setHelp("targetDirectory").setDefault(CLDRPaths.GEN_DIRECTORY + "xmlModify").setMatch(".+")),
        fileRegex(new Option.Params().setHelp("filename regex").setMatch(".*").setDefault(".*")),
        pathRegex(new Option.Params().setHelp("path regex").setMatch(".*")),
        verbose(new Option.Params().setHelp("verbose debugging messages"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

