/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.unicode.cldr.util.Pick;
import org.unicode.cldr.util.Quoter;
import org.unicode.cldr.util.Tokenizer;

public class BNF {
    private Map map = new HashMap();
    private Set variables = new HashSet();
    private Pick pick = null;
    private Pick.Target target = null;
    private Tokenizer t;
    private Quoter quoter;
    private Random random;
    int maxRepeat = 99;
    private static final int NO_WEIGHT = Integer.MIN_VALUE;

    public String next() {
        return this.target.next();
    }

    public String getInternal() {
        return this.pick.getInternal(0, new HashSet());
    }

    public BNF(Random random, Quoter quoter) {
        this.random = random;
        this.quoter = quoter;
        this.t = new Tokenizer();
    }

    public BNF addRules(String rules) {
        this.t.setSource(rules);
        while (this.addRule()) {
        }
        return this;
    }

    public BNF complete() {
        Object temp;
        Object msg;
        Set ruleSet = this.map.keySet();
        this.variables.add("$root");
        this.variables.addAll(this.t.getLookedUpItems());
        if (!ruleSet.equals(this.variables)) {
            msg = this.showDiff(this.variables, ruleSet);
            if (((String)msg).length() != 0) {
                msg = "Error: Missing definitions for: " + (String)msg;
            }
            if (((String)(temp = this.showDiff(ruleSet, this.variables))).length() != 0) {
                temp = "Warning: Defined but not used: " + (String)temp;
            }
            if (((String)msg).length() == 0) {
                msg = temp;
            } else if (((String)temp).length() != 0) {
                msg = (String)msg + "; " + (String)temp;
            }
            this.error((String)msg);
        }
        if (!ruleSet.equals(this.variables)) {
            msg = this.showDiff(this.variables, ruleSet);
            if (((String)msg).length() != 0) {
                msg = "Missing definitions for: " + (String)msg;
            }
            if (((String)(temp = this.showDiff(ruleSet, this.variables))).length() != 0) {
                temp = "Defined but not used: " + (String)temp;
            }
            if (((String)msg).length() == 0) {
                msg = temp;
            } else if (((String)temp).length() != 0) {
                msg = (String)msg + "; " + (String)temp;
            }
            this.error((String)msg);
        }
        for (String key : ruleSet) {
            Pick expression = (Pick)this.map.get(key);
            for (Object key2 : ruleSet) {
                if (key.equals(key2)) continue;
                Pick expression2 = (Pick)this.map.get(key2);
                expression2.replace(key, expression);
            }
        }
        this.pick = (Pick)this.map.get("$root");
        this.target = Pick.Target.make(this.pick, this.random, this.quoter);
        return this;
    }

    String showDiff(Set a, Set b) {
        HashSet temp = new HashSet();
        temp.addAll(a);
        temp.removeAll(b);
        if (temp.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = temp.iterator();
        while (it.hasNext()) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append(it.next().toString());
        }
        return buffer.toString();
    }

    void error(String msg) {
        throw new IllegalArgumentException(msg + "\r\n" + this.t.toString());
    }

    private boolean addRule() {
        String s2;
        int type = this.t.next();
        if (type == -1) {
            return false;
        }
        if (type != -3) {
            this.error("missing weight");
        }
        if ((s2 = this.t.getString()).length() == 0 || s2.charAt(0) != '$') {
            this.error("missing $ in variable");
        }
        if (this.t.next() != 61) {
            this.error("missing =");
        }
        int startBody = this.t.index;
        Pick rule = this.getAlternation();
        if (rule == null) {
            this.error("missing expression");
        }
        this.t.addSymbol(s2, this.t.getSource(), startBody, this.t.index);
        if (this.t.next() != 59) {
            this.error("missing ;");
        }
        return this.addPick(s2, rule);
    }

    protected boolean addPick(String s2, Pick rule) {
        Object temp = this.map.get(s2);
        if (temp != null) {
            this.error("duplicate variable");
        }
        if (rule.name == null) {
            rule.name(s2);
        }
        this.map.put(s2, rule);
        return true;
    }

    public BNF addSet(String variable, UnicodeSet set) {
        if (set != null) {
            String body = set.toString();
            this.t.addSymbol(variable, body, 0, body.length());
            this.addPick(variable, Pick.codePoint(set));
        }
        return this;
    }

    Pick qualify(Pick item) {
        int type = this.t.next();
        switch (type) {
            case 64: {
                return new Pick.Quote(item);
            }
            case 126: {
                return new Pick.Morph(item);
            }
            case 63: {
                int weight = this.getWeight();
                if (weight == Integer.MIN_VALUE) {
                    weight = 50;
                }
                int[] weights = new int[]{100 - weight, weight};
                return Pick.repeat(0, 1, weights, item);
            }
            case 42: {
                int[] weights = this.getWeights();
                return Pick.repeat(1, this.maxRepeat, weights, item);
            }
            case 43: {
                int[] weights = this.getWeights();
                return Pick.repeat(1, this.maxRepeat, weights, item);
            }
            case 123: {
                int start;
                if (this.t.next() != -2) {
                    this.error("missing number");
                }
                int end = start = (int)this.t.getNumber();
                type = this.t.next();
                if (type == 44) {
                    end = this.maxRepeat;
                    type = this.t.next();
                    if (type == -2) {
                        end = (int)this.t.getNumber();
                        type = this.t.next();
                    }
                }
                if (type != 125) {
                    this.error("missing }");
                }
                int[] weights = this.getWeights();
                return Pick.repeat(start, end, weights, item);
            }
        }
        this.t.backup();
        return item;
    }

    Pick getCore() {
        int token = this.t.next();
        if (token == -3) {
            String s2 = this.t.getString();
            if (s2.charAt(0) == '$') {
                this.variables.add(s2);
            }
            return Pick.string(s2);
        }
        if (token == -4) {
            return Pick.codePoint(this.t.getUnicodeSet());
        }
        if (token != 40) {
            this.t.backup();
            return null;
        }
        Pick temp = this.getAlternation();
        token = this.t.next();
        if (token != 41) {
            this.error("missing )");
        }
        return temp;
    }

    Pick getSequence() {
        Pick.Sequence result = null;
        Pick last = null;
        while (true) {
            Pick oldItem;
            Pick item;
            if ((item = this.getCore()) == null) {
                if (result != null) {
                    return result;
                }
                if (last != null) {
                    return last;
                }
                this.error("missing item in sequence");
            }
            do {
                oldItem = item;
            } while ((item = this.qualify(item)) != oldItem);
            if (last == null) {
                last = item;
                continue;
            }
            if (result == null) {
                result = Pick.makeSequence().and2(last);
            }
            result = result.and2(item);
        }
    }

    Pick getAlternation() {
        Pick.Alternation result = null;
        Pick last = null;
        int lastWeight = Integer.MIN_VALUE;
        while (true) {
            int token;
            int weight;
            Pick temp;
            if ((temp = this.getSequence()) == null) {
                this.error("empty alternation");
            }
            if ((weight = this.getWeight()) == Integer.MIN_VALUE) {
                weight = 1;
            }
            if (last == null) {
                last = temp;
                lastWeight = weight;
            } else {
                if (result == null) {
                    result = Pick.makeAlternation().or2(lastWeight, last);
                }
                result = result.or2(weight, temp);
            }
            if ((token = this.t.next()) == 124) continue;
            this.t.backup();
            if (result != null) {
                return result;
            }
            if (last != null) break;
        }
        return last;
    }

    int getWeight() {
        int token = this.t.next();
        if (token != -2) {
            this.t.backup();
            return Integer.MIN_VALUE;
        }
        int weight = (int)this.t.getNumber();
        token = this.t.next();
        if (token != 37) {
            this.error("missing %");
        }
        return weight;
    }

    int[] getWeights() {
        int weight;
        ArrayList<Integer> list = new ArrayList<Integer>();
        while ((weight = this.getWeight()) != Integer.MIN_VALUE) {
            list.add(weight);
        }
        if (list.isEmpty()) {
            return null;
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    public int getMaxRepeat() {
        return this.maxRepeat;
    }

    public BNF setMaxRepeat(int maxRepeat) {
        this.maxRepeat = maxRepeat;
        return this;
    }
}

