/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.icu.text.LocaleDisplayNames;
import com.ibm.icu.text.Transform;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.StandardCodes;

public final class CLDRLocale
implements Comparable<CLDRLocale> {
    private static final boolean DEBUG = false;
    private String parentId;
    private volatile CLDRLocale parentLocale;
    private ULocale ulocale;
    private String basename;
    private String fullname;
    private LocaleIDParser parts = null;
    private static ConcurrentHashMap<String, CLDRLocale> stringToLoc = new ConcurrentHashMap();
    public static final CLDRLocale ROOT = CLDRLocale.getInstance(ULocale.ROOT);
    private static Cache<ULocale, NameFormatter> defaultFormatters = CacheBuilder.newBuilder().initialCapacity(1).build();
    private static NameFormatter gDefaultFormatter = CLDRLocale.getSimpleFormatterFor(ULocale.getDefault());

    private String toDisplayLanguageTag() {
        if (this.getBaseName().equals("root")) {
            return "root";
        }
        return this.toLanguageTag();
    }

    public String toLanguageTag() {
        return this.ulocale.toLanguageTag();
    }

    public static String toLanguageTag(String locale) {
        return CLDRLocale.getInstance(locale).toLanguageTag();
    }

    private CLDRLocale(String str) {
        str = this.process(str);
        if (CLDRLocale.rootMatches(str)) {
            this.fullname = "root";
            this.parentId = null;
        } else {
            this.parts = new LocaleIDParser();
            this.parts.set(str);
            this.fullname = this.parts.toString();
            this.parentId = LocaleIDParser.getParent(str);
        }
        this.basename = this.fullname;
        if (this.ulocale == null) {
            this.ulocale = new ULocale(this.fullname);
        }
    }

    public String toString() {
        return this.fullname;
    }

    public String getBaseName() {
        return this.basename;
    }

    private String process(String baseName) {
        return baseName.replaceAll("__", "_");
    }

    @Override
    public int compareTo(CLDRLocale o) {
        if (o == this) {
            return 0;
        }
        return this.fullname.compareTo(o.fullname);
    }

    public int hashCode() {
        return this.fullname.hashCode();
    }

    public ULocale toULocale() {
        return this.ulocale;
    }

    public static CLDRLocale getInstance(String s2) {
        if (s2 == null) {
            return null;
        }
        if (CLDRLocale.rootMatches(s2)) {
            s2 = "root";
        }
        return stringToLoc.computeIfAbsent(s2, k -> new CLDRLocale((String)k));
    }

    private static boolean rootMatches(String s2) {
        return s2.equals(ULocale.ROOT.getBaseName()) || s2.equalsIgnoreCase("root");
    }

    public static CLDRLocale getInstance(ULocale u) {
        if (u == null) {
            return null;
        }
        return CLDRLocale.getInstance(u.getBaseName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLDRLocale getParent() {
        if (this.parentId == null) {
            return null;
        }
        CLDRLocale result = this.parentLocale;
        if (result == null) {
            CLDRLocale cLDRLocale = this;
            synchronized (cLDRLocale) {
                result = this.parentLocale;
                if (result == null) {
                    this.parentLocale = result = CLDRLocale.getInstance(this.parentId);
                }
            }
        }
        return result;
    }

    public boolean childOf(CLDRLocale other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        CLDRLocale parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.childOf(other);
    }

    public Iterable<CLDRLocale> getParentIterator() {
        final CLDRLocale newThis = this;
        return new Iterable<CLDRLocale>(){

            @Override
            public Iterator<CLDRLocale> iterator() {
                return new Iterator<CLDRLocale>(){
                    CLDRLocale what;
                    {
                        this.what = newThis;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.what.getParent() != null;
                    }

                    @Override
                    public CLDRLocale next() {
                        CLDRLocale curr = this.what;
                        if (this.what != null) {
                            this.what = this.what.getParent();
                        }
                        return curr;
                    }

                    @Override
                    public void remove() {
                        throw new InternalError("unmodifiable iterator");
                    }
                };
            }
        };
    }

    public CLDRLocale getLanguageLocale() {
        return CLDRLocale.getInstance(this.getLanguage());
    }

    public String getLanguage() {
        return this.parts == null ? this.fullname : this.parts.getLanguage();
    }

    public String getScript() {
        return this.parts == null ? null : this.parts.getScript();
    }

    public boolean isLanguageLocale() {
        return this.equals(this.getLanguageLocale());
    }

    public String getCountry() {
        return this.parts == null ? null : this.parts.getRegion();
    }

    public String getVariant() {
        return this.toULocale().getVariant();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLDRLocale)) {
            return false;
        }
        return 0 == this.compareTo((CLDRLocale)o);
    }

    public String getDisplayName() {
        return this.getDisplayName(CLDRLocale.getDefaultFormatter());
    }

    public String getDisplayRegion() {
        return this.getDisplayCountry(CLDRLocale.getDefaultFormatter());
    }

    public String getDisplayVariant() {
        return this.getDisplayVariant(CLDRLocale.getDefaultFormatter());
    }

    public String getDisplayName(boolean combined, Transform<String, String> picker) {
        return this.getDisplayName(CLDRLocale.getDefaultFormatter(), combined, picker);
    }

    public String getDisplayName(NameFormatter displayLocale) {
        if (displayLocale == null) {
            displayLocale = CLDRLocale.getDefaultFormatter();
        }
        return displayLocale.getDisplayName(this);
    }

    public static NameFormatter getSimpleFormatterFor(ULocale loc) {
        final ULocale uLocFinal = loc;
        try {
            return defaultFormatters.get(loc, new Callable<NameFormatter>(){

                @Override
                public NameFormatter call() throws Exception {
                    return new SimpleFormatter(uLocFinal);
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDisplayName(ULocale displayLocale) {
        return CLDRLocale.getSimpleFormatterFor(displayLocale).getDisplayName(this);
    }

    public static NameFormatter getDefaultFormatter() {
        return gDefaultFormatter;
    }

    public static NameFormatter setDefaultFormatter(NameFormatter nf) {
        gDefaultFormatter = nf;
        return gDefaultFormatter;
    }

    public String getDisplayCountry(NameFormatter displayLocale) {
        if (displayLocale == null) {
            displayLocale = CLDRLocale.getDefaultFormatter();
        }
        return displayLocale.getDisplayCountry(this);
    }

    public String getDisplayVariant(NameFormatter displayLocale) {
        if (displayLocale == null) {
            displayLocale = CLDRLocale.getDefaultFormatter();
        }
        return displayLocale.getDisplayVariant(this);
    }

    public static Set<CLDRLocale> getInstance(Iterable<String> available) {
        TreeSet<CLDRLocale> s2 = new TreeSet<CLDRLocale>();
        for (String str : available) {
            s2.add(CLDRLocale.getInstance(str));
        }
        return s2;
    }

    public String getDisplayName(NameFormatter engFormat, boolean combined, Transform<String, String> picker) {
        return engFormat.getDisplayName(this, combined, picker);
    }

    public CLDRLocale getHighestNonrootParent() {
        CLDRLocale parent;
        CLDRLocale res = this == ROOT ? null : ((parent = this.getParent()) == ROOT || parent == null ? this : parent.getHighestNonrootParent());
        return res;
    }

    public boolean isParentRoot() {
        return ROOT == this.getParent();
    }

    public int getRank() {
        if (this == ROOT) {
            return 0;
        }
        return 1 + this.getParent().getRank();
    }

    public static CLDRLocale getInstance(String lang, String script, String region) {
        return CLDRLocale.getInstance((lang.isEmpty() || lang.equals("root") ? "und" : lang) + (String)(script.isEmpty() ? "" : "_" + script) + (String)(region.isEmpty() ? "" : "_" + region));
    }

    public String getRegion() {
        return this.getCountry();
    }

    public static interface SublocaleProvider {
        public Set<CLDRLocale> subLocalesOf(CLDRLocale var1);
    }

    public static enum FormatBehavior {
        replace,
        extend,
        extendHtml;

    }

    public static class CLDRFormatter
    extends SimpleFormatter {
        private FormatBehavior behavior = FormatBehavior.extend;
        private CLDRFile file = null;

        public CLDRFormatter(CLDRFile fromFile) {
            super(CLDRLocale.getInstance(fromFile.getLocaleID()).toULocale());
            this.file = fromFile;
        }

        public CLDRFormatter(CLDRFile fromFile, FormatBehavior behavior) {
            super(CLDRLocale.getInstance(fromFile.getLocaleID()).toULocale());
            this.behavior = behavior;
            this.file = fromFile;
        }

        public CLDRFormatter() {
            super(ULocale.ROOT);
        }

        public CLDRFormatter(FormatBehavior behavior) {
            super(ULocale.ROOT);
            this.behavior = behavior;
        }

        @Override
        public String getDisplayVariant(CLDRLocale cldrLocale) {
            if (this.file != null) {
                return this.file.getName("variant", cldrLocale.getVariant());
            }
            return this.tryForBetter(super.getDisplayVariant(cldrLocale), cldrLocale.getVariant());
        }

        @Override
        public String getDisplayName(CLDRLocale cldrLocale) {
            if (this.file != null) {
                return this.file.getName(cldrLocale.toDisplayLanguageTag(), true, null);
            }
            return super.getDisplayName(cldrLocale);
        }

        @Override
        public String getDisplayName(CLDRLocale cldrLocale, boolean onlyConstructCompound, Transform<String, String> altPicker) {
            if (this.file != null) {
                return this.file.getName(cldrLocale.toDisplayLanguageTag(), onlyConstructCompound, altPicker);
            }
            return super.getDisplayName(cldrLocale);
        }

        @Override
        public String getDisplayScript(CLDRLocale cldrLocale) {
            if (this.file != null) {
                return this.file.getName("script", cldrLocale.getScript());
            }
            return this.tryForBetter(super.getDisplayScript(cldrLocale), cldrLocale.getScript());
        }

        @Override
        public String getDisplayLanguage(CLDRLocale cldrLocale) {
            if (this.file != null) {
                return this.file.getName("language", cldrLocale.getLanguage());
            }
            return this.tryForBetter(super.getDisplayLanguage(cldrLocale), cldrLocale.getLanguage());
        }

        @Override
        public String getDisplayCountry(CLDRLocale cldrLocale) {
            if (this.file != null) {
                return this.file.getName("territory", cldrLocale.getCountry());
            }
            return this.tryForBetter(super.getDisplayLanguage(cldrLocale), cldrLocale.getLanguage());
        }

        private String tryForBetter(String superString, String code) {
            String fromLst;
            if (superString.equals(code) && (fromLst = StandardCodes.make().getData("language", code)) != null && !fromLst.equals(code)) {
                switch (this.behavior) {
                    case replace: {
                        return fromLst;
                    }
                    case extend: {
                        return superString + " [" + fromLst + "]";
                    }
                    case extendHtml: {
                        return superString + " [<i>" + fromLst + "</i>]";
                    }
                }
            }
            return superString;
        }
    }

    public static class SimpleFormatter
    implements NameFormatter {
        private LocaleDisplayNames ldn;

        public SimpleFormatter(ULocale displayLocale) {
            this.ldn = LocaleDisplayNames.getInstance(displayLocale);
        }

        public LocaleDisplayNames getDisplayNames() {
            return this.ldn;
        }

        public LocaleDisplayNames setDisplayNames(LocaleDisplayNames ldn) {
            this.ldn = ldn;
            return this.ldn;
        }

        @Override
        public String getDisplayVariant(CLDRLocale cldrLocale) {
            return this.ldn.variantDisplayName(cldrLocale.getVariant());
        }

        @Override
        public String getDisplayCountry(CLDRLocale cldrLocale) {
            return this.ldn.regionDisplayName(cldrLocale.getCountry());
        }

        @Override
        public String getDisplayName(CLDRLocale cldrLocale) {
            StringBuffer sb = new StringBuffer();
            String l = cldrLocale.getLanguage();
            String s2 = cldrLocale.getScript();
            String r = cldrLocale.getCountry();
            String v = cldrLocale.getVariant();
            if (l != null && !l.isEmpty()) {
                sb.append(this.getDisplayLanguage(cldrLocale));
            } else {
                sb.append("?");
            }
            if (s2 != null && !s2.isEmpty() || r != null && !r.isEmpty() || v != null && !v.isEmpty()) {
                sb.append(" (");
                if (s2 != null && !s2.isEmpty()) {
                    sb.append(this.getDisplayScript(cldrLocale)).append(",");
                }
                if (r != null && !r.isEmpty()) {
                    sb.append(this.getDisplayCountry(cldrLocale)).append(",");
                }
                if (v != null && !v.isEmpty()) {
                    sb.append(this.getDisplayVariant(cldrLocale)).append(",");
                }
                sb.replace(sb.length() - 1, sb.length(), ")");
            }
            return sb.toString();
        }

        @Override
        public String getDisplayScript(CLDRLocale cldrLocale) {
            return this.ldn.scriptDisplayName(cldrLocale.getScript());
        }

        @Override
        public String getDisplayLanguage(CLDRLocale cldrLocale) {
            return this.ldn.languageDisplayName(cldrLocale.getLanguage());
        }

        @Override
        public String getDisplayName(CLDRLocale cldrLocale, boolean onlyConstructCompound, Transform<String, String> altPicker) {
            return this.getDisplayName(cldrLocale);
        }
    }

    public static interface NameFormatter {
        public String getDisplayName(CLDRLocale var1);

        public String getDisplayName(CLDRLocale var1, boolean var2, Transform<String, String> var3);

        public String getDisplayLanguage(CLDRLocale var1);

        public String getDisplayScript(CLDRLocale var1);

        public String getDisplayVariant(CLDRLocale var1);

        public String getDisplayCountry(CLDRLocale var1);
    }
}

