/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StringId;

public abstract class CLDRURLS {
    public static final String CLDR_SCHEMA_BASE = "https://schemas.unicode.org/cldr";
    public static final String CLDR_CURVER_BASE = "https://schemas.unicode.org/cldr/46.1";
    public static final String CLDR_REPO_BASE = "https://github.com/unicode-org/cldr/";
    public static final String CLDR_REPO_MAIN = "https://github.com/unicode-org/cldr/blob/main/";
    public static final String CLDR_STAGING_REPO_MAIN = "https://github.com/unicode-org/cldr-staging/blob/main/";
    public static final String DEFAULT_COMMIT_BASE = "https://github.com/unicode-org/cldr/commit/";
    public static final String DEFAULT_HOST = "st.unicode.org";
    public static final String DEFAULT_PATH = "/cldr-apps";
    public static final String DEFAULT_BASE = "https://st.unicode.org/cldr-apps";
    public static final String CLDR_NEWTICKET_URL = "https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket";
    public static final String CLDR_REPO_ROOT = "https://github.com/unicode-org/cldr";
    public static final String CLDR_HOMEPAGE = "https://cldr.unicode.org";
    public static final String UNICODE_CONSORTIUM = "The Unicode Consortium";
    public static final String CLDR_UPDATINGDTD_URL = "https://cldr.unicode.org/development/updating-dtds";
    public static final String UNICODE_SPDX = "Unicode-3.0";
    public static final String UNICODE_SPDX_HEADER = "SPDX-License-Identifier: Unicode-3.0";
    public static final String CLDR_SURVEY_BASE = "CLDR_SURVEY_BASE";
    public static final String CLDR_SURVEY_PATH = "CLDR_SURVEY_PATH";
    public static final String TOOLSURL = "http://cldr.unicode.org/tools/";
    protected static String VPATH = "/v#";
    public static final String UNKNOWN_REVISION = "(unknown)";
    public static final String GENERAL_HELP_URL = "https://cldr.unicode.org/translation/";
    public static final String ADMIN_HELP_URL = "https://cldr.unicode.org/index/survey-tool/survey-tool-administration";
    public static final String CAPITALIZATION_URL = "https://cldr.unicode.org/translation/translation-guide-general/capitalization";
    public static final String CHARACTERS_HELP = "https://cldr.unicode.org/translation/characters";
    public static final String CHARACTER_LABELS = "https://cldr.unicode.org/translation/characters/character-labels";
    public static final String CHARTS_URL = "https://cldr.unicode.org/index/charts#TOC-Summary";
    public static final String COMPOUND_UNITS_HELP = "https://cldr.unicode.org/translation/units/unit-names-and-patterns#h.7kdholgw8hpx";
    public static final String COUNTRY_NAMES = "https://cldr.unicode.org/translation/displaynames/countryregion-territory-names";
    public static final String CURRENCY_NAMES = "https://cldr.unicode.org/translation/currency-names-and-symbols";
    public static final String DATE_TIME_HELP = "https://cldr.unicode.org/translation/date-time/date-time-names#h.ewzjebmpoi4k";
    public static final String DATE_TIME_NAMES = "https://cldr.unicode.org/translation/date-time/date-time-names";
    public static final String DATE_TIME_NAMES_CYCLIC = "https://cldr.unicode.org/translation/date-time/date-time-names#h.h0vy2eyzcj0n";
    public static final String DATE_TIME_NAMES_FIELD = "https://cldr.unicode.org/translation/date-time/date-time-names#h.8wfk3599ck9x";
    public static final String DATE_TIME_NAMES_MONTH = "https://cldr.unicode.org/translation/date-time/date-time-names#h.fww3pfyk0uwn";
    public static final String DATE_TIME_NAMES_RELATIVE = "https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v";
    public static final String DATE_TIME_PATTERNS = "https://cldr.unicode.org/translation/date-time/date-time-patterns";
    public static final String DATE_TIME_PATTERNS_URL = "https://cldr.unicode.org/translation/date-time/date-time-patterns";
    public static final String ERRORS_URL = "https://cldr.unicode.org/translation/error-and-warning-codes";
    public static final String EXEMPLAR_CHARACTERS = "https://cldr.unicode.org/translation/core-data/exemplars";
    public static final String GRAMMATICAL_INFLECTION = "https://cldr.unicode.org/translation/grammatical-inflection";
    public static final String KEY_NAMES = "https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af";
    public static final String LANGUAGE_NAMES = "https://cldr.unicode.org/translation/displaynames/languagelocale-names";
    public static final String LISTS_HELP = "https://cldr.unicode.org/translation/miscellaneous-displaying-lists";
    public static final String LOCALE_PATTERN = "https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns";
    public static final String NUMBERING_SYSTEMS = "https://cldr.unicode.org/translation/core-data/numbering-systems";
    public static final String NUMBERS_HELP = "https://cldr.unicode.org/translation/currency-names-and-symbols";
    public static final String NUMBERS_PLURAL = "https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.mnb2fmj0pt72";
    public static final String NUMBERS_SHORT = "https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz";
    public static final String NUMBER_PATTERNS = "https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z";
    public static final String PARSE_LENIENT = "https://cldr.unicode.org/translation/core-data/characters#h.j3x0cwalqgqt";
    public static final String PERSON_NAME_FORMATS = "https://cldr.unicode.org/translation/miscellaneous-person-name-formats";
    public static final String PLURALS_HELP = "https://cldr.unicode.org/translation/getting-started/plurals";
    public static final String PLURALS_HELP_MINIMAL = "https://cldr.unicode.org/translation/getting-started/plurals#h.pnla5cp3nl4l";
    public static final String SCRIPT_NAMES = "https://cldr.unicode.org/translation/displaynames/script-names";
    public static final String SHORT_CHARACTER_NAMES = "https://cldr.unicode.org/translation/characters/short-names-and-keywords#h.4a8wthj27m74";
    public static final String TRANSFORMS_HELP = "https://cldr.unicode.org/translation/transforms";
    public static final String TYPOGRAPHIC_NAMES = "https://cldr.unicode.org/translation/characters/typographic-names";
    public static final String TZ_CITY_NAMES = "https://cldr.unicode.org/translation/time-zones-and-city-names";
    public static final String UNITS_HELP = "https://cldr.unicode.org/translation/units";
    public static final String UNITS_MISC_HELP = "https://cldr.unicode.org/translation/units";
    public static final String PRIORITY_SUMMARY_HELP_URL = "https://cldr.unicode.org/translation/getting-started/vetting-view#TOC-Priority-Items";
    public static final String UPDATING_CURRENCY_CODES = "https://cldr.unicode.org/development/updating-codes/update-currency-codes";
    public static final String CLDR_ARCHIVE = "https://cldr.unicode.org/development/creating-the-archive";

    public abstract String base();

    public String forXpath(String locale, String xpath) {
        return this.forXpath(CLDRLocale.getInstance(locale), xpath);
    }

    public final String forXpath(CLDRLocale locale, String xpath) {
        this.assertIsXpath(xpath);
        String hexid = xpath == null ? null : StringId.getHexId(xpath);
        return this.forXpathHexId(locale, hexid);
    }

    public final String forXpathHexId(String locale, String hexid) {
        return this.forXpathHexId(CLDRLocale.getInstance(locale), hexid);
    }

    public final String forXpathHexId(CLDRLocale locale, String hexid) {
        this.assertIsHexId(hexid);
        return this.forSpecial(Special.Survey, locale, (String)null, hexid);
    }

    public final String forXpathHexId(String locale, PathHeader.PageId page, String hexid) {
        return this.forXpathHexId(CLDRLocale.getInstance(locale), page, hexid);
    }

    public final String forXpathHexId(CLDRLocale locale, PathHeader.PageId page, String hexid) {
        this.assertIsHexId(hexid);
        return this.forSpecial(Special.Survey, locale, page, hexid);
    }

    public final String forPage(String locale, PathHeader.PageId page) {
        return this.forPage(CLDRLocale.getInstance(locale), page);
    }

    public final String forPage(CLDRLocale locale, PathHeader.PageId page) {
        return this.forSpecial(Special.Survey, locale, page.name(), null);
    }

    public final String forLocale(CLDRLocale locale) {
        return this.forXpath(locale, null);
    }

    public final String forSpecial(Special special, CLDRLocale locale, PathHeader.PageId page, String hexid) {
        return this.forSpecial(special, locale, page.name(), hexid);
    }

    public final String forSpecial(Special special) {
        return this.forSpecial(special, (CLDRLocale)null, (String)null, null);
    }

    public final String forSpecial(Special special, CLDRLocale locale) {
        return this.forSpecial(special, locale, (String)null, null);
    }

    public String forSpecial(Special special, CLDRLocale locale, String page, String hexid) {
        StringBuilder sb = new StringBuilder(this.base());
        sb.append(VPATH);
        if (special != null) {
            sb.append(special.id);
        }
        sb.append('/');
        if (locale != null) {
            sb.append(locale.getBaseName());
        }
        sb.append('/');
        if (page != null) {
            sb.append(page);
        }
        sb.append('/');
        if (hexid != null) {
            sb.append(hexid);
        }
        return sb.toString();
    }

    public final void assertIsHexId(String hexid) throws IllegalArgumentException {
        if (hexid != null && hexid.startsWith("/")) {
            throw new IllegalArgumentException("This function takes a hex StringID: perhaps you meant to use forXpath() instead.");
        }
    }

    public final void assertIsXpath(String xpath) throws IllegalArgumentException {
        if (xpath != null && !xpath.startsWith("/")) {
            throw new IllegalArgumentException("This function takes an XPath: perhaps you meant to use forXpathHexId() instead.");
        }
    }

    public final String forSpecial(Special special, String localeID) {
        return this.forSpecial(special, CLDRLocale.getInstance(localeID));
    }

    public final String forPathHeader(String locale, PathHeader pathHeader) {
        return this.forPathHeader(CLDRLocale.getInstance(locale), pathHeader);
    }

    public final String forPathHeader(CLDRLocale locale, PathHeader pathHeader) {
        return this.forSpecial(Special.Survey, locale, pathHeader.getPageId(), StringId.getHexId(pathHeader.getOriginalPath()));
    }

    public static String gitHashToLink(String hash) {
        if (!CLDRURLS.isKnownHash(hash)) {
            return "<span class=\"githashLink\">" + hash + "</span>";
        }
        return "<a class=\"githashLink\" href=\"" + CldrUtility.getProperty("CLDR_COMMIT_BASE", DEFAULT_COMMIT_BASE) + hash + "\">" + hash.substring(0, 8) + "</a>";
    }

    public static boolean isKnownHash(String hash) {
        return !hash.equals(UNKNOWN_REVISION);
    }

    public static final String toHTML(String url) {
        return "<a href=\"" + url + "\">" + url + "</a>";
    }

    public static String getVettingViewerHeaderStyles() {
        return "<style>\n.hide {display:none}\n.vve {}\n.vvn {}\n.vvp {}\n.vvl {}\n.vvm {}\n.vvu {}\n.vvw {}\n.vvd {}\n.vvo {}\n</style>";
    }

    public static enum Special {
        Survey(""),
        Locales,
        Vetting("dashboard"),
        Forum;

        private final String id;

        private Special(String s2) {
            this.id = s2;
        }

        private Special() {
            this.id = this.name().toLowerCase();
        }
    }
}

