/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CoverageInfo {
    private static final int MAXLOCALES = 50;
    private Cache<String, CoverageLevel2> localeToCoverageLevelInfo = CacheBuilder.newBuilder().maximumSize(50L).build();
    private Cache<XPathWithLocation, Level> coverageCache = CacheBuilder.newBuilder().maximumSize(50L).build();
    private final SupplementalDataInfo supplementalDataInfo;

    public CoverageInfo(SupplementalDataInfo coverageInfoGettable) {
        this.supplementalDataInfo = coverageInfoGettable;
    }

    public Level getCoverageLevel(String xpath, String loc) {
        Level result = null;
        final XPathWithLocation xpLoc = new XPathWithLocation(xpath, loc);
        try {
            result = this.coverageCache.get(xpLoc, new Callable<Level>(){

                @Override
                public Level call() throws Exception {
                    final String location = xpLoc.getLocation();
                    CoverageLevel2 cov = CoverageInfo.this.localeToCoverageLevelInfo.get(location, new Callable<CoverageLevel2>(){

                        @Override
                        public CoverageLevel2 call() throws Exception {
                            return CoverageLevel2.getInstance(CoverageInfo.this.supplementalDataInfo, location);
                        }
                    });
                    Level result = cov.getLevel(xpLoc.getXPath());
                    return result;
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getCoverageValue(String xpath, String loc) {
        return this.getCoverageLevel(xpath, loc).getLevel();
    }

    private static final class XPathWithLocation {
        private final String xpath;
        private final String location;
        private final int hashCode;

        public XPathWithLocation(String xpath, String location) {
            this.xpath = xpath;
            this.location = location;
            this.hashCode = Objects.hash(this.xpath, this.location);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.hashCode != other.hashCode()) {
                return false;
            }
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            XPathWithLocation o = (XPathWithLocation)other;
            if (this.location != null && !this.location.equals(o.location)) {
                return false;
            }
            return this.xpath == null || this.xpath.equals(o.xpath);
        }

        public String getXPath() {
            return this.xpath;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

