/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.XPathParts;

public class DtdPathIterator {
    final DtdData dtdData;
    final XPathParts xpathParts;

    public DtdPathIterator(DtdData dtdData) {
        this.dtdData = dtdData;
        this.xpathParts = new XPathParts();
    }

    public void visit(Consumer<XPathParts> function, Function<DtdData.Attribute, String> sample) {
        this.xpathParts.clear();
        this.visit(this.dtdData.ROOT, function, sample);
    }

    private void visit(DtdData.Element parent, Consumer<XPathParts> visitor, Function<DtdData.Attribute, String> sample) {
        if (parent.isDeprecated()) {
            return;
        }
        String parentName = parent.getName();
        if (parentName.contentEquals("exemplarCharacters")) {
            boolean bl = false;
        }
        if (parentName.equals("alias") || parentName.equals("identity") || parentName.equals("special")) {
            return;
        }
        Set<DtdData.Element> children = parent.getChildren().keySet();
        if (!children.isEmpty()) {
            LinkedHashSet<DtdData.Element> temp = new LinkedHashSet<DtdData.Element>();
            for (DtdData.Element element : children) {
                if (element.isDeprecated()) continue;
                temp.add(element);
            }
            children = ImmutableSet.copyOf(temp);
        }
        int index = this.xpathParts.size();
        this.xpathParts.addElement(parentName);
        ArrayList<DtdData.Attribute> optionalAttributes = new ArrayList<DtdData.Attribute>();
        for (DtdData.Attribute attribute : parent.getAttributes().keySet()) {
            String attributeName;
            if (attribute.isDeprecated() || attribute.getStatus() != DtdData.AttributeStatus.distinguished || (attributeName = attribute.getName()).equals("alt")) continue;
            if (attribute.mode == DtdData.Mode.OPTIONAL) {
                if (parentName.equals("displayName") && attributeName.equals("count") && !this.xpathParts.contains("currency")) continue;
                optionalAttributes.add(attribute);
                continue;
            }
            this.xpathParts.setAttribute(index, attributeName, sample.apply(attribute));
        }
        if (!optionalAttributes.isEmpty()) {
            int n = 1 << optionalAttributes.size();
            for (int bitmask = n - 1; bitmask >= 0; --bitmask) {
                for (int bit = 0; bit < optionalAttributes.size(); ++bit) {
                    DtdData.Attribute attribute = (DtdData.Attribute)optionalAttributes.get(bit);
                    String attributeName = attribute.getName();
                    if ((bitmask & 1 << bit) == 0) {
                        this.xpathParts.setAttribute(index, attributeName, sample.apply(attribute));
                    } else {
                        this.xpathParts.removeAttribute(index, attributeName);
                    }
                    if (children.isEmpty()) {
                        visitor.accept(this.xpathParts);
                        continue;
                    }
                    for (DtdData.Element child : children) {
                        this.visit(child, visitor, sample);
                    }
                }
            }
        } else if (children.isEmpty()) {
            visitor.accept(this.xpathParts);
        } else {
            for (DtdData.Element child : children) {
                this.visit(child, visitor, sample);
            }
        }
        this.xpathParts.removeElement(index);
    }

    public static void main(String[] args) {
        HashSet seen = new HashSet();
        HashSet seenPh = new HashSet();
        DtdPathIterator dtdPathIterator = new DtdPathIterator(DtdData.getInstance(DtdType.ldml));
        PathHeader.Factory phf = PathHeader.getFactory();
        ArrayList failures = new ArrayList();
        Factory factory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
        PathStarrer ps = new PathStarrer().setSubstitutionPattern("%A");
        TreeMap<String, String> starredToSample = new TreeMap<String, String>();
        for (String locale : Arrays.asList("en", "de", "zh", "ar", "ru")) {
            CLDRFile cfile = factory.make(locale, true);
            for (String path : cfile.fullIterable()) {
                String starred = ps.set(path);
                if (starredToSample.containsKey(starred = starred.replace("[@alt=\"%A\"]", "")) || starred.endsWith("/alias") || starred.startsWith("//ldml/identity/")) continue;
                starredToSample.put(starred, path);
            }
        }
        TreeSet starredUnseen = new TreeSet(starredToSample.keySet());
        dtdPathIterator.visit(x -> {
            if (seen.contains(x)) {
                boolean bl = false;
            } else {
                failures.clear();
                String xString = x.toString();
                String sample = (String)starredToSample.get(xString);
                starredUnseen.remove(xString);
                System.out.println(seen.size() + "\t" + x + "\t" + failures + "\t" + sample);
                seen.add(x.cloneAsThawed().freeze());
                if (seen.size() % 25 == 0) {
                    boolean bl = false;
                }
            }
        }, y -> "%A");
        if (!starredUnseen.isEmpty()) {
            System.out.println("ERROR: In files, not dtd");
            System.out.println(Joiner.on("\n\t").join(starredUnseen));
        }
    }
}

