/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class ICUServiceBuilder {
    public static Currency NO_CURRENCY = Currency.getInstance("XXX");
    private CLDRFile cldrFile;
    private CLDRFile collationFile;
    private static final Map<CLDRLocale, ICUServiceBuilder> ISBMap = new HashMap<CLDRLocale, ICUServiceBuilder>();
    private static final TimeZone utc = TimeZone.getTimeZone("GMT");
    private static final DateFormat iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", ULocale.ENGLISH);
    private final Map<String, SimpleDateFormat> cacheDateFormats = new HashMap<String, SimpleDateFormat>();
    private final Map<String, DateFormatSymbols> cacheDateFormatSymbols = new HashMap<String, DateFormatSymbols>();
    private final Map<String, NumberFormat> cacheNumberFormats = new HashMap<String, NumberFormat>();
    private final Map<String, DecimalFormatSymbols> cacheDecimalFormatSymbols = new HashMap<String, DecimalFormatSymbols>();
    private final Map<String, RuleBasedCollator> cacheRuleBasedCollators = new HashMap<String, RuleBasedCollator>();
    private boolean cachingIsEnabled = true;
    public static final boolean ISB_CAN_CLEAR_CACHE = true;
    private SupplementalDataInfo supplementalData;
    private static final int[] DateFormatValues;
    private static final String[] DateFormatNames;
    private static final String[] Days;
    private static String[] NumberNames;
    static int CURRENCY;
    static int OTHER_KEY;
    static int PATTERN;
    UnicodeSet beforeCurrencyMatch;
    UnicodeSet beforeSurroundingMatch;
    String beforeInsertBetween;
    UnicodeSet afterCurrencyMatch;
    UnicodeSet afterSurroundingMatch;
    String afterInsertBetween;
    static final String HM_PATH = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"hm\"]";
    static final String BHM_PATH = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"Bhm\"]";

    public static String isoDateFormat(Date date) {
        return iso.format(date);
    }

    public static String isoDateFormat(long value) {
        return iso.format(new Date(value));
    }

    public static Date isoDateParse(String date) throws ParseException {
        return iso.parse(date);
    }

    public void setCachingEnabled(boolean enabled) {
        this.cachingIsEnabled = enabled;
    }

    public void clearCache() {
        this.cacheDateFormats.clear();
        this.cacheDateFormatSymbols.clear();
        this.cacheNumberFormats.clear();
        this.cacheDecimalFormatSymbols.clear();
        this.cacheRuleBasedCollators.clear();
    }

    public CLDRFile getCldrFile() {
        return this.cldrFile;
    }

    public ICUServiceBuilder setCldrFile(CLDRFile cldrFile) {
        if (!cldrFile.isResolved()) {
            throw new IllegalArgumentException("CLDRFile must be resolved");
        }
        this.cldrFile = cldrFile;
        this.supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
        this.cacheDateFormats.clear();
        this.cacheNumberFormats.clear();
        this.cacheDateFormatSymbols.clear();
        this.cacheDecimalFormatSymbols.clear();
        this.cacheRuleBasedCollators.clear();
        return this;
    }

    public static ICUServiceBuilder forLocale(CLDRLocale locale) {
        ICUServiceBuilder result = ISBMap.get(locale);
        if (result == null) {
            result = new ICUServiceBuilder();
            if (locale != null) {
                result.cldrFile = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*").make(locale.getBaseName(), true);
                result.collationFile = Factory.make(CLDRPaths.COLLATION_DIRECTORY, ".*").makeWithFallback(locale.getBaseName());
            }
            result.supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
            result.cacheDateFormats.clear();
            result.cacheNumberFormats.clear();
            result.cacheDateFormatSymbols.clear();
            result.cacheDecimalFormatSymbols.clear();
            result.cacheRuleBasedCollators.clear();
            ISBMap.put(locale, result);
        }
        return result;
    }

    public RuleBasedCollator getRuleBasedCollator(String type) throws Exception {
        RuleBasedCollator col;
        RuleBasedCollator ruleBasedCollator = col = this.cachingIsEnabled ? this.cacheRuleBasedCollators.get(type) : null;
        if (col == null) {
            col = this._getRuleBasedCollator(type);
            if (this.cachingIsEnabled) {
                this.cacheRuleBasedCollators.put(type, col);
            }
        }
        return (RuleBasedCollator)col.clone();
    }

    private RuleBasedCollator _getRuleBasedCollator(String type) throws Exception {
        String collationType;
        Object path;
        String rules = "";
        if ("default".equals(type)) {
            path = "//ldml/collations/defaultCollation";
            collationType = this.collationFile.getWinningValueWithBailey((String)path);
        } else {
            collationType = type;
        }
        path = "";
        String importPath = "//ldml/collations/collation[@visibility=\"external\"][@type=\"" + collationType + "\"]/import[@type=\"standard\"]";
        if (this.collationFile.isHere(importPath)) {
            String fullPath = this.collationFile.getFullXPath(importPath);
            XPathParts xpp = XPathParts.getFrozenInstance(fullPath);
            String importSource = xpp.getAttributeValue(-1, "source");
            String importType = xpp.getAttributeValue(-1, "type");
            CLDRLocale importLocale = CLDRLocale.getInstance(importSource);
            CLDRFile importCollationFile = Factory.make(CLDRPaths.COLLATION_DIRECTORY, ".*").makeWithFallback(importLocale.getBaseName());
            path = "//ldml/collations/collation[@type=\"" + importType + "\"]/cr";
            rules = importCollationFile.getStringValue((String)path);
        } else {
            path = "//ldml/collations/collation[@type=\"" + collationType + "\"]/cr";
            rules = this.collationFile.getStringValue((String)path);
        }
        RuleBasedCollator col = rules != null && rules.length() > 0 ? new RuleBasedCollator(rules) : (RuleBasedCollator)RuleBasedCollator.getInstance();
        return col;
    }

    public RuleBasedCollator getRuleBasedCollator() throws Exception {
        return this.getRuleBasedCollator("default");
    }

    public SimpleDateFormat getDateFormat(String calendar, int dateIndex, int timeIndex) {
        return this.getDateFormat(calendar, dateIndex, timeIndex, null);
    }

    public SimpleDateFormat getDateFormat(String calendar, int dateIndex, int timeIndex, String numbersOverride) {
        SimpleDateFormat result;
        String key = this.cldrFile.getLocaleID() + "," + calendar + "," + dateIndex + "," + timeIndex;
        SimpleDateFormat simpleDateFormat = result = this.cachingIsEnabled ? this.cacheDateFormats.get(key) : null;
        if (result != null) {
            return (SimpleDateFormat)result.clone();
        }
        String pattern = this.getPattern(calendar, dateIndex, timeIndex);
        result = this.getFullFormat(calendar, pattern, numbersOverride);
        if (this.cachingIsEnabled) {
            this.cacheDateFormats.put(key, result);
        }
        return (SimpleDateFormat)result.clone();
    }

    public SimpleDateFormat getDateFormat(String calendar, String pattern, String numbersOverride) {
        SimpleDateFormat result;
        String key = this.cldrFile.getLocaleID() + "," + calendar + ",," + pattern + ",,," + numbersOverride;
        SimpleDateFormat simpleDateFormat = result = this.cachingIsEnabled ? this.cacheDateFormats.get(key) : null;
        if (result != null) {
            return (SimpleDateFormat)result.clone();
        }
        result = this.getFullFormat(calendar, pattern, numbersOverride);
        if (this.cachingIsEnabled) {
            this.cacheDateFormats.put(key, result);
        }
        return (SimpleDateFormat)result.clone();
    }

    public SimpleDateFormat getDateFormat(String calendar, String pattern) {
        return this.getDateFormat(calendar, pattern, null);
    }

    private SimpleDateFormat getFullFormat(String calendar, String pattern, String numbersOverride) {
        ULocale curLocaleWithCalendar = new ULocale(this.cldrFile.getLocaleID() + "@calendar=" + calendar);
        SimpleDateFormat result = new SimpleDateFormat(pattern, numbersOverride, curLocaleWithCalendar);
        Calendar cal = Calendar.getInstance(curLocaleWithCalendar);
        cal.setTimeZone(utc);
        result.setCalendar(cal);
        result.setDateFormatSymbols((DateFormatSymbols)this._getDateFormatSymbols(calendar).clone());
        NumberFormat numberFormat = result.getNumberFormat();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)numberFormat;
            df.setGroupingUsed(false);
            df.setDecimalSeparatorAlwaysShown(false);
            df.setParseIntegerOnly(true);
            df.setMinimumFractionDigits(0);
        }
        result.setNumberFormat((NumberFormat)numberFormat.clone());
        if (numbersOverride != null && numbersOverride.contains("=")) {
            String[] overrides;
            for (String override : overrides = numbersOverride.split(",")) {
                String[] fields = override.split("=", 2);
                if (fields.length != 2) continue;
                String overrideField = fields[0].substring(0, 1);
                ULocale curLocaleWithNumbers = new ULocale(this.cldrFile.getLocaleID() + "@numbers=" + fields[1]);
                NumberFormat onf = NumberFormat.getInstance(curLocaleWithNumbers, 0);
                if (onf instanceof DecimalFormat) {
                    DecimalFormat df = (DecimalFormat)onf;
                    df.setGroupingUsed(false);
                    df.setDecimalSeparatorAlwaysShown(false);
                    df.setParseIntegerOnly(true);
                    df.setMinimumFractionDigits(0);
                }
                result.setNumberFormat(overrideField, onf);
            }
        }
        return result;
    }

    private DateFormatSymbols _getDateFormatSymbols(String calendar) {
        DateFormatSymbols result;
        String key = this.cldrFile.getLocaleID() + "," + calendar;
        DateFormatSymbols dateFormatSymbols = result = this.cachingIsEnabled ? this.cacheDateFormatSymbols.get(key) : null;
        if (result != null) {
            return (DateFormatSymbols)result.clone();
        }
        ULocale curLocaleWithCalendar = new ULocale(this.cldrFile.getLocaleID() + "@calendar=" + calendar);
        DateFormatSymbols formatData = new DateFormatSymbols(curLocaleWithCalendar);
        String prefix = "//ldml/dates/calendars/calendar[@type=\"" + calendar + "\"]/";
        String[] last = this.getArrayOfWinningValues(new String[]{this.getDayPeriods(prefix, "format", "wide", "am"), this.getDayPeriods(prefix, "format", "wide", "pm")});
        formatData.setAmPmStrings(last);
        this.checkFound(last);
        int minEras = calendar.equals("chinese") || calendar.equals("dangi") ? 0 : 1;
        List<String> temp = this.getArray(prefix + "eras/eraAbbr/era[@type=\"", 0, null, "\"]", minEras);
        last = temp.toArray(new String[temp.size()]);
        formatData.setEras(last);
        if (minEras != 0) {
            this.checkFound(last);
        }
        temp = this.getArray(prefix + "eras/eraNames/era[@type=\"", 0, null, "\"]", minEras);
        last = temp.toArray(new String[temp.size()]);
        formatData.setEraNames(last);
        if (minEras != 0) {
            this.checkFound(last);
        }
        formatData.setMonths(this.getArray(prefix, "month", "format", "wide"), 0, 1);
        formatData.setMonths(this.getArray(prefix, "month", "format", "abbreviated"), 0, 0);
        formatData.setMonths(this.getArray(prefix, "month", "format", "narrow"), 0, 2);
        formatData.setMonths(this.getArray(prefix, "month", "stand-alone", "wide"), 1, 1);
        formatData.setMonths(this.getArray(prefix, "month", "stand-alone", "abbreviated"), 1, 0);
        formatData.setMonths(this.getArray(prefix, "month", "stand-alone", "narrow"), 1, 2);
        formatData.setWeekdays(this.getArray(prefix, "day", "format", "wide"), 0, 1);
        formatData.setWeekdays(this.getArray(prefix, "day", "format", "abbreviated"), 0, 0);
        formatData.setWeekdays(this.getArray(prefix, "day", "format", "narrow"), 0, 2);
        formatData.setWeekdays(this.getArray(prefix, "day", "stand-alone", "wide"), 1, 1);
        formatData.setWeekdays(this.getArray(prefix, "day", "stand-alone", "abbreviated"), 1, 0);
        formatData.setWeekdays(this.getArray(prefix, "day", "stand-alone", "narrow"), 1, 2);
        formatData.setQuarters(this.getArray(prefix, "quarter", "format", "wide"), 0, 1);
        formatData.setQuarters(this.getArray(prefix, "quarter", "format", "abbreviated"), 0, 0);
        formatData.setQuarters(this.getArray(prefix, "quarter", "format", "narrow"), 0, 2);
        formatData.setQuarters(this.getArray(prefix, "quarter", "stand-alone", "wide"), 1, 1);
        formatData.setQuarters(this.getArray(prefix, "quarter", "stand-alone", "abbreviated"), 1, 0);
        formatData.setQuarters(this.getArray(prefix, "quarter", "stand-alone", "narrow"), 1, 2);
        if (this.cachingIsEnabled) {
            this.cacheDateFormatSymbols.put(key, formatData);
        }
        return (DateFormatSymbols)formatData.clone();
    }

    private String getDayPeriods(String prefix, String context, String width, String type) {
        return prefix + "dayPeriods/dayPeriodContext[@type=\"" + context + "\"]/dayPeriodWidth[@type=\"" + width + "\"]/dayPeriod[@type=\"" + type + "\"]";
    }

    private String[] getArrayOfWinningValues(String[] xpaths) {
        String[] result = new String[xpaths.length];
        for (int i = 0; i < xpaths.length; ++i) {
            result[i] = this.cldrFile.getWinningValueWithBailey(xpaths[i]);
        }
        this.checkFound(result, xpaths);
        return result;
    }

    private void checkFound(String[] last) {
        if (last == null || last.length == 0 || last[0] == null) {
            throw new IllegalArgumentException("Failed to load array");
        }
    }

    private void checkFound(String[] last, String[] xpaths) {
        if (last == null || last.length == 0 || last[0] == null) {
            throw new IllegalArgumentException("Failed to load array {" + xpaths[0] + ",...}");
        }
    }

    private String getPattern(String calendar, int dateIndex, int timeIndex) {
        String pattern;
        if (DateFormatValues[timeIndex] == -1) {
            pattern = this.getDateTimePattern(calendar, "date", DateFormatNames[dateIndex]);
        } else if (DateFormatValues[dateIndex] == -1) {
            pattern = this.getDateTimePattern(calendar, "time", DateFormatNames[timeIndex]);
        } else {
            String p0 = this.getDateTimePattern(calendar, "time", DateFormatNames[timeIndex]);
            String p1 = this.getDateTimePattern(calendar, "date", DateFormatNames[dateIndex]);
            String datetimePat = this.getDateTimePattern(calendar, "dateTime", DateFormatNames[dateIndex]);
            pattern = MessageFormat.format(datetimePat, p0, p1);
        }
        return pattern;
    }

    private String getDateTimePattern(String calendar, String dateOrTime, String type) {
        String key = "//ldml/dates/calendars/calendar[@type=\"" + calendar + "\"]/" + dateOrTime + "Formats/" + dateOrTime + "FormatLength" + (String)(type = "[@type=\"" + (String)type + "\"]") + "/" + dateOrTime + "Format[@type=\"standard\"]/pattern[@type=\"standard\"]";
        String value = this.cldrFile.getWinningValueWithBailey(key);
        if (value == null) {
            throw new IllegalArgumentException("locale: " + this.cldrFile.getLocaleID() + "\tpath: " + key + "\nvalue: " + value);
        }
        return value;
    }

    private String[] getArray(String key, String type, String context, String width) {
        String prefix = key + type + "s/" + type + "Context[@type=\"" + context + "\"]/" + type + "Width[@type=\"" + width + "\"]/" + type + "[@type=\"";
        String postfix = "\"]";
        boolean isDay = type.equals("day");
        int arrayCount = isDay ? 7 : (type.equals("month") ? 12 : 4);
        List<String> temp = this.getArray(prefix, isDay ? 0 : 1, (String[])(isDay ? Days : null), postfix, arrayCount);
        if (isDay) {
            temp.add(0, "");
        }
        String[] result = temp.toArray(new String[temp.size()]);
        this.checkFound(result);
        return result;
    }

    private List<String> getArray(String prefix, int firstIndex, String[] itemNames, String postfix, int minimumSize) {
        String lastType;
        String item;
        ArrayList<String> result = new ArrayList<String>();
        int i = firstIndex;
        while ((item = this.cldrFile.getWinningValueWithBailey(prefix + (lastType = itemNames != null && i < itemNames.length ? itemNames[i] : String.valueOf(i)) + postfix)) != null) {
            result.add(item);
            ++i;
        }
        if (result.size() < minimumSize) {
            throw new RuntimeException("Internal Error: ICUServiceBuilder.getArray():" + this.cldrFile.getLocaleID() + " " + prefix + lastType + postfix + " - result.size=" + result.size() + ", less than acceptable minimum " + minimumSize);
        }
        return result;
    }

    public DecimalFormat getCurrencyFormat(String currency) {
        return this._getNumberFormat(currency, CURRENCY, null, null);
    }

    public DecimalFormat getCurrencyFormat(String currency, String currencySymbol) {
        return this._getNumberFormat(currency, CURRENCY, currencySymbol, null);
    }

    public DecimalFormat getCurrencyFormat(String currency, String currencySymbol, String numberSystem) {
        return this._getNumberFormat(currency, CURRENCY, currencySymbol, numberSystem);
    }

    public DecimalFormat getNumberFormat(int index) {
        return this._getNumberFormat(NumberNames[index], OTHER_KEY, null, null);
    }

    public DecimalFormat getNumberFormat(int index, String numberSystem) {
        return this._getNumberFormat(NumberNames[index], OTHER_KEY, null, numberSystem);
    }

    public NumberFormat getGenericNumberFormat(String ns) {
        NumberFormat result;
        NumberFormat numberFormat = result = this.cachingIsEnabled ? this.cacheNumberFormats.get(this.cldrFile.getLocaleID() + "@numbers=" + ns) : null;
        if (result == null) {
            ULocale ulocale = new ULocale(this.cldrFile.getLocaleID() + "@numbers=" + ns);
            result = NumberFormat.getInstance(ulocale);
            if (this.cachingIsEnabled) {
                this.cacheNumberFormats.put(this.cldrFile.getLocaleID() + "@numbers=" + ns, result);
            }
        }
        return (NumberFormat)result.clone();
    }

    public DecimalFormat getNumberFormat(String pattern) {
        return this._getNumberFormat(pattern, PATTERN, null, null);
    }

    public DecimalFormat getNumberFormat(String pattern, String numberSystem) {
        return this._getNumberFormat(pattern, PATTERN, null, numberSystem);
    }

    private DecimalFormat _getNumberFormat(String key1, int kind, String currencySymbol, String numberSystem) {
        DecimalFormat result;
        String localeIDString = numberSystem == null ? this.cldrFile.getLocaleID() : this.cldrFile.getLocaleID() + "@numbers=" + numberSystem;
        ULocale ulocale = new ULocale(localeIDString);
        String key = currencySymbol == null ? ulocale + "/" + key1 + "/" + kind : ulocale + "/" + key1 + "/" + kind + "/" + currencySymbol;
        DecimalFormat decimalFormat = result = this.cachingIsEnabled ? (DecimalFormat)this.cacheNumberFormats.get(key) : null;
        if (result != null) {
            return (DecimalFormat)result.clone();
        }
        String pattern = kind == PATTERN ? key1 : this.getPattern(key1, kind);
        DecimalFormatSymbols symbols = this._getDecimalFormatSymbols(numberSystem);
        MyCurrency mc = null;
        if (kind == CURRENCY) {
            String currencyGrouping;
            String currencyPattern;
            String prefix = "//ldml/numbers/currencies/currency[@type=\"" + key1 + "\"]/";
            if (currencySymbol == null) {
                currencySymbol = this.cldrFile.getWinningValueWithBailey(prefix + "symbol");
            }
            if (currencySymbol == null) {
                throw new NullPointerException(this.cldrFile.getSourceLocation(prefix + "symbol") + ": " + this.cldrFile.getLocaleID() + ": : null currencySymbol for " + prefix + "symbol");
            }
            String currencyDecimal = this.cldrFile.getWinningValueWithBailey(prefix + "decimal");
            if (currencyDecimal != null) {
                symbols = this.cloneIfNeeded(symbols);
                symbols.setMonetaryDecimalSeparator(currencyDecimal.charAt(0));
            }
            if ((currencyPattern = this.cldrFile.getWinningValueWithBailey(prefix + "pattern")) != null) {
                pattern = currencyPattern;
            }
            if ((currencyGrouping = this.cldrFile.getWinningValueWithBailey(prefix + "grouping")) != null) {
                symbols = this.cloneIfNeeded(symbols);
                symbols.setMonetaryGroupingSeparator(currencyGrouping.charAt(0));
            }
            if (pattern.contains(";")) {
                Object[] pieces = pattern.split(";");
                for (int i = 0; i < pieces.length; ++i) {
                    pieces[i] = this.fixCurrencySpacing((String)pieces[i], currencySymbol);
                }
                pattern = CldrUtility.join(pieces, ";");
            } else {
                pattern = this.fixCurrencySpacing(pattern, currencySymbol);
            }
            SupplementalDataInfo.CurrencyNumberInfo info = this.supplementalData.getCurrencyNumberInfo(key1);
            mc = new MyCurrency(key1, currencySymbol, this.cldrFile.getWinningValueWithBailey(prefix + "displayName"), info);
        }
        result = new DecimalFormat(pattern, symbols);
        if (mc != null) {
            result.setCurrency(mc);
            result.setMaximumFractionDigits(mc.getDefaultFractionDigits());
            result.setMinimumFractionDigits(mc.getDefaultFractionDigits());
        } else {
            result.setCurrency(NO_CURRENCY);
        }
        if (kind == OTHER_KEY && key1.equals("integer")) {
            result.setMaximumFractionDigits(0);
            result.setDecimalSeparatorAlwaysShown(false);
            result.setParseIntegerOnly(true);
        }
        if (this.cachingIsEnabled) {
            this.cacheNumberFormats.put(key, result);
        }
        return (DecimalFormat)result.clone();
    }

    private String fixCurrencySpacing(String pattern, String symbol) {
        int endPos;
        int startPos = ((String)pattern).indexOf(164);
        if (startPos > 0 && this.beforeCurrencyMatch.contains(UTF16.charAt(symbol, 0))) {
            int ch = UTF16.charAt((String)pattern, startPos - 1);
            if (ch == 35) {
                ch = 48;
            }
            if (this.beforeSurroundingMatch.contains(ch)) {
                pattern = ((String)pattern).substring(0, startPos) + this.beforeInsertBetween + ((String)pattern).substring(startPos);
            }
        }
        if ((endPos = ((String)pattern).lastIndexOf(164) + 1) < ((String)pattern).length() && this.afterCurrencyMatch.contains(UTF16.charAt(symbol, symbol.length() - 1))) {
            int ch = UTF16.charAt((String)pattern, endPos);
            if (ch == 35) {
                ch = 48;
            }
            if (this.afterSurroundingMatch.contains(ch)) {
                pattern = ((String)pattern).substring(0, endPos) + this.afterInsertBetween + ((String)pattern).substring(endPos);
            }
        }
        return pattern;
    }

    private DecimalFormatSymbols cloneIfNeeded(DecimalFormatSymbols symbols) {
        if (symbols == this._getDecimalFormatSymbols(null)) {
            return (DecimalFormatSymbols)symbols.clone();
        }
        return symbols;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols(String numberSystem) {
        return (DecimalFormatSymbols)this._getDecimalFormatSymbols(numberSystem).clone();
    }

    private DecimalFormatSymbols _getDecimalFormatSymbols(String numberSystem) {
        DecimalFormatSymbols symbols;
        String key = numberSystem == null ? this.cldrFile.getLocaleID() : this.cldrFile.getLocaleID() + "@numbers=" + numberSystem;
        DecimalFormatSymbols decimalFormatSymbols = symbols = this.cachingIsEnabled ? this.cacheDecimalFormatSymbols.get(key) : null;
        if (symbols != null) {
            return (DecimalFormatSymbols)symbols.clone();
        }
        symbols = new DecimalFormatSymbols();
        if (numberSystem == null) {
            numberSystem = this.cldrFile.getWinningValueWithBailey("//ldml/numbers/defaultNumberingSystem");
        }
        symbols.setDecimalSeparator(this.getSymbolCharacter("decimal", numberSystem));
        symbols.setExponentSeparator(this.getSymbolString("exponential", numberSystem));
        symbols.setGroupingSeparator(this.getSymbolCharacter("group", numberSystem));
        symbols.setInfinity(this.getSymbolString("infinity", numberSystem));
        symbols.setMinusSignString(this.getSymbolString("minusSign", numberSystem));
        symbols.setNaN(this.getSymbolString("nan", numberSystem));
        symbols.setPatternSeparator(this.getSymbolCharacter("list", numberSystem));
        symbols.setPercentString(this.getSymbolString("percentSign", numberSystem));
        symbols.setPerMill(this.getSymbolCharacter("perMille", numberSystem));
        symbols.setPlusSignString(this.getSymbolString("plusSign", numberSystem));
        String digits = this.supplementalData.getDigits(numberSystem);
        if (digits != null && digits.length() == 10) {
            symbols.setZeroDigit(digits.charAt(0));
        }
        try {
            symbols.setMonetaryDecimalSeparator(this.getSymbolCharacter("currencyDecimal", numberSystem));
        }
        catch (IllegalArgumentException e) {
            symbols.setMonetaryDecimalSeparator(symbols.getDecimalSeparator());
        }
        try {
            symbols.setMonetaryGroupingSeparator(this.getSymbolCharacter("currencyGroup", numberSystem));
        }
        catch (IllegalArgumentException e) {
            symbols.setMonetaryGroupingSeparator(symbols.getGroupingSeparator());
        }
        String prefix = "//ldml/numbers/currencyFormats/currencySpacing/beforeCurrency/";
        this.beforeCurrencyMatch = new UnicodeSet(this.cldrFile.getWinningValueWithBailey(prefix + "currencyMatch")).freeze();
        this.beforeSurroundingMatch = new UnicodeSet(this.cldrFile.getWinningValueWithBailey(prefix + "surroundingMatch")).freeze();
        this.beforeInsertBetween = this.cldrFile.getWinningValueWithBailey(prefix + "insertBetween");
        prefix = "//ldml/numbers/currencyFormats/currencySpacing/afterCurrency/";
        this.afterCurrencyMatch = new UnicodeSet(this.cldrFile.getWinningValueWithBailey(prefix + "currencyMatch")).freeze();
        this.afterSurroundingMatch = new UnicodeSet(this.cldrFile.getWinningValueWithBailey(prefix + "surroundingMatch")).freeze();
        this.afterInsertBetween = this.cldrFile.getWinningValueWithBailey(prefix + "insertBetween");
        if (this.cachingIsEnabled) {
            this.cacheDecimalFormatSymbols.put(key, symbols);
        }
        return (DecimalFormatSymbols)symbols.clone();
    }

    private char getSymbolCharacter(String key, String numsys) {
        return this.getSymbolString(key, numsys).charAt(0);
    }

    private String getSymbolString(String key, String numsys) {
        String value = null;
        try {
            value = this.cldrFile.getWinningValueWithBailey("//ldml/numbers/symbols[@numberSystem=\"" + numsys + "\"]/" + key);
            if (value == null || value.length() < 1) {
                throw new RuntimeException();
            }
            return value;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Illegal value <" + value + "> at //ldml/numbers/symbols[@numberSystem='" + numsys + "']/" + key);
        }
    }

    private String getPattern(String key1, int isCurrency) {
        String prefix = "//ldml/numbers/";
        String type = key1;
        if (isCurrency == CURRENCY) {
            type = "currency";
        } else if (key1.equals("integer")) {
            type = "decimal";
        }
        String path = prefix + type + "Formats/" + type + "FormatLength/" + type + "Format[@type=\"standard\"]/pattern[@type=\"standard\"]";
        String pattern = this.cldrFile.getWinningValueWithBailey(path);
        if (pattern == null) {
            throw new IllegalArgumentException("locale: " + this.cldrFile.getLocaleID() + "\tpath: " + path);
        }
        return pattern;
    }

    public String formatDayPeriod(int timeInDay, Context context, Width width) {
        DayPeriodInfo dayPeriodInfo = this.supplementalData.getDayPeriods(DayPeriodInfo.Type.format, this.cldrFile.getLocaleID());
        DayPeriodInfo.DayPeriod period = dayPeriodInfo.getDayPeriod(timeInDay);
        String dayPeriodFormatString = this.getDayPeriodValue(ICUServiceBuilder.getDayPeriodPath(period, context, width), "\ufffd", null);
        String result = this.formatDayPeriod(timeInDay, period, dayPeriodFormatString);
        return result;
    }

    public String getDayPeriodValue(String path, String fallback, Output<Boolean> real) {
        String dayPeriodFormatString = this.cldrFile.getStringValue(path);
        if (dayPeriodFormatString == null) {
            dayPeriodFormatString = fallback;
        }
        if (real != null) {
            CLDRFile.Status status = new CLDRFile.Status();
            String locale = this.cldrFile.getSourceLocaleID(path, status);
            real.value = status.pathWhereFound.equals(path) && this.cldrFile.getLocaleID().equals(locale);
        }
        return dayPeriodFormatString;
    }

    public static String getDayPeriodPath(DayPeriodInfo.DayPeriod period, Context context, Width width) {
        String path = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"" + context + "\"]/dayPeriodWidth[@type=\"" + width + "\"]/dayPeriod[@type=\"" + period + "\"]";
        return path;
    }

    public String formatDayPeriod(int timeInDay, String dayPeriodFormatString) {
        return this.formatDayPeriod(timeInDay, null, dayPeriodFormatString);
    }

    private String formatDayPeriod(int timeInDay, DayPeriodInfo.DayPeriod period, String dayPeriodFormatString) {
        String pattern = null;
        if (timeInDay % 6 != 0 && (pattern = this.cldrFile.getStringValue(BHM_PATH)) != null) {
            pattern = pattern.replace('B', '\ue000');
        }
        if (pattern == null && (pattern = this.cldrFile.getStringValue(HM_PATH)) != null) {
            pattern = pattern.replace('a', '\ue000');
            boolean fixSpace = true;
            if (period != null) {
                if (period == DayPeriodInfo.DayPeriod.am || period == DayPeriodInfo.DayPeriod.pm) {
                    fixSpace = false;
                }
            } else if (dayPeriodFormatString.equalsIgnoreCase("am") || dayPeriodFormatString.equalsIgnoreCase("pm")) {
                fixSpace = false;
            }
            if (fixSpace) {
                pattern = pattern.replace('\u202f', ' ');
            }
        }
        if (pattern == null) {
            pattern = "h:mm \ue000";
        }
        SimpleDateFormat df = this.getDateFormat("gregorian", pattern);
        String formatted = df.format(timeInDay);
        String result = formatted.replace("\ue000", dayPeriodFormatString);
        return result;
    }

    static {
        iso.setTimeZone(utc);
        DateFormatValues = new int[]{-1, 3, 2, 1, 0};
        DateFormatNames = new String[]{"none", "short", "medium", "long", "full"};
        Days = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        NumberNames = new String[]{"integer", "decimal", "percent", "scientific"};
        CURRENCY = 0;
        OTHER_KEY = 1;
        PATTERN = 2;
    }

    public static enum Context {
        format,
        stand_alone;


        public String toString() {
            return this.name().replace('_', '-');
        }
    }

    public static enum Width {
        wide,
        abbreviated,
        narrow;

    }

    private static class MyCurrency
    extends Currency {
        String symbol;
        String displayName;
        int fractDigits;
        double roundingIncrement;

        MyCurrency(String code, String symbol, String displayName, SupplementalDataInfo.CurrencyNumberInfo currencyNumberInfo) {
            super(code);
            this.symbol = symbol == null ? code : symbol;
            this.displayName = displayName == null ? code : displayName;
            this.fractDigits = currencyNumberInfo.getDigits();
            this.roundingIncrement = currencyNumberInfo.getRoundingIncrement();
        }

        @Override
        public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
            int i;
            String result;
            String string = nameStyle == 0 ? this.symbol : (nameStyle == 1 ? this.getCurrencyCode() : (result = nameStyle == 2 ? this.displayName : null));
            if (result == null) {
                throw new IllegalArgumentException();
            }
            if (isChoiceFormat != null) {
                isChoiceFormat[0] = false;
            }
            for (i = 0; i < result.length() && result.charAt(i) == '=' && i < 2; ++i) {
            }
            if (isChoiceFormat != null) {
                boolean bl = isChoiceFormat[0] = i == 1;
            }
            if (i != 0) {
                result = result.substring(1);
            }
            return result;
        }

        @Override
        public double getRoundingIncrement() {
            return this.roundingIncrement;
        }

        @Override
        public int getDefaultFractionDigits() {
            return this.fractDigits;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof MyCurrency)) {
                return false;
            }
            MyCurrency that = (MyCurrency)other;
            return this.roundingIncrement == that.roundingIncrement && this.fractDigits == that.fractDigits && this.symbol.equals(that.symbol) && this.displayName.equals(that.displayName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.roundingIncrement, this.fractDigits, this.symbol, this.displayName);
        }
    }
}

