/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Utility;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.StackTracker;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class IsoCurrencyParser {
    private static final String ISO_CURRENT_CODES_XML = "dl_iso_table_a1.xml";
    private static final String CLDR_EXTENSIONS_XML = "dl_cldr_extensions.xml";
    private static final ImmutableMap<String, String> COUNTRY_CORRECTIONS = new ImmutableMap.Builder<String, String>().put("UNITED ARAB EMIRATES (THE)", "AE").put(Utility.unescape("\u00c5LAND ISLANDS"), "AX").put("SAINT BARTH\u00c9LEMY", "BL").put("BOLIVIA (PLURINATIONAL STATE OF)", "BO").put("BAHAMAS (THE)", "BS").put("COCOS (KEELING) ISLANDS (THE)", "CC").put("CONGO (THE DEMOCRATIC REPUBLIC OF THE)", "CD").put("CENTRAL AFRICAN REPUBLIC (THE)", "CF").put("CONGO (THE)", "CG").put(Utility.unescape("C\u00d4TE D\u2019IVOIRE"), "CI").put("COOK ISLANDS (THE)", "CK").put("CABO VERDE", "CV").put(Utility.unescape("CURA\u00c7AO"), "CW").put("CZECHIA", "CZ").put("DOMINICAN REPUBLIC (THE)", "DO").put("FALKLAND ISLANDS (THE) [MALVINAS]", "FK").put("MICRONESIA (FEDERATED STATES OF)", "FM").put("FAROE ISLANDS (THE)", "FO").put("UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND (THE)", "GB").put("GAMBIA (THE)", "GM").put("HEARD ISLAND AND McDONALD ISLANDS", "HM").put("BRITISH INDIAN OCEAN TERRITORY (THE)", "IO").put("IRAN (ISLAMIC REPUBLIC OF)", "IR").put("COMOROS (THE)", "KM").put(Utility.unescape("KOREA (THE DEMOCRATIC PEOPLE\u2019S REPUBLIC OF)"), "KP").put("KOREA (THE REPUBLIC OF)", "KR").put("CAYMAN ISLANDS (THE)", "KY").put(Utility.unescape("LAO PEOPLE\u2019S DEMOCRATIC REPUBLIC (THE)"), "LA").put("MOLDOVA (THE REPUBLIC OF)", "MD").put("SAINT MARTIN", "MF").put("MARSHALL ISLANDS (THE)", "MH").put("MACEDONIA (THE FORMER YUGOSLAV REPUBLIC OF)", "MK").put("NORTHERN MARIANA ISLANDS (THE)", "MP").put("NETHERLANDS (THE)", "NL").put("NIGER (THE)", "NE").put("PHILIPPINES (THE)", "PH").put("PALESTINE, STATE OF", "PS").put(Utility.unescape("R\u00c9UNION"), "RE").put("RUSSIAN FEDERATION (THE)", "RU").put("SUDAN (THE)", "SD").put("ESWATINI", "SZ").put("TURKS AND CAICOS ISLANDS (THE)", "TC").put("FRENCH SOUTHERN TERRITORIES (THE)", "TF").put("TAIWAN (PROVINCE OF CHINA)", "TW").put("TANZANIA, UNITED REPUBLIC OF", "TZ").put("UNITED STATES MINOR OUTLYING ISLANDS (THE)", "UM").put("UNITED STATES OF AMERICA (THE)", "US").put("HOLY SEE (THE)", "VA").put("VENEZUELA (BOLIVARIAN REPUBLIC OF)", "VE").put("VIRGIN ISLANDS (BRITISH)", "VG").put("VIRGIN ISLANDS (U.S.)", "VI").put(Utility.unescape("INTERNATIONAL MONETARY FUND (IMF)\u00a0"), "ZZ").put("MEMBER COUNTRIES OF THE AFRICAN DEVELOPMENT BANK GROUP", "ZZ").put("SISTEMA UNITARIO DE COMPENSACION REGIONAL DE PAGOS \"SUCRE\"", "ZZ").put("EUROPEAN MONETARY CO-OPERATION FUND (EMCF)", "ZZ").put("T\u00dcRK\u0130YE", "TR").build();
    static Map<String, String> iso4217CountryToCountryCode = new TreeMap<String, String>();
    static Set<String> exceptionList = new LinkedHashSet<String>();
    private Relation<String, Data> codeList = Relation.of(new TreeMap(), TreeSet.class, null);
    private Relation<String, String> countryToCodes = Relation.of(new TreeMap(), TreeSet.class, null);
    private static IsoCurrencyParser INSTANCE_WITHOUT_EXTENSIONS;
    private static IsoCurrencyParser INSTANCE_WITH_EXTENSIONS;

    public static IsoCurrencyParser getInstance(boolean useCLDRExtensions) {
        return useCLDRExtensions ? INSTANCE_WITH_EXTENSIONS : INSTANCE_WITHOUT_EXTENSIONS;
    }

    public static IsoCurrencyParser getInstance() {
        return IsoCurrencyParser.getInstance(true);
    }

    public Relation<String, Data> getCodeList() {
        return this.codeList;
    }

    private IsoCurrencyParser(boolean useCLDRExtensions) {
        ISOCurrencyHandler isoCurrentHandler = new ISOCurrencyHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(isoCurrentHandler);
        xfr.readCLDRResource(ISO_CURRENT_CODES_XML, -1, false);
        if (useCLDRExtensions) {
            xfr.readCLDRResource(CLDR_EXTENSIONS_XML, -1, false);
        }
        if (exceptionList.size() != 0) {
            throw new IllegalArgumentException(exceptionList.toString());
        }
        this.codeList.freeze();
        this.countryToCodes.freeze();
    }

    public Relation<String, String> getCountryToCodes() {
        return this.countryToCodes;
    }

    public static String getCountryCode(String iso4217Country) {
        String name;
        if ((iso4217Country = iso4217Country.trim()).startsWith("\"")) {
            iso4217Country = iso4217Country.substring(1, iso4217Country.length() - 1);
        }
        if ((name = iso4217CountryToCountryCode.get(iso4217Country)) != null) {
            return name;
        }
        if (iso4217Country.startsWith("ZZ")) {
            return "ZZ";
        }
        exceptionList.add(String.format("\n\t\t.put(\"%s\", \"XXX\") // fix XXX and add to COUNTRY_CORRECTIONS in " + StackTracker.currentElement(0).getFileName(), iso4217Country));
        return "ZZ";
    }

    static {
        StandardCodes sc = StandardCodes.make();
        Set<String> countries = sc.getAvailableCodes("territory");
        for (String country : countries) {
            String name = sc.getData("territory", country);
            iso4217CountryToCountryCode.put(name.toUpperCase(Locale.ENGLISH), country);
        }
        iso4217CountryToCountryCode.putAll(COUNTRY_CORRECTIONS);
        INSTANCE_WITHOUT_EXTENSIONS = new IsoCurrencyParser(false);
        INSTANCE_WITH_EXTENSIONS = new IsoCurrencyParser(true);
    }

    public class ISOCurrencyHandler
    extends XMLFileReader.SimpleHandler {
        Set<String> KNOWN_BAD_ISO_DATA_CODES = new TreeSet<String>(Arrays.asList("SVC"));
        String country_code;
        String currency_name;
        String alphabetic_code;
        int numeric_code;
        int minor_unit;

        public void cleanup() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            try {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String type = parts.getElement(-1);
                if (type.equals("CtryNm")) {
                    value = value.replaceAll("\n", "");
                    this.country_code = IsoCurrencyParser.getCountryCode(value);
                    if (this.country_code == null) {
                        this.country_code = "ZZ";
                    }
                    this.alphabetic_code = "XXX";
                    this.numeric_code = -1;
                    this.minor_unit = 0;
                } else if (type.equals("CcyNm")) {
                    this.currency_name = value;
                } else if (type.equals("Ccy")) {
                    this.alphabetic_code = value;
                } else if (type.equals("CcyNbr")) {
                    try {
                        this.numeric_code = Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        this.numeric_code = -1;
                    }
                } else if (type.equals("CcyMnrUnts")) {
                    try {
                        this.minor_unit = Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        this.minor_unit = 2;
                    }
                }
                if (type.equals("CcyMnrUnts") && this.alphabetic_code.length() > 0 && !this.KNOWN_BAD_ISO_DATA_CODES.contains(this.alphabetic_code)) {
                    Data data = new Data(this.country_code, this.currency_name, this.numeric_code, this.minor_unit);
                    IsoCurrencyParser.this.codeList.put(this.alphabetic_code, data);
                    IsoCurrencyParser.this.countryToCodes.put(data.getCountryCode(), this.alphabetic_code);
                }
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("path: " + path + ",\tvalue: " + value).initCause(e);
            }
        }
    }

    public static class Data
    implements Comparable<Object> {
        private String name;
        private String countryCode;
        private int numericCode;
        private int minor_unit;

        public Data(String countryCode, String name, int numericCode, int minor_unit) {
            this.countryCode = countryCode;
            this.name = name;
            this.numericCode = numericCode;
            this.minor_unit = minor_unit;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getName() {
            return this.name;
        }

        public int getNumericCode() {
            return this.numericCode;
        }

        public int getMinorUnit() {
            return this.minor_unit;
        }

        public String toString() {
            return String.format("[%s,\t%s [%s],\t%d]", this.name, this.countryCode, StandardCodes.make().getData("territory", this.countryCode), this.numericCode);
        }

        @Override
        public int compareTo(Object o) {
            Data other = (Data)o;
            int result = this.countryCode.compareTo(other.countryCode);
            if (0 != result) {
                return result;
            }
            result = this.name.compareTo(other.name);
            if (0 != result) {
                return result;
            }
            return this.numericCode - other.numericCode;
        }
    }
}

