/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LanguageInfo {
    static final StandardCodes sc = StandardCodes.make();
    static final CLDRConfig config = CLDRConfig.getInstance();
    static final SupplementalDataInfo SDI = config.getSupplementalDataInfo();
    private int literatePopulation;
    private Relation<SupplementalDataInfo.OfficialStatus, String> statusToRegions = Relation.of(new EnumMap(SupplementalDataInfo.OfficialStatus.class), TreeSet.class);
    private Level level;
    private CldrDir cldrDir;
    static final Map<String, LanguageInfo> languageCodeToInfo;

    public Relation<SupplementalDataInfo.OfficialStatus, String> getStatusToRegions() {
        return this.statusToRegions;
    }

    public int getLiteratePopulation() {
        return this.literatePopulation;
    }

    public Level getCldrLevel() {
        return this.level;
    }

    public CldrDir getCldrDir() {
        return this.cldrDir;
    }

    public static LanguageInfo get(String languageCode) {
        return languageCodeToInfo.get(languageCode);
    }

    public static Set<String> getAvailable() {
        return languageCodeToInfo.keySet();
    }

    public String toString() {
        return this.literatePopulation + "\t" + CldrUtility.ifNull(this.cldrDir, "") + "\t" + CldrUtility.ifSame(this.level, Level.UNDETERMINED, "") + "\t" + (this.statusToRegions.isEmpty() ? "" : this.statusToRegions.toString());
    }

    private static LanguageInfo getRaw(TreeMap<String, LanguageInfo> temp, String language) {
        LanguageInfo foo = temp.get(language);
        if (foo == null) {
            foo = new LanguageInfo();
            temp.put(language, foo);
        }
        return foo;
    }

    static {
        TreeMap<String, LanguageInfo> temp = new TreeMap<String, LanguageInfo>();
        LanguageTagParser ltp = new LanguageTagParser();
        for (String territory : SDI.getTerritoriesWithPopulationData()) {
            for (String string : SDI.getLanguagesForTerritoryWithPopulationData(territory)) {
                SupplementalDataInfo.PopulationData data = SDI.getLanguageAndTerritoryPopulationData(string, territory);
                String language = ltp.set(string).getLanguage();
                LanguageInfo foo = LanguageInfo.getRaw(temp, language);
                SupplementalDataInfo.OfficialStatus ostatus = data.getOfficialStatus();
                if (ostatus != SupplementalDataInfo.OfficialStatus.unknown) {
                    foo.statusToRegions.put(ostatus, territory);
                }
                foo.literatePopulation = (int)((double)foo.literatePopulation + data.getLiteratePopulation());
            }
        }
        Set<String> languages = config.getCldrFactory().getAvailableLanguages();
        Set<String> full_languages = config.getFullCldrFactory().getAvailableLanguages();
        for (String string : full_languages) {
            LanguageInfo foo = LanguageInfo.getRaw(temp, string);
            foo.cldrDir = languages.contains(string) ? CldrDir.main : CldrDir.seed;
        }
        LanguageInfo.getRaw(temp, (String)"und").cldrDir = CldrDir.base;
        LanguageInfo.getRaw(temp, (String)"zxx").cldrDir = CldrDir.base;
        for (Map.Entry entry : temp.entrySet()) {
            LanguageInfo value = (LanguageInfo)entry.getValue();
            value.statusToRegions.freeze();
            value.level = sc.getLocaleCoverageLevel(Organization.cldr, (String)entry.getKey());
        }
        languageCodeToInfo = Collections.unmodifiableMap(temp);
    }

    public static enum CldrDir {
        base,
        main,
        seed;

    }
}

