/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

public final class LocaleInheritanceInfo {
    private String locale;
    private String path;
    private Reason reason;
    private String attribute = null;

    public String getLocale() {
        return this.locale;
    }

    public String getPath() {
        return this.path;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getAttribute() {
        return this.attribute;
    }

    LocaleInheritanceInfo(String locale, String path, Reason reason) {
        this.locale = locale;
        this.path = path;
        this.reason = reason;
    }

    LocaleInheritanceInfo(String locale, String path, Reason reason, String attribute) {
        this.locale = locale;
        this.path = path;
        this.reason = reason;
        this.attribute = attribute;
    }

    public String toString() {
        if (this.locale == null && this.path == null) {
            return this.reason.name();
        }
        if (this.path == null) {
            return String.format("%s: locale %s", this.reason.name(), this.locale);
        }
        if (this.locale == null) {
            return String.format("%s: %s", this.reason.name(), this.path);
        }
        return String.format("%s: %s:%s", this.reason.name(), this.locale, this.path);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocaleInheritanceInfo)) {
            return false;
        }
        LocaleInheritanceInfo o = (LocaleInheritanceInfo)other;
        if (o.reason != this.reason) {
            return false;
        }
        if (!LocaleInheritanceInfo.equals(this.locale, o.locale)) {
            return false;
        }
        return LocaleInheritanceInfo.equals(this.path, o.path);
    }

    private static final boolean equals(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        return a.equals(b);
    }

    public static enum Reason {
        value("Found: explicit value", true),
        codeFallback("Found: code fallback", true),
        alias("An alias was found at this location", false),
        constructed("Constructed value", false),
        none("The value was not found in this locale.", true),
        inheritanceMarker("Found: Inheritance marker", false),
        removedAttribute("Removed attribute: ${attribute}", false),
        changedAttribute("Changed attribute: ${attribute}", false),
        fallback("Other fallback path", false);

        private String description;
        private boolean terminal;

        public boolean isTerminal() {
            return this.terminal;
        }

        private Reason(String description, boolean terminal) {
            this.description = description;
            this.terminal = terminal;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name() + ": " + this.description;
        }
    }
}

