/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

public class PatternCache {
    private static final int INITIAL_CAPACITY = 30;
    private static final int MAX_CAPACITY = 1000;
    private static final boolean USE_CACHE = true;
    private static final boolean RECORD_STATISTICS = false;
    private static final Cache<String, Pattern> cache = CacheBuilder.newBuilder().initialCapacity(30).maximumSize(1000L).build();

    public static Pattern get(final String patternStr) {
        if (patternStr == null) {
            throw new IllegalArgumentException("Please call with non-null argument");
        }
        if (patternStr.isEmpty()) {
            throw new IllegalArgumentException("Please call with non-empty argument");
        }
        Pattern result = null;
        try {
            result = cache.get(patternStr, new Callable<Pattern>(){

                @Override
                public Pattern call() throws Exception {
                    return Pattern.compile(patternStr);
                }
            });
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("The supplied pattern is not valid: " + patternStr, e);
        }
        return result;
    }

    public static boolean isRecordStatistics() {
        return false;
    }

    public static boolean isCachingEnabled() {
        return true;
    }

    public static CacheStats getStatistics() {
        return cache.stats();
    }
}

