/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;

public class ReferenceStringSearch {
    private static final int PADDING = 3;
    private RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
    private BreakIterator breaker;
    private String key;
    private String target;
    private int[] keyBuffer;
    private CollationElementIterator2 targetIterator;
    private int[] targetBuffer;
    private int targetBufferStart;
    private int targetBufferLength;
    private int[] targetBackMapBefore;
    private int[] targetBackMapAfter;
    private int lastAfter;
    boolean widestStart;
    boolean widestLimit;
    private ExtendedRange internalPosition = new ExtendedRange();

    public RuleBasedCollator getCollator() {
        return this.collator;
    }

    public ReferenceStringSearch setCollator(RuleBasedCollator collator) {
        this.collator = collator;
        this.targetIterator = new CollationElementIterator2(collator);
        if (this.key != null) {
            this.setKey(this.key);
        }
        if (this.target != null) {
            this.setTarget(this.target);
        }
        return this;
    }

    public BreakIterator getBreaker() {
        return this.breaker;
    }

    public ReferenceStringSearch setBreaker(BreakIterator breaker) {
        this.breaker = breaker;
        if (this.target != null) {
            breaker.setText(this.target);
        }
        return this;
    }

    public boolean isWidestLimit() {
        return this.widestLimit;
    }

    public void setWidestLimit(boolean widestLimit) {
        this.widestLimit = widestLimit;
    }

    public boolean isWidestStart() {
        return this.widestStart;
    }

    public void setWidestStart(boolean widestStart) {
        this.widestStart = widestStart;
    }

    public String getKey() {
        return this.key;
    }

    public ReferenceStringSearch setKey(String key) {
        int collationElement;
        this.key = key;
        ArrayList<Integer> keyBufferList = new ArrayList<Integer>();
        CollationElementIterator2 keyIterator = new CollationElementIterator2(this.collator).setText(key);
        while ((collationElement = keyIterator.nextProcessed()) != -1) {
            keyBufferList.add(collationElement);
        }
        this.keyBuffer = this.getIntBuffer(keyBufferList);
        return this;
    }

    public int getNativeOffset() {
        return this.targetBackMapBefore[this.targetBufferStart];
    }

    public ReferenceStringSearch setNativeOffset(int nativeOffset) {
        if (nativeOffset < 0 || nativeOffset > this.target.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.targetIterator.setOffset(nativeOffset);
        this.targetBufferStart = 0;
        this.targetBufferLength = 0;
        this.lastAfter = 0;
        if (nativeOffset != 0) {
            this.targetIterator.previousProcessed();
            this.lastAfter = this.targetIterator.offsetAfter;
        }
        this.fillBuffer();
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public ReferenceStringSearch setTarget(String target) {
        this.target = target;
        if (this.breaker != null) {
            this.breaker.setText(target);
        }
        this.targetIterator.setText(target);
        this.targetBuffer = new int[this.keyBuffer.length + 3];
        this.targetBackMapBefore = new int[this.keyBuffer.length + 3];
        this.targetBackMapAfter = new int[this.keyBuffer.length + 3];
        this.targetBufferStart = 0;
        this.lastAfter = 0;
        this.targetBufferLength = 0;
        this.fillBuffer();
        return this;
    }

    private boolean shiftBuffer() {
        this.lastAfter = this.targetBackMapAfter[this.targetBufferStart];
        ++this.targetBufferStart;
        if (this.targetBufferStart >= this.targetBuffer.length) {
            this.targetBufferStart = 0;
        }
        --this.targetBufferLength;
        return this.fillBuffer();
    }

    private boolean fillBuffer() {
        while (this.targetBufferLength < this.keyBuffer.length + 1) {
            int ce = this.targetIterator.nextProcessed();
            if (ce == -1) {
                return false;
            }
            int targetBufferLimit = this.targetBufferStart + this.targetBufferLength;
            if (targetBufferLimit >= this.targetBuffer.length) {
                targetBufferLimit -= this.targetBuffer.length;
            }
            this.targetBuffer[targetBufferLimit] = ce;
            this.targetBackMapBefore[targetBufferLimit] = this.targetIterator.offsetBefore;
            this.targetBackMapAfter[targetBufferLimit] = this.targetIterator.offsetAfter;
            ++this.targetBufferLength;
        }
        return true;
    }

    public boolean searchForwards(ExtendedRange position) {
        while (this.targetBufferLength >= this.keyBuffer.length) {
            if (this.matchesAt()) {
                position.minStart = this.lastAfter;
                position.maxStart = this.targetBackMapBefore[this.targetBufferStart];
                int last = this.targetBufferStart + this.keyBuffer.length - 1;
                if (last >= this.targetBuffer.length) {
                    last -= this.targetBuffer.length;
                }
                position.minLimit = this.targetBackMapAfter[last];
                if (this.targetBufferLength == this.keyBuffer.length) {
                    position.maxLimit = this.target.length();
                } else {
                    if (++last >= this.targetBuffer.length) {
                        last -= this.targetBuffer.length;
                    }
                    position.maxLimit = this.targetBackMapBefore[last];
                }
                this.shiftBuffer();
                return true;
            }
            this.shiftBuffer();
        }
        return false;
    }

    private boolean matchesAt() {
        int j = this.targetBufferStart;
        for (int i = 0; i < this.keyBuffer.length; ++i) {
            if (this.keyBuffer[i] != this.targetBuffer[j]) {
                return false;
            }
            if (++j < this.targetBuffer.length) continue;
            j = 0;
        }
        return true;
    }

    public boolean searchForwards(Range position) {
        while (true) {
            boolean succeeds;
            if (!(succeeds = this.searchForwards(this.internalPosition))) {
                return false;
            }
            position.start = ReferenceStringSearch.getBoundary(this.breaker, this.internalPosition.minStart, this.internalPosition.maxStart, !this.widestStart);
            if (position.start == -1) continue;
            position.limit = ReferenceStringSearch.getBoundary(this.breaker, this.internalPosition.minLimit, this.internalPosition.maxLimit, this.widestLimit);
            if (position.limit != -1) break;
        }
        return true;
    }

    private int[] getIntBuffer(ArrayList<Integer> keyBufferList) {
        int[] buffer = new int[keyBufferList.size()];
        for (int i = 0; i < keyBufferList.size(); ++i) {
            buffer[i] = keyBufferList.get(i);
        }
        return buffer;
    }

    public static int getBoundary(BreakIterator breaker, int minBoundary, int maxBoundary, boolean greatest) {
        int result;
        if (breaker == null) {
            return greatest ? maxBoundary : minBoundary;
        }
        if (greatest) {
            result = breaker.preceding(maxBoundary + 1);
            if (result < minBoundary) {
                result = -1;
            }
        } else {
            result = breaker.following(minBoundary - 1);
            if (result < minBoundary) {
                result = -1;
            }
        }
        return result;
    }

    public static class CollationElementIterator2 {
        private CollationElementIterator keyIterator;
        private int strengthMask = -65536;
        private int variableTop;
        private int offsetBefore;
        private int offsetAfter;

        public int getOffsetBefore() {
            return this.offsetBefore;
        }

        public int getOffsetAfter() {
            return this.offsetAfter;
        }

        public CollationElementIterator2 reset() {
            this.keyIterator.reset();
            return this;
        }

        public CollationElementIterator2 setOffset(int offset) {
            this.keyIterator.setOffset(offset);
            return this;
        }

        public CollationElementIterator2 setText(String source) {
            this.keyIterator.setText(source);
            return this;
        }

        public CollationElementIterator2(RuleBasedCollator collator) {
            this.variableTop = !collator.isAlternateHandlingShifted() ? -1 : collator.getVariableTop() | 0xFFFF;
            switch (collator.getStrength()) {
                case 0: {
                    this.strengthMask = -65536;
                    break;
                }
                case 1: {
                    this.strengthMask = -256;
                    break;
                }
                default: {
                    this.strengthMask = -1;
                }
            }
            this.keyIterator = collator.getCollationElementIterator("");
        }

        int nextProcessed() {
            int collationElement;
            do {
                this.offsetBefore = this.keyIterator.getOffset();
            } while ((collationElement = this.keyIterator.next()) != -1 && ((collationElement &= this.strengthMask) < this.variableTop && collationElement > 65535 || collationElement == 0));
            this.offsetAfter = this.keyIterator.getOffset();
            return collationElement;
        }

        int previousProcessed() {
            int collationElement;
            do {
                this.offsetAfter = this.keyIterator.getOffset();
            } while ((collationElement = this.keyIterator.previous()) != -1 && ((collationElement &= this.strengthMask) < this.variableTop && collationElement > 65535 || collationElement == 0));
            this.offsetBefore = this.keyIterator.getOffset();
            return collationElement;
        }
    }

    public static class Range {
        public int start;
        public int limit;

        public String toString() {
            return this.start + ", " + this.limit;
        }

        public String toString(String key, String target) {
            return "'" + target.substring(0, this.start) + "[" + target.substring(this.start, this.limit) + "]" + target.substring(this.limit) + "'";
        }
    }

    public static class ExtendedRange {
        int minStart;
        int maxStart;
        int minLimit;
        int maxLimit;

        public String toString() {
            return this.minStart + ", " + this.maxStart + ", " + this.minLimit + ", " + this.maxLimit;
        }

        public String toString(String key, String target) {
            return "'" + target.substring(0, this.minStart) + "[" + target.substring(this.minStart, this.maxStart) + "{" + target.substring(this.maxStart, this.minLimit) + "}" + target.substring(this.minLimit, this.maxLimit) + "]" + target.substring(this.maxLimit) + "'";
        }
    }
}

