/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.regex.Pattern;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.PatternCache;

public abstract class SemiFileReader
extends FileProcessor {
    public static final Pattern SPLIT = PatternCache.get("\\s*;\\s*");

    protected abstract boolean handleLine(int var1, int var2, int var3, String[] var4);

    @Override
    protected void handleEnd() {
    }

    protected boolean isCodePoint() {
        return true;
    }

    protected String[] splitLine(String line) {
        return SPLIT.split(line);
    }

    @Override
    protected boolean handleLine(int lineCount, String line) {
        int end;
        int start;
        String[] parts = this.splitLine(line);
        if (this.isCodePoint()) {
            String source = parts[0];
            int range = source.indexOf("..");
            if (range >= 0) {
                start = Integer.parseInt(source.substring(0, range), 16);
                end = Integer.parseInt(source.substring(range + 2), 16);
            } else {
                start = end = Integer.parseInt(source, 16);
            }
        } else {
            end = -1;
            start = -1;
        }
        return this.handleLine(lineCount, start, end, parts);
    }
}

