/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CharUtilities;
import org.unicode.cldr.util.Dictionary;

public class SimpleDictionary<T>
extends Dictionary<T> {
    private TreeMap<CharSequence, T> data = new TreeMap();
    private Set<CharSequence> possibleMatchesBefore;
    private Set<CharSequence> possibleMatchesAfter;
    private Dictionary.Matcher.Status finalStatus;
    boolean done;
    private int matchCount;
    private CharSequence lastEntry = "";

    private SimpleDictionary(Map<CharSequence, T> source) {
        for (CharSequence text : source.keySet()) {
            this.addMapping(text, source.get(text));
        }
    }

    private void addMapping(CharSequence text, T result) {
        if (CharUtilities.compare(text, this.lastEntry) <= 0) {
            throw new IllegalArgumentException("Each string must be greater than the previous one.");
        }
        this.lastEntry = text;
        this.data.put(text, result);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, T>> getMapping() {
        return Collections.unmodifiableMap(this.data).entrySet().iterator();
    }

    @Override
    public Dictionary.Matcher<T> getMatcher() {
        return new SimpleMatcher();
    }

    public static boolean startsWith(CharSequence first, CharSequence possiblePrefix) {
        if (first.length() < possiblePrefix.length()) {
            return false;
        }
        for (int i = 0; i < possiblePrefix.length(); ++i) {
            if (first.charAt(i) == possiblePrefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private class SimpleMatcher
    extends Dictionary.Matcher<T> {
        private SimpleMatcher() {
        }

        @Override
        public Dictionary.Matcher<T> setOffset(int offset) {
            SimpleDictionary.this.possibleMatchesBefore = SimpleDictionary.this.data.keySet();
            SimpleDictionary.this.done = false;
            this.matchValue = null;
            return super.setOffset(offset);
        }

        @Override
        public Dictionary.Matcher.Status next() {
            if (SimpleDictionary.this.done) {
                if (SimpleDictionary.this.finalStatus == Dictionary.Matcher.Status.NONE) {
                    this.matchValue = null;
                }
                return SimpleDictionary.this.finalStatus;
            }
            CharSequence firstMatch = null;
            while (this.text.hasCharAt(this.matchEnd)) {
                ++this.matchEnd;
                CharSequence probe = this.text.subSequence(this.offset, this.matchEnd);
                firstMatch = this.filterToStartsWith(probe);
                if (firstMatch != null && firstMatch.length() == probe.length()) {
                    SimpleDictionary.this.possibleMatchesAfter.remove(firstMatch);
                    SimpleDictionary.this.possibleMatchesBefore = SimpleDictionary.this.possibleMatchesAfter;
                    this.matchValue = SimpleDictionary.this.data.get(firstMatch);
                    SimpleDictionary.this.finalStatus = Dictionary.Matcher.Status.NONE;
                    return Dictionary.Matcher.Status.MATCH;
                }
                if (SimpleDictionary.this.possibleMatchesAfter.size() == 0) {
                    --this.matchEnd;
                    break;
                }
                SimpleDictionary.this.possibleMatchesBefore = SimpleDictionary.this.possibleMatchesAfter;
            }
            SimpleDictionary.this.done = true;
            if (this.matchEnd == this.offset || SimpleDictionary.this.possibleMatchesBefore.size() == 0) {
                this.matchValue = null;
                SimpleDictionary.this.finalStatus = Dictionary.Matcher.Status.NONE;
                return SimpleDictionary.this.finalStatus;
            }
            if (firstMatch == null) {
                firstMatch = SimpleDictionary.this.possibleMatchesBefore.iterator().next();
            }
            this.matchValue = SimpleDictionary.this.data.get(firstMatch);
            SimpleDictionary.this.matchCount = SimpleDictionary.this.possibleMatchesBefore.size();
            SimpleDictionary.this.finalStatus = Dictionary.Matcher.Status.PARTIAL;
            return SimpleDictionary.this.finalStatus;
        }

        @Override
        public boolean nextUniquePartial() {
            return SimpleDictionary.this.matchCount == 1;
        }

        private CharSequence filterToStartsWith(CharSequence probe) {
            CharSequence result = null;
            SimpleDictionary.this.possibleMatchesAfter = new TreeSet<CharSequence>();
            for (CharSequence item : SimpleDictionary.this.possibleMatchesBefore) {
                if (!SimpleDictionary.startsWith(item, probe)) continue;
                if (result == null) {
                    result = item;
                }
                SimpleDictionary.this.possibleMatchesAfter.add(item);
            }
            return result;
        }

        public boolean contains(CharSequence text) {
            return SimpleDictionary.this.data.containsKey(text);
        }

        public T get(CharSequence text) {
            return SimpleDictionary.this.data.get(text);
        }

        @Override
        public Dictionary<T> getDictionary() {
            return SimpleDictionary.this;
        }
    }

    public static class SimpleDictionaryBuilder<T>
    implements Dictionary.DictionaryBuilder<T> {
        @Override
        public SimpleDictionary<T> make(Map<CharSequence, T> source) {
            return new SimpleDictionary<T>(source);
        }
    }
}

