/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class StringId {
    private static final Map<String, Long> STRING_TO_ID = new ConcurrentHashMap<String, Long>();
    private static final Map<Long, String> ID_TO_STRING = new ConcurrentHashMap<Long, String>();
    private static final MessageDigest digest;
    private static final int RETRY_LIMIT = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getId(CharSequence charSequence) {
        String string = charSequence.toString();
        Long resultLong = STRING_TO_ID.get(string);
        if (resultLong != null) {
            return resultLong;
        }
        int retryCount = 9;
        while (true) {
            try {
                MessageDigest messageDigest = digest;
                synchronized (messageDigest) {
                    byte[] hash = digest.digest(string.getBytes(StandardCharsets.UTF_8));
                    long result = 0L;
                    for (int i = 0; i < 8; ++i) {
                        result <<= 8;
                        result ^= (long)hash[i];
                    }
                    STRING_TO_ID.put(string, result &= Long.MAX_VALUE);
                    ID_TO_STRING.put(result, string);
                    return result;
                }
            }
            catch (RuntimeException e) {
                if (--retryCount >= 0) continue;
                throw e;
            }
            break;
        }
    }

    public static String getHexId(CharSequence string) {
        return Long.toHexString(StringId.getId(string));
    }

    public static String getStringFromHexId(String string) {
        return StringId.getStringFromId(Long.parseLong(string, 16));
    }

    public static String getStringFromId(long longValue) {
        return ID_TO_STRING.get(longValue);
    }

    static {
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

