/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.text.UnicodeSet;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.props.BagFormatter;

public class Tokenizer {
    protected String source;
    protected StringBuffer buffer = new StringBuffer();
    protected long number;
    protected UnicodeSet unicodeSet = null;
    protected int index;
    boolean backedup = false;
    protected int lastIndex = -1;
    protected int nextIndex;
    int lastValue = -6;
    TokenSymbolTable symbolTable = new TokenSymbolTable();
    private static final char QUOTE = '\'';
    private static final char BSLASH = '\\';
    private static final UnicodeSet QUOTERS = new UnicodeSet().add(39).add(92);
    private static final UnicodeSet WHITESPACE = new UnicodeSet("[\\u0009-\\u000D\\u0020\\u0085\\u200E\\u200F\\u2028\\u2029]");
    private static final UnicodeSet SYNTAX = new UnicodeSet("[\\u0021-\\u002F\\u003A-\\u0040\\u005B-\\u0060\\u007B-\\u007E\\u00A1-\\u00A7\\u00A9\\u00AB-\\u00AC\\u00AE\\u00B0-\\u00B1\\u00B6\\u00B7\\u00BB\\u00BF\\u00D7\\u00F7\\u2010-\\u2027\\u2030-\\u205E\\u2190-\\u2BFF\\u3001\\u3003\\u3008-\\u3020\\u3030\\uFD3E\\uFD3F\\uFE45\\uFE46]").removeAll(QUOTERS).remove(36);
    private static final UnicodeSet NEWLINE = new UnicodeSet("[\\u000A\\u000D\\u0085\\u2028\\u2029]");
    private static final UnicodeSet NON_STRING = new UnicodeSet().addAll(WHITESPACE).addAll(SYNTAX);
    protected UnicodeSet whiteSpace = WHITESPACE;
    protected UnicodeSet syntax = SYNTAX;
    private UnicodeSet non_string = NON_STRING;
    public static final int DONE = -1;
    public static final int NUMBER = -2;
    public static final int STRING = -3;
    public static final int UNICODESET = -4;
    public static final int UNTERMINATED_QUOTE = -5;
    public static final int BACKEDUP_TOO_FAR = -6;
    private static final int AFTER_QUOTE = 3;
    private static final int IN_STRING = 4;
    private static final int AFTER_BSLASH = 5;
    private static final int IN_QUOTE = 6;
    private static final BagFormatter usf = new BagFormatter();

    private void fixSets() {
        if (this.syntax.containsSome(QUOTERS) || this.syntax.containsSome(this.whiteSpace)) {
            this.syntax = ((UnicodeSet)this.syntax.clone()).removeAll(QUOTERS).removeAll(this.whiteSpace);
        }
        if (this.whiteSpace.containsSome(QUOTERS)) {
            this.whiteSpace = ((UnicodeSet)this.whiteSpace.clone()).removeAll(QUOTERS);
        }
        this.non_string = new UnicodeSet(this.syntax).addAll(this.whiteSpace);
    }

    public Tokenizer setSource(String source) {
        this.source = source;
        this.index = 0;
        return this;
    }

    public Tokenizer setIndex(int index) {
        this.index = index;
        return this;
    }

    public String toString(int type, boolean backedupBefore) {
        String s2 = this.backedup ? "@" : "*";
        switch (type) {
            case -1: {
                return s2 + "Done" + s2;
            }
            case -6: {
                return s2 + "Illegal Backup" + s2;
            }
            case -5: {
                return s2 + "Unterminated Quote=" + this.getString() + s2;
            }
            case -3: {
                return s2 + "s=" + this.getString() + s2;
            }
            case -2: {
                return s2 + "n=" + this.getNumber() + s2;
            }
            case -4: {
                return s2 + "n=" + this.getUnicodeSet() + s2;
            }
        }
        return s2 + "c=" + usf.getName(type, true) + s2;
    }

    public void backup() {
        if (this.backedup) {
            throw new IllegalArgumentException("backup too far");
        }
        this.backedup = true;
        this.nextIndex = this.index;
        this.index = this.lastIndex;
    }

    public int next() {
        if (this.backedup) {
            this.backedup = false;
            this.index = this.nextIndex;
            return this.lastValue;
        }
        int cp = 0;
        boolean inComment = false;
        while (true) {
            if (this.index >= this.source.length()) {
                this.lastValue = -1;
                return -1;
            }
            cp = this.nextChar();
            if (inComment) {
                if (!NEWLINE.contains(cp)) continue;
                inComment = false;
                continue;
            }
            if (cp == 35) {
                inComment = true;
                continue;
            }
            if (!this.whiteSpace.contains(cp)) break;
        }
        this.lastIndex = this.index;
        if (cp == 91) {
            ParsePosition pos = new ParsePosition(this.index - 1);
            this.unicodeSet = new UnicodeSet(this.source, pos, this.symbolTable);
            this.index = pos.getIndex();
            this.lastValue = -4;
            return -4;
        }
        if (this.syntax.contains(cp)) {
            this.lastValue = cp;
            return this.lastValue;
        }
        if (UCharacter.getType(cp) == 9) {
            this.number = UCharacter.getNumericValue(cp);
            while (this.index < this.source.length()) {
                cp = this.nextChar();
                if (UCharacter.getType(cp) != 9) {
                    this.index -= UTF16.getCharCount(cp);
                    break;
                }
                this.number *= 10L;
                this.number += (long)UCharacter.getNumericValue(cp);
            }
            this.lastValue = -2;
            return -2;
        }
        this.buffer.setLength(0);
        int status = 4;
        block13: while (true) {
            switch (status) {
                case 3: {
                    if (cp == 39) {
                        UTF16.append(this.buffer, 39);
                        status = 6;
                        break;
                    }
                }
                case 4: {
                    if (cp == 39) {
                        status = 6;
                        break;
                    }
                    if (cp == 92) {
                        status = 5;
                        break;
                    }
                    if (this.non_string.contains(cp)) {
                        this.index -= UTF16.getCharCount(cp);
                        break block13;
                    }
                    UTF16.append(this.buffer, cp);
                    break;
                }
                case 6: {
                    if (cp == 39) {
                        status = 3;
                        break;
                    }
                    UTF16.append(this.buffer, cp);
                    break;
                }
                case 5: {
                    switch (cp) {
                        case 110: {
                            cp = 10;
                            break;
                        }
                        case 114: {
                            cp = 13;
                            break;
                        }
                        case 116: {
                            cp = 9;
                        }
                    }
                    UTF16.append(this.buffer, cp);
                    status = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Internal Error");
                }
            }
            if (this.index >= this.source.length()) break;
            cp = this.nextChar();
        }
        if (status > 4) {
            this.lastValue = -5;
            return -5;
        }
        this.lastValue = -3;
        return -3;
    }

    public String getString() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.source.substring(0, this.index) + "$$$" + this.source.substring(this.index);
    }

    public long getNumber() {
        return this.number;
    }

    public UnicodeSet getUnicodeSet() {
        return this.unicodeSet;
    }

    private int nextChar() {
        int cp = UTF16.charAt(this.source, this.index);
        this.index += UTF16.getCharCount(cp);
        return cp;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSource() {
        return this.source;
    }

    public UnicodeSet getSyntax() {
        return this.syntax;
    }

    public UnicodeSet getWhiteSpace() {
        return this.whiteSpace;
    }

    public void setSyntax(UnicodeSet set) {
        this.syntax = set;
        this.fixSets();
    }

    public void setWhiteSpace(UnicodeSet set) {
        this.whiteSpace = set;
        this.fixSets();
    }

    public Set getLookedUpItems() {
        return this.symbolTable.itemsLookedUp;
    }

    public void addSymbol(String var, String value, int start, int limit) {
        char[] body = new char[--limit - start];
        value.getChars(start, limit, body, 0);
        this.symbolTable.add(var, body);
    }

    public class TokenSymbolTable
    implements SymbolTable {
        Map contents = new HashMap();
        Set itemsLookedUp = new HashSet();

        public void add(String var, char[] body) {
            this.contents.put(var.substring(1), body);
        }

        @Override
        public char[] lookup(String s2) {
            this.itemsLookedUp.add("$" + s2);
            return (char[])this.contents.get(s2);
        }

        @Override
        public UnicodeMatcher lookupMatcher(int ch) {
            return null;
        }

        @Override
        public String parseReference(String text, ParsePosition pos, int limit) {
            int start;
            int i;
            int cp;
            for (i = start = pos.getIndex(); i < limit && UCharacter.isUnicodeIdentifierPart(cp = UTF16.charAt(text, i)); i += UTF16.getCharCount(cp)) {
            }
            pos.setIndex(i);
            return text.substring(start, i);
        }
    }
}

