/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class UnicodeRelation<T>
implements Freezable<UnicodeRelation<T>> {
    final UnicodeMap<Set<T>> data = new UnicodeMap();
    final SetMaker<T> maker;
    public static SetMaker<Object> HASHSET_MAKER = new SetMaker<Object>(){

        @Override
        public Set<Object> make() {
            return new HashSet<Object>();
        }
    };
    public static final SetMaker<Object> LINKED_HASHSET_MAKER = new SetMaker<Object>(){

        @Override
        public Set<Object> make() {
            return new LinkedHashSet<Object>();
        }
    };

    public UnicodeRelation(SetMaker<T> maker) {
        this.maker = maker;
    }

    public UnicodeRelation() {
        this.maker = HASHSET_MAKER;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean containsKey(int key) {
        return this.data.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public boolean containsValue(T value) {
        for (Set<T> v : this.data.values()) {
            if (!v.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Set<T> get(int key) {
        return this.data.get(key);
    }

    public Set<T> get(String key) {
        return this.data.get(key);
    }

    public UnicodeSet getKeys(T value) {
        UnicodeSet result = new UnicodeSet();
        for (Map.Entry<String, Set<T>> entry : this.data.entrySet()) {
            if (!entry.getValue().contains(value)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public UnicodeRelation<T> add(String key, T value) {
        Set<T> newValues = this.addValue(this.data.get(key), value);
        if (newValues != null) {
            this.data.put(key, newValues);
        }
        return this;
    }

    public UnicodeRelation<T> add(int key, T value) {
        Set<T> newValues = this.addValue(this.data.get(key), value);
        if (newValues != null) {
            this.data.put(key, newValues);
        }
        return this;
    }

    public UnicodeRelation<T> addAll(String key, Collection<T> values) {
        Set<T> newValues = this.addValues(this.data.get(key), values);
        if (newValues != null) {
            this.data.put(key, newValues);
        }
        return this;
    }

    public UnicodeRelation<T> addAll(Map<String, T> m4) {
        for (Map.Entry<String, T> entry : m4.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UnicodeRelation<T> addAll(UnicodeSet keys, Collection<T> values) {
        for (String key : keys) {
            this.addAll(key, values);
        }
        return this;
    }

    public UnicodeRelation<T> addAll(UnicodeSet keys, T ... values) {
        return this.addAll(keys, (T)Arrays.asList(values));
    }

    public UnicodeRelation<T> addAll(UnicodeSet keys, T value) {
        for (String key : keys) {
            this.add(key, value);
        }
        return this;
    }

    private Set<T> addValue(Set<T> oldValues, T value) {
        if (oldValues == null) {
            return Collections.singleton(value);
        }
        if (oldValues.contains(value)) {
            return null;
        }
        Set<T> newValues = this.make(oldValues);
        newValues.add(value);
        return Collections.unmodifiableSet(newValues);
    }

    private final Set<T> make(Collection<T> oldValues) {
        Set<T> newValues = this.maker.make();
        newValues.addAll(oldValues);
        return newValues;
    }

    private Set<T> addValues(Set<T> oldValues, Collection<T> values) {
        if (oldValues == null) {
            if (values.size() == 1) {
                return Collections.singleton(values.iterator().next());
            }
            return Collections.unmodifiableSet(this.make(values));
        }
        if (oldValues.containsAll(values)) {
            return null;
        }
        Set<T> newValues = this.make(oldValues);
        newValues.addAll(values);
        return Collections.unmodifiableSet(newValues);
    }

    private Set<T> removeValues(Set<T> oldValues, Collection<T> values) {
        if (oldValues == null) {
            return null;
        }
        if (Collections.disjoint(oldValues, values)) {
            return null;
        }
        Set<T> newValues = this.make(oldValues);
        newValues.removeAll(values);
        return newValues.size() == 0 ? Collections.EMPTY_SET : Collections.unmodifiableSet(newValues);
    }

    public UnicodeRelation<T> remove(int key) {
        this.data.remove(key);
        return this;
    }

    public UnicodeRelation<T> remove(String key) {
        this.data.remove(key);
        return this;
    }

    public UnicodeRelation<T> removeValue(T value) {
        UnicodeSet toChange = this.getKeys(value);
        for (String key : toChange) {
            this.remove(key, value);
        }
        return this;
    }

    public UnicodeRelation<T> remove(int key, T value) {
        Set<T> values = this.data.getValue(key);
        if (values != null && values.contains(value)) {
            this.removeExisting(key, value, values);
        }
        return this;
    }

    public UnicodeRelation<T> remove(String key, T value) {
        Set<T> values = this.data.getValue(key);
        if (values != null && values.contains(value)) {
            this.removeExisting(key, value, values);
        }
        return this;
    }

    public UnicodeRelation<T> removeAll(String key, Collection<T> values) {
        Set<T> newValues = this.removeValues(this.data.get(key), values);
        if (newValues != null) {
            if (newValues == Collections.EMPTY_SET) {
                this.data.remove(key);
            } else {
                this.data.put(key, newValues);
            }
        }
        return this;
    }

    public UnicodeRelation<T> removeAll(Map<String, T> m4) {
        for (Map.Entry<String, T> entry : m4.entrySet()) {
            this.remove(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UnicodeRelation<T> removeAll(UnicodeSet keys, Collection<T> values) {
        for (String key : keys) {
            this.removeAll(key, values);
        }
        return this;
    }

    public UnicodeRelation<T> removeAll(UnicodeSet keys, T ... values) {
        return this.removeAll(keys, (T)Arrays.asList(values));
    }

    public UnicodeRelation<T> removeAll(UnicodeSet keys, T value) {
        for (String key : keys) {
            this.remove(key, value);
        }
        return this;
    }

    private void removeExisting(int key, T value, Set<T> values) {
        if (values.size() == 1) {
            this.data.remove(key);
        } else {
            Set<T> newValues = this.make(values);
            newValues.remove(value);
            this.data.put(key, Collections.unmodifiableSet(newValues));
        }
    }

    private void removeExisting(String key, T value, Set<T> values) {
        if (values.size() == 1) {
            this.data.remove(key);
        } else {
            Set<T> newValues = this.make(values);
            newValues.remove(value);
            this.data.put(key, Collections.unmodifiableSet(newValues));
        }
    }

    public void clear() {
        this.data.clear();
    }

    public UnicodeSet keySet() {
        return this.data.keySet();
    }

    public Collection<T> values() {
        Set<T> result = this.maker.make();
        for (Set<T> v : this.data.values()) {
            result.addAll(v);
        }
        return result;
    }

    public Iterable<Map.Entry<String, Set<T>>> keyValues() {
        return this.data.entrySet();
    }

    public String toString() {
        return this.data.toString();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UnicodeRelation && this.data.equals(((UnicodeRelation)obj).data);
    }

    @Override
    public boolean isFrozen() {
        return this.data.isFrozen();
    }

    @Override
    public UnicodeRelation<T> freeze() {
        this.data.freeze();
        return this;
    }

    @Override
    public UnicodeRelation<T> cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public static interface SetMaker<T> {
        public Set<T> make();
    }
}

