/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathException;
import org.unicode.cldr.util.XPathExpressionParser;
import org.w3c.dom.Node;

public class VariableAndPathParser<E, F> {
    private final XPathExpressionParser xpExpParser;
    private ExtractableVariable variableExtractor;
    private ExtractablePath<E, F> pathExtractor;

    public ExtractableVariable getVariableExtractor() {
        return this.variableExtractor;
    }

    public void setVariableExtractor(ExtractableVariable variableExtractor) {
        this.variableExtractor = variableExtractor;
    }

    public ExtractablePath<E, F> getPathExtractor() {
        return this.pathExtractor;
    }

    public void setPathExtractor(ExtractablePath<E, F> pathExtractor) {
        this.pathExtractor = pathExtractor;
    }

    public VariableAndPathParser(File f) throws IOException {
        this.xpExpParser = new XPathExpressionParser(f);
    }

    public VariableAndPathParser(Reader in) throws IOException {
        this.xpExpParser = new XPathExpressionParser(in);
    }

    public Map<String, String> getVariables(String varsXPath) {
        final HashMap<String, String> variables = new HashMap<String, String>();
        if (this.variableExtractor != null) {
            try {
                this.xpExpParser.iterateThroughNodeSet(varsXPath, new XPathExpressionParser.NodeHandlingInterface(){

                    @Override
                    public void handle(Node aNode) {
                        Map.Entry<String, String> curVar = VariableAndPathParser.this.variableExtractor.extractVariable(aNode);
                        if (curVar != null) {
                            variables.put(curVar.getKey(), curVar.getValue());
                        }
                    }
                });
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
        }
        return variables;
    }

    public Map<E, F> getPaths(String pathsXPath) {
        final HashMap pathsReadFromFile = new HashMap();
        if (this.pathExtractor != null) {
            try {
                this.xpExpParser.iterateThroughNodeSet(pathsXPath, new XPathExpressionParser.NodeHandlingInterface(){

                    @Override
                    public void handle(Node aNode) {
                        Map.Entry p = VariableAndPathParser.this.pathExtractor.extractPath(aNode);
                        if (p != null) {
                            pathsReadFromFile.put(p.getKey(), p.getValue());
                        }
                    }
                });
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
        }
        return pathsReadFromFile;
    }

    public static interface ExtractablePath<E, F> {
        public Map.Entry<E, F> extractPath(Node var1);
    }

    public static interface ExtractableVariable {
        public Map.Entry<String, String> extractVariable(Node var1);
    }
}

