/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.EnumSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.NotificationCategory;
import org.unicode.cldr.util.Organization;

public class VettingParameters {
    final EnumSet<NotificationCategory> choices;
    final CLDRLocale locale;
    final Level coverageLevel;
    int userId = 0;
    Organization organization = null;
    CLDRFile sourceFile = null;
    CLDRFile baselineFile = null;
    String specificSinglePath = null;

    public VettingParameters(EnumSet<NotificationCategory> choices, CLDRLocale locale, Level coverageLevel) {
        this.choices = choices;
        this.locale = locale;
        this.coverageLevel = coverageLevel;
    }

    public void setFiles(CLDRLocale locale, Factory sourceFactory, Factory baselineFactory) {
        String localeId = locale.getBaseName();
        CLDRFile sourceFile = sourceFactory.make(localeId, true);
        CLDRFile baselineFile = baselineFactory.make(localeId, true);
        this.setFiles(sourceFile, baselineFile);
    }

    public void setFilesForBaseline(CLDRLocale locale, Factory baselineFactory) {
        String localeId = locale.getBaseName();
        CLDRFile baselineFile = baselineFactory.make(localeId, true);
        CLDRFile sourceFile = baselineFactory.make(localeId, true);
        this.setFiles(sourceFile, baselineFile);
    }

    public void setFiles(CLDRFile sourceFile, CLDRFile baselineFile) {
        this.sourceFile = sourceFile;
        this.baselineFile = baselineFile;
    }

    public void setXpath(String xpath) {
        this.specificSinglePath = xpath;
    }

    public void setUserAndOrganization(int userId, Organization organization) {
        this.userId = userId;
        this.organization = organization;
    }

    public CLDRFile getBaselineFile() {
        return this.baselineFile;
    }

    public CLDRFile getSourceFile() {
        return this.sourceFile;
    }

    public int getUserId() {
        return this.userId;
    }

    public CLDRLocale getLocale() {
        return this.locale;
    }

    public boolean isOnlyForSinglePath() {
        return this.specificSinglePath != null;
    }
}

