/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.Relation;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class ExtractCountItems {
    CLDRConfig testInfo = ToolConfig.getToolInstance();
    Factory factory = this.testInfo.getCldrFactory();
    Map<String, SampleData> samples = new LinkedHashMap<String, SampleData>();

    public static void main(String[] args) {
        new ExtractCountItems().gatherData();
    }

    void gatherData() {
        LinkedHashSet<String> singletonLanguages = new LinkedHashSet<String>();
        LinkedHashMap<String, LinkedHashMap<String, SampleData>> defectiveLocales = new LinkedHashMap<String, LinkedHashMap<String, SampleData>>();
        for (String string : this.factory.getAvailableLanguages()) {
            LinkedHashMap<String, SampleData> data;
            Set<String> pluralLocales;
            Level level;
            Map<String, Level> locale_status = StandardCodes.make().getLocaleToLevel(Organization.google);
            if (locale_status == null || (level = locale_status.get(string)) == null || level.compareTo(Level.BASIC) <= 0 || !(pluralLocales = this.testInfo.getSupplementalDataInfo().getPluralLocales()).contains(string)) continue;
            SupplementalDataInfo.PluralInfo pluralInfo = this.testInfo.getSupplementalDataInfo().getPlurals(string);
            Set<String> keywords = pluralInfo.getCanonicalKeywords();
            int keywordCount = keywords.size();
            if (keywordCount == 1) {
                singletonLanguages.add(string);
                continue;
            }
            CLDRFile cldr = this.factory.make(string, true);
            SampleData sampleData = this.getSamples(cldr, keywordCount, "//ldml/units/unit", data = new LinkedHashMap<String, SampleData>());
            if (sampleData == null) {
                sampleData = this.getSamples(cldr, keywordCount, "//ldml/numbers/currencies/currency", data);
            }
            if (sampleData == null) {
                defectiveLocales.put(string, data);
                continue;
            }
            System.out.println("#" + string + "\t" + sampleData.basePath);
            for (Map.Entry<SupplementalDataInfo.PluralInfo.Count, String> entry : sampleData.entrySet()) {
                System.out.println(string + "\t" + (Object)((Object)entry.getKey()) + "\t<" + entry.getValue() + ">");
            }
        }
        System.out.println("");
        System.out.println("\tLanguages with one plural category: " + singletonLanguages);
        System.out.println("\tLanguages with only defective samples: ");
        for (Map.Entry entry : defectiveLocales.entrySet()) {
            String locale = (String)entry.getKey();
            System.out.println(locale);
            SupplementalDataInfo.PluralInfo pluralInfo = this.testInfo.getSupplementalDataInfo().getPlurals(locale);
            Set<String> keywords = pluralInfo.getCanonicalKeywords();
            EnumSet<SupplementalDataInfo.PluralInfo.Count> realKeywords = EnumSet.noneOf(SupplementalDataInfo.PluralInfo.Count.class);
            for (String s2 : keywords) {
                realKeywords.add(SupplementalDataInfo.PluralInfo.Count.valueOf(s2));
            }
            HashSet<Pair<SupplementalDataInfo.PluralInfo.Count, SupplementalDataInfo.PluralInfo.Count>> missingPairs = new HashSet<Pair<SupplementalDataInfo.PluralInfo.Count, SupplementalDataInfo.PluralInfo.Count>>();
            for (SupplementalDataInfo.PluralInfo.Count i : realKeywords) {
                for (SupplementalDataInfo.PluralInfo.Count j : realKeywords) {
                    if (i.compareTo(j) >= 0) continue;
                    missingPairs.add(new Pair<SupplementalDataInfo.PluralInfo.Count, SupplementalDataInfo.PluralInfo.Count>(i, j));
                }
            }
            this.showMinimalPairs(missingPairs, (Map)entry.getValue());
        }
    }

    private void showMinimalPairs(Set<Pair<SupplementalDataInfo.PluralInfo.Count, SupplementalDataInfo.PluralInfo.Count>> missingPairs, Map<String, SampleData> pathToSamples) {
        for (Map.Entry<String, SampleData> entry : pathToSamples.entrySet()) {
            SampleData samples = entry.getValue();
            Iterator<Pair<SupplementalDataInfo.PluralInfo.Count, SupplementalDataInfo.PluralInfo.Count>> it = missingPairs.iterator();
            while (it.hasNext()) {
                Pair<SupplementalDataInfo.PluralInfo.Count, SupplementalDataInfo.PluralInfo.Count> missing = it.next();
                SupplementalDataInfo.PluralInfo.Count first = missing.getFirst();
                SupplementalDataInfo.PluralInfo.Count second = missing.getSecond();
                String s1 = samples.countToString.get((Object)first);
                String s2 = samples.countToString.get((Object)second);
                if (s1 == null || s2 == null || s1.equals(s2)) continue;
                System.out.println(missing + "\t" + samples.basePath + "\t<" + s1 + ">\t<" + s2 + ">");
                it.remove();
            }
        }
        System.out.println("Missing minimal pairs: " + missingPairs);
    }

    SampleData getSamples(CLDRFile cldr, int keywordCount, String prefix, Map<String, SampleData> data) {
        for (String path : With.in(cldr.iterator(prefix, cldr.getComparator()))) {
            int items;
            if (!path.contains("@count") || path.contains("//ldml/numbers/decimalFormats") || path.contains("//ldml/numbers/currencyFormats") || path.contains("@alt=\"short\"")) continue;
            String value = cldr.getStringValue(path).toLowerCase(Locale.ENGLISH);
            XPathParts parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
            SupplementalDataInfo.PluralInfo.Count count = SupplementalDataInfo.PluralInfo.Count.valueOf(parts.getAttributeValue(-1, "count"));
            parts.setAttribute(-1, "count", null);
            String basePath = parts.toString();
            SampleData sampleData = data.get(basePath);
            if (sampleData == null) {
                sampleData = new SampleData(basePath);
                data.put(basePath, sampleData);
            }
            if ((items = sampleData.put(count, value)) != keywordCount) continue;
            this.samples.put(cldr.getLocaleID(), sampleData);
            return sampleData;
        }
        return null;
    }

    static class SampleData {
        EnumMap<SupplementalDataInfo.PluralInfo.Count, String> countToString = new EnumMap(SupplementalDataInfo.PluralInfo.Count.class);
        Relation<String, SupplementalDataInfo.PluralInfo.Count> stringToCount = Relation.of(new HashMap(), HashSet.class);
        String basePath;

        public SampleData(String basePath) {
            this.basePath = basePath;
        }

        public int put(SupplementalDataInfo.PluralInfo.Count count, String value) {
            this.countToString.put(count, value);
            this.stringToCount.put(value, count);
            return this.stringToCount.size();
        }

        public String toString() {
            return this.countToString.toString();
        }

        public Set<Map.Entry<SupplementalDataInfo.PluralInfo.Count, String>> entrySet() {
            return this.countToString.entrySet();
        }
    }
}

