/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import com.ibm.icu.impl.Utility;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.unicode.cldr.json.CldrItem;
import org.unicode.cldr.json.LdmlConvertRules;

public class CldrNode {
    private Map<String, String> distinguishingAttributes = new HashMap<String, String>();
    private Map<String, String> nondistinguishingAttributes = new HashMap<String, String>();
    private String name;
    private String parent;
    private CldrItem item;
    private String uniqueNodeName;

    public static CldrNode createNode(String parent, String pathSegment, String fullPathSegment) throws ParseException {
        return CldrNode.createNode(parent, pathSegment, fullPathSegment, null);
    }

    public static CldrNode createNode(String parent, String pathSegment, String fullPathSegment, CldrItem item) throws ParseException {
        CldrNode node = new CldrNode();
        node.item = item;
        node.parent = parent;
        node.name = CldrNode.extractAttrs(pathSegment, node.distinguishingAttributes);
        String fullTrunk = CldrNode.extractAttrs(fullPathSegment, node.nondistinguishingAttributes);
        if (!node.name.equals(fullTrunk)) {
            throw new ParseException("Error in parsing \"" + pathSegment + "\":\"" + fullPathSegment + " - " + node.name + " != " + fullTrunk, 0);
        }
        for (String key : node.distinguishingAttributes.keySet()) {
            node.nondistinguishingAttributes.remove(key);
        }
        String[] suppressList = LdmlConvertRules.ATTR_SUPPRESS_LIST;
        for (int i = 0; i < suppressList.length; i += 3) {
            String key;
            String value;
            if (!node.name.equals(suppressList[i]) || (value = node.distinguishingAttributes.get(key = suppressList[i + 2])) == null || !value.equals(suppressList[i + 1])) continue;
            node.distinguishingAttributes.remove(key);
        }
        return node;
    }

    private static String extractAttrs(String pathSegment, Map<String, String> attributes) throws ParseException {
        int start = 0;
        String trunk = new String();
        while (true) {
            int ind2;
            int ind1;
            if ((ind1 = pathSegment.indexOf("[@", start)) < 0) {
                if (!trunk.isEmpty()) break;
                trunk = pathSegment;
                break;
            }
            if (trunk.isEmpty()) {
                trunk = pathSegment.substring(0, ind1);
            }
            if ((ind2 = pathSegment.indexOf("=", ind1 += 2)) < 0) {
                throw new ParseException("Missing '=' in attribute specification.", ind1);
            }
            String attr = pathSegment.substring(ind1, ind2);
            ind1 = ind2 + 1;
            if ((ind2 = pathSegment.charAt(ind1) == '\"' ? pathSegment.indexOf("\"]", ++ind1) : pathSegment.indexOf("]", ind1)) < 0) {
                throw new ParseException("Unexpected end in attribute specification.", ind1);
            }
            String value = pathSegment.substring(ind1, ind2);
            start = ind2;
            attributes.put(attr, value);
        }
        return trunk;
    }

    public String getUntransformedPath() {
        if (this.item != null) {
            return this.item.getUntransformedPath();
        }
        return "noitem";
    }

    private CldrNode() {
    }

    public Map<String, String> getAttrAsValueMap() {
        String keyStrMidStar;
        String keyStr;
        HashMap<String, String> attributesAsValues = new HashMap<String, String>();
        for (String key : this.distinguishingAttributes.keySet()) {
            keyStr = LdmlConvertRules.getKeyStr(this.getParent(), this.name, key);
            keyStrMidStar = LdmlConvertRules.getKeyStr(this.getParent(), "*", key);
            String keyStr2 = LdmlConvertRules.getKeyStr(this.name, key);
            if (!LdmlConvertRules.ATTR_AS_VALUE_SET.contains(keyStr) && !LdmlConvertRules.ATTR_AS_VALUE_SET.contains(keyStr2)) continue;
            if (LdmlConvertRules.COMPACTABLE_ATTR_AS_VALUE_SET.contains(keyStr) || LdmlConvertRules.COMPACTABLE_ATTR_AS_VALUE_SET.contains(keyStrMidStar)) {
                attributesAsValues.put("_", this.distinguishingAttributes.get(key));
                continue;
            }
            attributesAsValues.put(key, this.distinguishingAttributes.get(key));
        }
        for (String key : this.nondistinguishingAttributes.keySet()) {
            if (LdmlConvertRules.IGNORABLE_NONDISTINGUISHING_ATTR_SET.contains(key)) continue;
            keyStr = LdmlConvertRules.getKeyStr(this.getParent(), this.name, key);
            keyStrMidStar = LdmlConvertRules.getKeyStr(this.getParent(), "*", key);
            if (LdmlConvertRules.COMPACTABLE_ATTR_AS_VALUE_SET.contains(keyStr) || LdmlConvertRules.COMPACTABLE_ATTR_AS_VALUE_SET.contains(keyStrMidStar)) {
                attributesAsValues.put("_", this.nondistinguishingAttributes.get(key));
                continue;
            }
            attributesAsValues.put(key, this.nondistinguishingAttributes.get(key));
        }
        String radixValue = (String)attributesAsValues.get("radix");
        if (radixValue != null) {
            attributesAsValues.remove("radix");
            for (Map.Entry attributes : attributesAsValues.entrySet()) {
                String oldKey = (String)attributes.getKey();
                String newValue = (String)attributes.getValue();
                String newKey = oldKey + "/" + radixValue;
                attributesAsValues.remove(oldKey);
                attributesAsValues.put(newKey, newValue);
            }
        }
        return attributesAsValues;
    }

    public void setDistinguishingAttributes(Map<String, String> distinguishingAttributes) {
        this.distinguishingAttributes = distinguishingAttributes;
    }

    public void setNondistinguishingAttributes(Map<String, String> nondistinguishingAttributes) {
        this.nondistinguishingAttributes = nondistinguishingAttributes;
    }

    public Map<String, String> getDistinguishingAttributes() {
        return this.distinguishingAttributes;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getNondistinguishingAttributes() {
        return this.nondistinguishingAttributes;
    }

    public String getNodeKeyName() {
        String attrIdStr2;
        String attrIdStr;
        if (this.uniqueNodeName != null) {
            return this.uniqueNodeName;
        }
        StringBuffer strbuf = new StringBuffer();
        String lastKey = null;
        for (String key : this.distinguishingAttributes.keySet()) {
            attrIdStr = LdmlConvertRules.getKeyStr(this.getParent(), this.name, key);
            attrIdStr2 = LdmlConvertRules.getKeyStr(this.name, key);
            if (LdmlConvertRules.IsSuppresedAttr(attrIdStr) || LdmlConvertRules.ATTR_AS_VALUE_SET.contains(attrIdStr) || LdmlConvertRules.ATTR_AS_VALUE_SET.contains(attrIdStr2) || key.equals("alt") || key.equals("count") || LdmlConvertRules.NAME_PART_DISTINGUISHING_ATTR_SET.contains(attrIdStr)) continue;
            if (strbuf.length() != 0) {
                throw new IllegalArgumentException("Can not have more than 1 key values in name: both '" + strbuf + "' (" + lastKey + ") and '" + this.distinguishingAttributes.get(key) + "' (" + key + "). attrIdStr=" + attrIdStr + " - check LdmlConvertRules.java#NAME_PART_DISTINGUISHING_ATTR_SET");
            }
            strbuf.append(this.distinguishingAttributes.get(key));
            lastKey = key;
        }
        if (strbuf.length() == 0) {
            strbuf.append(this.name);
        }
        for (String key : this.distinguishingAttributes.keySet()) {
            attrIdStr = LdmlConvertRules.getKeyStr(this.getParent(), this.name, key);
            attrIdStr2 = LdmlConvertRules.getKeyStr(this.name, key);
            if (LdmlConvertRules.IsSuppresedAttr(attrIdStr) || LdmlConvertRules.ATTR_AS_VALUE_SET.contains(attrIdStr) || LdmlConvertRules.ATTR_AS_VALUE_SET.contains(attrIdStr2) || !key.equals("alt") && !LdmlConvertRules.NAME_PART_DISTINGUISHING_ATTR_SET.contains(attrIdStr)) continue;
            strbuf.append("-");
            strbuf.append(key);
            strbuf.append("-");
            strbuf.append(this.distinguishingAttributes.get(key));
        }
        this.uniqueNodeName = strbuf.toString();
        if (this.uniqueNodeName.length() == 1 && this.name.equals("character")) {
            this.uniqueNodeName = "U+" + Utility.hex(this.uniqueNodeName.charAt(0), 4);
        } else if (this.isTimezoneType()) {
            this.uniqueNodeName = this.uniqueNodeName.replaceFirst("\\+", "");
        }
        return this.uniqueNodeName;
    }

    public String getNodeDistinguishingName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.name);
        for (String key : this.distinguishingAttributes.keySet()) {
            strbuf.append("-");
            strbuf.append(key);
            strbuf.append("-");
            strbuf.append(this.distinguishingAttributes.get(key));
        }
        return strbuf.toString();
    }

    public boolean isTimezoneType() {
        return LdmlConvertRules.TIMEZONE_ELEMENT_NAME_SET.contains(this.name);
    }

    public String toString() {
        return "[CldrNode " + this.getParent() + "/" + this.getNodeDistinguishingName() + "]";
    }

    public String getParent() {
        return this.parent;
    }
}

