/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XPathParts;

public class CheckAnnotations
extends CheckCLDR {
    private static final Pattern ANNOTATION_PATH = Pattern.compile("//ldml/annotations/.*");
    private static final Map<String, Set<String>> entriesLackingTts = new HashMap<String, Set<String>>();
    static final Pattern HAS_ANNOTATION_ECODE;

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        String localeID;
        String parent;
        boolean isTopLevel;
        if (!ANNOTATION_PATH.matcher(path).matches()) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        if (value == null || value.isEmpty()) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.nullOrEmptyValue).setMessage("The annotation may not be empty"));
            return this;
        }
        CLDRFile file = this.getCldrFileToCheck();
        String ecode = CheckAnnotations.hasAnnotationECode(value);
        if (ecode != null && file.isNotRoot(path)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalAnnotationCode).setMessage("The annotation must be a translation and not contain the E\u2026 code from root, or anything like it. ({0})", ecode));
        }
        boolean bl = isTopLevel = (parent = LocaleIDParser.getParent(localeID = file.getLocaleID())) == null || parent.equals("root");
        if (!path.contains("[@type=\"tts\"]") && isTopLevel) {
            boolean ttsMissing;
            XPathParts parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
            String ttsPath = parts.addAttribute("type", "tts").toString();
            String ttsValue = file.getWinningValue(ttsPath);
            boolean bl2 = ttsMissing = ttsValue == null || ttsValue.isEmpty() || file.isNotRoot(path) && ecode == null && CheckAnnotations.hasAnnotationECode(ttsValue) != null;
            if (ttsMissing && entriesLackingTts.keySet().contains(localeID)) {
                String cpValue = parts.findAttributeValue("annotation", "cp");
                Set<String> cpEntriesLackingTts = entriesLackingTts.get(localeID);
                if (cpEntriesLackingTts == null || cpEntriesLackingTts.contains(cpValue)) {
                    boolean bl3 = ttsMissing = !ttsMissing;
                }
            }
            if (ttsMissing) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.ttsAnnotationMissing).setMessage("Have keywords but missing the corresponding name (tts) entry"));
            }
        }
        return this;
    }

    static String hasAnnotationECode(String value) {
        Matcher m4 = HAS_ANNOTATION_ECODE.matcher(value);
        if (m4.find()) {
            return m4.group();
        }
        return null;
    }

    static {
        entriesLackingTts.put("ak", new HashSet<String>(Arrays.asList("\ud83e\ude80")));
        entriesLackingTts.put("br", new HashSet<String>(Arrays.asList("'")));
        entriesLackingTts.put("ccp", new HashSet<String>(Arrays.asList("\ud83e\udd6a")));
        entriesLackingTts.put("ha", new HashSet<String>(Arrays.asList("\ud83d\udc68\u200d\ud83e\uddaf", "\ud83d\udc68\u200d\ud83e\uddbc", "\ud83d\udc69\u200d\ud83e\uddaf", "\ud83d\udc69\u200d\ud83e\uddbc")));
        entriesLackingTts.put("kab", new HashSet<String>(Arrays.asList("\u2699", "\ud83c\udc04", "\ud83c\udf24", "\ud83c\udf80", "\ud83d\udc8a", "\ud83d\udcb2", "\ud83d\uddb2", "\ud83d\ude80")));
        entriesLackingTts.put("om", null);
        entriesLackingTts.put("qu", new HashSet<String>(Arrays.asList("\u2712")));
        entriesLackingTts.put("sat", new HashSet<String>(Arrays.asList("\ud83c\udf50", "\ud83c\udf51", "\ud83c\udf52", "\ud83c\udf53", "\ud83d\udc20", "\ud83d\udc21", "\ud83d\udc28", "\ud83d\udc33", "\ud83d\udc39", "\ud83d\udc5e", "\ud83d\udca5", "\ud83e\udd3d\u200d\u2642", "\ud83e\udd50", "\ud83e\udd78", "\ud83e\udd88")));
        HAS_ANNOTATION_ECODE = PatternCache.get("E[0-9]{1,3}(?:[-\u2013:\u2014.][0-9]{1,3}){0,2}");
    }
}

