/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.EmojiConstants;
import org.unicode.cldr.util.LanguageGroup;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;

public class EmojiSubdivisionNames {
    private static final String subdivisionPathPrefix = "//ldml/localeDisplayNames/subdivisions/subdivision[@type=\"";
    private static final String subdivisionPathSuffix = "\"]";
    private static final Map<String, Map<String, String>> localeToNameToSubdivisionId = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> localeToSubdivisionIdToName = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Pattern SUBDIVISION_PATTERN = Pattern.compile("\\s*<subdivision\\s+type=\"(gb(?:eng|sct|wls))\">([^<]+)</subdivision>");
    private static final SortedSet<String> SUBDIVISION_FILE_NAMES = ImmutableSortedSet.copyOf((Comparable[])new File(CLDRPaths.SUBDIVISIONS_DIRECTORY).list());
    public static Set<String> SUBDIVISIONS;

    public static Map<String, String> getSubdivisionIdToName(String localeID) {
        Map<String, String> result = localeToSubdivisionIdToName.get(localeID);
        if (result == null) {
            EmojiSubdivisionNames.load(localeID);
            result = localeToSubdivisionIdToName.get(localeID);
            if (result == null) {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    public static Map<String, String> getNameToSubdivisionPath(String localeID) {
        Map<String, String> result = localeToNameToSubdivisionId.get(localeID);
        if (result == null) {
            EmojiSubdivisionNames.load(localeID);
            result = localeToNameToSubdivisionId.get(localeID);
            if (result == null) {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    private static void load(String localeID) {
        try {
            Map<Object, Object> _subdivisionIdToName;
            Map<Object, Object> _nameToSubdivisionId;
            String fileName = localeID + ".xml";
            if (SUBDIVISION_FILE_NAMES.contains(fileName)) {
                _nameToSubdivisionId = new TreeMap();
                _subdivisionIdToName = new TreeMap();
                Matcher m4 = SUBDIVISION_PATTERN.matcher("");
                for (String line : FileUtilities.in(new File(CLDRPaths.SUBDIVISIONS_DIRECTORY, fileName))) {
                    if (!m4.reset(line).matches()) continue;
                    String xpath = subdivisionPathPrefix + EmojiConstants.toTagSeq(m4.group(1)) + subdivisionPathSuffix;
                    _nameToSubdivisionId.put(m4.group(2), xpath);
                    _subdivisionIdToName.put(m4.group(1), m4.group(2));
                }
                _nameToSubdivisionId = _nameToSubdivisionId.isEmpty() ? Collections.emptyMap() : ImmutableMap.copyOf(_nameToSubdivisionId);
                _subdivisionIdToName = _subdivisionIdToName.isEmpty() ? Collections.emptyMap() : ImmutableMap.copyOf(_subdivisionIdToName);
            } else {
                String parentLocaleId = LocaleIDParser.getParent(localeID);
                _nameToSubdivisionId = EmojiSubdivisionNames.getNameToSubdivisionPath(parentLocaleId);
                _subdivisionIdToName = localeToSubdivisionIdToName.get(parentLocaleId);
            }
            if (_nameToSubdivisionId != null) {
                localeToNameToSubdivisionId.put(localeID, _nameToSubdivisionId);
            }
            if (_subdivisionIdToName != null) {
                localeToSubdivisionIdToName.put(localeID, _subdivisionIdToName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.print("Group\tOrd.\tLocale\tCode");
        for (String sd : SUBDIVISIONS) {
            System.out.print('\t');
            System.out.print(sd);
        }
        System.out.println();
        CLDRFile english = CLDRConfig.getInstance().getEnglish();
        HashSet<String> locales = new HashSet<String>();
        NameGetter nameGetter = english.nameGetter();
        for (String filename : SUBDIVISION_FILE_NAMES) {
            String locale;
            Map<String, String> map;
            if (!filename.endsWith(".xml") || (map = EmojiSubdivisionNames.getSubdivisionIdToName(locale = filename.substring(0, filename.length() - 4))).isEmpty()) continue;
            locales.add(locale);
            ULocale ulocale = new ULocale(locale);
            LanguageGroup group = LanguageGroup.get(ulocale);
            int rank = LanguageGroup.rankInGroup(ulocale);
            System.out.print(group + "\t" + rank + "\t" + nameGetter.getNameFromIdentifier(locale) + "\t" + locale);
            for (String sd : SUBDIVISIONS) {
                System.out.print('\t');
                System.out.print(map.get(sd));
            }
            System.out.println();
        }
        for (String locale : StandardCodes.make().getLocaleCoverageLocales(Organization.cldr)) {
            ULocale ulocale;
            String region;
            if (locales.contains(locale) || !(region = (ulocale = new ULocale(locale)).getCountry()).isEmpty() && !region.equals("PT") && !region.equals("GB")) continue;
            LanguageGroup group = LanguageGroup.get(ulocale);
            int rank = LanguageGroup.rankInGroup(ulocale);
            System.out.println(group + "\t" + rank + "\t" + english.nameGetter().getNameFromIdentifier(locale) + "\t" + locale);
        }
    }

    static {
        localeToNameToSubdivisionId.put("root", Collections.emptyMap());
        SUBDIVISIONS = ImmutableSet.of("gbeng", "gbsct", "gbwls");
    }
}

