/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Row;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeSet;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.UnitConverter;

public class ChartUnitConversions
extends Chart {
    private static final boolean DUMP_UNIT_TABLE_TO_STDOUT = false;
    public static final String QUANTITY_MSG = "The units are grouped and ordered by Quantity (which are based on the NIST quantities, see <a href='https://www.nist.gov/pml/special-publication-811' target='nist811'>NIST 811</a>). Note that the quantities are informative.";
    public static final String RATIONAL_MSG = "Each numeric value is an exact rational. (Radians are an exception since the value of \u03c0 is irrational; a rational approximation is used.)The format is a terminating decimal where possible; otherwise a repeating decimal if possible (where \u02d9 marks the start of the <a href='https://en.wikipedia.org/wiki/Repeating_decimal' target='wiki'>reptend</a>); otherwise a <a href='https://en.wikipedia.org/wiki/Rational_number' target='wiki'>rational number</a> (of the form <i>numerator/denominator</i>).";
    public static final String SPEC_GENERAL_MSG = "The " + ChartUnitConversions.ldmlSpecLink("/tr35-general.html#Contents") + " should be consulted for more details, such as how to handle complex units (such as foot-per-minute) by converting the elements";

    public static void main(String[] args) {
        new ChartUnitConversions().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return FormattedFileWriter.CHART_TARGET_DIR;
    }

    @Override
    public String getTitle() {
        return "Unit Conversions";
    }

    @Override
    public String getExplanation() {
        return "<p>Unit Conversions provide conversions for units, such as meter \u27f9 foot, so that a source units can be converted into what is needed for localized <a href='unit_preferences.html' target='unit_preferences'>Unit Preferences</a>. There are many possible units, and additional units and conversions will be added in future releases.</p><ul><li>Each Source Unit is converted to the Target Unit by multiplying it by the Factor and adding the Offset (if any).</li><li>The unit identifiers are internal, and are to be localized for display to users. See <a href='https://www.unicode.org/cldr/charts/latest/by_type/units.area.html#hectare' target='units.area.hectare'>Hectare</a>, for example. <li>Each numeric value is an exact rational. (Radians are an exception since the value of \u03c0 is irrational; a rational approximation is used.)The format is a terminating decimal where possible; otherwise a repeating decimal if possible (where \u02d9 marks the start of the <a href='https://en.wikipedia.org/wiki/Repeating_decimal' target='wiki'>reptend</a>); otherwise a <a href='https://en.wikipedia.org/wiki/Rational_number' target='wiki'>rational number</a> (of the form <i>numerator/denominator</i>).</li><li>The Systems column indicates which systems the units are used in. For now, they just show the two \u2018inch-pound\u2019 systems.</li><li>The units are grouped and ordered by Quantity (which are based on the NIST quantities, see <a href='https://www.nist.gov/pml/special-publication-811' target='nist811'>NIST 811</a>). Note that the quantities are informative.</li><li>" + SPEC_GENERAL_MSG + ".</li></ul>" + ChartUnitConversions.dataScrapeMessage("/tr35-general.html#Contents", "common/testData/units/unitsTest.txt", "common/supplemental/units.xml");
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().addColumn("SortKey", "class='source'", null, "class='source'", true).setHidden(true).setSortPriority(0).addColumn("Quantity", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setRepeatHeader(true).setBreakSpans(true).addColumn("Target", "class='source'", null, "class='source'", true).addColumn("Systems", "class='source'", null, "class='source'", true).addColumn("Source Unit", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).addColumn("Approx. Factor", "class='target'", null, "class='target'", true).setCellAttributes("class='target' style='text-align:right'").addColumn("Exact* Factor", "class='target'", null, "class='target'", true).setCellAttributes("class='target' style='text-align:right'").addColumn("Offset", "class='target'", null, "class='target'", true).setCellAttributes("class='target' style='text-align:right'");
        UnitConverter converter = SDI.getUnitConverter();
        converter.getSourceToSystems();
        TreeSet<Row.R4<UnitConverter.UnitId, UnitConverter.UnitSystem, Rational, String>> all = new TreeSet<Row.R4<UnitConverter.UnitId, UnitConverter.UnitSystem, Rational, String>>();
        for (Map.Entry<String, UnitConverter.TargetInfo> entry : converter.getInternalConversionData().entrySet()) {
            String sourceUnit = entry.getKey();
            String quantity = converter.getQuantityFromUnit(sourceUnit, false);
            UnitConverter.TargetInfo targetInfo = entry.getValue();
            EnumSet<UnitConverter.UnitSystem> systems = EnumSet.copyOf(converter.getSystemsEnum(sourceUnit));
            UnitConverter.UnitSystem sortingSystem = (UnitConverter.UnitSystem)((Object)systems.iterator().next());
            switch (sortingSystem) {
                case si: 
                case si_acceptable: {
                    sortingSystem = UnitConverter.UnitSystem.metric;
                    break;
                }
                case uksystem: {
                    sortingSystem = UnitConverter.UnitSystem.ussystem;
                    break;
                }
            }
            UnitConverter.UnitId targetUnitId = converter.createUnitId(targetInfo.target);
            Row.R4<UnitConverter.UnitId, UnitConverter.UnitSystem, Rational, String> sortKey = Row.of(targetUnitId, sortingSystem, targetInfo.unitInfo.factor, sourceUnit);
            all.add(sortKey);
            String repeatingFactor = targetInfo.unitInfo.factor.toString(Rational.FormatStyle.repeating);
            String basicFactor = targetInfo.unitInfo.factor.toString(Rational.FormatStyle.approx);
            String repeatingOffset = targetInfo.unitInfo.offset.equals(Rational.ZERO) ? "" : targetInfo.unitInfo.offset.toString(Rational.FormatStyle.repeating);
            Object targetDisplay = targetInfo.target;
            String normalized = converter.getStandardUnit(targetInfo.target);
            if (!((String)targetDisplay).equals(normalized)) {
                targetDisplay = normalized + " = " + (String)targetDisplay;
            }
            tablePrinter.addRow().addCell(sortKey).addCell((Comparable)((Object)quantity)).addCell((Comparable)targetDisplay).addCell((Comparable)((Object)Joiner.on(", ").join(systems))).addCell((Comparable)((Object)sourceUnit)).addCell((Comparable)((Object)basicFactor)).addCell((Comparable)((Object)repeatingFactor)).addCell((Comparable)((Object)repeatingOffset)).finishRow();
        }
        pw.write(tablePrinter.toTable());
    }
}

