/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class DeriveScripts {
    private static final boolean SHOW = false;
    static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    static final SupplementalDataInfo SUP = CONFIG.getSupplementalDataInfo();
    static final Multimap<String, String> LANG_TO_SCRIPT;
    static final Map<String, String> SUPPRESS;

    private static void add(Multimap<String, String> langToScript, String lang, String script) {
        if (script == null || langToScript.put(lang, script)) {
            // empty if block
        }
    }

    public static Multimap<String, String> getLanguageToScript() {
        return LANG_TO_SCRIPT;
    }

    public static void showLine(String language, String scriptField, String status) {
        CLDRFile english = CONFIG.getEnglish();
        System.out.println(language + ";\t" + scriptField + "\t# " + english.nameGetter().getNameFromTypeEnumCode(NameType.LANGUAGE, language) + ";\t" + status + ";\t" + Iso639Data.getScope(language) + ";\t" + Iso639Data.getType(language));
    }

    public static void main(String[] args) {
        LikelySubtags ls = new LikelySubtags();
        CLDRFile english = CONFIG.getEnglish();
        int count = 0;
        int i = 0;
        System.out.println("#From Suppress Script");
        for (Map.Entry<String, String> entry : SUPPRESS.entrySet()) {
            DeriveScripts.showLine(entry.getKey(), entry.getValue(), "Suppress");
            ++i;
        }
        System.out.println("#total:\t" + i);
        i = 0;
        boolean haveMore = true;
        System.out.println("\n#From Exemplars");
        int scriptCount = 1;
        while (haveMore) {
            haveMore = false;
            if (scriptCount != 1) {
                System.out.println("\n#NEEDS RESOLUTION:\t" + scriptCount + " scripts");
            }
            for (Map.Entry<String, Collection<String>> entry : DeriveScripts.getLanguageToScript().asMap().entrySet()) {
                Collection<String> scripts = entry.getValue();
                int scriptsSize = scripts.size();
                if (scriptsSize != scriptCount) {
                    if (scriptsSize <= scriptCount) continue;
                    haveMore = true;
                    continue;
                }
                String lang = entry.getKey();
                DeriveScripts.showLine(lang, scripts.size() == 1 ? scripts.iterator().next() : scripts.toString(), "Exemplars" + (scripts.size() == 1 ? "" : "*"));
                ++i;
                String likelyScript = scriptsSize == 1 ? "" : ls.getLikelyScript(lang);
                System.out.println(++count + "\t" + scriptsSize + "\t" + lang + "\t" + english.nameGetter().getNameFromIdentifier(lang) + "\t" + scripts + "\t" + likelyScript);
            }
            System.out.println("#total:\t" + i);
            i = 0;
            ++scriptCount;
        }
    }

    public static Map<String, String> getSuppress() {
        return SUPPRESS;
    }

    static {
        File[] paths = new File[]{new File(CLDRPaths.EXEMPLARS_DIRECTORY)};
        Factory fullCldrFactory = SimpleFactory.make(paths, ".*");
        LikelySubtags ls = new LikelySubtags();
        LanguageTagParser ltp = new LanguageTagParser();
        HashSet seen = new HashSet();
        TreeMultimap<String, String> langToScript = TreeMultimap.create();
        TreeMap<String, String> suppress = new TreeMap<String, String>();
        Map<String, Map<StandardCodes.LstrField, String>> langToInfo = StandardCodes.getLstregEnumRaw().get((Object)StandardCodes.LstrType.language);
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> entry : langToInfo.entrySet()) {
            String langCode;
            String likelyScript;
            String suppressValue = entry.getValue().get((Object)StandardCodes.LstrField.Suppress_Script);
            if (suppressValue == null || !(likelyScript = ls.getLikelyScript(langCode = entry.getKey())).equals("Zzzz")) continue;
            suppress.put(langCode, suppressValue);
        }
        SUPPRESS = ImmutableMap.copyOf(suppress);
        LanguageTagCanonicalizer canon = new LanguageTagCanonicalizer();
        for (String file : fullCldrFactory.getAvailable()) {
            CLDRFile cldrFile;
            String lang;
            String langScript;
            if (!file.equals(langScript = ltp.set(file).getLanguage()) || (lang = canon.transform(ltp.getLanguage())).equals("root")) continue;
            String script = "";
            try {
                cldrFile = fullCldrFactory.make(lang, false);
            }
            catch (SimpleFactory.NoSourceDirectoryException nsde) {
                throw new RuntimeException("Cannot load locale " + lang + " for " + file + " (canonicalized from " + ltp.getLanguage() + ")", nsde);
            }
            UnicodeSet exemplars = cldrFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
            for (String s2 : exemplars) {
                int scriptNum = UScript.getScript(s2.codePointAt(0));
                if (scriptNum == 0 || scriptNum == 1 || scriptNum == 103) continue;
                script = UScript.getShortName(scriptNum);
                break;
            }
            if (script.isEmpty()) continue;
            DeriveScripts.add(langToScript, lang, script);
        }
        LANG_TO_SCRIPT = ImmutableMultimap.copyOf(langToScript);
    }
}

