/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.IOException;
import org.unicode.cldr.tool.ChartAnnotations;
import org.unicode.cldr.tool.ChartCollation;
import org.unicode.cldr.tool.ChartDelta;
import org.unicode.cldr.tool.ChartGrammaticalForms;
import org.unicode.cldr.tool.ChartPersonNames;
import org.unicode.cldr.tool.ChartSubdivisionNames;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.GenerateBcp47Text;
import org.unicode.cldr.tool.GenerateKeyboardCharts;
import org.unicode.cldr.tool.GenerateSidewaysView;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.ShowLanguages;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.StackTracker;
import org.unicode.cldr.util.VerifyCompactNumbers;
import org.unicode.cldr.util.VerifyZones;

public class GenerateAllCharts {
    private static void headline(String str) {
        StackTraceElement caller = StackTracker.currentElement(0);
        System.out.println();
        System.out.println("---------------------------");
        System.out.println(caller.getFileName() + ":" + caller.getLineNumber() + "  " + str);
    }

    public static void main(String[] args) throws Exception {
        GenerateAllCharts.headline("Setting Up");
        File mainDir = new File(CLDRPaths.CHART_DIRECTORY);
        System.out.println("Writing to " + mainDir.getAbsolutePath());
        if (mainDir.mkdirs()) {
            System.err.println("Created: " + mainDir);
        }
        if (!mainDir.isDirectory()) {
            throw new IOException("Main dir doesn't exist: " + mainDir);
        }
        GenerateAllCharts.headline("Copying LICENSE, README.md, css, etc.");
        FileCopier.copy(CldrUtility.class, "data/LICENSE", CLDRPaths.CHART_DIRECTORY, "LICENSE");
        FileCopier.copy(GenerateAllCharts.class, "README-CHARTS.md", CLDRPaths.CHART_DIRECTORY, "README.md");
        FileCopier.copy(GenerateAllCharts.class, "index.css", CLDRPaths.CHART_DIRECTORY);
        FileCopier.copy(GenerateAllCharts.class, "main-index.html", CLDRPaths.CHART_DIRECTORY, "index.html");
        GenerateAllCharts.headline("Setting Up include htmls");
        FormattedFileWriter.copyIncludeHtmls(CLDRPaths.CHART_DIRECTORY);
        if (ToolConstants.CHART_VERSION.compareTo("37") >= 0) {
            GenerateAllCharts.headline("ChartGrammaticalForms");
            new ChartGrammaticalForms().writeChart(null);
        }
        GenerateAllCharts.headline("ShowLanguages");
        ShowLanguages.main(args);
        GenerateAllCharts.headline("ChartAnnotations");
        new ChartAnnotations().writeChart(null);
        GenerateAllCharts.headline("ChartSubdivisionNames");
        new ChartSubdivisionNames().writeChart(null);
        GenerateAllCharts.headline("GenerateBcp47Text");
        GenerateBcp47Text.main(args);
        GenerateAllCharts.headline("GenerateSidewaysView");
        GenerateSidewaysView.main(args);
        GenerateAllCharts.headline("ShowData");
        ShowData.main(args);
        GenerateAllCharts.headline("ChartDelta");
        ChartDelta.main(args);
        GenerateAllCharts.headline("ChartDelta - high level");
        ChartDelta.main(args, true);
        GenerateAllCharts.headline("ChartCollation");
        ChartCollation.main(args);
        GenerateAllCharts.headline("VerifyCompactNumbers");
        VerifyCompactNumbers.main(args);
        GenerateAllCharts.headline("VerifyZones");
        VerifyZones.main(args);
        GenerateAllCharts.headline("DateTimeFormats");
        DateTimeFormats.main(args);
        GenerateAllCharts.headline("ChartPersonNames");
        new ChartPersonNames().writeChart(null);
        GenerateAllCharts.headline("GenerateKeyboardCharts");
        GenerateKeyboardCharts.main(args);
        GenerateAllCharts.headline("DONE");
    }
}

