/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Row;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UTF16;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CollatorHelper;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.EscapingUtilities;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.Timer;

public class GenerateComparison {
    private static PrettyPath prettyPathMaker;
    private static Collator collator;
    static EnglishRowComparator ENG;
    static final String warningMessage = "<p><b>Warning: this chart is still under development. For how to use it, see <a href=\"http://unicode.org/cldr/data/docs/survey/vetting.html\">Help: How to Vet</a>.</b></p>";
    private static NumberFormat format;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        Timer timer = new Timer();
        Timer totalTimer = new Timer();
        long totalPaths = 0L;
        format = NumberFormat.getNumberInstance();
        format.setGroupingUsed(true);
        Counter<Object> totalCounter = new Counter<Object>();
        String oldDirectory = CldrUtility.getProperty("oldDirectory", PathUtilities.getNormalizedPathString(new File(CLDRPaths.BASE_DIRECTORY, "common/main")) + "/");
        String newDirectory = CldrUtility.getProperty("newDirectory", PathUtilities.getNormalizedPathString(new File(CLDRPaths.BASE_DIRECTORY, "../cldr-release-1-7/common/main")) + "/");
        String changesDirectory = CldrUtility.getProperty("changesDirectory", PathUtilities.getNormalizedPathString(CLDRPaths.CHART_DIRECTORY + "/changes/", new String[0]) + "/");
        String filter = CldrUtility.getProperty("localeFilter", ".*");
        boolean SHOW_ALIASED = CldrUtility.getProperty("showAliased", "false").toLowerCase().startsWith("t");
        Factory oldFactory = Factory.make(oldDirectory, filter);
        Factory newFactory = Factory.make(newDirectory, filter);
        CLDRFile english = newFactory.make("en", true);
        CLDRFile newRoot = newFactory.make("root", true);
        Set<String> oldList = oldFactory.getAvailableLanguages();
        Set<String> newList = newFactory.getAvailableLanguages();
        HashSet<String> unifiedList = new HashSet<String>(oldList);
        unifiedList.addAll(newList);
        TreeSet<Row.R2<String, String>> pairs = new TreeSet<Row.R2<String, String>>();
        for (String code : unifiedList) {
            pairs.add(Row.of(english.nameGetter().getNameFromIdentifier(code), code));
        }
        prettyPathMaker = new PrettyPath();
        int totalDifferences = 0;
        int differences = 0;
        TreeSet<Row.R2<String, String>> indexInfo = new TreeSet<Row.R2<String, String>>(ENG);
        for (Row.R2 r2 : pairs) {
            HashSet<String> paths;
            void var26_35;
            CLDRFile newFile;
            String localeName;
            String locale;
            block25: {
                block24: {
                    block23: {
                        timer.start();
                        locale = (String)r2.get1();
                        localeName = (String)r2.get0();
                        System.out.println(locale);
                        differences = 0;
                        System.out.println();
                        Object var26_32 = null;
                        if (oldList.contains(locale)) {
                            try {
                                CLDRFile cLDRFile = oldFactory.make(locale, true, true);
                                break block23;
                            }
                            catch (Exception e) {
                                GenerateComparison.addToIndex(indexInfo, "ERROR1.6 ", locale, localeName);
                                continue;
                            }
                        }
                        CLDRFile cLDRFile = SimpleFactory.makeFile(locale);
                    }
                    newFile = null;
                    if (newList.contains(locale)) {
                        try {
                            newFile = newFactory.make(locale, true, true);
                            break block24;
                        }
                        catch (Exception e) {
                            GenerateComparison.addToIndex(indexInfo, "ERROR1.7 ", locale, localeName);
                            continue;
                        }
                    }
                    newFile = SimpleFactory.makeFile(locale);
                }
                if (var26_35 == null) {
                    GenerateComparison.addToIndex(indexInfo, "NEW ", locale, localeName);
                    continue;
                }
                if (newFile == null) {
                    GenerateComparison.addToIndex(indexInfo, "DELETED ", locale, localeName);
                    continue;
                }
                System.out.println("*** " + localeName + "\t" + locale);
                System.out.println();
                if (newFile.isAliasedAtTopLevel()) continue;
                try {
                    paths = new HashSet<String>();
                    var26_35.forEach(paths::add);
                    if (oldList.contains(locale)) {
                        paths.addAll(var26_35.getExtraPaths());
                    }
                    newFile.forEach(paths::add);
                    if (!newList.contains(locale)) break block25;
                    paths.addAll(newFile.getExtraPaths());
                }
                catch (Exception e) {
                    System.err.println("Locale: " + locale + ", " + localeName);
                    e.printStackTrace();
                    GenerateComparison.addToIndex(indexInfo, "ERROR ", locale, localeName);
                    continue;
                }
            }
            String localeDisplayName = english.nameGetter().getNameFromIdentifier(locale);
            TablePrinter table = new TablePrinter().setCaption("Changes in " + localeDisplayName + " (" + locale + ")").addColumn("PRETTY_SORT1").setSortPriority(1).setHidden(true).setRepeatHeader(true).addColumn("PRETTY_SORT2").setSortPriority(2).setHidden(true).addColumn("PRETTY_SORT3").setSortPriority(3).setHidden(true).addColumn("ESCAPED_PATH").setHidden(true).addColumn("Inh.").setCellAttributes("class=\"{0}\"").setSortPriority(0).setSpanRows(true).setRepeatHeader(true).addColumn("Section").setSpanRows(true).setCellAttributes("class='section'").addColumn("Subsection").setSpanRows(true).setCellAttributes("class='subsection'").addColumn("Item").setSpanRows(true).setCellPattern("<a href=\"{4}\">{0}</a>").setCellAttributes("class='item'").addColumn("English").setCellAttributes("class='english'").addColumn("Status").setSortPriority(4).setCellAttributes("class=\"{0}\"").addColumn("Old" + localeDisplayName).setCellAttributes("class='old'").addColumn("New" + localeDisplayName).setCellAttributes("class='new'");
            Counter<String> fileCounter = new Counter<String>();
            for (String path : paths) {
                boolean reject;
                if (path.contains("/alias") || path.contains("/identity")) continue;
                String cleanedPath = CLDRFile.getNondraftNonaltXPath(path);
                String oldValue = var26_35.getStringValue(cleanedPath);
                String newValue = newFile.getStringValue(path);
                String englishValue = english.getStringValue(cleanedPath);
                if (oldValue != null && oldValue.contains("{1} {0}")) {
                    System.out.print("");
                }
                if (GenerateComparison.equals(newValue, oldValue)) continue;
                CLDRFile.Status newStatus = new CLDRFile.Status();
                String newFoundLocale = GenerateComparison.getStatus(newFile, newRoot, path, newValue, newStatus);
                boolean isAliased = false;
                if (!newStatus.pathWhereFound.equals(path)) {
                    isAliased = true;
                }
                if (!newFoundLocale.equals(locale)) {
                    isAliased = true;
                }
                if (isAliased && !SHOW_ALIASED) continue;
                String newFullPath = newFile.getFullXPath(path);
                boolean bl = reject = newFullPath != null && newFullPath.contains("@draft") && !newFullPath.contains("@draft=\"contributed\"");
                Object status = reject ? "NOT-ACC" : (newValue == null ? "deleted" : (oldValue == null ? "added" : "changed"));
                String coreStatus = status;
                if (isAliased) {
                    status = "I+" + (String)status;
                }
                fileCounter.increment((String)status);
                totalCounter.increment(status);
                String pretty_sort = prettyPathMaker.getPrettyPath(cleanedPath);
                String[] prettyPartsSort = pretty_sort.split("[|]");
                if (prettyPartsSort.length != 3) {
                    System.out.println("Bad pretty path: " + pretty_sort + ", original: " + cleanedPath);
                }
                String prettySort1 = prettyPartsSort[0];
                String prettySort2 = prettyPartsSort[1];
                String prettySort3 = prettyPartsSort[2];
                String pretty = prettyPathMaker.getOutputForm(pretty_sort);
                String escapedPath = "http://unicode.org/cldr/apps/survey?_=" + locale + "&xpath=" + EscapingUtilities.urlEscape(cleanedPath);
                String[] prettyParts = pretty.split("[|]");
                if (prettyParts.length != 3) {
                    System.out.println("Bad pretty path: " + pretty + ", original: " + cleanedPath);
                }
                String pretty1 = prettyParts[0];
                String pretty2 = prettyParts[1];
                String pretty3 = prettyParts[2];
                table.addRow().addCell((Comparable)((Object)prettySort1)).addCell((Comparable)((Object)prettySort2)).addCell((Comparable)((Object)prettySort3)).addCell((Comparable)((Object)escapedPath)).addCell((Comparable)((Object)(isAliased ? "I" : ""))).addCell((Comparable)((Object)pretty1)).addCell((Comparable)((Object)pretty2)).addCell((Comparable)((Object)pretty3)).addCell((Comparable)((Object)(englishValue == null ? "-" : englishValue))).addCell((Comparable)((Object)coreStatus)).addCell((Comparable)((Object)(oldValue == null ? "-" : oldValue))).addCell((Comparable)((Object)(newValue == null ? "-" : newValue))).finishRow();
                ++totalDifferences;
                ++differences;
            }
            GenerateComparison.addToIndex(indexInfo, "", locale, localeName, fileCounter);
            PrintWriter out = FileUtilities.openUTF8Writer(changesDirectory, locale + ".html");
            String title = "Changes in " + localeDisplayName;
            out.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>" + title + "</title>\n<link rel='stylesheet' href='index.css' type='text/css'>\n<base target='_blank'>\n</head><body>\n<h1>" + title + "</h1>\n<a href='index.html'>Index</a> | <a href=\"http://unicode.org/cldr/data/docs/survey/vetting.html\"><b style=\"background-color: yellow;\"><i>Help: How to Vet</i></b></a><p><b>Warning: this chart is still under development. For how to use it, see <a href=\"http://unicode.org/cldr/data/docs/survey/vetting.html\">Help: How to Vet</a>.</b></p>");
            TablePrinter table2 = new TablePrinter().setCaption("Totals").addColumn("Inh.").setSortPriority(0).addColumn("Status").setSortPriority(1).addColumn("Total");
            for (String key : fileCounter.getKeysetSortedByKey()) {
                boolean inherited = key.startsWith("I+");
                table2.addRow().addCell((Comparable)((Object)(inherited ? "I" : ""))).addCell((Comparable)((Object)(inherited ? key.substring(2) : key))).addCell((Comparable)((Object)format.format(fileCounter.getCount(key)))).finishRow();
            }
            out.println(table2);
            out.println("<br>");
            out.println(table);
            System.out.println(locale + "\tDifferences:\t" + format.format(differences) + "\tPaths:\t" + format.format(paths.size()) + "\tTime:\t" + timer);
            totalPaths += (long)paths.size();
            out.println(ShowData.dateFooter());
            out.println(CldrUtility.ANALYTICS);
            out.println("</body></html>");
            out.close();
        }
        PrintWriter indexFile = FileUtilities.openUTF8Writer(changesDirectory, "index.html");
        indexFile.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>Change Summary</title>\n<link rel='stylesheet' href='index.css' type='text/css'>\n<base target='_blank'>\n</head><body>\n<h1>Change Summary</h1>\n<a href=\"http://unicode.org/cldr/data/docs/survey/vetting.html\"><b style=\"background-color: yellow;\"><i>Help: How to Vet</i></b></a><p><b>Warning: this chart is still under development. For how to use it, see <a href=\"http://unicode.org/cldr/data/docs/survey/vetting.html\">Help: How to Vet</a>.</b></p><table><tr>");
        String string = "";
        int last = 0;
        for (Row.R2 r2 : indexInfo) {
            void var23_26;
            int firstChar = ((String)r2.get0()).codePointAt(0);
            indexFile.append((CharSequence)(firstChar == last ? var23_26 : (last == 0 ? "" : "</td></tr>\n<tr>") + "<th>" + String.valueOf((char)firstChar) + "</th><td>")).append((CharSequence)r2.get1());
            String string2 = " | ";
            last = ((String)r2.get0()).codePointAt(0);
        }
        indexFile.println("</tr></table>");
        indexFile.println(ShowData.dateFooter());
        indexFile.println(CldrUtility.ANALYTICS);
        indexFile.println("</body></html>");
        indexFile.close();
        System.out.println();
        for (String string3 : totalCounter.getKeysetSortedByKey()) {
            System.out.println(string3 + "\t" + totalCounter.getCount(string3));
        }
        System.out.println("Total Differences:\t" + format.format(totalDifferences) + "\tPaths:\t" + format.format(totalPaths) + "\tTotal Time:\t" + format.format(totalTimer.getDuration()) + "ms");
    }

    private static void addToIndex(Set<Row.R2<String, String>> indexInfo, String title, String locale, String localeName) {
        GenerateComparison.addToIndex(indexInfo, title, locale, localeName, null);
    }

    private static void addToIndex(Set<Row.R2<String, String>> indexInfo, String title, String locale, String localeName, Counter<String> fileCounter) {
        if (title.startsWith("ERROR")) {
            indexInfo.add(Row.R2.of(localeName, title + " " + localeName + " (" + locale + ")"));
            return;
        }
        Object counterString = "";
        if (fileCounter != null) {
            for (String s2 : fileCounter) {
                if (((String)counterString).length() != 0) {
                    counterString = (String)counterString + "; ";
                }
                counterString = (String)counterString + s2.charAt(0) + ":" + format.format(fileCounter.getCount(s2));
            }
        }
        indexInfo.add(Row.R2.of(localeName, "<a href='" + locale + ".html'>" + title + localeName + " (" + locale + ")</a>" + (String)(((String)counterString).length() == 0 ? "" : " [" + (String)counterString + "]")));
    }

    private static String getStatus(CLDRFile oldFile, CLDRFile oldRoot, String path, String oldString, CLDRFile.Status oldStatus) {
        String oldRootValue;
        String oldLocale = oldFile.getSourceLocaleID(path, oldStatus);
        if (!oldLocale.equals("root") && GenerateComparison.equals(oldString, oldRootValue = oldRoot.getStringValue(oldStatus.pathWhereFound))) {
            oldLocale = "root";
        }
        return oldLocale;
    }

    private static void showSet(PrintWriter out, Set<Row.R2<String, String>> rejected, String locale, String title) {
        if (rejected.size() != 0) {
            out.println();
            out.println(locale + "\t" + title + "\t" + rejected.size());
            for (Row.R2<String, String> prettyAndline : rejected) {
                out.println((String)prettyAndline.get1());
            }
        }
    }

    private static boolean equals(String newString, String oldString) {
        if (newString == null) {
            return oldString == null;
        }
        return newString.equals(oldString);
    }

    static {
        collator = CollatorHelper.ROOT_COLLATOR;
        ENG = new EnglishRowComparator();
    }

    static class EnglishRowComparator
    implements Comparator<Row.R2<String, String>> {
        private static Comparator<String> unicode = new UTF16.StringComparator(true, false, 0);

        EnglishRowComparator() {
        }

        @Override
        public int compare(Row.R2<String, String> arg0, Row.R2<String, String> arg1) {
            int result = collator.compare((String)arg0.get0(), (String)arg1.get0());
            if (result != 0) {
                return result;
            }
            result = unicode.compare((String)arg0.get0(), (String)arg1.get0());
            if (result != 0) {
                return result;
            }
            result = collator.compare((String)arg0.get1(), (String)arg1.get1());
            if (result != 0) {
                return result;
            }
            result = unicode.compare((String)arg0.get1(), (String)arg1.get1());
            return result;
        }
    }
}

