/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.icu.impl.Pair;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.IslamicCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;

public class GenerateDateTimeTestData {
    private static final String OUTPUT_SUBDIR = "datetime";
    private static final String OUTPUT_FILENAME = "datetime.json";
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = SupplementalDataInfo.getInstance();
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final Factory CLDR_FACTORY = CLDR_CONFIG.getCldrFactory();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ImmutableSet<String> NUMBERING_SYSTEMS = ImmutableSet.of("latn", "arab", "beng");
    private static final ImmutableSet<String> LOCALES = ImmutableSet.of("en_US", "en_GB", "zh_Hant_TW", "vi", "ar", "mt_MT", new String[]{"bn", "zu"});
    private static final ImmutableSet<String> CALENDARS = ImmutableSet.of("gregorian", "buddhist", "hebrew", "chinese", "roc", "japanese", new String[]{"islamic", "islamic-umalqura", "persian"});
    private static final ImmutableSet<String> TIME_ZONES = ImmutableSet.of("America/Los_Angeles", "Africa/Luanda", "Asia/Tehran", "Europe/Kiev", "Australia/Brisbane", "Pacific/Palau", new String[]{"America/Montevideo"});
    private static final ImmutableSet<ZonedDateTime> JAVA_TIME_ZONED_DATE_TIMES = ImmutableSet.of(LocalDate.parse("2024-03-17").atStartOfDay(ZoneId.of(ZoneOffset.UTC.getId())), Instant.parse("2001-07-02T13:14:15.00Z").atZone(ZoneOffset.UTC), Instant.parse("1984-05-29T07:53:00.00Z").atZone(ZoneOffset.UTC), Instant.parse("2050-05-29T16:47:00.00Z").atZone(ZoneOffset.UTC), LocalDate.parse("1969-07-16").atStartOfDay(ZoneId.of(ZoneOffset.UTC.getId())), Instant.ofEpochMilli(1000000000L).atZone(ZoneOffset.UTC), new ZonedDateTime[]{Instant.ofEpochMilli(1000000000000L).atZone(ZoneOffset.UTC)});
    private static final ImmutableSet<ImmutableMap<Object, Object>> TEMPORAL_DATES = ImmutableSet.of(GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2024).put("month", 3).put("day", 7).put("hour", 0).put("minute", 0).put("second", 1).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).put("calendar", "gregory").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2001).put("month", 7).put("day", 2).put("hour", 13).put("minute", 14).put("second", 15).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 1984).put("month", 5).put("day", 29).put("hour", 7).put("minute", 53).put("second", 0).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2030).put("month", 5).put("day", 29).put("hour", 16).put("minute", 47).put("second", 0).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 1969).put("month", 7).put("day", 16).put("hour", 0).put("minute", 0).put("second", 0).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 1970).put("month", 1).put("day", 12).put("hour", 13).put("minute", 46).put("second", 40).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), new ImmutableMap[]{GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2001).put("month", 9).put("day", 9).put("hour", 1).put("minute", 46).put("second", 40).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build()});
    private static final Pattern SKELETON_YEAR_FIELD_PATTERN = Pattern.compile("y+");
    private static final Pattern SKELETON_ERA_FIELD_PATTERN = Pattern.compile("G+");
    private static final Pattern SKELETON_MONTH_FIELD_PATTERN = Pattern.compile("M+");
    private static final Pattern SKELETON_DAY_FIELD_PATTERN = Pattern.compile("d+");

    private static final ImmutableMap.Builder<Object, Object> newMapStringToObjectBuilder() {
        return ImmutableMap.builder();
    }

    private static final ImmutableMap.Builder<Object, ImmutableMap<Object, Object>> newMapStringToMapBuilder() {
        return ImmutableMap.builder();
    }

    private static Set<String> getLocaleNumberingSystems(CLDRFile localeFile) {
        HashSet<String> result = new HashSet<String>();
        for (CLDRFile.NumberingSystem system : CLDRFile.NumberingSystem.values()) {
            String numberingSystem;
            String string = numberingSystem = system.path == null ? "latn" : localeFile.getStringValue(system.path);
            if (numberingSystem == null) continue;
            result.add(numberingSystem);
        }
        return result;
    }

    private static ZonedDateTime getZonedDateTimeFromTemporalDateInput(Map<Object, Object> input) {
        if (!input.containsKey("year")) {
            return null;
        }
        if (!input.containsKey("month")) {
            return null;
        }
        if (!input.containsKey("day")) {
            return null;
        }
        if (input.containsKey("calendar") && !((String)input.get("calendar")).equals("gregory")) {
            return null;
        }
        int year = (Integer)input.get("year");
        int monthInt = (Integer)input.get("month");
        int day = (Integer)input.get("day");
        Month month = Month.of(monthInt);
        int hour = (Integer)input.getOrDefault("hour", 0);
        int minute = (Integer)input.getOrDefault("minute", 0);
        int second = (Integer)input.getOrDefault("second", 0);
        int millisecond = (Integer)input.getOrDefault("millisecond", 0);
        int microsecond = (Integer)input.getOrDefault("microsecond", 0);
        int nanosecondOrig = (Integer)input.getOrDefault("nanosecond", 0);
        int nanosecond = (millisecond * 1000 + microsecond) * 1000 + nanosecondOrig;
        String timeZoneIdStr = (String)input.getOrDefault("timeZone", "UTC");
        ZoneId timeZoneId = ZoneId.of(timeZoneIdStr);
        LocalDateTime localDt = LocalDateTime.of(year, month, day, hour, minute, second, nanosecond);
        return ZonedDateTime.of(localDt, timeZoneId);
    }

    public static final Optional<CLDRFile> getCLDRFile(String locale) {
        CLDRFile cldrFile = CLDR_FACTORY.make(locale, true, CLDRFile.DraftStatus.contributed);
        Level coverageLevel = CalculatedCoverageLevels.getInstance().getEffectiveCoverageLevel(locale);
        if (coverageLevel == null || !coverageLevel.isAtLeast(Level.MODERN)) {
            return Optional.empty();
        }
        return Optional.of(cldrFile);
    }

    private static String getDateLength(Map<Object, Object> optionsMap) {
        String length = null;
        if (optionsMap.containsKey("dateLength")) {
            length = (String)optionsMap.get("dateLength");
        }
        return length;
    }

    private static String getTimeLength(Map<Object, Object> optionsMap) {
        String length = null;
        if (optionsMap.containsKey("timeLength")) {
            length = (String)optionsMap.get("timeLength");
        }
        return length;
    }

    private static String getExpectedStringForTestCase(ICUServiceBuilder icuServiceBuilder, CLDRFile localeCldrFile, String calendar, TimeZone icuTimeZone, ZonedDateTime zdt, String timeLength, String dateLength, String dateTimeGluePatternFormatType) {
        String formattedDateTime;
        SimpleDateFormat timeFormatter = null;
        SimpleDateFormat dateFormatter = null;
        if (timeLength != null) {
            timeFormatter = localeCldrFile.getTimeFormat(calendar, timeLength, icuServiceBuilder);
            assert (timeFormatter != null);
            timeFormatter.setTimeZone(icuTimeZone);
        }
        if (dateLength != null) {
            dateFormatter = localeCldrFile.getDateFormat(calendar, dateLength, icuServiceBuilder);
            assert (dateFormatter != null);
            dateFormatter.setTimeZone(icuTimeZone);
        }
        if (dateLength == null) {
            formattedDateTime = timeFormatter.format(zdt);
        } else if (timeLength == null) {
            formattedDateTime = dateFormatter.format(zdt);
        } else {
            assert (dateTimeGluePatternFormatType != null);
            String formattedDate = dateFormatter.format(zdt);
            String formattedTime = timeFormatter.format(zdt);
            formattedDateTime = localeCldrFile.glueDateTimeFormat(formattedDate, formattedTime, calendar, dateLength, dateTimeGluePatternFormatType, icuServiceBuilder);
        }
        return formattedDateTime;
    }

    private static ImmutableSet<FieldStyleComboInput> getFieldStyleComboInputs() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FieldStyleComboInput elem = new FieldStyleComboInput();
        elem.fieldStyleCombo.timeStyle = TimeStyle.SHORT;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.dateStyle = DateStyle.MEDIUM;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.dateStyle = DateStyle.FULL;
        elem.fieldStyleCombo.timeStyle = TimeStyle.SHORT;
        elem.fieldStyleCombo.dateTimeFormatType = DateTimeFormatType.AT_TIME;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.dateStyle = DateStyle.FULL;
        elem.fieldStyleCombo.timeStyle = TimeStyle.SHORT;
        elem.fieldStyleCombo.dateTimeFormatType = DateTimeFormatType.STANDARD;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.dateStyle = DateStyle.SHORT;
        elem.fieldStyleCombo.timeStyle = TimeStyle.FULL;
        elem.fieldStyleCombo.dateTimeFormatType = DateTimeFormatType.AT_TIME;
        elem.shouldMultiplyByTimeZone = true;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.YMDE;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.YMDE;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.MEDIUM;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.YMDE;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.YMDE;
        elem.fieldStyleCombo.yearStyle = YearStyle.WITH_ERA;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.YMDE;
        elem.fieldStyleCombo.yearStyle = YearStyle.WITH_ERA;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.MEDIUM;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.YMDE;
        elem.fieldStyleCombo.yearStyle = YearStyle.WITH_ERA;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.SPECIFIC;
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.Z;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.LOCATION;
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.Z;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.GENERIC;
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.Z;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.OFFSET;
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.Z;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.SPECIFIC;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.SPECIFIC;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.LOCATION;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.LOCATION;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.GENERIC;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.GENERIC;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.OFFSET;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.MDTZ;
        elem.fieldStyleCombo.zoneStyle = ZoneStyle.OFFSET;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByTimeZone = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.M;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.T;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.T;
        elem.fieldStyleCombo.hourCycle = HourCycle.H12;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.SHORT;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.T;
        elem.fieldStyleCombo.hourCycle = HourCycle.H12;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.MEDIUM;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.T;
        elem.fieldStyleCombo.hourCycle = HourCycle.H12;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        elem = new FieldStyleComboInput();
        elem.fieldStyleCombo = new FieldStyleCombo();
        elem.fieldStyleCombo.semanticSkeleton = SemanticSkeleton.T;
        elem.fieldStyleCombo.hourCycle = HourCycle.H23;
        elem.fieldStyleCombo.semanticSkeletonLength = SemanticSkeletonLength.LONG;
        elem.shouldMultiplyByDateTime = true;
        builder.add(elem);
        return builder.build();
    }

    private static String getFieldFromDateTimeSkeleton(CLDRFile localeCldrFile, FieldStyleCombo fieldStyleCombo, String calendarStr, Pattern fieldPattern) {
        String skeletonLength = fieldStyleCombo.semanticSkeletonLength.getLabel();
        String dateTimeSkeleton = localeCldrFile.getDateSkeleton(calendarStr, skeletonLength);
        Matcher fieldMatchResult = fieldPattern.matcher(dateTimeSkeleton);
        if (fieldMatchResult.find()) {
            String field = fieldMatchResult.group();
            return field;
        }
        return "";
    }

    public static String computeSkeletonFromSemanticSkeleton(ICUServiceBuilder icuServiceBuilder, CLDRFile localeCldrFile, FieldStyleCombo fieldStyleCombo, String calendarStr) {
        SemanticSkeleton skeleton = fieldStyleCombo.semanticSkeleton;
        StringBuilder sb = new StringBuilder();
        if (skeleton.hasYear()) {
            String year = GenerateDateTimeTestData.getFieldFromDateTimeSkeleton(localeCldrFile, fieldStyleCombo, calendarStr, SKELETON_YEAR_FIELD_PATTERN);
            String era = GenerateDateTimeTestData.getFieldFromDateTimeSkeleton(localeCldrFile, fieldStyleCombo, calendarStr, SKELETON_ERA_FIELD_PATTERN);
            String updatedYear = year;
            String updatedEra = era;
            YearStyle yearStyle = fieldStyleCombo.yearStyle;
            if (yearStyle != null) {
                switch (yearStyle) {
                    case AUTO: {
                        updatedYear = year;
                        updatedEra = era;
                        break;
                    }
                    case FULL: {
                        updatedYear = year.replace("yy", "y");
                        updatedEra = era;
                        break;
                    }
                    case WITH_ERA: {
                        updatedYear = year.replace("yy", "y");
                        updatedEra = era.isEmpty() ? "G" : era;
                    }
                }
            }
            String updatedYearEra = updatedEra + updatedYear;
            sb.append(updatedYearEra);
        }
        if (skeleton.hasMonth()) {
            if (skeleton.isStandalone()) {
                switch (fieldStyleCombo.semanticSkeletonLength) {
                    case LONG: {
                        sb.append("LLLL");
                        break;
                    }
                    case MEDIUM: {
                        sb.append("LLL");
                        break;
                    }
                    case SHORT: {
                        sb.append("L");
                        break;
                    }
                }
            } else {
                sb.append(GenerateDateTimeTestData.getFieldFromDateTimeSkeleton(localeCldrFile, fieldStyleCombo, calendarStr, SKELETON_MONTH_FIELD_PATTERN));
            }
        }
        if (skeleton.hasDay()) {
            sb.append(GenerateDateTimeTestData.getFieldFromDateTimeSkeleton(localeCldrFile, fieldStyleCombo, calendarStr, SKELETON_DAY_FIELD_PATTERN));
        }
        if (skeleton.hasWeekday()) {
            switch (fieldStyleCombo.semanticSkeletonLength) {
                case LONG: {
                    sb.append("EEEE");
                    break;
                }
                case MEDIUM: {
                    sb.append("EEE");
                    break;
                }
                case SHORT: {
                    if (skeleton.isStandalone()) {
                        sb.append("EEEEE");
                        break;
                    }
                    sb.append("EEE");
                    break;
                }
            }
        }
        if (skeleton.hasTime()) {
            if (fieldStyleCombo.hourCycle == null) {
                sb.append("j");
            } else {
                switch (fieldStyleCombo.hourCycle) {
                    case H12: {
                        sb.append("h");
                        break;
                    }
                    case H23: {
                        sb.append("H");
                    }
                }
            }
            sb.append("m");
            sb.append("s");
        }
        if (skeleton.hasZone()) {
            switch (fieldStyleCombo.zoneStyle) {
                case GENERIC: {
                    if (skeleton.isStandalone()) {
                        if (fieldStyleCombo.semanticSkeletonLength == SemanticSkeletonLength.SHORT) {
                            sb.append("v");
                            break;
                        }
                        sb.append("vvvv");
                        break;
                    }
                    sb.append("v");
                    break;
                }
                case SPECIFIC: {
                    if (skeleton.isStandalone()) {
                        if (fieldStyleCombo.semanticSkeletonLength == SemanticSkeletonLength.SHORT) {
                            sb.append("z");
                            break;
                        }
                        sb.append("zzzz");
                        break;
                    }
                    sb.append("z");
                    break;
                }
                case LOCATION: {
                    sb.append("VVVV");
                    break;
                }
                case OFFSET: {
                    sb.append("O");
                    break;
                }
            }
        }
        return sb.toString();
    }

    private static TestCase convertTestCaseInputToTestCase(ICUServiceBuilder icuServiceBuilder, CLDRFile localeCldrFile, TestCaseInput testCaseInput) {
        String calendarStr = testCaseInput.calendar.getType();
        String dateLength = testCaseInput.fieldStyleCombo.dateStyle == null ? null : testCaseInput.fieldStyleCombo.dateStyle.getLabel();
        String timeLength = testCaseInput.fieldStyleCombo.timeStyle == null ? null : testCaseInput.fieldStyleCombo.timeStyle.getLabel();
        LocalDateTime localDt = testCaseInput.dateTime;
        TimeZone icuTimeZone = testCaseInput.timeZone;
        ZoneId zoneId = ZoneId.of(icuTimeZone.getID());
        ZonedDateTime zdt = ZonedDateTime.of(localDt, zoneId);
        String dateTimeGluePatternFormatType = testCaseInput.fieldStyleCombo.dateTimeFormatType == null ? null : testCaseInput.fieldStyleCombo.dateTimeFormatType.getLabel();
        String expected = GenerateDateTimeTestData.getExpectedStringForTestCase(icuServiceBuilder, localeCldrFile, calendarStr, icuTimeZone, zdt, timeLength, dateLength, dateTimeGluePatternFormatType);
        TestCase result = new TestCase();
        result.testCaseInput = testCaseInput;
        result.expected = expected;
        return result;
    }

    private static TestCase computeTestCase(ICUServiceBuilder icuServiceBuilder, CLDRFile localeCldrFile, TestCaseInput testCaseInput) {
        if (testCaseInput.fieldStyleCombo.semanticSkeleton == null) {
            return GenerateDateTimeTestData.convertTestCaseInputToTestCase(icuServiceBuilder, localeCldrFile, testCaseInput);
        }
        String calendarStr = testCaseInput.calendar.getType();
        String skeleton = GenerateDateTimeTestData.computeSkeletonFromSemanticSkeleton(icuServiceBuilder, localeCldrFile, testCaseInput.fieldStyleCombo, calendarStr);
        DateTimeFormats formats = new DateTimeFormats().set(localeCldrFile, calendarStr);
        SimpleDateFormat formatterForSkeleton = formats.getDateFormatFromSkeleton(skeleton);
        formatterForSkeleton.setCalendar(testCaseInput.calendar);
        formatterForSkeleton.setTimeZone(testCaseInput.timeZone);
        String timeZoneIdStr = testCaseInput.timeZone.getID();
        ZoneId timeZoneId = ZoneId.of(timeZoneIdStr);
        ZonedDateTime zdt = ZonedDateTime.of(testCaseInput.dateTime, timeZoneId);
        String formattedDateTime = formatterForSkeleton.format(zdt);
        TestCase result = new TestCase();
        result.testCaseInput = testCaseInput;
        result.classicalSkeleton = skeleton;
        result.expected = formattedDateTime;
        return result;
    }

    public static ImmutableSet<TestCase> getKernelTestCases() {
        List<Pair<ULocale, JapaneseCalendar>> LOCALE_CALENDAR_PAIRS = List.of(Pair.of(ULocale.ENGLISH, new GregorianCalendar()), Pair.of(ULocale.forLanguageTag("ar-SA"), new IslamicCalendar()), Pair.of(ULocale.forLanguageTag("th-TH"), new BuddhistCalendar()), Pair.of(ULocale.forLanguageTag("ja-JP"), new JapaneseCalendar()));
        List<LocalDateTime> DATE_TIMES = List.of(LocalDateTime.of(2000, 1, 1, 0, 0, 0), LocalDateTime.of(2024, 7, 1, 8, 50, 7), LocalDateTime.of(2014, 7, 15, 12, 0, 0));
        List<LocalDateTime> DATE_TIME_ONE_ONLY = List.of(DATE_TIMES.get(0));
        List<TimeZone> STATIC_TIME_ZONES = List.of(TimeZone.GMT_ZONE, TimeZone.getTimeZone("Australia/Adelaide"));
        List<TimeZone> STATIC_TIME_ZONE_ONE_ONLY = List.of(STATIC_TIME_ZONES.get(0));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Pair<ULocale, JapaneseCalendar> localeCalendarPair : LOCALE_CALENDAR_PAIRS) {
            ULocale locale = (ULocale)localeCalendarPair.first;
            Calendar calendar = (Calendar)localeCalendarPair.second;
            String localeStr = locale.getName();
            CLDRFile localeCldrFile = GenerateDateTimeTestData.getCLDRFile(localeStr).orElse(null);
            if (localeCldrFile == null) continue;
            ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
            icuServiceBuilder.clearCache();
            icuServiceBuilder.setCldrFile(localeCldrFile);
            for (FieldStyleComboInput input : GenerateDateTimeTestData.getFieldStyleComboInputs()) {
                assert (input.shouldMultiplyByDateTime || input.shouldMultiplyByTimeZone);
                FieldStyleCombo fieldStyleCombo = input.fieldStyleCombo;
                List<LocalDateTime> dateTimeIterationColl = DATE_TIME_ONE_ONLY;
                if (input.shouldMultiplyByDateTime) {
                    dateTimeIterationColl = DATE_TIMES;
                }
                List<TimeZone> timeZoneIterationColl = STATIC_TIME_ZONE_ONE_ONLY;
                if (input.shouldMultiplyByTimeZone) {
                    timeZoneIterationColl = STATIC_TIME_ZONES;
                }
                for (LocalDateTime localDateTime : dateTimeIterationColl) {
                    for (TimeZone timeZone : timeZoneIterationColl) {
                        TestCaseInput testCaseInput = new TestCaseInput();
                        testCaseInput.fieldStyleCombo = fieldStyleCombo;
                        testCaseInput.dateTime = localDateTime;
                        testCaseInput.timeZone = timeZone;
                        testCaseInput.locale = locale;
                        testCaseInput.calendar = calendar;
                        TestCase testCase = GenerateDateTimeTestData.computeTestCase(icuServiceBuilder, localeCldrFile, testCaseInput);
                        builder.add(testCase);
                    }
                }
            }
        }
        return builder.build();
    }

    private static TestCaseSerde convertTestCaseToSerialize(TestCase testCase) {
        TestCaseSerde result = new TestCaseSerde();
        result.dateLength = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.dateStyle).map(DateStyle::getLabel).orElse(null);
        result.timeLength = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.timeStyle).map(TimeStyle::getLabel).orElse(null);
        result.semanticSkeleton = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.semanticSkeleton).map(SemanticSkeleton::getLabel).orElse(null);
        result.semanticSkeletonLength = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.semanticSkeletonLength).map(SemanticSkeletonLength::getLabel).orElse(null);
        result.classicalSkeleton = testCase.classicalSkeleton;
        result.dateTimeFormatType = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.dateTimeFormatType).map(DateTimeFormatType::getLabel).orElse(null);
        result.hourCycle = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.hourCycle).map(HourCycle::getLabel).orElse(null);
        result.zoneStyle = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.zoneStyle).map(ZoneStyle::getLabel).orElse(null);
        result.yearStyle = Optional.ofNullable(testCase.testCaseInput.fieldStyleCombo.yearStyle).map(YearStyle::getLabel).orElse(null);
        result.calendar = testCase.testCaseInput.calendar.getType();
        result.locale = testCase.testCaseInput.locale.toLanguageTag();
        LocalDateTime localDt = testCase.testCaseInput.dateTime;
        TimeZone icuTimeZone = testCase.testCaseInput.timeZone;
        ZoneId zoneId = ZoneId.of(icuTimeZone.getID());
        ZonedDateTime zdt = ZonedDateTime.of(localDt, zoneId);
        result.input = zdt.toString();
        result.expected = testCase.expected;
        return result;
    }

    public static void main(String[] args) throws IOException {
        try (TempPrintWriter pw = TempPrintWriter.openUTF8Writer(CLDRPaths.TEST_DATA + OUTPUT_SUBDIR, OUTPUT_FILENAME);){
            ImmutableSet<TestCase> testCases = GenerateDateTimeTestData.getKernelTestCases();
            List testCaseSerdes = testCases.stream().map(GenerateDateTimeTestData::convertTestCaseToSerialize).collect(Collectors.toList());
            pw.println(GSON.toJson(testCaseSerdes));
        }
    }

    static class TestCaseSerde {
        String dateLength = null;
        String timeLength = null;
        String semanticSkeleton = null;
        String semanticSkeletonLength = null;
        String classicalSkeleton = null;
        String dateTimeFormatType = null;
        String hourCycle = null;
        String zoneStyle = null;
        String yearStyle = null;
        String calendar = null;
        String locale = null;
        String input = null;
        String expected = null;

        TestCaseSerde() {
        }
    }

    static class TestCase {
        TestCaseInput testCaseInput;
        String classicalSkeleton;
        String expected;

        TestCase() {
        }
    }

    static class TestCaseInput {
        FieldStyleCombo fieldStyleCombo;
        LocalDateTime dateTime;
        TimeZone timeZone;
        ULocale locale;
        Calendar calendar;

        TestCaseInput() {
        }
    }

    static class FieldStyleComboInput {
        FieldStyleCombo fieldStyleCombo = new FieldStyleCombo();
        boolean shouldMultiplyByTimeZone;
        boolean shouldMultiplyByDateTime;

        FieldStyleComboInput() {
        }
    }

    static class FieldStyleCombo {
        SemanticSkeleton semanticSkeleton;
        SemanticSkeletonLength semanticSkeletonLength;
        DateStyle dateStyle;
        TimeStyle timeStyle;
        HourCycle hourCycle;
        ZoneStyle zoneStyle;
        YearStyle yearStyle;
        DateTimeFormatType dateTimeFormatType;

        FieldStyleCombo() {
        }
    }

    static enum ZoneStyle {
        SPECIFIC("specific"),
        GENERIC("generic"),
        LOCATION("location"),
        OFFSET("offset");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private ZoneStyle(String label) {
            this.label = label;
        }
    }

    static enum YearStyle {
        AUTO("auto"),
        FULL("full"),
        WITH_ERA("with_era");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private YearStyle(String label) {
            this.label = label;
        }
    }

    static enum HourCycle {
        H12("H12"),
        H23("H23");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private HourCycle(String label) {
            this.label = label;
        }
    }

    static enum SemanticSkeleton {
        YMDE("YMDE"),
        MDTZ("MDTZ"),
        M("M"),
        T("T"),
        Z("Z");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private SemanticSkeleton(String label) {
            this.label = label;
        }

        public boolean hasYear() {
            return this == YMDE;
        }

        public boolean hasMonth() {
            return this == YMDE || this == MDTZ || this == M;
        }

        public boolean hasDay() {
            return this == YMDE || this == MDTZ;
        }

        public boolean hasWeekday() {
            return this == YMDE;
        }

        public boolean hasTime() {
            return this == MDTZ || this == T;
        }

        public boolean hasZone() {
            return this == MDTZ || this == Z;
        }

        public boolean isStandalone() {
            return this == M || this == T || this == Z;
        }
    }

    static enum SemanticSkeletonLength {
        SHORT("short"),
        MEDIUM("medium"),
        LONG("long");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private SemanticSkeletonLength(String label) {
            this.label = label;
        }
    }

    static enum TimeStyle {
        SHORT("short"),
        MEDIUM("medium"),
        LONG("long"),
        FULL("full");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private TimeStyle(String label) {
            this.label = label;
        }
    }

    static enum DateStyle {
        SHORT("short"),
        MEDIUM("medium"),
        LONG("long"),
        FULL("full");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private DateStyle(String label) {
            this.label = label;
        }
    }

    static enum DateTimeFormatType {
        STANDARD("standard"),
        AT_TIME("atTime");

        public final String label;

        String getLabel() {
            return this.label;
        }

        private DateTimeFormatType(String label) {
            this.label = label;
        }
    }
}

