/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.unicode.cldr.util.CLDRPaths;

public class GenerateKeyboardCharts {
    static final String SUBDIR = "keyboards";
    static IOException copyErr = null;

    public static void main(String[] args) throws IOException {
        File mainDir = new File(CLDRPaths.CHART_DIRECTORY);
        if (mainDir.mkdirs()) {
            System.err.println("Created: " + mainDir);
        }
        if (!mainDir.isDirectory()) {
            throw new IOException("Main dir doesn't exist: " + mainDir);
        }
        File kbdDir = new File(CLDRPaths.BASE_DIRECTORY, "docs/charts/keyboards");
        if (!kbdDir.exists()) {
            throw new IOException("Keyboards root dir doesn't exist: " + kbdDir);
        }
        File kbdStatic = new File(kbdDir, "static");
        File kbdStaticData = new File(kbdDir, "static/data");
        if (!kbdStaticData.exists()) {
            System.err.println("ERROR: " + kbdStaticData + " does not exist. Keyboard charts weren't run.");
            System.err.println("See " + new File(kbdDir, "README.md") + " for help.");
            return;
        }
        File staticTarg = new File(mainDir, "keyboards/static");
        File staticDataTarg = new File(mainDir, "keyboards/static/data");
        if (staticDataTarg.mkdirs()) {
            System.err.println("Created: " + staticDataTarg);
        }
        System.out.println("Copying: " + kbdStatic + " to " + staticTarg);
        Files.copy(new File(kbdDir, "index.html").toPath(), new File(mainDir, "keyboards/index.html").toPath(), StandardCopyOption.REPLACE_EXISTING);
        String kbdStaticPrefix = kbdStatic.getAbsolutePath();
        Files.walk(kbdStatic.toPath(), new FileVisitOption[0]).forEach(path -> {
            if (!path.toFile().isFile()) {
                return;
            }
            path.getParent().toFile().mkdirs();
            System.out.println(path.toFile().getAbsolutePath());
            String rel = path.toFile().getAbsolutePath().substring(kbdStaticPrefix.length());
            try {
                Path out = new File(staticTarg, rel).toPath();
                System.out.println(" -> " + out);
                Files.copy(path, out, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Error copying " + path);
                copyErr = new IOException("Error copying " + path, e);
            }
        });
        if (copyErr != null) {
            throw copyErr;
        }
    }
}

