/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.PluralMinimalPairs;
import org.unicode.cldr.tool.PluralRulesFactory;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PluralRanges;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;

public class GeneratePluralRanges {
    private static final boolean MINIMAL = true;
    private final SupplementalDataInfo SUPPLEMENTAL;
    private final PluralRulesFactory prf;
    private static final Comparator<Set<String>> STRING_SET_COMPARATOR = Comparator.comparing(Set::size).thenComparing(Comparators.lexicographical(Comparator.naturalOrder()));
    private static final Comparator<Set<SupplementalDataInfo.PluralInfo.Count>> COUNT_SET_COMPARATOR = Comparator.comparing(Set::size).thenComparing(Comparators.lexicographical(Comparator.naturalOrder()));

    public GeneratePluralRanges(SupplementalDataInfo supplementalDataInfo) {
        this.SUPPLEMENTAL = supplementalDataInfo;
        this.prf = PluralRulesFactory.getInstance(this.SUPPLEMENTAL);
    }

    public static void main(String[] args) {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        GeneratePluralRanges me = new GeneratePluralRanges(testInfo.getSupplementalDataInfo());
        me.reformatPluralRanges();
    }

    private void generateSamples(CLDRFile english, Factory factory) {
        TreeSet<String> sorted = new TreeSet<String>(this.SUPPLEMENTAL.getPluralRangesLocales());
        sorted.addAll(StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN)));
        LanguageTagParser ltp = new LanguageTagParser();
        for (String locale : this.SUPPLEMENTAL.getPluralLocales()) {
            if (!locale.contains("_") || !sorted.contains(ltp.set(locale).getLanguage())) continue;
            sorted.add(locale);
        }
        System.out.println("Co.\tLocale Name\tStart\tEnd\tResult\tStart Sample\tEnd Sample\tStart Example\tEnd Example\tCombined Example");
        for (String locale : sorted) {
            Set<SupplementalDataInfo.PluralInfo.Count> counts3;
            SupplementalDataInfo.PluralInfo pluralInfo2;
            SupplementalDataInfo.PluralInfo pluralInfo3 = this.SUPPLEMENTAL.getPlurals(locale);
            if (locale.contains("_") && (pluralInfo2 = this.SUPPLEMENTAL.getPlurals(ltp.set(locale).getLanguage())).equals(pluralInfo3) || (counts3 = pluralInfo3.getCounts()).size() == 1) continue;
            List<RangeSample> list = this.getRangeInfo(factory.make(locale, true));
            if (list == null) {
                System.out.println("Failure with " + locale);
                continue;
            }
            for (RangeSample rangeSample : list) {
                System.out.println(locale + "\t" + english.nameGetter().getNameFromIdentifier(locale) + "\t" + rangeSample.start + "\t" + rangeSample.end + "\t" + (Serializable)(rangeSample.result == null ? "missing" : rangeSample.result) + "\t" + rangeSample.min + "\t" + rangeSample.max + "\t" + rangeSample.startExample + "\t" + rangeSample.endExample + "\t" + rangeSample.resultExample);
            }
        }
    }

    public List<RangeSample> getRangeInfo(CLDRFile cldrFile) {
        String locale = cldrFile.getLocaleID();
        if (locale.equals("iw")) {
            locale = "he";
        }
        ArrayList<RangeSample> list = new ArrayList<RangeSample>();
        SupplementalDataInfo.PluralInfo pluralInfo = this.SUPPLEMENTAL.getPlurals(locale);
        Set<SupplementalDataInfo.PluralInfo.Count> counts = pluralInfo.getCounts();
        PluralRanges pluralRanges = this.SUPPLEMENTAL.getPluralRanges(locale);
        if (pluralRanges == null && locale.contains("_")) {
            String locale2 = new ULocale(locale).getLanguage();
            pluralRanges = this.SUPPLEMENTAL.getPluralRanges(locale2);
        }
        if (pluralRanges == null) {
            return null;
        }
        ULocale ulocale = new ULocale(locale);
        PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(ulocale.toString());
        Output<DecimalQuantity> maxSample = new Output<DecimalQuantity>();
        Output<DecimalQuantity> minSample = new Output<DecimalQuantity>();
        ICUServiceBuilder icusb = new ICUServiceBuilder();
        icusb.setCldrFile(cldrFile);
        DecimalFormat nf = icusb.getNumberFormat(1);
        String defaultNumberingSystem = cldrFile.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        String range = cldrFile.getWinningValue("//ldml/numbers/miscPatterns[@numberSystem=\"" + defaultNumberingSystem + "\"]/pattern[@type=\"range\"]");
        for (SupplementalDataInfo.PluralInfo.Count s2 : counts) {
            for (SupplementalDataInfo.PluralInfo.Count e : counts) {
                if (!pluralInfo.rangeExists(s2, e, minSample, maxSample)) continue;
                SupplementalDataInfo.PluralInfo.Count r = pluralRanges.getExplicit(s2, e);
                String minFormatted = GeneratePluralRanges.format(nf, (DecimalQuantity)minSample.value);
                String maxFormatted = GeneratePluralRanges.format(nf, (DecimalQuantity)maxSample.value);
                String rangeFormatted = MessageFormat.format(range, minFormatted, maxFormatted);
                list.add(new RangeSample(s2, e, r, (DecimalQuantity)minSample.value, (DecimalQuantity)maxSample.value, GeneratePluralRanges.getExample(locale, samplePatterns, s2, minFormatted), GeneratePluralRanges.getExample(locale, samplePatterns, e, maxFormatted), GeneratePluralRanges.getExample(locale, samplePatterns, r, rangeFormatted)));
            }
        }
        return list;
    }

    public static String format(DecimalFormat nf, DecimalQuantity minSample) {
        nf.setMinimumFractionDigits((int)minSample.getPluralOperand(PluralRules.Operand.v));
        nf.setMaximumFractionDigits((int)minSample.getPluralOperand(PluralRules.Operand.v));
        return nf.format(minSample);
    }

    public static String getExample(String locale, PluralMinimalPairs samplePatterns, SupplementalDataInfo.PluralInfo.Count r, String numString) {
        String samplePattern;
        if (r == null) {
            return "\u00abmissing\u00bb";
        }
        try {
            samplePattern = samplePatterns.get(PluralRules.PluralType.CARDINAL, r);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Locale: " + locale + "; Count: " + r, e);
        }
        return samplePattern.replace('\u00a0', ' ').replace("{0}", numString);
    }

    public void reformatPluralRanges() {
        TreeMap<Set<SupplementalDataInfo.PluralInfo.Count>, Relation<Set<String>, String>> seen = new TreeMap<Set<SupplementalDataInfo.PluralInfo.Count>, Relation<Set<String>, String>>(COUNT_SET_COMPARATOR);
        try (TempPrintWriter out = TempPrintWriter.openUTF8Writer(CLDRPaths.SUPPLEMENTAL_DIRECTORY, "pluralRanges.xml");){
            out.println(DtdType.supplementalData.header(MethodHandles.lookup().lookupClass()) + "\t<version number=\"$Revision$\" />\n\t<plurals>");
            for (String string : this.SUPPLEMENTAL.getPluralRangesLocales()) {
                PluralRanges pluralRanges = this.SUPPLEMENTAL.getPluralRanges(string);
                SupplementalDataInfo.PluralInfo pluralInfo = this.SUPPLEMENTAL.getPlurals(string);
                Set<SupplementalDataInfo.PluralInfo.Count> counts = pluralInfo.getCounts();
                Set<String> s2 = this.reformat(pluralRanges, counts);
                Relation<Set<String>, String> item = (Relation<Set<String>, String>)seen.get(counts);
                if (item == null) {
                    item = Relation.of(new TreeMap(STRING_SET_COMPARATOR), TreeSet.class);
                    seen.put(counts, item);
                }
                item.put(s2, string);
            }
            for (Map.Entry entry : seen.entrySet()) {
                out.println("\n<!-- " + Joiner.on(", ").join((Iterable)entry.getKey()) + " -->");
                for (Map.Entry entry2 : ((Relation)entry.getValue()).keyValuesSet()) {
                    out.println("\t\t<pluralRanges locales=\"" + Joiner.on(" ").join(entry2.getValue()) + "\">");
                    for (String line : (Set)entry2.getKey()) {
                        out.println("\t\t\t" + line);
                    }
                    out.println("\t\t</pluralRanges>");
                }
            }
            out.println("\t</plurals>\n</supplementalData>");
        }
    }

    public Set<String> reformat(PluralRanges pluralRanges, Set<SupplementalDataInfo.PluralInfo.Count> counts) {
        LinkedHashSet<String> s2 = new LinkedHashSet<String>();
        for (SupplementalDataInfo.PluralInfo.Count start : counts) {
            for (SupplementalDataInfo.PluralInfo.Count end : counts) {
                SupplementalDataInfo.PluralInfo.Count result = pluralRanges.getExplicit(start, end);
                if (result == null) continue;
                String line = PluralRanges.showRange(start, end, result);
                s2.add(line);
            }
        }
        return s2;
    }

    Set<String> minimize(PluralRanges pluralRanges, SupplementalDataInfo.PluralInfo pluralInfo) {
        SupplementalDataInfo.PluralInfo.Count r;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        PluralRanges.Matrix matrix = new PluralRanges.Matrix();
        Output<DecimalQuantity> maxSample = new Output<DecimalQuantity>();
        Output<DecimalQuantity> minSample = new Output<DecimalQuantity>();
        for (SupplementalDataInfo.PluralInfo.Count s2 : SupplementalDataInfo.PluralInfo.Count.VALUES) {
            for (SupplementalDataInfo.PluralInfo.Count e : SupplementalDataInfo.PluralInfo.Count.VALUES) {
                if (!pluralInfo.rangeExists(s2, e, minSample, maxSample)) continue;
                r = pluralRanges.getExplicit(s2, e);
                matrix.set(s2, e, r);
            }
        }
        EnumSet<SupplementalDataInfo.PluralInfo.Count> endDone = EnumSet.noneOf(SupplementalDataInfo.PluralInfo.Count.class);
        EnumSet<SupplementalDataInfo.PluralInfo.Count> startDone = EnumSet.noneOf(SupplementalDataInfo.PluralInfo.Count.class);
        for (Object end : pluralInfo.getCounts()) {
            r = matrix.endSame((SupplementalDataInfo.PluralInfo.Count)((Object)end));
            if (r == null) continue;
            result.add("<pluralRange              \t\tend=\"" + end + "\"\tresult=\"" + r + "\"/>");
            endDone.add((SupplementalDataInfo.PluralInfo.Count)((Object)end));
        }
        Output<Boolean> emit = new Output<Boolean>();
        for (SupplementalDataInfo.PluralInfo.Count start : pluralInfo.getCounts()) {
            SupplementalDataInfo.PluralInfo.Count r2 = matrix.startSame(start, endDone, emit);
            if (r2 == null) continue;
            if (((Boolean)emit.value).booleanValue()) {
                result.add("<pluralRange\tstart=\"" + start + "\"          \t\tresult=\"" + r2 + "\"/>");
            }
            startDone.add(start);
        }
        for (Object end : pluralInfo.getCounts()) {
            if (endDone.contains(end)) continue;
            for (SupplementalDataInfo.PluralInfo.Count start : pluralInfo.getCounts()) {
                if (startDone.contains((Object)start)) continue;
                SupplementalDataInfo.PluralInfo.Count r3 = matrix.get(start, (SupplementalDataInfo.PluralInfo.Count)((Object)end));
                if (r3 != null) {
                    result.add(PluralRanges.showRange(start, end, r3));
                    continue;
                }
                result.add("<!-- <pluralRange\tstart=\"" + start + "\" \tend=\"" + end + "\" \tresult=\"" + r3 + "\"/> -->");
            }
        }
        return result;
    }

    static enum RangeStrategy {
        other,
        end,
        start,
        mixed;

    }

    public static class RangeSample {
        final SupplementalDataInfo.PluralInfo.Count start;
        final SupplementalDataInfo.PluralInfo.Count end;
        final SupplementalDataInfo.PluralInfo.Count result;
        final DecimalQuantity min;
        final DecimalQuantity max;
        final String startExample;
        final String endExample;
        final String resultExample;

        public RangeSample(SupplementalDataInfo.PluralInfo.Count start, SupplementalDataInfo.PluralInfo.Count end, SupplementalDataInfo.PluralInfo.Count result, DecimalQuantity min2, DecimalQuantity max, String startExample, String endExample, String resultExample) {
            this.start = start;
            this.end = end;
            this.result = result;
            this.min = min2;
            this.max = max;
            this.startExample = startExample;
            this.endExample = endExample;
            this.resultExample = resultExample;
        }
    }
}

