/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.AnnotationUtil;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class GenerateProductionData {
    private static boolean DEBUG = false;
    private static boolean VERBOSE = false;
    private static Matcher FILE_MATCH = null;
    private static String SOURCE_COMMON_DIR = null;
    private static String DEST_COMMON_DIR = null;
    private static boolean ADD_LOGICAL_GROUPS = false;
    private static boolean ADD_DATETIME = false;
    private static boolean ADD_SIDEWAYS = false;
    private static boolean ADD_ROOT = false;
    private static boolean INCLUDE_COMPREHENSIVE = false;
    private static boolean CONSTRAINED_RESTORATION = false;
    private static final Set<String> NON_XML = ImmutableSet.of("dtd", "properties", "testData", "uca");
    private static final Set<String> COPY_ANYWAY = ImmutableSet.of("casing", "collation");
    private static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    private static final String[] SPECIAL_PATHS = new String[]{"//ldml/numbers/defaultNumberingSystem", "//ldml/numbers/defaultNumberingSystem[@alt=\"latn\"]"};
    private static final Set<String> SPECIAL_PATH_SET = new TreeSet<String>(Arrays.asList(SPECIAL_PATHS));
    static final Multimap<String, String> LOCALE_TO_PATH_EXCEPTIONS = ((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().put("oc_ES", "//ldml/localeDisplayNames/territories/territory[@type=\"HK\"][@alt=\"short\"]")).put("zh_Hant_MO", "//ldml/localeDisplayNames/languages/language[@type=\"yue\"][@alt=\"menu\"]")).put("zh_Hant_MO", "//ldml/localeDisplayNames/territories/territory[@type=\"CI\"][@alt=\"variant\"]")).put("zh_Hant_HK", "//ldml/localeDisplayNames/languages/language[@type=\"yue\"][@alt=\"menu\"]")).put("zh_Hant_HK", "//ldml/localeDisplayNames/territories/territory[@type=\"CI\"][@alt=\"variant\"]")).put("ru_BY", "//ldml/numbers/currencies/currency[@type=\"RUR\"]/symbol[@alt=\"narrow\"]")).put("oc_ES", "//ldml/localeDisplayNames/territories/territory[@type=\"HK\"][@alt=\"short\"]")).put("el_POLYTON", "//ldml/localeDisplayNames/territories/territory[@type=\"CI\"][@alt=\"variant\"]")).put("be_TARASK", "//ldml/localeDisplayNames/languages/language[@type=\"az\"][@alt=\"short\"]")).build();

    public static void main(String[] args) {
        MyOptions.parse(args, true);
        SOURCE_COMMON_DIR = MyOptions.sourceDirectory.option.getValue();
        DEST_COMMON_DIR = MyOptions.destinationDirectory.option.getValue();
        VERBOSE = MyOptions.verbose.option.doesOccur();
        DEBUG = MyOptions.Debug.option.doesOccur();
        String fileMatch = MyOptions.fileMatch.option.getValue();
        if (fileMatch != null) {
            FILE_MATCH = Pattern.compile(fileMatch).matcher("");
        }
        ADD_LOGICAL_GROUPS = "true".equalsIgnoreCase(MyOptions.logicalGroups.option.getValue());
        ADD_DATETIME = "true".equalsIgnoreCase(MyOptions.time.option.getValue());
        ADD_SIDEWAYS = "true".equalsIgnoreCase(MyOptions.Sideways.option.getValue());
        ADD_ROOT = "true".equalsIgnoreCase(MyOptions.root.option.getValue());
        INCLUDE_COMPREHENSIVE = "true".equalsIgnoreCase(MyOptions.includeComprehensive.option.getValue());
        CONSTRAINED_RESTORATION = "true".equalsIgnoreCase(MyOptions.constrainedRestoration.option.getValue());
        TreeMap specialDirectories = new TreeMap();
        Arrays.asList(DtdType.values()).forEach(type -> {
            boolean isLdmlDtdType = type == DtdType.ldml;
            Set<String> directories = type == DtdType.ldmlICU ? NON_XML : type.directories;
            for (String dir : directories) {
                File sourceDir = new File(SOURCE_COMMON_DIR, dir);
                File destinationDir = new File(DEST_COMMON_DIR, dir);
                Stats stats = new Stats();
                GenerateProductionData.copyFilesAndReturnIsEmpty(sourceDir, destinationDir, null, isLdmlDtdType, stats);
                if (!GenerateProductionData.directoryIsSpecial(sourceDir.getAbsolutePath())) continue;
                specialDirectories.put(sourceDir, destinationDir);
            }
        });
        for (File source : specialDirectories.keySet()) {
            File dest = (File)specialDirectories.get(source);
            GenerateProductionData.doubleCheckSpecialPaths(source, dest);
        }
    }

    private static boolean copyFilesAndReturnIsEmpty(File sourceFile, File destinationFile, Factory factory, boolean isLdmlDtdType, Stats stats) {
        if (sourceFile.isDirectory()) {
            Set<String> childless;
            System.out.println(sourceFile + " => " + destinationFile);
            if (!destinationFile.mkdirs()) {
                Arrays.stream(destinationFile.listFiles()).forEach(File::delete);
            }
            TreeSet<String> sorted = new TreeSet<String>();
            sorted.addAll(Arrays.asList(sourceFile.list()));
            if (COPY_ANYWAY.contains(sourceFile.getName())) {
                isLdmlDtdType = false;
            }
            factory = null;
            if (isLdmlDtdType) {
                factory = Factory.make(sourceFile.toString(), ".*");
            }
            boolean isMainDir = factory != null && sourceFile.getName().contentEquals("main");
            boolean isRbnfDir = factory != null && sourceFile.getName().contentEquals("rbnf");
            boolean isAnnotationsDir = factory != null && sourceFile.getName().startsWith("annotations");
            HashSet<String> emptyLocales = new HashSet<String>();
            Stats stats2 = new Stats();
            Factory theFactory = factory;
            boolean isLdmlDtdType2 = isLdmlDtdType;
            sorted.forEach(file -> {
                boolean isEmpty;
                File sourceFile2 = new File(sourceFile, (String)file);
                File destinationFile2 = new File(destinationFile, (String)file);
                if (VERBOSE) {
                    System.out.println("\t" + file);
                }
                Factory currFactory = theFactory;
                if (isMainDir) {
                    if (file.equals("root.xml")) {
                        currFactory = null;
                    }
                } else if (isRbnfDir) {
                    currFactory = null;
                }
                if (isEmpty = GenerateProductionData.copyFilesAndReturnIsEmpty(sourceFile2, destinationFile2, currFactory, isLdmlDtdType2, stats2)) {
                    emptyLocales.add(GenerateProductionData.getLocaleIdFromFileName(file));
                }
            });
            stats2.showNonZero("\tTOTAL:\t");
            if (!(emptyLocales.isEmpty() || isMainDir || (childless = GenerateProductionData.getChildless(emptyLocales, factory.getAvailable(), isAnnotationsDir)).isEmpty())) {
                if (VERBOSE) {
                    System.out.println("\t" + destinationFile + "\tRemoving empty locales:" + childless);
                }
                childless.stream().forEach(locale -> new File(destinationFile, locale + ".xml").delete());
            }
            return false;
        }
        if (factory != null) {
            String file2 = sourceFile.getName();
            if (!file2.endsWith(".xml")) {
                return false;
            }
            String localeId = GenerateProductionData.getLocaleIdFromFileName(file2);
            if (FILE_MATCH != null && !FILE_MATCH.reset(localeId).matches()) {
                return false;
            }
            boolean isRoot = localeId.equals("root");
            CLDRFile cldrFileUnresolved = factory.make(localeId, false);
            CLDRFile cldrFileResolved = factory.make(localeId, true);
            boolean gotOne = false;
            TreeSet<String> toRemove = new TreeSet<String>();
            TreeSet<String> toRetain = new TreeSet<String>();
            TreeSet<String> toRetainSpecial = new TreeSet<String>();
            Output<String> pathWhereFound = new Output<String>();
            Output<String> localeWhereFound = new Output<String>();
            boolean specialPathsAreRequired = GenerateProductionData.areSpecialPathsRequired(localeId, sourceFile.toString());
            String debugPath = "//ldml/localeDisplayNames/languages/language[@type=\"en_US\"]";
            boolean debugLocale = localeId.equals("pt");
            ImmutableSortedSet<String> sortedPaths = ImmutableSortedSet.copyOf(cldrFileUnresolved);
            for (String xpath : sortedPaths) {
                Object paths;
                Level coverage;
                String bailey;
                String value;
                if (xpath.startsWith("//ldml/identity")) continue;
                if (debugPath != null && debugLocale && xpath.startsWith(debugPath)) {
                    boolean bl = false;
                }
                if ((value = cldrFileUnresolved.getStringValue(xpath)) == null || CldrUtility.INHERITANCE_MARKER.equals(value)) {
                    toRemove.add(xpath);
                    continue;
                }
                if (isRoot && AnnotationUtil.pathIsAnnotation(xpath)) {
                    toRemove.add(xpath);
                    continue;
                }
                if (specialPathsAreRequired && GenerateProductionData.pathIsSpecial(xpath)) {
                    toRetainSpecial.add(xpath);
                }
                if (!(!value.equals(bailey = cldrFileResolved.getBaileyValue(xpath, pathWhereFound, localeWhereFound)) || ADD_SIDEWAYS && !GenerateProductionData.pathEqualsOrIsOkAltVariantOf(cldrFileResolved, xpath, (String)pathWhereFound.value, localeId, (String)localeWhereFound.value) || ADD_ROOT && (Objects.equals("root", localeWhereFound.value) || Objects.equals("code-fallback", localeWhereFound.value)))) {
                    toRemove.add(xpath);
                    continue;
                }
                if (!INCLUDE_COMPREHENSIVE && (coverage = SDI.getCoverageLevel(xpath, localeId)) == Level.COMPREHENSIVE) {
                    toRemove.add(xpath);
                    continue;
                }
                if (ADD_LOGICAL_GROUPS && !LogicalGrouping.isOptional(cldrFileResolved, xpath) && (paths = LogicalGrouping.getPaths(cldrFileResolved, xpath)) != null && paths.size() > 1) {
                    Iterator<String> iterator = paths.iterator();
                    while (iterator.hasNext()) {
                        String possiblePath = iterator.next();
                        if (LogicalGrouping.isOptional(cldrFileResolved, possiblePath)) continue;
                        toRetain.add(possiblePath);
                    }
                }
                if (ADD_DATETIME && GenerateProductionData.isDateTimePath(xpath)) {
                    toRetain.addAll(GenerateProductionData.dateTimePaths(xpath));
                }
                gotOne = true;
            }
            if (specialPathsAreRequired) {
                GenerateProductionData.addSpecialPathsIfMissing(toRetainSpecial);
            }
            try (PrintWriter pw = new PrintWriter(destinationFile);){
                CLDRFile outCldrFile = cldrFileUnresolved.cloneAsThawed();
                if (DEBUG) {
                    GenerateProductionData.showIfNonZero(localeId, "removing", toRemove);
                    GenerateProductionData.showIfNonZero(localeId, "retaining", toRetain);
                    GenerateProductionData.showIfNonZero(localeId, "retaining for special paths", toRetainSpecial);
                }
                if (CONSTRAINED_RESTORATION) {
                    toRetain.retainAll(toRemove);
                    if (DEBUG) {
                        GenerateProductionData.showIfNonZero(localeId, "constrained retaining", toRetain);
                    }
                }
                toRetain.addAll(toRetainSpecial);
                boolean changed0 = toRemove.removeAll(toRetain);
                if (DEBUG && changed0) {
                    GenerateProductionData.showIfNonZero(localeId, "final removing", toRemove);
                }
                boolean changed = toRetain.removeAll(toRemove);
                if (DEBUG && changed) {
                    GenerateProductionData.showIfNonZero(localeId, "final retaining", toRetain);
                }
                outCldrFile.removeAll(toRemove, false);
                if (DEBUG) {
                    for (String xpath : toRemove) {
                        System.out.println(localeId + ": removing: \u00ab" + cldrFileUnresolved.getStringValue(xpath) + "\u00bb, " + xpath);
                    }
                }
                for (String xpath : toRetain) {
                    String value;
                    if (debugPath != null && localeId.equals(debugLocale) && xpath.equals(debugPath)) {
                        boolean possiblePath = false;
                    }
                    if ((value = cldrFileResolved.getStringValue(xpath)) == null || value.equals(CldrUtility.INHERITANCE_MARKER)) {
                        throw new IllegalArgumentException(localeId + ": " + value + " in value for " + xpath);
                    }
                    if (DEBUG) {
                        String oldValue = cldrFileUnresolved.getStringValue(xpath);
                        System.out.println("Restoring: \u00ab" + oldValue + "\u00bb \u21d2 \u00ab" + value + "\u00bb\t" + xpath);
                    }
                    outCldrFile.add(xpath, value);
                }
                int count = 0;
                for (String xpath : outCldrFile) {
                    String value;
                    if (debugPath != null && localeId.equals(debugLocale) && xpath.equals(debugPath)) {
                        boolean oldValue = false;
                    }
                    if ((value = outCldrFile.getStringValue(xpath)) != null && !value.equals(CldrUtility.INHERITANCE_MARKER)) continue;
                    throw new IllegalArgumentException(localeId + ": " + value + " in value for " + xpath);
                }
                outCldrFile.write(pw);
                ++stats.files;
                stats.removed += (long)toRemove.size();
                stats.retained += (long)toRetain.size();
                stats.remaining += (long)count;
            }
            catch (FileNotFoundException e) {
                throw new ICUUncheckedIOException("Can't copy " + sourceFile + " to " + destinationFile + " \u2014 ", e);
            }
            return !gotOne;
        }
        if (FILE_MATCH != null) {
            String baseName;
            String file3 = sourceFile.getName();
            int dotPos = file3.lastIndexOf(46);
            String string = baseName = dotPos >= 0 ? file3.substring(0, file3.length() - dotPos) : file3;
            if (!FILE_MATCH.reset(baseName).matches()) {
                return false;
            }
        }
        ++stats.files;
        GenerateProductionData.copyFiles(sourceFile, destinationFile);
        return false;
    }

    private static String getLocaleIdFromFileName(String file) {
        return file.substring(0, file.length() - 4);
    }

    private static boolean areSpecialPathsRequired(String localeId, String directory) {
        return GenerateProductionData.localeIsSpecial(localeId) && GenerateProductionData.directoryIsSpecial(directory);
    }

    private static boolean directoryIsSpecial(String directory) {
        return directory.contains("common/main");
    }

    private static boolean localeIsSpecial(String localeId) {
        return localeId.equals("ar") || localeId.startsWith("ar_") && !"ar_001".equals(localeId);
    }

    private static boolean pathIsSpecial(String xpath) {
        return SPECIAL_PATH_SET.contains(xpath);
    }

    private static void addSpecialPathsIfMissing(Set<String> toRetainSpecial) {
        for (String xpath : SPECIAL_PATH_SET) {
            if (toRetainSpecial.contains(xpath)) continue;
            toRetainSpecial.add(xpath);
        }
    }

    private static void doubleCheckSpecialPaths(File sourceDir, File destDir) {
        TreeSet<String> sorted = new TreeSet<String>();
        sorted.addAll(Arrays.asList(sourceDir.list()));
        Factory factory = Factory.make(destDir.toString(), ".*");
        sorted.forEach(file -> GenerateProductionData.doubleCheckLocale(sourceDir, destDir, file, factory));
    }

    private static void doubleCheckLocale(File sourceDir, File destDir, String file, Factory factory) {
        if (!file.endsWith(".xml")) {
            return;
        }
        String localeId = GenerateProductionData.getLocaleIdFromFileName(file);
        if (!GenerateProductionData.localeIsSpecial(localeId)) {
            return;
        }
        File destFile = new File(destDir, file);
        if (!destFile.exists()) {
            throw new InternalCldrException("doubleCheckLocale FILE NOT FOUND: " + destFile);
        }
        CLDRFile cldrFileUnresolved = factory.make(localeId, false);
        for (String xpath : SPECIAL_PATH_SET) {
            String value = cldrFileUnresolved.getStringValue(xpath);
            if (value == null) {
                throw new InternalCldrException("Locale " + localeId + " missing required special path " + xpath);
            }
            if (!CldrUtility.INHERITANCE_MARKER.equals(value)) continue;
            throw new InternalCldrException("Locale " + localeId + " has INHERITANCE_MARKER for required special path " + xpath);
        }
    }

    private static void showIfNonZero(String localeId, String title, Set<String> toRemove) {
        if (toRemove.size() != 0) {
            System.out.println(localeId + ": " + title + ": " + toRemove.size());
        }
    }

    private static boolean pathEqualsOrIsOkAltVariantOf(CLDRFile cldrFileResolved, String desiredPath, String foundPath, String localeId, String foundLocaleId) {
        if (LOCALE_TO_PATH_EXCEPTIONS.containsEntry(localeId, desiredPath)) {
            return false;
        }
        if (desiredPath.equals(foundPath)) {
            return true;
        }
        if (!foundLocaleId.equals(localeId)) {
            return false;
        }
        if (desiredPath.contains("type=\"en_GB\"") && desiredPath.contains("alt=")) {
            boolean bl = false;
        }
        if (foundPath == null || foundPath.equals("constructed")) {
            return !LocaleIDParser.isL1(localeId);
        }
        XPathParts desiredPathParts = XPathParts.getFrozenInstance(desiredPath);
        XPathParts foundPathParts = XPathParts.getFrozenInstance(foundPath);
        if (desiredPathParts.size() != foundPathParts.size()) {
            return false;
        }
        for (int e = 0; e < desiredPathParts.size(); ++e) {
            Map<String, String> attr2;
            String element2;
            String element1 = desiredPathParts.getElement(e);
            if (!element1.equals(element2 = foundPathParts.getElement(e))) {
                return false;
            }
            Map<String, String> attr1 = desiredPathParts.getAttributes(e);
            if (attr1.equals(attr2 = foundPathParts.getAttributes(e))) continue;
            Set<String> keys1 = attr1.keySet();
            Set<String> keys2 = attr2.keySet();
            for (String attr : Sets.union(keys1, keys2)) {
                if (attr.equals("alt") || Objects.equals(attr1.get(attr), attr2.get(attr))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isDateTimePath(String xpath) {
        return xpath.startsWith("//ldml/dates/calendars/calendar") && xpath.contains("FormatLength[@type=");
    }

    private static Set<String> dateTimePaths(String xpath) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String prefix = xpath.substring(0, xpath.indexOf(93) + 2);
        for (String type : Arrays.asList("date", "time", "dateTime")) {
            String pattern = prefix + "$XFormats/$XFormatLength[@type=\"$Y\"]/$XFormat[@type=\"standard\"]/pattern[@type=\"standard\"]".replace("$X", type);
            for (String width : Arrays.asList("full", "long", "medium", "short")) {
                result.add(pattern.replace("$Y", width));
            }
        }
        return result;
    }

    private static Set<String> getChildless(Set<String> emptyLocales, Set<String> available, boolean isAnnotationsDir) {
        HashMultimap<String, String> parent2child = HashMultimap.create();
        for (String locale : available) {
            String simpleParent;
            String parent = LocaleIDParser.getParent(locale);
            if (parent != null) {
                parent2child.put(parent, locale);
            }
            if (!isAnnotationsDir || (simpleParent = LocaleIDParser.getParent(locale, SupplementalDataInfo.ParentLocaleComponent.collations)) == null || parent != null && simpleParent == parent) continue;
            parent2child.put(simpleParent, locale);
        }
        HashSet<String> result = new HashSet<String>();
        for (String empty : emptyLocales) {
            if (!GenerateProductionData.allChildrenAreEmpty(empty, emptyLocales, parent2child)) continue;
            result.add(empty);
        }
        return result;
    }

    private static boolean allChildrenAreEmpty(String locale, Set<String> emptyLocales, Multimap<String, String> parent2child) {
        Collection<String> children = parent2child.get(locale);
        for (String child : children) {
            if (!emptyLocales.contains(child)) {
                return false;
            }
            if (GenerateProductionData.allChildrenAreEmpty(child, emptyLocales, parent2child)) continue;
            return false;
        }
        return true;
    }

    private static void copyFiles(File sourceFile, File destinationFile) {
        try {
            Files.copy(sourceFile, destinationFile);
        }
        catch (IOException e) {
            System.err.println("Can't copy " + sourceFile + " to " + destinationFile + " \u2014 " + e);
        }
    }

    private static class Stats {
        long files;
        long removed;
        long retained;
        long remaining;

        private Stats() {
        }

        Stats clear() {
            this.remaining = 0L;
            this.retained = 0L;
            this.removed = 0L;
            this.files = 0L;
            return this;
        }

        public String toString() {
            return "files=" + this.files + (String)(this.removed + this.retained + this.remaining == 0L ? "" : "; removed=" + this.removed + "; retained=" + this.retained + "; remaining=" + this.remaining);
        }

        public void showNonZero(String label) {
            if (this.removed + this.retained + this.remaining != 0L) {
                System.out.println(label + this.toString());
            }
        }
    }

    static enum MyOptions {
        sourceDirectory(new Option.Params().setHelp("source common directory").setDefault(CLDRPaths.COMMON_DIRECTORY).setMatch(".*")),
        destinationDirectory(new Option.Params().setHelp("destination common directory").setDefault(CLDRPaths.STAGING_DIRECTORY + "production/common").setMatch(".*")),
        logicalGroups(new Option.Params().setHelp("add path/values for logical groups").setDefault("true").setMatch("true|false")),
        time(new Option.Params().setHelp("add path/values for stock date/time/datetime").setDefault("true").setMatch("true|false")),
        Sideways(new Option.Params().setHelp("add path/values for sideways inheritance").setDefault("true").setMatch("true|false")),
        root(new Option.Params().setHelp("add path/values for root and code-fallback").setDefault("true").setMatch("true|false")),
        constrainedRestoration(new Option.Params().setHelp("only add inherited paths that were in original file").setDefault("true").setMatch("true|false")),
        includeComprehensive(new Option.Params().setHelp("exclude comprehensive paths \u2014 otherwise just to modern level").setDefault("true").setMatch("true|false")),
        verbose(new Option.Params().setHelp("verbose debugging messages")),
        Debug(new Option.Params().setHelp("debug")),
        fileMatch(new Option.Params().setHelp("regex to match patterns").setMatch(".*"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

