/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.util.Output;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;

public class GetChanges {
    static CLDRConfig testInfo = ToolConfig.getToolInstance();
    static CLDRFile english = testInfo.getEnglish();
    static boolean verbose = true;
    public static final Set<String> ROOT_OR_CODE_FALLBACK = ImmutableSet.of("code-fallback", "root");
    static Pattern OLD_PATH = PatternCache.get("//ldml/units/unit\\[@type=\"([^\"]*)\"]/unitPattern\\[@count=\"([^\"]*)\"](\\[@alt=\"([^\"]*)\"])?");
    static Matcher OLD_PATH_MATCHER = OLD_PATH.matcher("");

    public static void main(String[] args) {
        System.out.println("#Dir\tState\tTrunk Value\tmodify_config.txt Locale\tAction\tlabel\tPath Value\tlabel\tNew Value");
        Matcher localeFilter = Pattern.compile(".*").matcher("");
        File vxml = new File(CLDRPaths.AUX_DIRECTORY, "voting/35/vxml2");
        for (File vxmlDir : vxml.listFiles()) {
            if (!vxmlDir.isDirectory()) continue;
            File[] commonSeedFiles = vxmlDir.listFiles();
            if (commonSeedFiles == null) {
                System.out.println("##No files in: " + vxmlDir);
                continue;
            }
            for (File commonSeed : commonSeedFiles) {
                if (!commonSeed.isDirectory() || "dtd".equals(commonSeed.getName())) continue;
                String subDir = vxmlDir.getName() + "/" + commonSeed.getName();
                String l2 = CLDRPaths.BASE_DIRECTORY + subDir;
                Factory factoryVxml = Factory.make(commonSeed.toString(), ".*");
                Factory factoryTrunk = Factory.make(l2, ".*");
                for (String locale : factoryVxml.getAvailable()) {
                    CLDRFile vxmlFile;
                    if (!localeFilter.reset(locale).matches() || locale.equals("root")) continue;
                    try {
                        vxmlFile = factoryVxml.make(locale, true);
                    }
                    catch (Exception e1) {
                        System.out.println("##Error: dir=\t" + commonSeed + "\t locale=\t" + locale + "\tmsg=\t" + e1.getMessage());
                        continue;
                    }
                    CLDRFile trunkFile = null;
                    try {
                        trunkFile = factoryTrunk.make(locale, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GetChanges.compare(subDir, vxmlFile, trunkFile);
                }
            }
        }
    }

    private static void compare(String dir, CLDRFile vxmlFileResolved, CLDRFile trunkFileResolved) {
        String localeID = vxmlFileResolved.getLocaleID();
        if (localeID.equals("ccp")) {
            boolean bl = false;
        }
        CLDRFile vxmlFileUnresolved = vxmlFileResolved.getUnresolved();
        Output<String> localeWhereFound = new Output<String>();
        Output<String> pathWhereFound = new Output<String>();
        CLDRFile.Status status = new CLDRFile.Status();
        int countNew = 0;
        int countChanged = 0;
        for (String path : vxmlFileUnresolved) {
            String vxmlValue;
            if (path.contains("/identity")) continue;
            if (path.contains("ccp")) {
                boolean bl = false;
            }
            String trunkValue = null;
            if (trunkFileResolved != null) {
                trunkValue = trunkFileResolved.getStringValue(path);
                String foundId = trunkFileResolved.getSourceLocaleID(path, status);
                if (ROOT_OR_CODE_FALLBACK.contains(foundId)) {
                    trunkValue = null;
                }
            }
            if (Objects.equals(vxmlValue = vxmlFileResolved.getStringValue(path), trunkValue)) continue;
            if (vxmlValue.equals(CldrUtility.INHERITANCE_MARKER)) {
                vxmlValue = vxmlFileResolved.getBaileyValue(path, pathWhereFound, localeWhereFound);
                if (ROOT_OR_CODE_FALLBACK.contains(localeWhereFound.value)) continue;
            }
            if (Objects.equals(vxmlValue, trunkValue)) continue;
            if (trunkValue == null) {
                ++countNew;
                if (!verbose) continue;
                System.out.println(dir + ";\tnew\t\tlocale=" + localeID + ";\taction=add;\tpath=\t" + path + "\tnew_value=\t" + vxmlValue);
                continue;
            }
            if (path.startsWith("//ldml/annotations")) continue;
            ++countChanged;
            if (!verbose) continue;
            System.out.println(dir + ";\ttrunk=\t" + trunkValue + "\tlocale=" + localeID + ";\taction=add;\tpath=\t" + path + "\tnew_value=\t" + vxmlValue);
        }
    }

    private void old() {
        boolean onlyMissing = true;
        String release = "33.1";
        String subdir = "annotations";
        Factory lastReleaseFactory = Factory.make(CLDRPaths.LAST_RELEASE_DIRECTORY + "common/" + subdir, ".*");
        Factory trunkFactory = testInfo.getAnnotationsFactory();
        Factory snapshotFactory = Factory.make(CLDRPaths.AUX_DIRECTORY + "voting/" + release + "/vxml/common/" + subdir, ".*");
        PathHeader.Factory phf = PathHeader.getFactory(english);
        int totalCount = 0;
        int localeCount = 0;
        Output<String> localeWhereFound = new Output<String>();
        Output<String> pathWhereFound = new Output<String>();
        CLDRFile englishCldrFile = trunkFactory.make("en", false);
        ImmutableSet<String> paths = ImmutableSet.copyOf(englishCldrFile.iterator());
        System.out.println("english paths: " + paths.size());
        TreeMultimap<String, PathHeader> missing = TreeMultimap.create();
        Set<String> locales = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, Collections.singleton(Level.MODERN));
        LanguageTagParser ltp = new LanguageTagParser();
        for (String string : locales) {
            CLDRFile snapshot;
            if (!ltp.set(string).getRegion().isEmpty() || string.equals("sr_Latn")) continue;
            System.out.println(string);
            try {
                snapshot = snapshotFactory.make(string, false);
            }
            catch (Exception e) {
                System.out.println("##Skipping " + string + ", no data in annotations/");
                continue;
            }
            CLDRFile lastRelease = null;
            try {
                lastRelease = lastReleaseFactory.make(string, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            CLDRFile trunk = null;
            try {
                trunk = trunkFactory.make(string, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TreeMap<PathHeader, Data> results = new TreeMap<PathHeader, Data>();
            for (String xpath : paths) {
                String valueLastRelease;
                if (xpath.contains("fallbackRegionFormat") || xpath.contains("exemplar") || xpath.contains("/identity")) continue;
                String newPath = GetChanges.fixOldPath(xpath);
                String valueSnapshot = snapshot.getStringValue(newPath);
                PathHeader ph = null;
                if (valueSnapshot == null) {
                    ph = phf.fromPath(newPath);
                    missing.put(string, ph);
                }
                String string2 = valueLastRelease = lastRelease == null ? null : lastRelease.getStringValue(xpath);
                if (valueSnapshot == null) {
                    ph = phf.fromPath(newPath);
                    missing.put(string, ph);
                }
                if (onlyMissing || valueSnapshot != null && Objects.equals(valueLastRelease, valueSnapshot)) continue;
                String valueTrunk = trunk == null ? null : trunk.getStringValue(newPath);
                String baileyValue = snapshot.getBaileyValue(xpath, pathWhereFound, localeWhereFound);
                if (!"root".equals(localeWhereFound.value) && !"code-fallback".equals(localeWhereFound.value) && CldrUtility.equals(valueSnapshot, baileyValue)) continue;
                ph = ph != null ? ph : phf.fromPath(newPath);
                results.put(ph, new Data(valueLastRelease, valueSnapshot, valueTrunk));
            }
            if (results.isEmpty()) continue;
            int itemCount = 0;
            ++localeCount;
            for (Map.Entry entry : results.entrySet()) {
                PathHeader ph = (PathHeader)entry.getKey();
                String englishValue = englishCldrFile.getStringValue(ph.getOriginalPath());
                System.out.println(localeCount + "\t" + ++itemCount + "\t" + string + "\t" + english.nameGetter().getNameFromIdentifier(string) + "\t" + ph + "\t\u00ab" + englishValue + "\u00bb\t" + entry.getValue());
            }
            totalCount += itemCount;
        }
        System.out.println("##Total:\t" + totalCount);
        for (Map.Entry entry : missing.entries()) {
            System.out.println((String)entry.getKey() + "\t" + entry.getValue());
        }
    }

    private static String fixOldPath(String xpath) {
        if (OLD_PATH_MATCHER.reset(xpath).matches()) {
            String type = OLD_PATH_MATCHER.group(4);
            return "//ldml/units/unitLength[@type=\"" + (type == null ? "long" : type) + "\"]/unit[@type=\"duration-" + OLD_PATH_MATCHER.group(1) + "\"]/unitPattern[@count=\"" + OLD_PATH_MATCHER.group(2) + "\"]";
        }
        return xpath;
    }

    static class Data {
        final String valueLastRelease;
        final String valueSnapshot;
        final String valueTrunk;

        public Data(String valueLastRelease, String valueSnapshot, String valueTrunk) {
            this.valueLastRelease = valueLastRelease;
            this.valueSnapshot = valueSnapshot;
            this.valueTrunk = valueTrunk;
        }

        public String toString() {
            return "\u00ab" + this.valueLastRelease + "\u00bb" + (!CldrUtility.equals(this.valueTrunk, this.valueLastRelease) ? "\u2021" : "") + "\t\u00ab" + this.valueSnapshot + "\u00bb" + (CldrUtility.equals(this.valueTrunk, this.valueSnapshot) ? "\u2020" : "");
        }
    }
}

