/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.util.Output;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.BestMinimalPairSamples;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ListGrammarData {
    static CLDRConfig CONFIG = CLDRConfig.getInstance();
    public static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    private static final CLDRFile ENGLISH = CONFIG.getEnglish();

    public static void main(String[] args) {
        MyOptions.parse(args);
        Matcher fileFilter = Pattern.compile(MyOptions.fileFilter.option.getValue()).matcher("");
        String orgFilter = MyOptions.orgFilter.option.getValue();
        Boolean exampleHtml = MyOptions.exampleHtml.option.doesOccur();
        Matcher coverageSkip = Pattern.compile(MyOptions.coverageSkip.option.getValue()).matcher("");
        Boolean verbose = MyOptions.verbose.option.doesOccur();
        Factory factory = CONFIG.getCldrFactory();
        PathHeader.Factory phf = PathHeader.getFactory();
        LinkedHashSet<CallSite> errors = new LinkedHashSet<CallSite>();
        LinkedHashMultimap<String, CallSite> lines = LinkedHashMultimap.create();
        LikelySubtags likelySubtags = new LikelySubtags();
        LinkedHashMultimap<Object, CallSite> stats = LinkedHashMultimap.create();
        for (String string : factory.getAvailableLanguages()) {
            Collection<String> rawCases;
            Object locale;
            Level coverage;
            if (!fileFilter.reset(string).matches() || coverageSkip.reset((coverage = StandardCodes.make().getLocaleCoverageLevel(Organization.valueOf(orgFilter), string)).toString()).matches() || !string.equals(locale = likelySubtags.minimize(string))) continue;
            CLDRFile cldrFile = factory.make((String)locale, true);
            ExampleGenerator exampleGenerator = null;
            if (exampleHtml.booleanValue()) {
                exampleGenerator = new ExampleGenerator(cldrFile, CONFIG.getEnglish());
            }
            BestMinimalPairSamples bestMinimalPairSamples = new BestMinimalPairSamples(cldrFile, null, true);
            TreeMap<PathHeader, String> pathHeaderToValue = new TreeMap<PathHeader, String>();
            TreeMultimap<String, String> sectionPageHeaderToCodes = TreeMultimap.create();
            for (String string2 : cldrFile.fullIterable()) {
                if (!string2.startsWith("//ldml/numbers/minimalPairs")) continue;
                PathHeader ph = phf.fromPath(string2);
                String value = cldrFile.getStringValue(string2);
                pathHeaderToValue.put(ph, value);
                sectionPageHeaderToCodes.put(ListGrammarData.sectionPageHeader(ph), ph.getCode());
            }
            if (pathHeaderToValue.isEmpty()) continue;
            String names = (String)locale + "\t" + ENGLISH.nameGetter().getNameFromIdentifier((String)locale);
            for (Map.Entry entry : pathHeaderToValue.entrySet()) {
                PathHeader ph = (PathHeader)entry.getKey();
                Collection codes = sectionPageHeaderToCodes.get(ListGrammarData.sectionPageHeader(ph));
                if (codes.size() == 1) {
                    errors.add((CallSite)((Object)("*" + names + "\t" + ph + "\tsinglular!")));
                    continue;
                }
                String minimalPattern = (String)entry.getValue();
                Output<String> output = new Output<String>();
                String sample = bestMinimalPairSamples.getBestValue(ph.getHeader(), ph.getCode(), output);
                lines.put(ph.getHeader(), (CallSite)((Object)(ph.getHeader() + "\t" + names + "\t" + coverage + "\t" + ph.getCode() + "\t" + (String)minimalPattern + "\t" + sample + "\t" + output + (String)(exampleHtml != false ? "\t" + ExampleGenerator.simplify(exampleGenerator.getExampleHtml(ph.getOriginalPath(), (String)pathHeaderToValue.get(ph))) : ""))));
            }
            GrammarInfo grammarInfo = SDI.getGrammarInfo((String)locale, true);
            if (grammarInfo == null) continue;
            Collection<String> genders = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
            if (!genders.isEmpty()) {
                Multimap<String, String> genderToUnits = bestMinimalPairSamples.getGenderToUnits();
                LinkedHashMultimap<String, Integer> genderToUnitCounts = LinkedHashMultimap.create();
                for (Map.Entry entry : genderToUnits.asMap().entrySet()) {
                    genderToUnitCounts.put((String)entry.getKey(), ((Collection)entry.getValue()).size());
                }
                stats.put(locale, (CallSite)((Object)("Gender Details\t" + names + "\t" + coverage + "\t\t\t" + genders.size() + "\t" + genderToUnitCounts.keySet().size() + "\t" + (double)genderToUnitCounts.keySet().size() / (double)genders.size() + "\t" + genderToUnitCounts + "\t" + genderToUnits)));
            }
            if ((rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units)).isEmpty()) continue;
            Set<String> pluralKeywords = SDI.getPlurals((String)locale).getPluralRules().getKeywords();
            Multimap<Integer, String> uniqueCaseAndCountToUnits = bestMinimalPairSamples.getUniqueCaseAndCountToUnits();
            Multimap<String, String> multimap = bestMinimalPairSamples.getDistinctNominativeCaseToUnit();
            LinkedHashMultimap<Integer, Integer> uniqueCaseAndCountToUnitsCounts = LinkedHashMultimap.create();
            double average = 0.0;
            double total = 0.0;
            for (Map.Entry<Integer, Collection<String>> entry : uniqueCaseAndCountToUnits.asMap().entrySet()) {
                uniqueCaseAndCountToUnitsCounts.put(entry.getKey(), entry.getValue().size());
                average += (double)(entry.getKey() * entry.getValue().size());
                total += (double)entry.getValue().size();
            }
            Collection<String> non_distinct = multimap.get("\uff1dnominative");
            HashSet<String> distinctUnits = new HashSet<String>(multimap.values());
            distinctUnits.removeAll(non_distinct);
            stats.put(locale, (CallSite)((Object)("Case&Count Details\t" + names + "\t" + coverage + "\t" + rawCases.size() + "\t" + pluralKeywords.size() + "\t" + rawCases.size() * pluralKeywords.size() + "\t" + average / total + "\t" + average / total / (double)rawCases.size() / (double)pluralKeywords.size() + "\t" + uniqueCaseAndCountToUnitsCounts + "\t" + uniqueCaseAndCountToUnits + "\t" + distinctUnits.size() + "\t" + multimap)));
        }
        for (String string : new TreeSet(lines.keySet())) {
            String lastLocale = "";
            for (String line : lines.get(string)) {
                String locale = line.substring(0, line.indexOf(9));
                if (!locale.equals(lastLocale)) {
                    lastLocale = locale;
                    System.out.println();
                }
                System.out.println(line);
            }
        }
        if (!stats.isEmpty()) {
            System.out.println("\n******** Gender/Case Details\n");
            System.out.println("Type\tLc\tLocale\tCoverage\tCases\tPlurals\tProduct/Gender\tAverage\t%\tCounts\tDetails1\tDistinct\tDetails2");
            for (Map.Entry entry : stats.asMap().entrySet()) {
                for (String line : (Collection)entry.getValue()) {
                    System.out.println(line);
                }
            }
        }
    }

    public static String sectionPageHeader(PathHeader ph) {
        return ph.getSectionId() + "|" + ph.getPageId() + "|" + ph.getHeader();
    }

    private static enum MyOptions {
        fileFilter(new Option.Params().setHelp("filter files by locale").setMatch(".*").setDefault(".*")),
        orgFilter(new Option.Params().setHelp("filter files by organization").setDefault("cldr")),
        coverageSkip(new Option.Params().setHelp("filter files by coverage").setMatch(".*").setDefault(Level.UNDETERMINED.toString())),
        exampleHtml(new Option.Params().setHelp("display exampleHtml")),
        verbose(new Option.Params().setHelp("verbose debugging messages"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

