/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.tool.PluralMinimalPairs;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.SupplementalDataInfo;

public abstract class PluralRulesFactory
extends PluralRules.Factory {
    private final SupplementalDataInfo supplementalDataInfo;
    private static ConcurrentHashMap<Pair<Type, String>, PluralRulesFactory> singletons = new ConcurrentHashMap();
    private Relation<ULocale, DecimalQuantity> EXTRA_SAMPLES = null;
    static String[][] EXTRA_SAMPLE_SOURCE = new String[][]{{"he,iw", "10,20"}, {"und,az,ka,kk,ky,mk,mn,my,pa,sq,uz", "0,0.0,0.1,1,1.0,1.1,2.0,2.1,3,4,5,10,11,1.2,1.121"}};

    @Override
    public abstract boolean hasOverride(ULocale var1);

    public static PluralRulesFactory getInstance(SupplementalDataInfo supplementalDataInfo) {
        return PluralRulesFactory.getInstance(supplementalDataInfo, Type.NORMAL);
    }

    public static PluralRulesFactory getInstance(SupplementalDataInfo supplementalDataInfo, Type type) {
        Pair<Type, String> key = new Pair<Type, String>(type, supplementalDataInfo.getDirectory().getAbsolutePath());
        PluralRulesFactory prf = singletons.get(key);
        if (prf == null) {
            switch (type) {
                case NORMAL: {
                    prf = new PluralRulesFactoryVanilla(supplementalDataInfo);
                    break;
                }
                default: {
                    throw new InternalError("Illegal type value: " + type);
                }
            }
            singletons.put(key, prf);
        }
        return prf;
    }

    private PluralRulesFactory(SupplementalDataInfo supplementalDataInfo) {
        this.supplementalDataInfo = supplementalDataInfo;
    }

    public Set<String> getLocales() {
        return this.supplementalDataInfo.getPluralLocales(SupplementalDataInfo.PluralType.cardinal);
    }

    public Set<SupplementalDataInfo.PluralInfo.Count> getSampleCounts(String locale, PluralRules.PluralType type) {
        PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(locale);
        return samplePatterns == null ? null : samplePatterns.getCounts(type);
    }

    public static String getSamplePattern(String uLocale, PluralRules.PluralType type, SupplementalDataInfo.PluralInfo.Count count) {
        String result;
        PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(uLocale);
        if (samplePatterns != null && (result = samplePatterns.get(type, count)) != null) {
            return result;
        }
        return "{0} {no pattern available}";
    }

    public Relation<ULocale, DecimalQuantity> getExtraSamples() {
        if (this.EXTRA_SAMPLES == null) {
            this.loadData();
        }
        return this.EXTRA_SAMPLES;
    }

    private void loadData() {
        Relation<ULocale, DecimalQuantity> tempSamples = Relation.of(new HashMap(), HashSet.class);
        for (String[] pair : EXTRA_SAMPLE_SOURCE) {
            for (String locale : pair[0].split("\\s*,\\s*")) {
                ULocale uLocale = new ULocale(locale);
                if (tempSamples.containsKey(uLocale)) {
                    throw new IllegalArgumentException("Duplicate locale: " + uLocale);
                }
                for (String item : pair[1].split("\\s*,\\s*")) {
                    tempSamples.put(uLocale, DecimalQuantity_DualStorageBCD.fromExponentString(item));
                }
            }
        }
        this.EXTRA_SAMPLES = tempSamples.freeze();
    }

    static class PluralRulesFactoryVanilla
    extends PluralRulesFactory {
        private PluralRulesFactoryVanilla(SupplementalDataInfo supplementalDataInfo) {
            super(supplementalDataInfo);
        }

        @Override
        public boolean hasOverride(ULocale locale) {
            return false;
        }

        @Override
        public PluralRules forLocale(ULocale locale, PluralRules.PluralType ordinal) {
            return PluralRules.forLocale(locale, ordinal);
        }

        @Override
        public ULocale[] getAvailableULocales() {
            return PluralRules.getAvailableULocales();
        }

        @Override
        public ULocale getFunctionalEquivalent(ULocale locale, boolean[] isAvailable) {
            return PluralRules.getFunctionalEquivalent(locale, isAvailable);
        }
    }

    public static enum Type {
        NORMAL,
        ALTERNATE;

    }
}

