/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PrettyPath;

public class ShowChildren {
    public static void main(String[] args) {
        System.out.println("Arguments: " + String.join((CharSequence)" ", args));
        long startTime = System.currentTimeMillis();
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        TreeSet<String> locales = new TreeSet<String>(cldrFactory.getAvailable());
        Relation<String, String> parent2children = Relation.of(new TreeMap(), TreeSet.class);
        LanguageTagParser ltp = new LanguageTagParser();
        for (String locale : locales) {
            String parent = ShowChildren.getParentWithoutRegion(ltp, locale);
            if (parent.equals(locale)) continue;
            parent2children.put(parent, locale);
        }
        PrettyPath prettyPath = new PrettyPath();
        CLDRFile english = ToolConfig.getToolInstance().getEnglish();
        Counter<String> deviations = new Counter<String>();
        for (Map.Entry entry : parent2children.keyValuesSet()) {
            TreeMap<String, Relation<String, String>> path2value2locales = new TreeMap<String, Relation<String, String>>();
            String parent = (String)entry.getKey();
            String parentName = english.nameGetter().getNameFromIdentifier(parent);
            CLDRFile parentFile = cldrFactory.make(parent, true);
            Set children = entry.getValue();
            for (String string : children) {
                CLDRFile file = cldrFactory.make(string, false);
                for (String path : file) {
                    String childValue;
                    String parentValue;
                    if (path.startsWith("//ldml/identity") || path.endsWith("/alias") || path.endsWith("/commonlyUsed")) continue;
                    Relation<String, String> value2locales = (Relation<String, String>)path2value2locales.get(path);
                    if (value2locales == null) {
                        value2locales = Relation.of(new LinkedHashMap(), TreeSet.class);
                        path2value2locales.put(path, value2locales);
                    }
                    if ((parentValue = parentFile.getStringValue(path)) == null) {
                        parentValue = "*MISSING*";
                    }
                    if (parentValue.equals(childValue = file.getStringValue(path))) continue;
                    value2locales.put(parentValue, parent);
                    value2locales.put(childValue, string);
                }
            }
            if (path2value2locales.size() == 0) continue;
            for (Map.Entry entry2 : path2value2locales.entrySet()) {
                String path = (String)entry2.getKey();
                String ppath = prettyPath.getPrettyPath(path, false);
                Relation value2locales = (Relation)entry2.getValue();
                for (Map.Entry valueAndLocales : value2locales.keyValuesSet()) {
                    System.out.println(parentName + "\t" + parent + "\t\u3008" + (String)valueAndLocales.getKey() + "\u3009\t" + valueAndLocales.getValue() + "\t" + ppath);
                }
                System.out.println();
            }
            deviations.add(parent, path2value2locales.size());
        }
        for (String locale : deviations.getKeysetSortedByKey()) {
            String parentName = english.nameGetter().getNameFromIdentifier(locale);
            System.out.println(parentName + "\t" + locale + "\t" + deviations.get(locale));
        }
        System.out.println("Done -- Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " minutes");
    }

    private static String getParentWithoutRegion(LanguageTagParser ltp, String locale) {
        while (!ltp.set(locale).getRegion().isEmpty()) {
            locale = LocaleIDParser.getParent(locale);
        }
        return locale;
    }
}

