/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.PatternTokenizer;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.UnicodeSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class DateTimeCanonicalizer {
    private boolean fixYears = false;
    private DateTimePatternGenerator.FormatParser formatDateParser = new DateTimePatternGenerator.FormatParser();
    private transient PatternTokenizer tokenizer = new PatternTokenizer().setSyntaxCharacters(new UnicodeSet("[a-zA-Z]")).setExtraQuotingCharacters(new UnicodeSet("[[[:script=Latn:][:script=Cyrl:]]&[[:L:][:M:]]]")).setUsingQuote(true);

    public DateTimeCanonicalizer(boolean fixYears) {
        this.fixYears = fixYears;
    }

    public String getCanonicalDatePattern(String path, String value, DateTimePatternType datetimePatternType) {
        String newValue;
        this.formatDateParser.set(value);
        if (this.fixYears) {
            StringBuilder result = new StringBuilder();
            for (Object item : this.formatDateParser.getItems()) {
                String itemString = item.toString();
                if (item instanceof String) {
                    result.append(this.tokenizer.quoteLiteral(itemString));
                    continue;
                }
                if (!itemString.startsWith("y") || datetimePatternType == DateTimePatternType.STOCK && path.contains("short") && itemString.equals("yy")) {
                    result.append(itemString);
                    continue;
                }
                result.append('y');
            }
            newValue = result.toString();
        } else {
            newValue = this.formatDateParser.toString();
        }
        if (!value.equals(newValue)) {
            value = newValue;
        }
        return value;
    }

    public static enum DateTimePatternType {
        NA,
        STOCK,
        AVAILABLE,
        INTERVAL,
        GMT;

        public static final Set<DateTimePatternType> STOCK_AVAILABLE_INTERVAL_PATTERNS;

        public static DateTimePatternType fromPath(String path) {
            return !path.contains("/dates") ? NA : (path.contains("/pattern") && (path.contains("/dateFormats") || path.contains("/timeFormats") || path.contains("/dateTimeFormatLength")) ? STOCK : (path.contains("/dateFormatItem") ? AVAILABLE : (path.contains("/intervalFormatItem") ? INTERVAL : (path.contains("/timeZoneNames/hourFormat") ? GMT : NA))));
        }

        static {
            STOCK_AVAILABLE_INTERVAL_PATTERNS = Collections.unmodifiableSet(EnumSet.of(STOCK, AVAILABLE, INTERVAL));
        }
    }
}

