/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class DelegatingIterator<T>
implements Iterator<T> {
    private Iterator<T>[] iterators;
    private int item = 0;

    public DelegatingIterator(Iterator<T> ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while (this.item < this.iterators.length) {
            boolean result = this.iterators[this.item].hasNext();
            if (result) {
                return true;
            }
            ++this.item;
        }
        return false;
    }

    @Override
    public T next() {
        while (this.item < this.iterators.length) {
            try {
                return this.iterators[this.item].next();
            }
            catch (NoSuchElementException e) {
                ++this.item;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T> Iterable<T> iterable(Iterable<T> ... s2) {
        return new MyIterable<T>(s2);
    }

    public static <T> T[] array(T ... s2) {
        return s2;
    }

    private static class MyIterable<T>
    implements Iterable<T> {
        public Iterable<T>[] iterables;

        public MyIterable(Iterable<T> ... s2) {
            this.iterables = s2;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator[] iterators = new Iterator[this.iterables.length];
            for (int i = 0; i < this.iterables.length; ++i) {
                iterators[i] = this.iterables[i].iterator();
            }
            return new DelegatingIterator(iterators);
        }
    }
}

