/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CollatorHelper;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.With;

public class Emoji {
    public static final Collator COLLATOR;
    public static final String EMOJI_VARIANT = "\ufe0f";
    public static final char JOINER = '\u200d';
    public static final String JOINER_STR = "\u200d";
    public static final String FEMALE = "\u2640";
    public static final String MALE = "\u2642";
    public static final String TRANSGENDER = "\u26a7";
    public static final String COMBINING_ENCLOSING_KEYCAP = "\u20e3";
    public static final String ZWJ = "\u200d";
    public static final UnicodeSet REGIONAL_INDICATORS;
    public static final UnicodeSet SKIN_MODIFIERS;
    public static final UnicodeSet HAIR_MODIFIERS;
    public static final UnicodeSet TAGS;
    public static final UnicodeSet FAMILY;
    public static final UnicodeSet GENDER;
    public static final UnicodeSet SPECIALS;
    public static final UnicodeSet MAN_WOMAN;
    public static final UnicodeSet OBJECT;
    static final UnicodeMap<String> emojiToMajorCategory;
    static final UnicodeMap<String> emojiToMinorCategory;
    static final UnicodeMap<String> toName;
    static final UnicodeSet NEUTRAL;
    public static final String ZWJ_HANDSHAKE_ZWJ;
    public static final String ZWJ_HEART_ZWJ;
    public static final UnicodeSet FULL_ZWJ_GENDER_MARKERS;
    static final Transliterator NEUTER;
    static final Map<String, Long> majorToOrder;
    static final Map<String, Long> minorToOrder;
    static final Map<String, Long> emojiToOrder;
    static final UnicodeSet nonConstructed;
    static final UnicodeSet allRgi;
    static final UnicodeSet allRgiNoES;
    static final UnicodeMap<String> restoreVariants;
    static final Set<Set<String>> genderSets;
    public static final UnicodeMap<String> EXTRA_SYMBOL_MINOR_CATEGORIES;
    public static final Map<String, Long> EXTRA_SYMBOL_ORDER;
    private static final boolean DEBUG = false;
    private static Set<String> NAME_PATHS;
    public static final String TYPE_TTS = "[@type=\"tts\"]";

    public static String removeVariants(String original) {
        return original.replace(EMOJI_VARIANT, "");
    }

    public static Set<Set<String>> getGenderGroups() {
        return genderSets;
    }

    public static final String restoreVariants(String source) {
        String restored = restoreVariants.get(source);
        if (restored != null) {
            boolean bl = false;
        }
        return restored == null ? source : restored;
    }

    private static <K, V> void putUnique(Map<K, V> map, K key, V value) {
        V oldValue = map.put(key, value);
        if (oldValue != null) {
            throw new ICUException("Attempt to change value of " + map + " for " + key + " from " + oldValue + " to " + value);
        }
    }

    public static UnicodeSet getAllRgi() {
        return allRgi;
    }

    public static UnicodeSet getAllRgiNoES() {
        return allRgiNoES;
    }

    public static String getMinorCategory(String emoji) {
        String minorCat = emojiToMinorCategory.get(emoji);
        if (minorCat == null && (minorCat = EXTRA_SYMBOL_MINOR_CATEGORIES.get(emoji)) == null) {
            throw new InternalCldrException("No minor category (aka subgroup) found for " + emoji + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"minor\", ...");
        }
        return minorCat;
    }

    public static String getName(String emoji) {
        return toName.get(emoji);
    }

    public static long getEmojiToOrder(String emoji) {
        Long result = emojiToOrder.get(emoji);
        if (result == null && (result = EXTRA_SYMBOL_ORDER.get(emoji)) == null) {
            throw new InternalCldrException("No Order found for " + emoji + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"minor\", ...");
        }
        return result;
    }

    public static long getEmojiMinorOrder(String minor) {
        Long result = minorToOrder.get(minor);
        if (result == null) {
            throw new InternalCldrException("No minor category (aka subgroup) found for " + minor + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"minor\", ...");
        }
        return result;
    }

    public static String getMajorCategory(String emoji) {
        String majorCat = emojiToMajorCategory.get(emoji);
        if (majorCat == null) {
            if (EXTRA_SYMBOL_MINOR_CATEGORIES.containsKey(emoji)) {
                majorCat = "Symbols";
            } else {
                throw new InternalCldrException("No minor category (aka subgroup) found for " + emoji + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"major\", ...");
            }
        }
        return majorCat;
    }

    public static Set<String> getMinorCategoriesWithExtras() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(emojiToMinorCategory.values());
        result.addAll(EXTRA_SYMBOL_MINOR_CATEGORIES.getAvailableValues());
        return ImmutableSet.copyOf(result);
    }

    public static UnicodeSet getEmojiInMinorCategoriesWithExtras(String minorCategory) {
        return new UnicodeSet(emojiToMinorCategory.getSet(minorCategory)).addAll(EXTRA_SYMBOL_MINOR_CATEGORIES.getSet(minorCategory)).freeze();
    }

    public static UnicodeSet getNonConstructed() {
        return nonConstructed;
    }

    public static synchronized Set<String> getNamePaths() {
        return NAME_PATHS != null ? NAME_PATHS : (NAME_PATHS = Emoji.buildPaths(TYPE_TTS));
    }

    private static ImmutableSet<String> buildPaths(String suffix) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String s2 : Emoji.getNonConstructed()) {
            String base = "//ldml/annotations/annotation[@cp=\"" + s2 + "\"]" + suffix;
            builder.add(base);
        }
        return builder.build();
    }

    public static PathHeader.PageId getPageId(String emoji) {
        String major = Emoji.getMajorCategory(emoji);
        String minor = Emoji.getMinorCategory(emoji);
        PathHeader.PageId pageId = PathHeader.PageId.forString(major);
        Long minorOrder = minorToOrder.get(minor);
        switch (pageId) {
            case Objects: {
                return minorOrder < minorToOrder.get("money") ? PathHeader.PageId.Objects : PathHeader.PageId.Objects2;
            }
            case People: {
                return minorOrder < minorToOrder.get("person-fantasy") ? PathHeader.PageId.People : PathHeader.PageId.People2;
            }
            case Symbols: {
                return minorOrder < minorToOrder.get("transport-sign") ? PathHeader.PageId.Symbols : PathHeader.PageId.EmojiSymbols;
            }
            case Travel_Places: {
                return minorOrder < minorToOrder.get("transport-ground") ? PathHeader.PageId.Travel_Places : PathHeader.PageId.Travel_Places2;
            }
        }
        return pageId;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var4_11;
        COLLATOR = CollatorHelper.EMOJI_COLLATOR;
        REGIONAL_INDICATORS = new UnicodeSet(127462, 127487).freeze();
        SKIN_MODIFIERS = new UnicodeSet("[\ud83c\udffb-\ud83c\udfff]").freeze();
        HAIR_MODIFIERS = new UnicodeSet("[\ud83e\uddb0\ud83e\uddb1\ud83e\uddb3\ud83e\uddb2]").freeze();
        TAGS = new UnicodeSet(917504, 917631).freeze();
        FAMILY = new UnicodeSet("[\u200d \ud83d\udc66-\ud83d\udc69 \ud83d\udc8b \u2764]").freeze();
        GENDER = new UnicodeSet().add(9792).add(9794).freeze();
        SPECIALS = new UnicodeSet("[{\ud83d\udc08\u200d\u2b1b}{\ud83d\udc3b\u200d\u2744}{\ud83d\udc68\u200d\ud83c\udf7c}{\ud83d\udc69\u200d\ud83c\udf7c}{\ud83e\uddd1\u200d\ud83c\udf7c}{\ud83e\uddd1\u200d\ud83c\udf84}{\ud83e\uddd1\u200d\ud83e\udd1d\u200d\ud83e\uddd1}{\ud83c\udff3\u200d\ud83c\udf08} {\ud83d\udc41\u200d\ud83d\udde8} {\ud83c\udff4\u200d\u2620} {\ud83d\udc15\u200d\ud83e\uddba} {\ud83d\udc68\u200d\ud83e\uddaf} {\ud83d\udc68\u200d\ud83e\uddbc} {\ud83d\udc68\u200d\ud83e\uddbd} {\ud83d\udc69\u200d\ud83e\uddaf} {\ud83d\udc69\u200d\ud83e\uddbc} {\ud83d\udc69\u200d\ud83e\uddbd}{\ud83c\udff3\u200d\u26a7}{\ud83e\uddd1\u200d\u2695}{\ud83e\uddd1\u200d\u2696}{\ud83e\uddd1\u200d\u2708}{\ud83e\uddd1\u200d\ud83c\udf3e}{\ud83e\uddd1\u200d\ud83c\udf73}{\ud83e\uddd1\u200d\ud83c\udf93}{\ud83e\uddd1\u200d\ud83c\udfa4}{\ud83e\uddd1\u200d\ud83c\udfa8}{\ud83e\uddd1\u200d\ud83c\udfeb}{\ud83e\uddd1\u200d\ud83c\udfed}{\ud83e\uddd1\u200d\ud83d\udcbb}{\ud83e\uddd1\u200d\ud83d\udcbc}{\ud83e\uddd1\u200d\ud83d\udd27}{\ud83e\uddd1\u200d\ud83d\udd2c}{\ud83e\uddd1\u200d\ud83d\ude80}{\ud83e\uddd1\u200d\ud83d\ude92}{\ud83e\uddd1\u200d\ud83e\uddaf}{\ud83e\uddd1\u200d\ud83e\uddbc}{\ud83e\uddd1\u200d\ud83e\uddbd}{\u2764\u200d\ud83d\udd25}, {\u2764\u200d\ud83e\ude79}, {\ud83d\ude2e\u200d\ud83d\udca8}, {\ud83d\ude35\u200d\ud83d\udcab}]").freeze();
        MAN_WOMAN = new UnicodeSet("[\ud83d\udc68 \ud83d\udc69]").freeze();
        OBJECT = new UnicodeSet("[\ud83d\udc69 \ud83c\udf93 \ud83c\udf3e \ud83c\udf73 \ud83c\udfeb \ud83c\udfed \ud83c\udfa8 \ud83d\ude92 \u2708 \ud83d\ude80 \ud83c\udfa4 \ud83d\udcbb \ud83d\udd2c \ud83d\udcbc \ud83d\udd27 \u2696 \u2695]").freeze();
        emojiToMajorCategory = new UnicodeMap();
        emojiToMinorCategory = new UnicodeMap();
        toName = new UnicodeMap();
        NEUTRAL = new UnicodeSet("[\u26f7\u26f9\ud83c\udfc2-\ud83c\udfc4\ud83c\udfc7\ud83c\udfca-\ud83c\udfce\ud83d\udc64\ud83d\udc65\ud83d\udc6a-\ud83d\udc73\ud83d\udc76\ud83d\udc77\ud83d\udc7c\ud83d\udc81\ud83d\udc82\ud83d\udc86\ud83d\udc87\ud83d\udc8f\ud83d\udc91\ud83d\udd74\ud83d\udd75\ud83d\udde3\ud83d\ude45-\ud83d\ude47\ud83d\ude4b\ud83d\ude4d\ud83d\ude4e\ud83d\udea3\ud83d\udeb4-\ud83d\udeb6\ud83d\udec0\ud83d\udecc\ud83e\udd26\ud83e\udd30\ud83e\udd31\ud83e\udd35\ud83e\udd37-\ud83e\udd3e\ud83e\uddb8\ud83e\uddb9\ud83e\uddd1-\ud83e\udddf]").freeze();
        ZWJ_HANDSHAKE_ZWJ = "\u200d" + UTF16.valueOf(129309) + "\u200d";
        ZWJ_HEART_ZWJ = "\u200d" + UTF16.valueOf(10084) + "\u200d";
        FULL_ZWJ_GENDER_MARKERS = new UnicodeSet().add("\u200d\u2640").add("\u200d\u2642").add("\u200d\u2640\ufe0f").add("\u200d\u2642\ufe0f").freeze();
        Object TO_NEUTRAL = new UnicodeMap<String>().put("\ud83d\udc66", "\ud83e\uddd2").put("\ud83d\udc67", "\ud83e\uddd2").put("\ud83d\udc68", "\ud83e\uddd1").put("\ud83d\udc69", "\ud83e\uddd1").put("\ud83d\udc74", "\ud83e\uddd3").put("\ud83d\udc75", "\ud83e\uddd3").put("\ud83e\udd34", "\ud83e\uddd1\u200d\ud83d\udc51").put("\ud83d\udc78", "\ud83e\uddd1\u200d\ud83d\udc51").put("\ud83c\udf85", "\ud83e\uddd1\u200d\ud83c\udf84").put("\ud83e\udd36", "\ud83e\uddd1\u200d\ud83c\udf84").put("\ud83d\udc83", "\ud83e\uddd1\u200d\ud83c\udfb6").put("\ud83d\udd7a", "\ud83e\uddd1\u200d\ud83c\udfb6").put("\ud83d\udc6b", "\ud83e\uddd1" + ZWJ_HANDSHAKE_ZWJ + "\ud83e\uddd1").put("\ud83d\udc6c", "\ud83e\uddd1" + ZWJ_HANDSHAKE_ZWJ + "\ud83e\uddd1").put("\ud83d\udc6d", "\ud83e\uddd1" + ZWJ_HANDSHAKE_ZWJ + "\ud83e\uddd1").put("\u200d\u2640\ufe0f", "").put("\u200d\u2642\ufe0f", "").put("\u200d\u2640", "").put("\u200d\u2642", "").freeze();
        TreeMap results = new TreeMap(Ordering.from(SupplementalDataInfo.LENGTH_FIRST).reversed());
        for (Map.Entry entry : ((UnicodeMap)TO_NEUTRAL).entrySet()) {
            results.put(entry.getKey(), (String)entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : results.entrySet()) {
            sb.append((String)entry.getKey()).append('\u2192').append((String)entry.getValue()).append(";\n");
        }
        NEUTER = Transliterator.createFromRules("foo", sb.toString(), 0);
        emojiToMajorCategory.setErrorOnReset(true);
        emojiToMinorCategory.setErrorOnReset(true);
        toName.setErrorOnReset(true);
        majorToOrder = new HashMap<String, Long>();
        minorToOrder = new HashMap<String, Long>();
        emojiToOrder = new LinkedHashMap<String, Long>();
        nonConstructed = new UnicodeSet();
        allRgi = new UnicodeSet();
        allRgiNoES = new UnicodeSet();
        restoreVariants = new UnicodeMap();
        Splitter semi = Splitter.on(';').trimResults();
        String majorCategory = null;
        String[][] minorCategory = null;
        Matcher matcher = Pattern.compile("\\s*[\\S]+\\s+(?:E\\d*.\\d+\\s+)(.*)").matcher("");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String line : FileUtilities.in(Emoji.class, "data/emoji/emoji-test.txt")) {
            boolean singleton;
            if (line.startsWith("#")) {
                if ((line = line.substring(1).trim()).startsWith("group:")) {
                    majorCategory = line.substring("group:".length()).trim();
                    majorToOrder.computeIfAbsent(majorCategory, k -> majorToOrder.size());
                    continue;
                }
                if (!line.startsWith("subgroup:")) continue;
                minorCategory = line.substring("subgroup:".length()).trim();
                minorToOrder.computeIfAbsent((String)minorCategory, k -> minorToOrder.size());
                continue;
            }
            if ((line = line.trim()).isEmpty()) continue;
            Iterator<Object> it = semi.split(line).iterator();
            String string = it.next();
            String original = Utility.fromHex(string, 4, " ");
            String typeRaw = it.next();
            int hashPos = typeRaw.indexOf(35);
            if (hashPos < 0) {
                throw new IllegalArgumentException("unexpected comment format: " + typeRaw);
            }
            String type = typeRaw.substring(0, hashPos).trim();
            if (type.startsWith("fully-qualified")) {
                String neutral;
                if (original.contains(MALE)) {
                    boolean bl = false;
                }
                allRgi.add(original);
                String variantsRemoved = Emoji.removeVariants(original);
                allRgiNoES.add(variantsRemoved);
                if (!original.equals(variantsRemoved)) {
                    restoreVariants.put(variantsRemoved, original);
                }
                if (!SKIN_MODIFIERS.containsSome(original) && !(neutral = NEUTER.transform(original)).equals(original)) {
                    treeMap.put(original, neutral);
                    treeMap.put(neutral, neutral);
                }
            }
            emojiToMajorCategory.put(original, majorCategory);
            emojiToMinorCategory.put(original, (String)minorCategory);
            String comment = typeRaw.substring(hashPos + 1);
            if (!matcher.reset(comment).matches()) {
                throw new IllegalArgumentException("unexpected comment format");
            }
            String name = matcher.group(1);
            toName.put(original, name);
            String minimal = original.replace(EMOJI_VARIANT, "");
            if (!emojiToOrder.containsKey(original)) {
                Emoji.putUnique(emojiToOrder, original, (long)emojiToOrder.size() * 100L);
            }
            if (!emojiToOrder.containsKey(minimal)) {
                Emoji.putUnique(emojiToOrder, minimal, (long)emojiToOrder.size() * 100L);
            }
            boolean bl = singleton = CharSequences.getSingleCodePoint(minimal) != Integer.MAX_VALUE;
            if (minimal.contains(COMBINING_ENCLOSING_KEYCAP) || REGIONAL_INDICATORS.containsSome(minimal) || TAGS.containsSome(minimal) || !singleton && SKIN_MODIFIERS.containsSome(minimal) || !singleton && FAMILY.containsAll(minimal)) continue;
            if (minimal.contains("\u200d")) {
                if (!SPECIALS.contains(minimal) && !GENDER.containsSome(minimal) && (!MAN_WOMAN.contains(minimal.codePointAt(0)) || !OBJECT.contains(minimal.codePointBefore(minimal.length())))) continue;
                nonConstructed.add(minimal);
                continue;
            }
            if (minimal.contains("\ud83d\udd1f")) continue;
            nonConstructed.add(minimal);
        }
        emojiToMajorCategory.freeze();
        emojiToMinorCategory.freeze();
        nonConstructed.add(SKIN_MODIFIERS);
        nonConstructed.freeze();
        toName.freeze();
        allRgi.freeze();
        allRgiNoES.addAll(SKIN_MODIFIERS).addAll(HAIR_MODIFIERS).freeze();
        for (String s2 : new UnicodeSet("[#*0-9\u00a9\u00ae\u203c\u2049\u2122\u2139\u2194-\u2199\u21a9\u21aa\u2328\u23cf\u23ed-\u23ef \u23f1\u23f2\u23f8-\u23fa\u24c2\u25aa\u25ab\u25b6\u25c0\u25fb\u25fc\u2600-\u2604\u260e\u2611\u2618\u261d\u2620\u2622 \u2623\u2626\u262a\u262e\u262f\u2638-\u263a\u2640\u2642\u265f\u2660\u2663\u2665\u2666\u2668\u267b\u267e\u2692\u2694-\u2697 \u2699\u269b\u269c\u26a0\u26a7\u26b0\u26b1\u26c8\u26cf\u26d1\u26d3\u26e9\u26f0\u26f1\u26f4\u26f7-\u26f9\u2702\u2708\u2709 \u270c\u270d\u270f\u2712\u2714\u2716\u271d\u2721\u2733\u2734\u2744\u2747\u2763\u2764\u27a1\u2934\u2935\u2b05-\u2b07\u3030 \u303d\u3297\u3299\ud83c\udd70\ud83c\udd71\ud83c\udd7e\ud83c\udd7f\ud83c\ude02\ud83c\ude37\ud83c\udf21\ud83c\udf24-\ud83c\udf2c\ud83c\udf36\ud83c\udf7d\ud83c\udf96\ud83c\udf97\ud83c\udf99-\ud83c\udf9b\ud83c\udf9e \ud83c\udf9f\ud83c\udfcb-\ud83c\udfce\ud83c\udfd4-\ud83c\udfdf\ud83c\udff3\ud83c\udff5\ud83c\udff7\ud83d\udc3f\ud83d\udc41\ud83d\udcfd\ud83d\udd49\ud83d\udd4a\ud83d\udd6f\ud83d\udd70\ud83d\udd73-\ud83d\udd79\ud83d\udd87 \ud83d\udd8a-\ud83d\udd8d\ud83d\udd90\ud83d\udda5\ud83d\udda8\ud83d\uddb1\ud83d\uddb2\ud83d\uddbc\ud83d\uddc2-\ud83d\uddc4\ud83d\uddd1-\ud83d\uddd3\ud83d\udddc-\ud83d\uddde\ud83d\udde1\ud83d\udde3\ud83d\udde8 \ud83d\uddef\ud83d\uddf3\ud83d\uddfa\ud83d\udecb\ud83d\udecd-\ud83d\udecf\ud83d\udee0-\ud83d\udee5\ud83d\udee9\ud83d\udef0\ud83d\udef3]")) {
            restoreVariants.put(s2, s2 + EMOJI_VARIANT);
        }
        restoreVariants.freeze();
        TreeMultimap<Object, Object> neutralToOthers = TreeMultimap.create(COLLATOR, COLLATOR);
        Multimaps.invertFrom(Multimaps.forMap(treeMap), neutralToOthers);
        LinkedHashSet<ImmutableSet<Object>> toGenderGroup = new LinkedHashSet<ImmutableSet<Object>>();
        for (Collection collection : neutralToOthers.asMap().values()) {
            TreeSet<Object> s3 = new TreeSet<Object>(COLLATOR);
            s3.addAll(collection);
            toGenderGroup.add(ImmutableSet.copyOf(s3));
        }
        genderSets = CldrUtility.protectCollection(toGenderGroup);
        EXTRA_SYMBOL_MINOR_CATEGORIES = new UnicodeMap();
        String[][] data = new String[][]{{"arrow", "\u2192 \u2193 \u2191 \u2190 \u2194 \u2195 \u21c6 \u21c5"}, {"alphanum", "\u00a9 \u00ae \u2117 \u2122 \u00b5"}, {"geometric", "\u25bc \u25b6 \u25b2 \u25c0 \u25cf \u25cb \u25ef \u25ca"}, {"math", "\u00d7 \u00f7 \u221a \u221e \u2206 \u2207 \u207b \u00b9 \u00b2 \u00b3 \u2261 \u2208 \u2282 \u2229 \u222a \u00b0 + \u00b1 \u2212 = \u2248 \u2260 > < \u2264 \u2265 \u00ac | ~"}, {"punctuation", "\u00a7 \u2020 \u2021 \\u0020  , \u3001 \u060c ; : \u061b ! \u00a1 ? \u00bf \u061f \u00b6 \u203b / \\ & # % \u2030 \u2032 \u2033 \u2034 @ * \u266a \u266d \u266f ` \u00b4 ^ \u00a8 \u2010 \u2015 _ - \u2013 \u2014 \u2022 \u00b7 . \u2026 \u3002 \u2027 \u30fb \u2018 \u2019 \u201a ' \u201c \u201d \u201e \u00bb \u00ab ( ) [ ] { } \u3014 \u3015 \u3008 \u3009 \u300a \u300b \u300c \u300d \u300e \u300f \u3016 \u3017 \u3010 \u3011"}, {"currency", "\u20ac \u00a3 \u00a5 \u20b9 \u20bd $ \u00a2 \u0e3f \u20aa \u20ba \u20ab \u20b1 \u20a9 \u20a1 \u20a6 \u20ae \u09f3 \u20b4 \u20b8 \u20b2 \u20b5 \u17db \u20ad \u058f \u20a5 \u20be \u20bc \u20bf \u060b \u20a7 \u00a4"}, {"other-symbol", "\u203e\u203d\u2038\u2042\u219a\u219b\u21ae\u2199\u219c\u219d\u219e\u219f\u21a0\u21a1\u21a2\u21a3\u21a4\u21a5\u21a6\u21a7\u21a8\u21ab\u21ac\u21ad\u21af\u21b0\u21b1\u21b2\u21b3\u21b4\u21b5\u21b6\u21b7\u21b8\u21b9\u21ba\u21bb\u21bc\u21bd\u21be\u21bf\u21c0\u21c1\u21c2\u21c3\u21c4\u21c7\u21c8\u21c9\u21ca\u21cb\u21cc\u21d0\u21cd\u21d1\u21d2\u21cf\u21d3\u21d4\u21ce\u21d6\u21d7\u21d8\u21d9\u21da\u21db\u21dc\u21dd\u21de\u21df\u21e0\u21e1\u21e2\u21e3\u21e4\u21e5\u21e6\u21e7\u21e8\u21e9\u21ea\u21f5\u2200\u2202\u2203\u2205\u2209\u220b\u220e\u220f\u2211\u226e\u226f\u2213\u2215\u2044\u2217\u2218\u2219\u221d\u221f\u2220\u2223\u2225\u2227\u222b\u222c\u222e\u2234\u2235\u2236\u2237\u223c\u223d\u223e\u2243\u2245\u224c\u2252\u2256\u2263\u2266\u2267\u226a\u226b\u226c\u2273\u227a\u227b\u2281\u2283\u2286\u2287\u2295\u2296\u2297\u2298\u2299\u229a\u229b\u229e\u229f\u22a5\u22ae\u22b0\u22b1\u22ed\u22b6\u22b9\u22bf\u22c1\u22c2\u22c3\u22c5\u22c6\u22c8\u22d2\u22d8\u22d9\u22ee\u22ef\u22f0\u22f1\u25a0\u25a1\u25a2\u25a3\u25a4\u25a5\u25a6\u25a7\u25a8\u25a9\u25ac\u25ad\u25ae\u25b0\u25b3\u25b4\u25b5\u25b7\u25b8\u25b9\u25ba\u25bb\u25bd\u25be\u25bf\u25c1\u25c2\u25c3\u25c4\u25c5\u25c6\u25c7\u25c8\u25c9\u25cc\u25cd\u25ce\u25d0\u25d1\u25d2\u25d3\u25d4\u25d5\u25d6\u25d7\u25d8\u25d9\u25dc\u25dd\u25de\u25df\u25e0\u25e1\u25e2\u25e3\u25e4\u25e5\u25e6\u25f3\u25f7\u25fb\u25fd\u25ff\u2a27\u2a2f\u2a3c\u2a63\u2a7d\u2a8d\u2a9a\u2aba\u20a2\u20a3\u20a4\u20b0\u20b3\u20b6\u20b7\u20a8\ufdfc"}};
        HashMap<String, Object> subcategoryToMaxSuborder = new HashMap<String, Object>();
        minorCategory = data;
        int n = minorCategory.length;
        boolean bl = false;
        while (var4_11 < n) {
            String[] row = minorCategory[var4_11];
            String subcategory = row[0];
            for (Map.Entry entry : emojiToMinorCategory.entrySet()) {
                if (!((String)entry.getValue()).equals(subcategory)) continue;
                String emoji = (String)entry.getKey();
                Object order = emojiToOrder.get(emoji);
                Long currentMax = (Long)subcategoryToMaxSuborder.get(subcategory);
                if (currentMax != null && currentMax >= (Long)order) continue;
                subcategoryToMaxSuborder.put(subcategory, order);
            }
            ++var4_11;
        }
        LinkedHashMap<String, Long> _EXTRA_SYMBOL_ORDER = new LinkedHashMap<String, Long>();
        for (String[] row : data) {
            String subcategory = row[0];
            String string = row[1];
            ArrayList<String> items = new ArrayList<String>();
            for (int cp : With.codePointArray(string)) {
                if (cp == 32) continue;
                items.add(With.fromCodePoint(cp));
            }
            UnicodeSet uset = new UnicodeSet().addAll((Iterable<?>)items);
            if (uset.containsSome(EXTRA_SYMBOL_MINOR_CATEGORIES.keySet())) {
                throw new IllegalArgumentException("Duplicate values in " + EXTRA_SYMBOL_MINOR_CATEGORIES);
            }
            EXTRA_SYMBOL_MINOR_CATEGORIES.putAll(uset, subcategory);
            long count = (Long)subcategoryToMaxSuborder.get(subcategory);
            for (String s4 : items) {
                _EXTRA_SYMBOL_ORDER.put(s4, ++count);
            }
            subcategoryToMaxSuborder.put(subcategory, count);
        }
        EXTRA_SYMBOL_MINOR_CATEGORIES.freeze();
        EXTRA_SYMBOL_ORDER = ImmutableMap.copyOf(_EXTRA_SYMBOL_ORDER);
        NAME_PATHS = null;
    }
}

