/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.UnicodeSet;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class EscapingUtilities {
    public static UnicodeSet OK_TO_NOT_QUOTE = new UnicodeSet("[!(-*,-\\:A-Z_a-z~]").freeze();

    public static String urlEscape(String path) {
        try {
            byte[] bytes;
            StringBuilder result = new StringBuilder();
            for (byte b : bytes = path.getBytes("utf-8")) {
                char c = (char)(b & 0xFF);
                if (OK_TO_NOT_QUOTE.contains(c)) {
                    result.append(c);
                    continue;
                }
                result.append('%');
                if (c < '\u0010') {
                    result.append('0');
                }
                result.append(Integer.toHexString(c).toUpperCase(Locale.ENGLISH));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }
}

